/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.audit.impl;

import com.bxm.adsmanager.dal.mapper.audit.VideoAssetMapper;
import com.bxm.adsmanager.facade.model.video.VideoAssetDto;
import com.bxm.adsmanager.facade.model.video.VideoAssetVo;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.model.dao.audit.VideoAsset;
import com.bxm.adsmanager.service.audit.VideoAssetService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VideoAssetServiceImpl
implements VideoAssetService {
    private static final Logger log = LoggerFactory.getLogger(VideoAssetServiceImpl.class);
    @Autowired
    VideoAssetMapper videoAssetMapper;
    @Autowired
    private AdShopIntegration adShopIntegration;

    @Override
    public void add(VideoAssetDto videoAssetDto) throws Exception {
        VideoAsset videoAsset = new VideoAsset();
        videoAsset.setAdvertiserId(videoAssetDto.getAdvertiserId());
        videoAsset.setCreateUser(videoAssetDto.getCreateUser());
        videoAsset.setImgUrl(videoAssetDto.getImgUrl());
        videoAsset.setVideoName(videoAssetDto.getVideoName());
        videoAsset.setStatus(videoAssetDto.getStatus());
        if (videoAsset.getStatus() == null) {
            videoAsset.setStatus(Short.valueOf((short)0));
        }
        if (videoAssetDto.getId() != null) {
            videoAsset.setStatus(Short.valueOf((short)0));
            videoAsset.setId(videoAssetDto.getId());
            videoAsset.setUpdateUser(videoAsset.getUpdateUser());
            videoAsset.setUpdateTime(videoAsset.getUpdateTime());
            this.videoAssetMapper.updateByPrimaryKeySelective(videoAsset);
        } else {
            videoAsset.setCreateTime(new Date());
            this.videoAssetMapper.insert(videoAsset);
        }
    }

    @Override
    public void updateStatus(Long id, Short Status, String userName) throws Exception {
        VideoAsset videoAsset = new VideoAsset();
        videoAsset.setUpdateTime(new Date());
        videoAsset.setUpdateUser(userName);
        videoAsset.setId(id);
        videoAsset.setStatus(Status);
        this.videoAssetMapper.updateByPrimaryKeySelective(videoAsset);
    }

    @Override
    public PageInfo<VideoAssetVo> getList(String keywords, Integer pageNum, Integer pageSize) throws Exception {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List list = this.videoAssetMapper.getList(keywords, null);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new PageInfo();
        }
        Map allAdvertiserMap = this.adShopIntegration.getAllAdvertiserMap();
        for (VideoAssetVo videoAssetVo : list) {
            videoAssetVo.setAdvertiserName((String)allAdvertiserMap.get(videoAssetVo.getAdvertiserId().intValue()));
        }
        return new PageInfo(list);
    }

    @Override
    public PageInfo<VideoAssetVo> getListByAdvertiser(String keywords, Integer pageNum, Integer pageSize, List<Long> advertiserIds) throws Exception {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List list = this.videoAssetMapper.getList(keywords, advertiserIds);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new PageInfo();
        }
        return new PageInfo(list);
    }

    @Override
    public VideoAssetVo getVideoAssetVo(Long id, Long advertiserId) throws Exception {
        VideoAssetVo videoAssetVo = this.videoAssetMapper.selectByParam(id, advertiserId);
        AdvertiserDto advertiserDto = this.adShopIntegration.findAdShopMsg(videoAssetVo.getAdvertiserId().longValue());
        videoAssetVo.setAdvertiserName(advertiserDto.getCompany());
        return videoAssetVo;
    }

    @Override
    public String url(Long id) throws Exception {
        VideoAsset videoAsset = this.videoAssetMapper.selectByPrimaryKey(id);
        if (videoAsset != null) {
            return videoAsset.getImgUrl();
        }
        return null;
    }
}

