/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.common.impl;

import com.bxm.adsmanager.dal.mapper.common.DictionariesMapper;
import com.bxm.adsmanager.facade.model.dictionaries.DictionariesVo;
import com.bxm.adsmanager.model.dao.common.Dictionaries;
import com.bxm.adsmanager.model.dao.common.DictionaryGroup;
import com.bxm.adsmanager.service.common.DictionariesService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.UuidUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DictionariesServiceImpl
implements DictionariesService {
    @Autowired
    private DictionariesMapper dictionariesMapper;

    @Override
    public List<Dictionaries> findAll(String typegroupid) {
        if (typegroupid == null) {
            throw new ValidateException("typegroupid must be not null");
        }
        return this.dictionariesMapper.findAll(typegroupid);
    }

    @Override
    public Dictionaries findByCode(String code, String groupTypeCode) {
        if (code == null) {
            throw new ValidateException("typecode must be not null");
        }
        return this.dictionariesMapper.findByCode(code, groupTypeCode);
    }

    @Override
    public Map<String, String> getCodeDetailMapByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return Collections.emptyMap();
        }
        List<Dictionaries> results = this.findAll(code);
        if (CollectionUtils.isEmpty(results)) {
            return Collections.emptyMap();
        }
        return results.stream().collect(Collectors.toMap(Dictionaries::getTypecode, Dictionaries::getTypename));
    }

    @Override
    public ResultModel insertTypeGroup(DictionaryGroup dictionaryGroup) {
        if (null == dictionaryGroup || StringUtils.isBlank((CharSequence)dictionaryGroup.getTypeGroupCode()) || StringUtils.isBlank((CharSequence)dictionaryGroup.getTypeGroupCode())) {
            return ResultModelFactory.FAIL500("\u5b57\u5178\u53c2\u6570\u4e0d\u80fd\u4f20\u7a7a");
        }
        int count = this.dictionariesMapper.findByParam(dictionaryGroup);
        if (count > 0) {
            return ResultModelFactory.FAIL500("\u5b57\u5178\u53c2\u6570\u4e0d\u80fd\u91cd\u590d");
        }
        ResultModel resultModel = new ResultModel();
        String id = UuidUtil.getUuidByJdk((boolean)true);
        dictionaryGroup.setId(id);
        dictionaryGroup.setModifyTime(new Date());
        int num = this.dictionariesMapper.insertTypeGroup(dictionaryGroup);
        resultModel.setSuccessed(num > 0);
        return resultModel;
    }

    @Override
    public ResultModel findDictionaryGroup(String keyword, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        ResultModel resultModel = new ResultModel();
        List list = this.dictionariesMapper.findDictionaryGroup(keyword);
        resultModel.setReturnValue((Object)new PageInfo(list));
        return resultModel;
    }

    @Override
    public ResultModel deleteTypeGroup(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return ResultModelFactory.FAIL500("\u5b57\u5178id\u4e0d\u53ef\u4e3a\u7a7a");
        }
        ResultModel resultModel = new ResultModel();
        List list = this.dictionariesMapper.findByGroupId(id, null);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return ResultModelFactory.FAIL500("\u8be5\u5b57\u5178\u5206\u7c7b\u4e0b\u5b58\u5728\u5b50\u7c7b\u5b57\u5178\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
        }
        DictionaryGroup dictionaryGroup = this.dictionariesMapper.selectDictionaryGroup(id);
        if (null == dictionaryGroup) {
            return ResultModelFactory.FAIL500("\u8be5\u5b57\u5178\u5206\u7c7b\u4e0d\u5b58\u5728");
        }
        int num = this.dictionariesMapper.deleteDictionaryGroup(id);
        resultModel.setSuccessed(num > 0);
        return resultModel;
    }

    @Override
    public ResultModel updateTypeGroup(DictionaryGroup dictionaryGroup) {
        if (null == dictionaryGroup || StringUtils.isBlank((CharSequence)dictionaryGroup.getId()) || StringUtils.isBlank((CharSequence)dictionaryGroup.getTypeGroupCode()) || StringUtils.isBlank((CharSequence)dictionaryGroup.getTypeGroupName())) {
            return ResultModelFactory.FAIL500("\u5b57\u5178\u53c2\u6570\u4e0d\u80fd\u4f20\u7a7a");
        }
        ResultModel resultModel = new ResultModel();
        int count = this.dictionariesMapper.findByParam(dictionaryGroup);
        if (count > 0) {
            return ResultModelFactory.FAIL500("\u8be5\u5b57\u5178\u540d\u79f0\u6216\u7f16\u7801\u4e0d\u53ef\u91cd\u590d");
        }
        int num = this.dictionariesMapper.updateDictionaryGroup(dictionaryGroup);
        resultModel.setSuccessed(num > 0);
        return resultModel;
    }

    @Override
    public ResultModel addDictionary(Dictionaries dictionaries) {
        if (null == dictionaries || StringUtils.isBlank((CharSequence)dictionaries.getTypecode()) || StringUtils.isBlank((CharSequence)dictionaries.getTypename()) || StringUtils.isBlank((CharSequence)dictionaries.getTypegroupid())) {
            return ResultModelFactory.FAIL500("\u5b57\u5178\u53c2\u6570\u4e0d\u80fd\u4f20\u7a7a");
        }
        int count = this.dictionariesMapper.findByDictionary(dictionaries);
        if (count > 0) {
            return ResultModelFactory.FAIL500("\u5b57\u5178\u53c2\u6570\u4e0d\u80fd\u91cd\u590d");
        }
        ResultModel resultModel = new ResultModel();
        dictionaries.setId(UuidUtil.getUuidByJdk((boolean)true));
        dictionaries.setModityTime(new Date());
        int id = this.dictionariesMapper.insertSelective(dictionaries);
        resultModel.setSuccessed(id > 0);
        return resultModel;
    }

    @Override
    public ResultModel findDictionary(String typeGroupId, Integer pageNum, Integer pageSize, String keyword) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        ResultModel resultModel = new ResultModel();
        List list = this.dictionariesMapper.findByGroupId(typeGroupId, keyword);
        resultModel.setReturnValue((Object)new PageInfo(list));
        return resultModel;
    }

    @Override
    public ResultModel updateDictionary(Dictionaries dictionaries) {
        if (null == dictionaries || StringUtils.isBlank((CharSequence)dictionaries.getTypecode()) || StringUtils.isBlank((CharSequence)dictionaries.getTypename()) || StringUtils.isBlank((CharSequence)dictionaries.getId())) {
            return ResultModelFactory.FAIL500("\u5b57\u5178\u53c2\u6570\u4e0d\u80fd\u4f20\u7a7a");
        }
        ResultModel resultModel = new ResultModel();
        int num = this.dictionariesMapper.updateByPrimaryKey(dictionaries);
        resultModel.setSuccessed(num > 0);
        return resultModel;
    }

    @Override
    public ResultModel deleteDictionary(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return ResultModelFactory.FAIL500("\u5b57\u5178\u53c2\u6570id\u4e0d\u80fd\u4f20\u7a7a");
        }
        Dictionaries dictionaries = this.dictionariesMapper.selectByPrimaryKey(id);
        if (null == dictionaries) {
            return ResultModelFactory.FAIL500("\u8be5\u5b57\u5178\u4e0d\u5b58\u5728");
        }
        ResultModel resultModel = new ResultModel();
        int num = this.dictionariesMapper.deleteByPrimaryKey(id);
        resultModel.setSuccessed(num > 0);
        return resultModel;
    }

    @Override
    public Map<String, String> getIdDetailMapByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return Collections.emptyMap();
        }
        List<Dictionaries> results = this.findAll(code);
        if (CollectionUtils.isEmpty(results)) {
            return Collections.emptyMap();
        }
        return results.stream().collect(Collectors.toMap(Dictionaries::getId, Dictionaries::getTypename));
    }

    public ResultModel findDictionaryNoPage(String typeGroupCode) {
        List dictionariesList = this.dictionariesMapper.findDictionaryNoPage(typeGroupCode);
        ResultModel resultModel = new ResultModel();
        if (CollectionUtils.isEmpty((Collection)dictionariesList)) {
            resultModel.setReturnValue((Object)Lists.newArrayList());
            return resultModel;
        }
        resultModel.setReturnValue((Object)dictionariesList);
        return resultModel;
    }

    @Override
    public List<DictionariesVo> findChildDictionaryNoPageByCode(String typeGroupCode) {
        List dictionariesList = this.dictionariesMapper.findDictionaryNoPage(typeGroupCode);
        if (dictionariesList == null) {
            return new ArrayList<DictionariesVo>(0);
        }
        return dictionariesList.stream().map(e -> {
            DictionariesVo dictionariesVo = new DictionariesVo();
            BeanUtils.copyProperties((Object)e, (Object)dictionariesVo);
            return dictionariesVo;
        }).collect(Collectors.toList());
    }
}

