/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.copydata;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdAssetsMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdRulesMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketAssetsRefMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketOsConfMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketWeightManualConfMapper;
import com.bxm.adsmanager.dal.mapper.copydata.CopyDataMapper;
import com.bxm.adsmanager.model.copydata.InfoActivityCertificateDetailEntity;
import com.bxm.adsmanager.model.copydata.InfoActivityCertificateEntity;
import com.bxm.adsmanager.model.copydata.InfoAdLimitappEntity;
import com.bxm.adsmanager.model.copydata.InfoAdLimitdateEntity;
import com.bxm.adsmanager.model.copydata.InfoAdLimitipEntity;
import com.bxm.adsmanager.model.copydata.InfoGetuiRuleLogEntity;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssets;
import com.bxm.adsmanager.model.dao.adkeeper.AdRules;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketAssetsRef;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketOnoff;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketOsConf;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketPriceConf;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketWeightManualConf;
import com.bxm.adsmanager.model.enums.CitysEnum;
import com.bxm.adsmanager.model.enums.RuleTargetEnum;
import com.bxm.adsmanager.model.enums.RuleTypeEnum;
import com.bxm.adsmanager.service.adkeeper.AdTicketOnoffService;
import com.bxm.adsmanager.service.adkeeper.AdTicketPriceConfService;
import com.bxm.adsmanager.service.copydata.CopyDataService;
import com.bxm.adsmanager.service.prod.ProdService;
import com.bxm.adsmanager.sysconfig.AsyncTaskExecutorFactory;
import com.bxm.commons.currency.Money;
import com.bxm.util.StringUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CopyDataServiceImpl
implements CopyDataService {
    private static final int ZERO = 0;
    private static final short ONE = 1;
    private static final Logger LOGGER = LoggerFactory.getLogger(CopyDataService.class);
    @Autowired
    private CopyDataMapper copyDataMapper;
    @Autowired
    private AdRulesMapper adRulesMapper;
    @Autowired
    private AdTicketMapper adTicketMapper;
    @Autowired
    private AdAssetsMapper adAssetsMapper;
    @Autowired
    private AdTicketAssetsRefMapper adTicketAssetsRefMapper;
    @Autowired
    private AdTicketOsConfMapper adTicketOsConfMapper;
    @Autowired
    private AdTicketWeightManualConfMapper adTicketWeightManualConfMapper;
    @Autowired
    private AdTicketPriceConfService adTicketPriceConfService;
    @Autowired
    private AdTicketOnoffService adTicketOnoffService;
    @Autowired
    private ProdService prodService;
    @Autowired
    private AsyncTaskExecutorFactory asyncTaskExecutorFactory;

    @Override
    public boolean copyApp(Long id) throws Exception {
        if (null == id) {
            List<InfoActivityCertificateEntity> adTickets = this.getList(null);
            if (CollectionUtils.isEmpty(adTickets)) {
                throw new Exception("\u67e5\u8be2\u6240\u6709\u5e7f\u544a\u5238\u7ed3\u679c\u4e3a\u7a7a");
            }
            for (InfoActivityCertificateEntity ad : adTickets) {
                this.copyAppByAdticketId(ad.getId().longValue());
            }
            return true;
        }
        this.copyAppByAdticketId(id);
        return true;
    }

    public void copyAppByAdticketId(Long id) throws Exception {
        List list = this.copyDataMapper.findAllApp(id);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        AdRules adRules = new AdRules();
        adRules.setTargetId(id);
        adRules.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
        adRules.setRuleType(Integer.valueOf(RuleTypeEnum.GUANGGAOWEI.getValue()));
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            InfoAdLimitappEntity entity = (InfoAdLimitappEntity)list.get(i);
            if (0 == i) {
                sb.append(entity.getLimittype()).append("-");
            }
            sb.append(entity.getAppkey()).append("-").append(entity.getBusiness());
            if (i == list.size() - 1) continue;
            sb.append(",");
        }
        adRules.setRuleValue(sb.toString());
        System.out.println(sb.toString());
        this.adRulesMapper.insert(adRules);
    }

    @Override
    public boolean copyDate(Long id) throws Exception {
        if (null == id) {
            List<InfoActivityCertificateEntity> adTickets = this.getList(null);
            if (CollectionUtils.isEmpty(adTickets)) {
                throw new Exception("\u67e5\u8be2\u6240\u6709\u5e7f\u544a\u5238\u7ed3\u679c\u4e3a\u7a7a");
            }
            for (InfoActivityCertificateEntity ad : adTickets) {
                this.copyDateByAdticketId(ad.getId().longValue());
            }
            return true;
        }
        this.copyDateByAdticketId(id);
        return true;
    }

    public void copyDateByAdticketId(Long id) throws Exception {
        List list = this.copyDataMapper.findAllDate(id);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        AdRules adRules = new AdRules();
        adRules.setTargetId(id);
        adRules.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
        adRules.setRuleType(Integer.valueOf(RuleTypeEnum.SHIJIANDUAN.getValue()));
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            InfoAdLimitdateEntity entity = (InfoAdLimitdateEntity)list.get(i);
            sb.append(entity.getStart()).append("-").append(entity.getEnd()).append("-").append("999999000");
            if (i == list.size() - 1) continue;
            sb.append(",");
        }
        adRules.setRuleValue(sb.toString());
        this.adRulesMapper.insert(adRules);
    }

    @Override
    public boolean copyImage(Long id) throws Exception {
        if (null == id) {
            List<InfoActivityCertificateEntity> adTickets = this.getList(null);
            if (CollectionUtils.isEmpty(adTickets)) {
                throw new Exception("\u67e5\u8be2\u6240\u6709\u5e7f\u544a\u5238\u7ed3\u679c\u4e3a\u7a7a");
            }
            for (InfoActivityCertificateEntity ad : adTickets) {
                this.copyImageByAdticketId(ad.getId().longValue());
            }
            return true;
        }
        this.copyImageByAdticketId(id);
        return true;
    }

    public void copyImageByAdticketId(Long id) throws Exception {
        List list = this.copyDataMapper.findAllImage(id);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            AdAssets adAssets = new AdAssets();
            InfoActivityCertificateDetailEntity entity = (InfoActivityCertificateDetailEntity)list.get(i);
            adAssets.setName(entity.getName());
            adAssets.setVars(entity.getProvinceOrCity());
            adAssets.setContent(entity.getNameSuffix());
            adAssets.setImage(entity.getImg());
            adAssets.setIntro(entity.getInfo());
            adAssets.setButtonTxt(entity.getBtn() == null ? "\u9ed8\u8ba4\u503c" : entity.getBtn());
            adAssets.setStatus(Short.valueOf(null == entity.getState() ? new Short("0").shortValue() : entity.getState().shortValue()));
            adAssets.setCreateUser("\u7cfb\u7edf\u540c\u6b65");
            adAssets.setFlowRate(Double.valueOf(0.0));
            this.adAssetsMapper.insert(adAssets);
            AdTicketAssetsRef ref = new AdTicketAssetsRef();
            ref.setAssetsId(adAssets.getId());
            ref.setTicketId(id);
            this.adTicketAssetsRefMapper.insert(ref);
        }
    }

    @Override
    public boolean copyCertificateOther(Long id) throws Exception {
        List<InfoActivityCertificateEntity> adTickets = this.getList(id);
        if (CollectionUtils.isEmpty(adTickets)) {
            throw new Exception("\u67e5\u8be2\u6240\u6709\u5e7f\u544a\u5238\u7ed3\u679c\u4e3a\u7a7a");
        }
        for (InfoActivityCertificateEntity ad : adTickets) {
            String oss = this.converOss(ad.getNosupportappos());
            for (String s : Splitter.on((String)",").trimResults().split((CharSequence)oss)) {
                AdTicketOsConf osConf = new AdTicketOsConf();
                osConf.setSupportOs(new Short(s));
                osConf.setTicketId(Long.valueOf(ad.getId().longValue()));
                this.adTicketOsConfMapper.insert(osConf);
            }
            Integer weight = ad.getOrdernum();
            AdTicketWeightManualConf conf = new AdTicketWeightManualConf();
            conf.setInterventionFactor(Double.valueOf(100.0));
            conf.setCreateUser("\u7cfb\u7edf\u540c\u6b65");
            conf.setTicketId(Long.valueOf(ad.getId().longValue()));
            this.adTicketWeightManualConfMapper.insert(conf);
            if (ad.getUnitprice() == null || !NumberUtils.isNumber((String)ad.getUnitprice())) continue;
            AdTicketPriceConf adTicketPriceConf = new AdTicketPriceConf();
            adTicketPriceConf.setCreateUser("\u7cfb\u7edf\u540c\u6b65");
            adTicketPriceConf.setModifyUser("\u7cfb\u7edf\u540c\u6b65");
            adTicketPriceConf.setTicketId(Long.valueOf(ad.getId().longValue()));
            Money money = Money.ofYuan((double)(ad.getUnitprice() == null ? 0.0 : Double.parseDouble(ad.getUnitprice())));
            adTicketPriceConf.setAfterPrice(Integer.valueOf(Long.valueOf(money.getLi()).intValue()));
            this.adTicketPriceConfService.update(adTicketPriceConf);
        }
        return true;
    }

    public String converOss(String oss) {
        String temp = "1,2,4";
        if (StringUtil.isNotBlank((CharSequence)oss)) {
            if (oss.equals("1,2,3")) {
                return null;
            }
            for (String s : Splitter.on((String)",").trimResults().split((CharSequence)oss)) {
                if ("3".equals(s)) {
                    temp = temp.replace("4", "");
                    continue;
                }
                temp = temp.replace(s, "");
            }
            temp = Joiner.on((String)",").join(Splitter.on((String)",").omitEmptyStrings().split((CharSequence)temp));
        }
        return temp;
    }

    @Override
    public boolean copyIp(Long id) throws Exception {
        if (null == id) {
            List<InfoActivityCertificateEntity> adTickets = this.getList(null);
            if (CollectionUtils.isEmpty(adTickets)) {
                throw new Exception("\u67e5\u8be2\u6240\u6709\u5e7f\u544a\u5238\u7ed3\u679c\u4e3a\u7a7a");
            }
            for (InfoActivityCertificateEntity ad : adTickets) {
                this.copyIpByAdticketId(ad.getId().longValue());
            }
            return true;
        }
        this.copyIpByAdticketId(id);
        return true;
    }

    public void copyIpByAdticketId(Long id) throws Exception {
        List list = this.copyDataMapper.findAllIp(id, Integer.valueOf(2));
        if (CollectionUtils.isEmpty((Collection)list)) {
            this.copyIpByAdticketIdBlack(id);
            return;
        }
        AdRules adRules = new AdRules();
        adRules.setTargetId(id);
        adRules.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
        adRules.setRuleType(Integer.valueOf(RuleTypeEnum.DIYUXIANZHI.getValue()));
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            InfoAdLimitipEntity entity = (InfoAdLimitipEntity)list.get(i);
            String name = entity.getDistrict();
            if (StringUtil.isBlank((CharSequence)name)) continue;
            sb.append(CitysEnum.getCodeByName((String)name));
            if (i == list.size() - 1) continue;
            sb.append(",");
        }
        adRules.setRuleValue(sb.toString());
        if (StringUtil.isNotBlank((CharSequence)adRules.getRuleValue())) {
            this.adRulesMapper.insert(adRules);
        }
    }

    public void copyIpByAdticketIdBlack(Long id) throws Exception {
        List list = this.copyDataMapper.findAllIp(id, Integer.valueOf(1));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        AdRules adRules = new AdRules();
        adRules.setTargetId(id);
        adRules.setTarget(Integer.valueOf(RuleTargetEnum.GUANGGAO_QUAN.getValue()));
        adRules.setRuleType(Integer.valueOf(RuleTypeEnum.DIYUXIANZHI.getValue()));
        String sb = "";
        for (int i = 0; i < list.size(); ++i) {
            InfoAdLimitipEntity entity = (InfoAdLimitipEntity)list.get(i);
            String name = entity.getDistrict();
            if (StringUtil.isBlank((CharSequence)name)) continue;
            sb = i == 0 ? CitysEnum.getCodeByUNName((String)name) : this.replaceString(sb, CitysEnum.getCodeByName((String)name));
        }
        sb = CopyDataServiceImpl.getNoLastComma(sb);
        adRules.setRuleValue(sb);
        if (StringUtil.isNotBlank((CharSequence)adRules.getRuleValue())) {
            this.adRulesMapper.insert(adRules);
        }
    }

    public String replaceString(String value, String certificateStr) {
        if (StringUtil.isNotEmpty((CharSequence)value) && StringUtil.isNotEmpty((CharSequence)certificateStr)) {
            if (certificateStr.equals(value)) {
                value = value.replaceAll(certificateStr, "");
                return value;
            }
            value = !value.startsWith(certificateStr) ? value.replaceAll("," + certificateStr, "") : value.replaceAll(certificateStr + ",", "");
            return value;
        }
        return value;
    }

    public static String getNoLastComma(String str) {
        if (StringUtil.isBlank((CharSequence)str)) {
            return "";
        }
        if (str.lastIndexOf(",") == str.length() - 1) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    @Override
    public boolean copyGetui(Long id) throws Exception {
        if (null == id) {
            List<InfoActivityCertificateEntity> adTickets = this.getList(null);
            if (CollectionUtils.isEmpty(adTickets)) {
                throw new Exception("\u67e5\u8be2\u6240\u6709\u5e7f\u544a\u5238\u7ed3\u679c\u4e3a\u7a7a");
            }
            for (InfoActivityCertificateEntity ad : adTickets) {
                this.copyGetuiByAdticketId(ad);
            }
            return true;
        }
        return false;
    }

    public void copyGetuiByAdticketId(InfoActivityCertificateEntity ad) throws Exception {
        List list = this.copyDataMapper.findAllGetui(Long.valueOf(ad.getId().longValue()));
        AdTicket adTicket = new AdTicket();
        adTicket.setId(Long.valueOf(ad.getId().longValue()));
        if (CollectionUtils.isNotEmpty((Collection)list) && ((InfoGetuiRuleLogEntity)list.get(0)).getFractionsline() != null) {
            adTicket.setUserGradePassScore(((InfoGetuiRuleLogEntity)list.get(0)).getFractionsline());
        }
        if (ad.getLimitadclick() != null) {
            adTicket.setBudgetDaily(ad.getLimitadclick());
        }
        if (adTicket.getUserGradePassScore() != null || adTicket.getBudgetDaily() != null) {
            this.adTicketMapper.updateByTempOther(adTicket);
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        InfoGetuiRuleLogEntity entity = (InfoGetuiRuleLogEntity)list.get(0);
        this.saveAdTicketOnoff(entity.getIsnoimei(), entity.getIsnoimeiprobability(), entity.getCertificateid().longValue(), 1);
        this.saveAdTicketOnoff(entity.getIsmatching(), entity.getIsmatchingprobability(), entity.getCertificateid().longValue(), 2);
    }

    public void saveAdTicketOnoff(Integer imei, Integer value, Long ticketId, Integer type) {
        AdTicketOnoff adTicketOnoff = new AdTicketOnoff();
        adTicketOnoff.setTicketId(ticketId);
        if (0 == imei) {
            adTicketOnoff.setOnoff(Short.valueOf(imei.shortValue()));
        } else {
            adTicketOnoff.setOnoff(Short.valueOf((short)1));
            adTicketOnoff.setValue(null == value ? "0" : value.toString());
        }
        adTicketOnoff.setType(type);
        this.adTicketOnoffService.add(adTicketOnoff);
    }

    @Override
    public boolean pushProd(Long id) throws Exception {
        List<Long> adTicketIds = this.findAdtickets(id);
        if (CollectionUtils.isEmpty(adTicketIds)) {
            throw new Exception("\u67e5\u8be2\u6240\u6709\u5e7f\u544a\u5238\u7ed3\u679c\u4e3a\u7a7a");
        }
        for (final Long adTicketId : adTicketIds) {
            this.asyncTaskExecutorFactory.taskExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    CopyDataServiceImpl.this.pushAdTicketToProd(adTicketId);
                }
            });
        }
        return true;
    }

    @Override
    public boolean pushProdSync(Long id) {
        if (Objects.nonNull(id)) {
            this.pushAdTicketToProd(id);
        } else {
            List tickets = this.adTicketMapper.selectTicketIdsByOpenStatus();
            tickets.forEach(this::pushAdTicketToProd);
        }
        return true;
    }

    public void pushAdTicketToProd(Long adTicketId) {
        try {
            this.prodService.pushAdTicketToProdPre(adTicketId);
        }
        catch (Exception e) {
            LOGGER.error("\u63a8\u9001\u6570\u636e\u5230\u524d\u7aef\u53d1\u5238\u7cfb\u7edf\u51fa\u9519\uff0cadticketid=" + adTicketId, (Throwable)e);
        }
    }

    public List<Long> findAdtickets(Long id) {
        ArrayList list = Lists.newArrayList();
        list.add((short)1);
        list.add((short)2);
        return this.adTicketMapper.findAdtickets(id, (List)list);
    }

    public List<InfoActivityCertificateEntity> getList(Long id) {
        return this.copyDataMapper.findAllCertificate(id);
    }
}

