/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.datapark.impl;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketOcpcMapper;
import com.bxm.adsmanager.dal.mapper.media.MediaMapper;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.integration.datapark.model.TicketCountCommon;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketOcpcConf;
import com.bxm.adsmanager.model.vo.report.TicketCountCommonExportVo;
import com.bxm.adsmanager.service.datapark.DataparkTicketService;
import com.bxm.adsmanager.utils.CollectionDataCopyUtil;
import com.bxm.adsmanager.utils.ExcelUtil;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.ticket.model.vo.SendTicketDetailVo;
import com.bxm.datapark.facade.ticket.model.vo.SendTicketVo;
import com.bxm.util.dto.ResultModel;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataparkTicketServiceImpl
implements DataparkTicketService {
    @Autowired
    private MediaMapper mediaMapper;
    @Autowired
    private AdTicketMapper adTicketMapper;
    @Autowired
    private AdTicketOcpcMapper adTicketOcpcMapper;
    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;

    @Override
    public void ticketDataExport(List<TicketCountCommon> list, String customExportFieldStr, Integer showIncreaseFlag, HttpServletResponse response) {
        List<TicketCountCommonExportVo> exportVos = CollectionDataCopyUtil.copyList(list, TicketCountCommonExportVo.class);
        ExcelUtil.customFieldExport(exportVos, TicketCountCommonExportVo.class, customExportFieldStr, showIncreaseFlag, "\u5e7f\u544a\u5238\u62a5\u8868.xls", response);
    }

    @Override
    public void pullSendTicket(ResultModel<Page<SendTicketVo>> rs) {
        List list = ((Page)rs.getReturnValue()).getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        List positionIds = list.stream().map(SendTicketVo::getPositionId).collect(Collectors.toList());
        List appEntranceAdRos = this.newAppEntranceFacadeIntegration.findListByPositionIds(positionIds);
        if (CollectionUtils.isEmpty((Collection)appEntranceAdRos)) {
            return;
        }
        Map appEntranceAdRoMap = appEntranceAdRos.stream().collect(HashMap::new, (k, v) -> k.put(v.getPositionId(), v), HashMap::putAll);
        for (SendTicketVo sendTicketVo : list) {
            AppEntranceAdRO appEntranceAdRo = (AppEntranceAdRO)appEntranceAdRoMap.get(sendTicketVo.getPositionId());
            if (null == appEntranceAdRo) continue;
            sendTicketVo.setAppName(appEntranceAdRo.getProviderAlias());
            sendTicketVo.setMjcode(appEntranceAdRo.getMjCode());
            sendTicketVo.setPositionName(appEntranceAdRo.getAppEntranceName());
        }
    }

    @Override
    public void pullSendTicketDetail(ResultModel<Page<SendTicketDetailVo>> rs) {
        List list = ((Page)rs.getReturnValue()).getList();
        if (list.size() > 0) {
            for (SendTicketDetailVo sendTicketDetailVo : list) {
                AdTicket adTicket = this.adTicketMapper.selectByPrimaryKey(sendTicketDetailVo.getCertificateId());
                AdTicketOcpcConf adTicketOcpcConf = this.adTicketOcpcMapper.selectByTicketId(sendTicketDetailVo.getCertificateId());
                String settleType = "";
                if (null != adTicket) {
                    sendTicketDetailVo.setTicketName(adTicket.getName());
                }
                if (null == adTicket || null == adTicketOcpcConf) continue;
                settleType = adTicketOcpcConf.getIsSupportOcpc() == 1 ? "OCPC" : (adTicket.getSettleType() == 1 ? "CPC" : "CPA");
                sendTicketDetailVo.setSettleType(settleType);
            }
        }
    }
}

