/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.diysite.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.dal.mapper.common.DictionariesMapper;
import com.bxm.adsmanager.dal.mapper.diysite.SiteTemplateMapper;
import com.bxm.adsmanager.model.dao.common.Dictionaries;
import com.bxm.adsmanager.model.dao.diysite.SiteInstanceDto;
import com.bxm.adsmanager.model.dao.diysite.SiteTemplateDao;
import com.bxm.adsmanager.model.dao.diysite.SiteTemplateDto;
import com.bxm.adsmanager.service.common.DictionariesService;
import com.bxm.adsmanager.service.diysite.SiteTemplateService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.utils.KeyBuilder;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.dozer.Mapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SiteTemplateServiceImpl
implements SiteTemplateService {
    @Autowired
    private SiteTemplateMapper siteTemplateMapper;
    @Autowired
    private DictionariesService dictionariesService;
    @Autowired
    private Mapper mapper;
    @Autowired
    private JedisFetcher fetcher;
    @Autowired
    private DictionariesMapper dictionariesMapper;

    @Override
    public Map<String, List<SiteTemplateDao>> findAll(SiteInstanceDto dto) {
        Long advertiserId = dto.getAdvertiserId();
        List list = new ArrayList();
        if (advertiserId != null) {
            String json = (String)this.fetcher.hfetchWithSelector(() -> KeyBuilder.build((Object[])new Object[]{"ADVERTISER", "OWN_SITE_TEMPLATE"}), advertiserId + "", String.class, 4);
            if (StringUtils.isNotEmpty((CharSequence)json) && !"[]".equals(json)) {
                list = JSON.parseArray((String)json, String.class);
            } else {
                return new HashedMap();
            }
        }
        HashedMap param = new HashedMap();
        param.put("templateTypes", list);
        List templateDaos = this.siteTemplateMapper.findTemplateAndType((Map)param);
        if (CollectionUtils.isEmpty((Collection)templateDaos)) {
            return new HashedMap();
        }
        HashMap resultMapTemp = Maps.newHashMap();
        for (SiteTemplateDao siteTemplate : templateDaos) {
            List<SiteTemplateDao> tempList;
            if (CollectionUtils.isEmpty((Collection)((Collection)resultMapTemp.get(siteTemplate.getTemplateType())))) {
                tempList = new ArrayList<SiteTemplateDao>();
                tempList.add(siteTemplate);
                resultMapTemp.put(siteTemplate.getTemplateType(), tempList);
                continue;
            }
            tempList = (List)resultMapTemp.get(siteTemplate.getTemplateType());
            tempList.add(siteTemplate);
            resultMapTemp.put(siteTemplate.getTemplateType(), tempList);
        }
        HashMap resultMap = Maps.newHashMap();
        List dictionariesList = this.dictionariesMapper.findDictionaryNoPage("websitetemplet");
        if (CollectionUtils.isNotEmpty((Collection)dictionariesList)) {
            Map TypeMap = dictionariesList.stream().collect(HashMap::new, (k, v) -> k.put(v.getTypecode(), v.getTypename()), HashMap::putAll);
            for (String code : resultMapTemp.keySet()) {
                if (!MapUtils.isNotEmpty((Map)TypeMap)) continue;
                String codeName = (String)TypeMap.get(code);
                resultMap.put(codeName, resultMapTemp.get(code));
            }
            return resultMap;
        }
        return resultMapTemp;
    }

    @Override
    public ResultModel<Boolean> add(SiteTemplateDto dto) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("templateName", dto.getTemplateName());
        map.put("templateType", dto.getTemplateType());
        SiteTemplateDao siteTemplateDao = this.siteTemplateMapper.findByParam(map);
        if (siteTemplateDao != null) {
            return ResultModelFactory.FAIL400("\u6a21\u677f\u540d\u79f0\u4e0d\u53ef\u91cd\u590d");
        }
        ResultModel resultModel = new ResultModel();
        SiteTemplateDao dao = new SiteTemplateDao();
        this.mapper.map((Object)dto, (Object)dao);
        dao.setCreateTime(new Date());
        dao.setModifyTime(new Date());
        int count = this.siteTemplateMapper.add(dao);
        resultModel.setReturnValue((Object)(count == 1 ? 1 : 0));
        resultModel.setSuccessed(count == 1);
        return resultModel;
    }

    @Override
    public Boolean delete(SiteTemplateDto dto) {
        SiteTemplateDao dao = new SiteTemplateDao();
        this.mapper.map((Object)dto, (Object)dao);
        dao.setDeleteTime(new Date());
        int count = this.siteTemplateMapper.update(dao);
        return count == 1;
    }

    @Override
    public List<Dictionaries> findTemplateTypes(String typeGroupCode) {
        ResultModel<List<Dictionaries>> resultModel = this.dictionariesService.findDictionaryNoPage(typeGroupCode);
        if (resultModel == null || CollectionUtils.isEmpty((Collection)((Collection)resultModel.getReturnValue()))) {
            return Lists.newArrayList();
        }
        List list = (List)resultModel.getReturnValue();
        return list;
    }

    @Override
    public PageInfo<SiteTemplateDao> findTemplate(SiteTemplateDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        dto.setFindIsDelete(Integer.valueOf(1));
        PageInfo pageInfo = new PageInfo(this.siteTemplateMapper.findAll(dto));
        List dictionariesList = this.dictionariesMapper.findDictionaryNoPage("websitetemplet");
        if (CollectionUtils.isNotEmpty((Collection)dictionariesList)) {
            Map TypeMap = dictionariesList.stream().collect(HashMap::new, (k, v) -> k.put(v.getTypecode(), v.getTypename()), HashMap::putAll);
            for (SiteTemplateDao siteTemplateDao : pageInfo.getList()) {
                if (!MapUtils.isNotEmpty((Map)TypeMap)) continue;
                siteTemplateDao.setTemplateType((String)TypeMap.get(siteTemplateDao.getTemplateType()));
            }
        }
        return pageInfo;
    }
}

