/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.media.impl;

import com.bxm.adsmanager.dal.mapper.media.AdPositionBlackAppidMapper;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.model.dao.media.AdPositionBlackAppid;
import com.bxm.adsmanager.model.dto.mediamanager.MediaPositionBlackAppIdDto;
import com.bxm.adsmanager.model.dto.mediamanager.MediaPositionBlackAppIdSearchDto;
import com.bxm.adsmanager.model.enums.ProdServiceNameEnum;
import com.bxm.adsmanager.model.vo.media.AdPositionBlackAppIdVo;
import com.bxm.adsmanager.service.media.MediaPositionBlackAppIdService;
import com.bxm.adsprod.facade.media.PositionBlackAppId;
import com.bxm.warcar.utils.JsonHelper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MediaPositionBlackAppIdServiceImpl
implements MediaPositionBlackAppIdService {
    private static final Logger log = LoggerFactory.getLogger(MediaPositionBlackAppIdServiceImpl.class);
    @Autowired
    private AdPositionBlackAppidMapper adPositionBlackAppidMapper;
    @Autowired
    private ProdPusherIntegration prodPusher;

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public List<String> savePositionBlackAppId(MediaPositionBlackAppIdDto dto) {
        String positionIds = dto.getPositionIds();
        String appIds = dto.getAppIds();
        HashSet<String> positionIdList = new HashSet<String>(Arrays.asList(positionIds.split(",")));
        HashSet<String> appIdList = new HashSet<String>(Arrays.asList(appIds.split(",")));
        MediaPositionBlackAppIdSearchDto searchDto = new MediaPositionBlackAppIdSearchDto();
        searchDto.setPositionIdList(new ArrayList<String>(positionIdList));
        List adPositionBlackAppIdVos = this.adPositionBlackAppidMapper.list(searchDto);
        Set oldAppIdSet = adPositionBlackAppIdVos.stream().map(p -> p.getPositionId() + "$" + p.getAppId()).collect(Collectors.toSet());
        ArrayList<String> existAppId = new ArrayList<String>();
        ArrayList<AdPositionBlackAppid> saveAppId = new ArrayList<AdPositionBlackAppid>(appIdList.size());
        for (String positionId : positionIdList) {
            for (String appId : appIdList) {
                this.adPositionBlackAppidMapper.deleteByPositionId(positionId, appId);
                AdPositionBlackAppid adPositionBlackAppid = new AdPositionBlackAppid();
                adPositionBlackAppid.setPositionId(positionId);
                adPositionBlackAppid.setAppId(appId);
                adPositionBlackAppid.setReason(dto.getReason());
                saveAppId.add(adPositionBlackAppid);
                if (!oldAppIdSet.contains(positionId + "$" + appId)) continue;
                existAppId.add(appId);
            }
        }
        this.adPositionBlackAppidMapper.insertBatch(saveAppId);
        this.push(positionIdList);
        return existAppId;
    }

    @Override
    public PageInfo<AdPositionBlackAppIdVo> list(MediaPositionBlackAppIdSearchDto dto) {
        Page page = PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        this.adPositionBlackAppidMapper.list(dto);
        return page.toPageInfo();
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public void delete(String blackIds) throws Exception {
        List<String> blackIdList = Arrays.asList(blackIds.split(","));
        AdPositionBlackAppid adPositionBlackAppid = this.adPositionBlackAppidMapper.selectByPrimaryKey(Integer.valueOf(blackIdList.get(0)));
        if (null == adPositionBlackAppid) {
            return;
        }
        this.adPositionBlackAppidMapper.deleteBlackIdBatch(blackIdList);
        HashSet<String> positionIdList = new HashSet<String>();
        positionIdList.add(adPositionBlackAppid.getPositionId());
        this.push(positionIdList);
    }

    @Override
    public void updatePositionBlackAppId(MediaPositionBlackAppIdDto dto) {
        AdPositionBlackAppid adPositionBlackAppid = new AdPositionBlackAppid();
        adPositionBlackAppid.setId(dto.getId());
        adPositionBlackAppid.setReason(dto.getReason());
        this.adPositionBlackAppidMapper.updateByPrimaryKeySelective(adPositionBlackAppid);
    }

    void push(Set<String> positionIdList) {
        if (CollectionUtils.isEmpty(positionIdList)) {
            return;
        }
        for (String positionId : positionIdList) {
            MediaPositionBlackAppIdSearchDto searchDto = new MediaPositionBlackAppIdSearchDto();
            searchDto.setPositionId(positionId);
            List list = this.adPositionBlackAppidMapper.list(searchDto);
            String totalAppIds = "";
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                totalAppIds = list.stream().map(l -> l.getAppId()).collect(Collectors.joining(","));
            }
            PositionBlackAppId positionBlackAppId = new PositionBlackAppId();
            positionBlackAppId.setPositionId(positionId);
            positionBlackAppId.setAppIds(totalAppIds);
            try {
                this.prodPusher.pushToProd(ProdServiceNameEnum.POSITION_APP_ID_BLACK.getServiceName(), (Map)Maps.newHashMap(), JsonHelper.convert2bytes((Object)positionBlackAppId));
            }
            catch (Exception e) {
                log.error("\u63a8\u9001\u5e7f\u544a\u4f4dAppId\u9ed1\u540d\u5355\u9519\u8bef" + e.getMessage(), (Throwable)e);
            }
        }
    }
}

