/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.media.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdRulesMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.config.AdPositionExtConfigMapper;
import com.bxm.adsmanager.dal.mapper.media.AdPositionBlackAppidMapper;
import com.bxm.adsmanager.dal.mapper.media.MediaMapper;
import com.bxm.adsmanager.dal.mapper.media.MediaPositionDirectTicketMapper;
import com.bxm.adsmanager.dal.mapper.media.MediaPositionWhiteTicketMapper;
import com.bxm.adsmanager.dal.mapper.position.PositionNewConfigMapper;
import com.bxm.adsmanager.dal.mapper.tbltag.ext.TblAdPostionTagMapperExt;
import com.bxm.adsmanager.enums.AreaTypeEnum;
import com.bxm.adsmanager.facade.model.position.PositionUpdateDto;
import com.bxm.adsmanager.integration.acl.AclUserIntegration;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.integration.adsmedia.media.NewMediaFacadeIntegration;
import com.bxm.adsmanager.integration.adsmedia.provider.ProviderFacadeIntegration;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.integration.adsprod.service.ProdTicketSimulationIntegration;
import com.bxm.adsmanager.model.constant.CommonConstant;
import com.bxm.adsmanager.model.constant.RedisKeys;
import com.bxm.adsmanager.model.dao.adkeeper.AdRules;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.config.AdPositionExtConfig;
import com.bxm.adsmanager.model.dao.media.AdMedia;
import com.bxm.adsmanager.model.dao.media.AdMediaPosition;
import com.bxm.adsmanager.model.dao.media.AdMediaTag;
import com.bxm.adsmanager.model.dao.media.AdPositionDirectTicket;
import com.bxm.adsmanager.model.dao.media.OldTagMsg;
import com.bxm.adsmanager.model.dao.media.Rules;
import com.bxm.adsmanager.model.dao.media.Time;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.PositionNewConfig;
import com.bxm.adsmanager.model.dto.mediamanager.MediaPositionBlackAppIdSearchDto;
import com.bxm.adsmanager.model.dto.position.PositionDirectFlowAssignDto;
import com.bxm.adsmanager.model.enums.ProdServiceNameEnum;
import com.bxm.adsmanager.model.enums.RuleTargetEnum;
import com.bxm.adsmanager.model.enums.RuleTypeEnum;
import com.bxm.adsmanager.model.vo.media.AdMediaTagMsg;
import com.bxm.adsmanager.model.vo.media.AdMediaTagPushVo;
import com.bxm.adsmanager.model.vo.media.AdMediaTagVo;
import com.bxm.adsmanager.model.vo.media.ProviderForAdsmanagerVO;
import com.bxm.adsmanager.model.vo.tbltag.TblAdTagVo;
import com.bxm.adsmanager.redis.RedisNewClient;
import com.bxm.adsmanager.service.common.DictionariesService;
import com.bxm.adsmanager.service.media.MediaService;
import com.bxm.adsmanager.service.mediamanager.PositionTicketWeightService;
import com.bxm.adsmanager.service.prod.ProdService;
import com.bxm.adsmanager.service.tbltag.TblAdTagService;
import com.bxm.adsmanager.utils.AppEntityConvertHelper;
import com.bxm.adsmanager.utils.CollectionDataCopyUtil;
import com.bxm.adsmanager.utils.PageInfoFactory;
import com.bxm.adsmanager.utils.UserRoleCodeUtil;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import com.bxm.adsmedia.facade.model.media.MediaAuditVO;
import com.bxm.adsmedia.facade.model.provider.ProviderAppAdDTO;
import com.bxm.adsmedia.facade.model.provider.ProviderRO;
import com.bxm.adsmedia.facade.model.provider.QueryProviderParamsDTO;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.util.StringUtil;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.integration.pair.Value;
import com.bxm.warcar.integration.pair.redis.RedisPairImpl;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriComponentsBuilder;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service
public final class MediaServiceImpl
implements MediaService {
    private static final Logger log = LoggerFactory.getLogger(MediaServiceImpl.class);
    @Autowired
    private MediaMapper mediaMapper;
    @Autowired
    private TblAdPostionTagMapperExt tblAdPostionTagMapperExt;
    @Autowired
    private AdRulesMapper adRulesMapper;
    @Autowired
    private ProdPusherIntegration prodPusher;
    @Autowired
    private MediaPositionWhiteTicketMapper mediaPositionWhiteTicketMapper;
    @Autowired
    private MediaPositionDirectTicketMapper mediaPositionDirectTicketMapper;
    @Autowired
    private ProdService prodService;
    @Autowired
    private AdTicketMapper adTicketMapper;
    @Autowired
    private TblAdTagService tblAdTagService;
    @Resource
    private RedisNewClient redisNewClient;
    @Autowired
    private PositionTicketWeightService positionTicketWeightService;
    @Autowired
    private AdPositionExtConfigMapper adPositionExtConfigMapper;
    @Autowired
    private PositionNewConfigMapper positionNewConfigMapper;
    @Resource
    private AclUserIntegration aclUserIntegration;
    @Autowired
    private ProviderFacadeIntegration providerFacadeIntegration;
    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;
    @Autowired
    private NewMediaFacadeIntegration newMediaFacadeIntegration;
    @Autowired
    private DictionariesService dictionariesService;
    @Autowired
    private ProdTicketSimulationIntegration prodTicketSimulationIntegration;
    @Autowired
    private AdPositionBlackAppidMapper adPositionBlackAppidMapper;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired
    @Qualifier(value="customeRedisPairImpl")
    private RedisPairImpl pair;
    private static List<String> positionIdList = Arrays.asList("596648b06c324b0ba77f7b833a42c38a-5", "596648b06c324b0ba77f7b833a42c38a-4", "e3017aa9baa445b0aefde8ee5350bec9-3", "c8552ca9a04a4c949ef21f4e26e352ef-1", "f8a9e882b09d4fbd987e4cecb52dfb95-4", "71b127d75f5c4125a3c42f3369d8acc7-3", "885a29ba3aad463f82d8a8118e434294-3", "f8044e2a60264cb9bfa37f80eee1cfdc-93", "f8044e2a60264cb9bfa37f80eee1cfdc-94");
    @Autowired
    private JedisFetcher fetcher;

    @Override
    public PageInfo<ProviderForAdsmanagerVO> queryMedia(String keyword, String mjcode, String bdcode, String email, Integer prepay, Integer pageNum, Integer pageSize, User user, Integer areaType) {
        PageInfo<ProviderForAdsmanagerVO> pageInfo;
        List voList;
        if (null != user && StringUtils.isNotBlank((CharSequence)UserRoleCodeUtil.isMj(user))) {
            if (StringUtils.isNotBlank((CharSequence)mjcode) && !mjcode.equals(user.getUsername())) {
                return PageInfoFactory.noData();
            }
            mjcode = user.getUsername();
        }
        if (null != user && StringUtils.isNotBlank((CharSequence)UserRoleCodeUtil.isBd(user))) {
            if (StringUtils.isNotBlank((CharSequence)bdcode) && !bdcode.equals(user.getUsername())) {
                return PageInfoFactory.noData();
            }
            bdcode = user.getUsername();
        }
        if (CollectionUtils.isEmpty((Collection)(voList = (pageInfo = this.getProviderAppForAdsmanagerVO(keyword, mjcode, bdcode, email, prepay, pageNum, pageSize, areaType)).getList()))) {
            return PageInfoFactory.noData();
        }
        Map mapMj = this.aclUserIntegration.queryUserByRoleCode("mj", Boolean.valueOf(false));
        Map mapBd = this.aclUserIntegration.queryUserByRoleCode("BD", Boolean.valueOf(false));
        Integer number = (pageNum - 1) * pageSize;
        for (ProviderForAdsmanagerVO vo : voList) {
            String appIdAndSecret;
            number = number + 1;
            vo.setNumber(number);
            vo.setMjText(mapMj.getOrDefault(vo.getMjcode(), ""));
            vo.setBdText(mapBd.getOrDefault(vo.getBdcode(), ""));
            PositionNewConfig positionNewConfig = this.positionNewConfigMapper.findByPositionId(vo.getAppkey());
            if (Objects.nonNull(positionNewConfig)) {
                vo.setIntro(positionNewConfig.getIntro());
                vo.setActRule(positionNewConfig.getActRule());
                vo.setActExplain(positionNewConfig.getActExplain());
                vo.setActivityStatement(positionNewConfig.getActivityStatement());
            }
            if (!Objects.nonNull(vo.getRtbType())) continue;
            String wbappId = (String)this.fetcher.hfetch(CommonConstant.getWeiboAppId(), vo.getAppkey(), String.class);
            if (!StringUtils.isBlank((CharSequence)wbappId) && vo.getRtbType() == 17) {
                vo.setWbAppId(wbappId);
                vo.setWbappCodeUrl("https://api.biz.weibo.com/oauth/authorize?client_id=" + wbappId + "&redirect_uri=https%3A%2F%2Fmgr.bianxianmao.com%3A18501%2Fwb%2Fcode&response_type=code&state=" + wbappId + "&scope=ads_read");
            }
            if (!Objects.equals(vo.getRtbType().intValue(), 1) || !StringUtils.isNotBlank((CharSequence)(appIdAndSecret = (String)this.fetcher.hfetch(RedisKeys.hashKuaishouAppIdConfig(), vo.getAppkey(), String.class)))) continue;
            String[] split = appIdAndSecret.split(",");
            String appId = split[0];
            String secret = split[1];
            String callbackUrl = split[2];
            vo.setKuaishouAppId(appId);
            vo.setKuaishouSecret(secret);
            vo.setKuaishouCallbackUrl(callbackUrl);
        }
        return pageInfo;
    }

    private PageInfo<ProviderForAdsmanagerVO> getProviderAppForAdsmanagerVO(String keywords, String mjCode, String bdCode, String email, Integer prepay, Integer pageNum, Integer pageSize, Integer areaType) {
        QueryProviderParamsDTO dto = new QueryProviderParamsDTO();
        dto.setKeywords(keywords);
        dto.setMjCode(mjCode);
        dto.setBdCode(bdCode);
        dto.setEmail(email);
        if (null != prepay) {
            dto.setAdvanceTypeFlag(Boolean.valueOf(1 == prepay));
        }
        dto.setAreaType(areaType);
        dto.setPageNum(pageNum);
        dto.setPageSize(pageSize);
        PageInfo providerROPageInfo = this.providerFacadeIntegration.getProviderPage(dto);
        if (CollectionUtils.isEmpty((Collection)providerROPageInfo.getList())) {
            return PageInfoFactory.noData();
        }
        PageInfo pageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)providerROPageInfo, (Object)pageInfo);
        ArrayList providerAppForAdsmanagerVOS = Lists.newArrayList();
        Integer number = (pageNum - 1) * pageSize;
        for (ProviderRO providerRO : providerROPageInfo.getList()) {
            ProviderForAdsmanagerVO providerAppForAdsmanagerVO = new ProviderForAdsmanagerVO();
            providerAppForAdsmanagerVO.setAppkey(providerRO.getAppKey());
            providerAppForAdsmanagerVO.setAppname(providerRO.getAppAlias());
            providerAppForAdsmanagerVO.setBdcode(providerRO.getBdCode());
            providerAppForAdsmanagerVO.setBusinessCount(providerRO.getAppEntranceCount());
            providerAppForAdsmanagerVO.setMjcode(providerRO.getMjCode());
            number = number + 1;
            providerAppForAdsmanagerVO.setNumber(number);
            providerAppForAdsmanagerVO.setAdvanceType(providerRO.getAdvanceTypeFlag() == null ? null : Integer.valueOf(providerRO.getAdvanceTypeFlag() != false ? 1 : 0));
            providerAppForAdsmanagerVO.setPrepay(providerRO.getAdvanceTypeFlag());
            providerAppForAdsmanagerVO.setRemark(providerRO.getRemark());
            providerAppForAdsmanagerVO.setAccountType(Integer.valueOf(providerRO.getProviderTypeCode().intValue()));
            providerAppForAdsmanagerVO.setProviderAccountType(Integer.valueOf(providerRO.getAccountTypeCode().intValue()));
            providerAppForAdsmanagerVO.setRtbType(providerRO.getRtbType());
            providerAppForAdsmanagerVO.setAllowOcpr(providerRO.getAllowOcpr());
            providerAppForAdsmanagerVO.setDataViewingRole(providerRO.getDataViewingRole());
            providerAppForAdsmanagerVO.setDomain(providerRO.getDomain());
            providerAppForAdsmanagerVO.setProviderId(providerRO.getId());
            providerAppForAdsmanagerVO.setAreaType(providerRO.getAreaType());
            providerAppForAdsmanagerVOS.add(providerAppForAdsmanagerVO);
        }
        pageInfo.setList((List)providerAppForAdsmanagerVOS);
        return pageInfo;
    }

    @Override
    public PageInfo<AdMediaPosition> queryMediaPosition(String appkey, Byte putinType, Integer pageNum, Integer pageSize, String keywords) {
        HashMap mapTag;
        QueryAppEntranceParamDTO dto = new QueryAppEntranceParamDTO();
        dto.setAppKey(appkey);
        dto.setPutinType(putinType);
        dto.setKeywords(keywords);
        dto.setPageNum(pageNum);
        dto.setPageSize(pageSize);
        PageInfo appEntranceAdRoPageInfo = this.newAppEntranceFacadeIntegration.getPage(dto);
        List appEntranceAdRos = appEntranceAdRoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)appEntranceAdRos)) {
            return PageInfoFactory.noData();
        }
        ArrayList adMediaPositions = Lists.newArrayListWithCapacity((int)appEntranceAdRos.size());
        ArrayList positionIds = Lists.newArrayListWithCapacity((int)appEntranceAdRos.size());
        Integer number = (pageNum - 1) * pageSize;
        for (AppEntranceAdRO adRO : appEntranceAdRos) {
            AdMediaPosition adMediaPosition = new AdMediaPosition();
            number = number + 1;
            adMediaPosition.setNumber(number);
            adMediaPosition.setAppkey(adRO.getAppKey());
            adMediaPosition.setAppname(adRO.getProviderAlias());
            adMediaPosition.setBusiness(adRO.getAppEntranceId().toString());
            adMediaPosition.setAppentrancename(adRO.getAppEntranceName());
            adMediaPosition.setPositionSize(adRO.getImageSize());
            adMediaPosition.setPositionId(adRO.getPositionId());
            adMediaPosition.setCooperationType(adRO.getCooperationType());
            adMediaPosition.setAdvanceTypeFlag(adRO.getAdvanceTypeFlag());
            adMediaPosition.setPositionScene(adRO.getPositionScene());
            adMediaPosition.setCountry(adRO.getCountry());
            adMediaPosition.setAreaType(adRO.getAreaType());
            if (null != adRO.getMediaChildClassId()) {
                adMediaPosition.setPositionChildClassId(String.valueOf(adRO.getMediaChildClassId()));
                adMediaPosition.setPositionChildClass(adRO.getMediaChildClassName());
            }
            if (null != adRO.getMediaClassId()) {
                adMediaPosition.setPositionParentClassId(String.valueOf(adRO.getMediaClassId()));
                adMediaPosition.setPositionParentClass(adRO.getMediaClassName());
            }
            adMediaPosition.setMediaType(adRO.getMediaSysType());
            if (null != adRO.getDockingMethod()) {
                adMediaPosition.setMode(String.valueOf(adRO.getDockingMethod()));
            }
            adMediaPosition.setPositionClassId(adRO.getId().toString());
            adMediaPosition.setDspFlag(adRO.getDspFlag());
            adMediaPosition.setEntranceScene(adRO.getEntranceScene());
            adMediaPosition.setEntrancePicUrl(adRO.getEntrancePicUrl());
            adMediaPosition.setClosedFlag(adRO.getClosedFlag());
            adMediaPosition.setWechatMiniAppPutFlag(adRO.getWechatMiniAppPutFlag());
            if (0 == adRO.getDockingMethod()) {
                this.buildPageLink(adMediaPosition);
            }
            adMediaPosition.setCouponsPutinFlag(adRO.getCouponsPutinFlag());
            adMediaPosition.setCouponsIconSize(adRO.getCouponsIconSize());
            adMediaPosition.setCouponsCreativeSize(adRO.getCouponsCreativeSize());
            adMediaPosition.setPutinType(adRO.getPutinType());
            adMediaPosition.setVideoDirection(adRO.getVideoDirection());
            adMediaPosition.setReportUrl(adRO.getReportUrl());
            if (adRO.getAppEntranceAdxId() != null) {
                adMediaPosition.setAppEntranceAdxId(adRO.getAppEntranceAdxId());
                adMediaPosition.setAdType(adRO.getAdType());
                adMediaPosition.setPositionType(adRO.getPositionType());
                adMediaPosition.setPositionTypeDesc(adRO.getPositionTypeDesc());
                adMediaPosition.setNormalRequestsRatio(adRO.getNormalRequestsRatio());
                adMediaPosition.setSettleType(adRO.getSettleType());
                adMediaPosition.setAdxChannel(adRO.getAdxChannel());
                adMediaPosition.setChannelTagId(adRO.getChannelTagId());
                adMediaPosition.setAssetsTemplateId(adRO.getAssetsTemplateId());
                adMediaPosition.setProfitMargin(adRO.getProfitMargin());
                if (adRO.getAdxNative() != null) {
                    AdMediaPosition.AdxNative adxNative = new AdMediaPosition.AdxNative();
                    BeanUtils.copyProperties((Object)adRO.getAdxNative(), (Object)adxNative);
                    adMediaPosition.setAdxNative(adxNative);
                }
                if (adRO.getAdxPicture() != null) {
                    AdMediaPosition.AdxPicture adxPicture = new AdMediaPosition.AdxPicture();
                    BeanUtils.copyProperties((Object)adRO.getAdxPicture(), (Object)adxPicture);
                    adMediaPosition.setAdxPicture(adxPicture);
                }
                if (adRO.getAdxText() != null) {
                    AdMediaPosition.AdxText adxText = new AdMediaPosition.AdxText();
                    BeanUtils.copyProperties((Object)adRO.getAdxText(), (Object)adxText);
                    adMediaPosition.setAdxText(adxText);
                }
                if (adRO.getAdxNativeVideo() != null) {
                    AdMediaPosition.AdxNativeVideo adxNativeVideo = new AdMediaPosition.AdxNativeVideo();
                    BeanUtils.copyProperties((Object)adRO.getAdxNativeVideo(), (Object)adxNativeVideo);
                    adMediaPosition.setAdxNativeVideo(adxNativeVideo);
                }
            }
            adMediaPositions.add(adMediaPosition);
            positionIds.add(adRO.getPositionId());
        }
        PageInfo mediaPositionPageInfo = CollectionDataCopyUtil.copyPageInfo(appEntranceAdRoPageInfo);
        mediaPositionPageInfo.setList((List)adMediaPositions);
        List<TblAdTagVo> treeAdTag = this.tblAdTagService.findTblAdTagListByType(0, 2);
        List<TblAdTagVo> tbl = this.tblAdTagService.findTblAdTagListByType(0, 1);
        if (CollectionUtils.isNotEmpty(tbl)) {
            mapTag = Maps.newHashMapWithExpectedSize((int)tbl.size());
            tbl.forEach(label -> mapTag.put(label.getCode().toString(), label.getName()));
        } else {
            mapTag = Collections.emptyMap();
        }
        List rulesByBiaoqiandiyu = this.adRulesMapper.findByTargetIdSupplements(Integer.valueOf(RuleTargetEnum.GUANGGAO_WEI.getValue()), Integer.valueOf(RuleTypeEnum.BIAOQIANDIYU.getValue()), (List)positionIds);
        List adPositionWhiteTicketList = this.mediaPositionWhiteTicketMapper.selectTicketIdByList((List)positionIds);
        List adPositionDirectTicketList = this.mediaPositionDirectTicketMapper.selectTicketIdByList((List)positionIds);
        HashMap<String, String> map = new HashMap<String, String>(adPositionWhiteTicketList.size());
        if (CollectionUtils.isNotEmpty((Collection)adPositionWhiteTicketList)) {
            for (Object ap : adPositionWhiteTicketList) {
                map.put(ap.getPositionId(), ap.getTicketId());
            }
        }
        HashMap<String, String> map2 = new HashMap<String, String>(adPositionDirectTicketList.size());
        if (CollectionUtils.isNotEmpty((Collection)adPositionDirectTicketList)) {
            for (AdPositionDirectTicket ap : adPositionDirectTicketList) {
                map2.put(ap.getPositionId(), ap.getTicketIds());
            }
        }
        HashMap mapTags = new HashMap(rulesByBiaoqiandiyu == null ? 0 : rulesByBiaoqiandiyu.size());
        HashMap tagCount = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)rulesByBiaoqiandiyu)) {
            HashMap<String, String> mapRules = new HashMap<String, String>(rulesByBiaoqiandiyu.size());
            rulesByBiaoqiandiyu.forEach(rule -> mapRules.put(rule.getKey(), rule.getValue()));
            HashSet listCode = new HashSet();
            mapRules.forEach((key, value) -> {
                List adMediaTags = JSON.parseArray((String)value, AdMediaTag.class);
                StringBuffer sb = new StringBuffer();
                if (CollectionUtils.isNotEmpty((Collection)adMediaTags)) {
                    for (AdMediaTag adMediaTag : adMediaTags) {
                        listCode.add(adMediaTag.getTag());
                    }
                    tagCount.put(key, adMediaTags.size());
                    for (String str : listCode) {
                        if (mapTag.get(str) == null) continue;
                        sb.append((String)mapTag.get(str)).append(",");
                    }
                    for (TblAdTagVo tt : treeAdTag) {
                        if (tt.getChildList().size() <= 0) {
                            if (!listCode.contains(tt.getCode().toString())) continue;
                            sb.append(tt.getName()).append(",");
                            continue;
                        }
                        this.codeTest(tt.getChildList(), listCode, tt.getName(), sb, "2");
                    }
                }
                if (StringUtil.isNotBlank((CharSequence)sb.toString())) {
                    mapTags.put(key, sb.toString().substring(0, sb.toString().length() - 1));
                }
                listCode.clear();
            });
        }
        MediaPositionBlackAppIdSearchDto searchDto = new MediaPositionBlackAppIdSearchDto();
        searchDto.setPositionIdList((List)positionIds);
        List positionBlackAppIdVos = this.adPositionBlackAppidMapper.list(searchDto);
        Map<String, Long> positionAppIdBalckNumMap = positionBlackAppIdVos.stream().collect(Collectors.groupingBy(p -> p.getPositionId(), Collectors.counting()));
        for (AdMediaPosition adMediaPosition : adMediaPositions) {
            String positionId = adMediaPosition.getPositionId();
            adMediaPosition.setTags((String)mapTags.get(positionId));
            adMediaPosition.setTagsCount(tagCount.getOrDefault(positionId, 0).intValue());
            adMediaPosition.setTicketIds((String)map.get(positionId));
            adMediaPosition.setDirectTickets((String)map2.getOrDefault(positionId, null));
            adMediaPosition.setAppIdBlackNum(positionAppIdBalckNumMap.getOrDefault(positionId, 0L));
            String key2 = RedisKeys.getKey((String)"AD_POSITION_CONFIG_%s", (Object[])new Object[]{positionId});
            AdPositionExtConfig extConfig = this.adPositionExtConfigMapper.getByPositionId(positionId);
            if (null == extConfig || null == extConfig.getNeedFloatMaterial()) {
                adMediaPosition.setNeedFloatMaterial(Integer.valueOf(1));
            } else {
                adMediaPosition.setNeedFloatMaterial(extConfig.getNeedFloatMaterial());
            }
            PositionNewConfig positionNewConfig = this.positionNewConfigMapper.findByPositionId(positionId);
            if (null == positionNewConfig) {
                adMediaPosition.setNewWanliu(Byte.valueOf((byte)1));
                adMediaPosition.setMore(Byte.valueOf((byte)1));
                adMediaPosition.setActivityStatement(Byte.valueOf((byte)0));
                adMediaPosition.setRewardTicket(Byte.valueOf((byte)0));
                if (positionIdList.contains(positionId)) {
                    adMediaPosition.setRewardTicket(Byte.valueOf((byte)0));
                } else {
                    adMediaPosition.setRewardTicket(Byte.valueOf((byte)1));
                    adMediaPosition.setRewardTicketCount(Integer.valueOf(3));
                }
                if (adMediaPosition.getAreaType().equals(AreaTypeEnum.AREA_TYPE_OTHER.getCode())) {
                    adMediaPosition.setNeedFloatMaterial(Integer.valueOf(0));
                    adMediaPosition.setNewWanliu(Byte.valueOf((byte)0));
                    adMediaPosition.setMore(Byte.valueOf((byte)0));
                    adMediaPosition.setRewardTicket(Byte.valueOf((byte)0));
                    adMediaPosition.setRewardTicketCount(Integer.valueOf(0));
                }
                adMediaPosition.setQqFront(Byte.valueOf((byte)0));
                adMediaPosition.setConfig(Integer.valueOf(0));
            } else {
                adMediaPosition.setNewWanliu(positionNewConfig.getNewWanliu());
                adMediaPosition.setStayWindowdsRegion(positionNewConfig.getStayWindowdsRegion());
                adMediaPosition.setStayWindowdsTime(positionNewConfig.getStayWindowdsTime());
                adMediaPosition.setMore(positionNewConfig.getMore());
                adMediaPosition.setActivityStatement(positionNewConfig.getActivityStatement());
                adMediaPosition.setIntro(positionNewConfig.getIntro());
                adMediaPosition.setRewardTicket(positionNewConfig.getRewardTicket());
                adMediaPosition.setRewardTicketCount(positionNewConfig.getRewardTicketCount());
                adMediaPosition.setActExplain(positionNewConfig.getActExplain());
                adMediaPosition.setActRule(positionNewConfig.getActRule());
                adMediaPosition.setQqFront(Byte.valueOf(Objects.isNull(positionNewConfig.getQqFront()) ? (byte)1 : positionNewConfig.getQqFront()));
                adMediaPosition.setQq(positionNewConfig.getQq());
                adMediaPosition.setKfPhone(positionNewConfig.getKfPhone());
                if (positionNewConfig.getKfFront() != null && positionNewConfig.getKfFront() == 1) {
                    adMediaPosition.setConfig(Integer.valueOf(76));
                } else {
                    adMediaPosition.setConfig(Integer.valueOf(0));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.fetcher.hfetch(CommonConstant.getKeyGeneratorByPositionDomainiCode(), positionId, String.class)))) {
                adMediaPosition.setDoMainCodeStatus(Integer.valueOf(1));
            } else {
                adMediaPosition.setDoMainCodeStatus(Integer.valueOf(0));
            }
            if ("1".equals(this.fetcher.hfetch(TicketKeyGenerator.Media.getMediaTagHighestControllers(), positionId, String.class))) {
                adMediaPosition.setHighestPositionStatus(Boolean.valueOf(true));
            } else {
                adMediaPosition.setHighestPositionStatus(Boolean.valueOf(false));
            }
            if (StringUtils.isNotBlank((CharSequence)adMediaPosition.getDirectTickets())) {
                Value value2 = this.pair.get(KeyBuilder.build((Object[])new Object[]{"DIRECT", adMediaPosition.getPositionId()}));
                adMediaPosition.setHaveDirectTicket(Boolean.valueOf(true));
                adMediaPosition.setDirectTicketRatio(value2 == null ? null : value2.ofInt());
            } else {
                adMediaPosition.setHaveDirectTicket(Boolean.valueOf(false));
            }
            adMediaPosition.setCheckUv((Byte)this.fetcher.hfetch(MediaServiceImpl.keyGenerator(), positionId, Byte.class));
            if (this.getPositionWhiteGroupSwitch(positionId).booleanValue()) {
                adMediaPosition.setOpenWhiteGroup(Integer.valueOf(0));
                continue;
            }
            adMediaPosition.setOpenWhiteGroup(Integer.valueOf(1));
        }
        return mediaPositionPageInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean getPositionWhiteGroupSwitch(String positionId) {
        JedisPool jedisPool = (JedisPool)this.fetcher.getClientOriginal();
        Jedis jedis = null;
        Boolean value = false;
        try {
            jedis = jedisPool.getResource();
            value = jedis.sismember("AD:FILTER:TICKET_GROUP:SWITCH", positionId);
        }
        catch (Exception e) {
            Boolean bl = value;
            return bl;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
        return value;
    }

    public static KeyGenerator keyGenerator() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "NOT", "CHECK", "UV"});
    }

    private void buildPageLink(AdMediaPosition adMediaPosition) {
        String stringBuilder = "https://i.tandehao.com/activities/?appKey=" + adMediaPosition.getAppkey() + "&appType=" + adMediaPosition.getMediaType() + "&appEntrance=" + adMediaPosition.getBusiness() + "&business=money";
        adMediaPosition.setLink(stringBuilder);
    }

    public Boolean codeTest(List<TblAdTagVo> treeChildAdTag, Set<String> listCode, String name, StringBuffer sb, String i) {
        ArrayList<String> treeList = new ArrayList<String>();
        ArrayList<String> tagList = new ArrayList<String>();
        Boolean b = true;
        for (TblAdTagVo ttsecond : treeChildAdTag) {
            if (ttsecond.getChildList().size() <= 0) {
                treeList.add(ttsecond.getCode().toString());
                if (!listCode.contains(ttsecond.getCode().toString())) continue;
                tagList.add(ttsecond.getCode().toString());
                continue;
            }
            treeList.add(ttsecond.getCode().toString());
            if (!this.codeTest(ttsecond.getChildList(), listCode, name + "/" + ttsecond.getName(), sb, "3").booleanValue()) continue;
            tagList.add(ttsecond.getCode().toString());
        }
        if (tagList != null && treeList.size() == tagList.size()) {
            b = true;
            if (StringUtil.equals((CharSequence)"2", (CharSequence)i)) {
                sb.append(name + ",");
            }
        } else {
            for (TblAdTagVo ttsecond : treeChildAdTag) {
                if (!tagList.contains(ttsecond.getCode().toString())) continue;
                sb.append(name + "/" + ttsecond.getName() + ",");
            }
            b = false;
        }
        return b;
    }

    @Override
    public List<AdMediaTagVo> queryTagByPositionId(String appkey, String business) {
        String rule = this.adRulesMapper.findByTargetIdSupplement(Integer.valueOf(RuleTargetEnum.GUANGGAO_WEI.getValue()), Integer.valueOf(RuleTypeEnum.BIAOQIANDIYU.getValue()), this.getLinkString(appkey, business, "-"));
        if (StringUtil.isNotEmpty((CharSequence)rule)) {
            List adMediaTags = JSON.parseArray((String)rule, AdMediaTag.class);
            List tablAdTag = this.tblAdPostionTagMapperExt.findAll();
            HashMap mapTag = new HashMap(tablAdTag == null ? 0 : tablAdTag.size());
            if (CollectionUtils.isNotEmpty((Collection)tablAdTag)) {
                tablAdTag.forEach(label -> mapTag.put(label.getCode() + "", label.getFullNameStr()));
            }
            ArrayList<AdMediaTagVo> rs = new ArrayList<AdMediaTagVo>();
            if (CollectionUtils.isNotEmpty((Collection)adMediaTags)) {
                adMediaTags.forEach(adMediaTag -> {
                    AdMediaTagVo adMediaTagVo = new AdMediaTagVo();
                    BeanUtils.copyProperties((Object)adMediaTag, (Object)adMediaTagVo);
                    adMediaTagVo.setTagText((String)mapTag.getOrDefault(adMediaTag.getTag(), null));
                    rs.add(adMediaTagVo);
                });
            }
            return rs;
        }
        return new ArrayList<AdMediaTagVo>();
    }

    @Override
    public void deleteTag(String appkey, String businessArray, String tagArray, String oldRegionArray, String oldTimeArray, String isBatch) throws Exception {
        List businesses = JSON.parseArray((String)businessArray, String.class);
        ArrayList positionIds = new ArrayList();
        List tags = JSON.parseArray((String)tagArray, String.class);
        businesses.forEach(business -> positionIds.add(this.getLinkString(appkey, (String)business, "-")));
        List rules = this.adRulesMapper.findByTargetIdSupplements(Integer.valueOf(RuleTargetEnum.GUANGGAO_WEI.getValue()), Integer.valueOf(RuleTypeEnum.BIAOQIANDIYU.getValue()), positionIds);
        if (CollectionUtils.isEmpty((Collection)rules)) {
            return;
        }
        List oldRegions = new ArrayList();
        if (StringUtil.isNotEmpty((CharSequence)oldRegionArray)) {
            oldRegions = JSON.parseArray((String)oldRegionArray, String.class);
        }
        List oldTimes = new ArrayList();
        if (StringUtil.isNotEmpty((CharSequence)oldTimeArray)) {
            oldTimes = JSON.parseArray((String)oldTimeArray, Time.class);
        }
        AdMediaTag oldAdMediaTag = new AdMediaTag();
        oldAdMediaTag.setRegions(oldRegions);
        oldAdMediaTag.setTimes(oldTimes);
        ArrayList<Rules> updateRules = new ArrayList<Rules>();
        rules.forEach(rule -> {
            List adMediaTags = JSON.parseArray((String)rule.getValue(), AdMediaTag.class);
            if (StringUtils.equals((CharSequence)"2", (CharSequence)isBatch)) {
                this.removeNewSameTag(adMediaTags, tags, oldAdMediaTag.getRegions(), oldAdMediaTag.getTimes());
            } else {
                this.removeSameTag(adMediaTags, tags);
            }
            Rules updateRule = new Rules();
            updateRule.setKey(rule.getKey());
            updateRule.setValue(JSON.toJSONString((Object)adMediaTags));
            updateRules.add(updateRule);
        });
        this.adRulesMapper.updateByTargetIdSupplements(Integer.valueOf(RuleTargetEnum.GUANGGAO_WEI.getValue()), Integer.valueOf(RuleTypeEnum.BIAOQIANDIYU.getValue()), updateRules);
        this.pushMediaTag(updateRules);
    }

    @Override
    public void bathInsertTag(String appkey, String businessArray, String tagArray, String regionArray, String timeArray) throws Exception {
        List businesses = JSON.parseArray((String)businessArray, String.class);
        ArrayList positionIds = new ArrayList();
        List tags = JSON.parseArray((String)tagArray, String.class);
        List regions = new ArrayList();
        if (StringUtil.isNotEmpty((CharSequence)regionArray)) {
            regions = JSON.parseArray((String)regionArray, String.class);
        }
        List times = new ArrayList();
        if (StringUtil.isNotEmpty((CharSequence)timeArray)) {
            times = JSON.parseArray((String)timeArray, Time.class);
        }
        ArrayList<AdMediaTag> newTags = new ArrayList<AdMediaTag>();
        for (String tag : tags) {
            AdMediaTag adMediaTag = new AdMediaTag();
            adMediaTag.setTag(tag);
            adMediaTag.setRegions(regions);
            adMediaTag.setTimes(times);
            newTags.add(adMediaTag);
        }
        ArrayList<Rules> updateRules = new ArrayList<Rules>();
        ArrayList<Rules> insertRules = new ArrayList<Rules>();
        businesses.forEach(business -> positionIds.add(this.getLinkString(appkey, (String)business, "-")));
        List rules = this.adRulesMapper.findByTargetIdSupplements(Integer.valueOf(RuleTargetEnum.GUANGGAO_WEI.getValue()), Integer.valueOf(RuleTypeEnum.BIAOQIANDIYU.getValue()), positionIds);
        if (CollectionUtils.isNotEmpty((Collection)rules)) {
            rules.forEach(rule -> {
                String positionId = rule.getKey();
                List adMediaTags = JSON.parseArray((String)rule.getValue(), AdMediaTag.class);
                this.removeNewSameTag(adMediaTags, tags, ((AdMediaTag)newTags.get(0)).getRegions(), ((AdMediaTag)newTags.get(0)).getTimes());
                adMediaTags.addAll(newTags);
                Rules updateRule = new Rules();
                updateRule.setKey(positionId);
                updateRule.setValue(JSON.toJSONString((Object)adMediaTags));
                updateRules.add(updateRule);
                positionIds.remove(positionId);
            });
            this.adRulesMapper.updateByTargetIdSupplements(Integer.valueOf(RuleTargetEnum.GUANGGAO_WEI.getValue()), Integer.valueOf(RuleTypeEnum.BIAOQIANDIYU.getValue()), updateRules);
        }
        if (CollectionUtils.isNotEmpty(positionIds)) {
            for (String positionId : positionIds) {
                Rules insertRule = new Rules();
                insertRule.setKey(positionId);
                insertRule.setValue(JSON.toJSONString(newTags));
                insertRules.add(insertRule);
            }
            this.adRulesMapper.batchInsertMediaTag(Integer.valueOf(RuleTargetEnum.GUANGGAO_WEI.getValue()), Integer.valueOf(RuleTypeEnum.BIAOQIANDIYU.getValue()), insertRules);
        }
        updateRules.addAll(insertRules);
        this.pushMediaTag(updateRules);
    }

    @Override
    public List<String> queryTagsByPositionId(String positionId) throws Exception {
        ArrayList<String> tagCodeList = new ArrayList<String>();
        ArrayList<String> positionIds = new ArrayList<String>();
        positionIds.add(positionId);
        List rules = this.adRulesMapper.findByTargetIdSupplements(Integer.valueOf(RuleTargetEnum.GUANGGAO_WEI.getValue()), Integer.valueOf(RuleTypeEnum.BIAOQIANDIYU.getValue()), positionIds);
        if (CollectionUtils.isNotEmpty((Collection)rules)) {
            rules.forEach(rule -> {
                String key = rule.getKey();
                List adMediaTags = JSON.parseArray((String)rule.getValue(), AdMediaTag.class);
                if (CollectionUtils.isNotEmpty((Collection)adMediaTags)) {
                    adMediaTags.forEach(adMediaTag -> tagCodeList.add(adMediaTag.getTag()));
                }
            });
        }
        return tagCodeList;
    }

    @Override
    public PageInfo<MediaAuditVO> getAuditPage(String companyName, String mediaName, String mjCode, Byte status, Long providerId, Integer areaType, Integer pageNum, Integer pageSize) {
        PageInfo auditPage = this.newMediaFacadeIntegration.getAuditPage(companyName, mediaName, mjCode, status, providerId, areaType, pageNum, pageSize);
        if (auditPage != null && auditPage.getList() != null) {
            Map<String, String> kfzbqMap = this.dictionariesService.getIdDetailMapByCode("KFZBQ");
            auditPage.getList().stream().forEach(e -> {
                String tags = e.getTags();
                if (StringUtils.isNotBlank((CharSequence)tags)) {
                    String[] tagArray = tags.split(",");
                    StringBuilder tagNams = new StringBuilder();
                    for (String tagId : tagArray) {
                        String tagName = (String)kfzbqMap.get(tagId);
                        if (tagName == null) continue;
                        tagNams.append(tagName).append(",");
                    }
                    if (tagNams.length() > 0) {
                        tagNams.deleteCharAt(tagNams.length() - 1);
                    }
                    e.setTags(tagNams.toString());
                }
            });
        }
        return auditPage;
    }

    public void removeNewSameTag(List<AdMediaTag> oldAdMediaTags, List<String> newTags, List<String> newRegions, List<Time> newTimes) {
        if (CollectionUtils.isNotEmpty(oldAdMediaTags)) {
            List<Object> oldTime = new ArrayList();
            List<String> newTime = this.getList(newTimes);
            Iterator<AdMediaTag> iterator = oldAdMediaTags.iterator();
            while (iterator.hasNext()) {
                AdMediaTag oldAdMediaTag = iterator.next();
                for (String newTag : newTags) {
                    if (!newTag.equals(oldAdMediaTag.getTag()) || CollectionUtils.isEmpty(newRegions) && CollectionUtils.isNotEmpty((Collection)oldAdMediaTag.getRegions()) || CollectionUtils.isNotEmpty(newRegions) && CollectionUtils.isEmpty((Collection)oldAdMediaTag.getRegions())) continue;
                    if (CollectionUtils.isEmpty(newRegions) && CollectionUtils.isEmpty((Collection)oldAdMediaTag.getRegions())) {
                        oldTime = this.getList(oldAdMediaTag.getTimes());
                        if (CollectionUtils.isEmpty(newTime) && CollectionUtils.isNotEmpty(oldTime) || CollectionUtils.isNotEmpty(newTime) && CollectionUtils.isEmpty(oldTime)) continue;
                        if (CollectionUtils.isEmpty(oldTime) && CollectionUtils.isEmpty(newTime)) {
                            iterator.remove();
                        } else if (oldTime.containsAll(newTime)) {
                            iterator.remove();
                        }
                    } else if (oldAdMediaTag.getRegions().containsAll(newRegions)) {
                        oldTime = this.getList(oldAdMediaTag.getTimes());
                        if (CollectionUtils.isEmpty(newTime) && CollectionUtils.isNotEmpty(oldTime) || CollectionUtils.isNotEmpty(newTime) && CollectionUtils.isEmpty(oldTime)) continue;
                        if (CollectionUtils.isEmpty(oldTime) && CollectionUtils.isEmpty(newTime)) {
                            iterator.remove();
                        } else if (oldTime.containsAll(newTime)) {
                            iterator.remove();
                        }
                    }
                    oldTime.clear();
                }
            }
        }
    }

    public List<String> getList(List<Time> times) {
        if (CollectionUtils.isEmpty(times)) {
            return new ArrayList<String>();
        }
        ArrayList<String> timeList = new ArrayList<String>();
        for (Time time : times) {
            timeList.add(time.getStart().toString());
            timeList.add(time.getEnd().toString());
        }
        return timeList;
    }

    @Override
    public void updateTag(String appkey, String business, String oldTag, String newTag, String regionArray, String timeArray, String oldRegionArray, String oldTimeArray) throws Exception {
        ArrayList<String> regions = new ArrayList();
        if (StringUtil.isNotEmpty((CharSequence)regionArray)) {
            regions = JSON.parseArray((String)regionArray, String.class);
        }
        ArrayList<String> oldRegions = new ArrayList();
        if (StringUtil.isNotEmpty((CharSequence)oldRegionArray)) {
            oldRegions = JSON.parseArray((String)oldRegionArray, String.class);
        }
        ArrayList<Time> oldTimes = new ArrayList();
        if (StringUtil.isNotEmpty((CharSequence)oldTimeArray)) {
            oldTimes = JSON.parseArray((String)oldTimeArray, Time.class);
        }
        ArrayList<Time> times = new ArrayList();
        if (StringUtil.isNotEmpty((CharSequence)timeArray)) {
            times = JSON.parseArray((String)timeArray, Time.class);
        }
        String positionId = this.getLinkString(appkey, business, "-");
        String rule = this.adRulesMapper.findByTargetIdSupplement(Integer.valueOf(RuleTargetEnum.GUANGGAO_WEI.getValue()), Integer.valueOf(RuleTypeEnum.BIAOQIANDIYU.getValue()), positionId);
        List adMediaTags = JSON.parseArray((String)rule, AdMediaTag.class);
        ArrayList<String> tags = new ArrayList<String>();
        tags.add(oldTag);
        this.removeNewSameTag(adMediaTags, tags, oldRegions, oldTimes);
        this.removeNewSameTag(adMediaTags, tags, regions, times);
        AdMediaTag adMediaTag = new AdMediaTag();
        adMediaTag.setTag(newTag);
        adMediaTag.setRegions(regions);
        adMediaTag.setTimes(times);
        adMediaTags.add(adMediaTag);
        ArrayList<Rules> updateRules = new ArrayList<Rules>();
        Rules updateRule = new Rules();
        updateRule.setKey(positionId);
        updateRule.setValue(JSON.toJSONString((Object)adMediaTags));
        updateRules.add(updateRule);
        this.adRulesMapper.updateByTargetIdSupplements(Integer.valueOf(RuleTargetEnum.GUANGGAO_WEI.getValue()), Integer.valueOf(RuleTypeEnum.BIAOQIANDIYU.getValue()), updateRules);
        this.pushMediaTag(updateRules);
    }

    private String getLinkString(String first, String last, String link) {
        return first.concat(link).concat(last);
    }

    private void removeSameTag(List<AdMediaTag> adMediaTags, List<String> tags) {
        if (CollectionUtils.isNotEmpty(adMediaTags)) {
            Iterator<AdMediaTag> iterator = adMediaTags.iterator();
            while (iterator.hasNext()) {
                if (!tags.contains(iterator.next().getTag())) continue;
                iterator.remove();
            }
        }
    }

    private void pushMediaTag(List<Rules> rules) throws Exception {
        if (CollectionUtils.isNotEmpty(rules)) {
            ArrayList<AdMediaTagPushVo> pushVos = new ArrayList<AdMediaTagPushVo>();
            for (Rules rule : rules) {
                ArrayList adMediaTagMsgs = new ArrayList();
                List adMediaTags = JSON.parseArray((String)rule.getValue(), AdMediaTag.class);
                if (CollectionUtils.isNotEmpty((Collection)adMediaTags)) {
                    adMediaTags.forEach(adMediaTag -> {
                        AdMediaTagMsg adMediaTagMsg = new AdMediaTagMsg();
                        adMediaTagMsg.setTag(adMediaTag.getTag());
                        adMediaTagMsg.setRegions(this.dealRegions(adMediaTag.getRegions()));
                        adMediaTagMsg.setTimes(this.dealTime(adMediaTag.getTimes()));
                        adMediaTagMsgs.add(adMediaTagMsg);
                    });
                }
                AdMediaTagPushVo adMediaTagPushVo = new AdMediaTagPushVo();
                adMediaTagPushVo.setPositionId(rule.getKey());
                adMediaTagPushVo.setTagMsg(JSON.toJSONString(adMediaTagMsgs));
                pushVos.add(adMediaTagPushVo);
            }
            this.prodPusher.pushToProd(ProdServiceNameEnum.MEDIA_TAG_REGION_TIME.getServiceName(), null, JSONArray.toJSONBytes(pushVos, (SerializerFeature[])new SerializerFeature[0]));
        }
    }

    private Set<String> dealRegions(List<String> regions) {
        HashSet<String> sets = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(regions)) {
            sets.addAll(regions);
        }
        return sets;
    }

    private Set<Integer> dealTime(List<Time> times) {
        HashSet<Integer> sets = new HashSet<Integer>();
        if (CollectionUtils.isNotEmpty(times)) {
            for (Time time : times) {
                int end;
                if (time == null || time.getStart() == null || time.getEnd() == null) continue;
                int start = time.getStart();
                int n = end = time.getEnd() == 0 ? 24 : time.getEnd();
                while (start < end) {
                    sets.add(new Integer(start++));
                }
            }
        }
        return sets;
    }

    @Override
    public synchronized void synchronizationTags() throws Exception {
        ImmutableSet ignore = ImmutableSet.of((Object)"fab287b219b343c98318a57d543640f1-1", (Object)"fab287b219b343c98318a57d543640f1-3", (Object)"fab287b219b343c98318a57d543640f1-4", (Object)"fab287b219b343c98318a57d543640f1-5", (Object)"fab287b219b343c98318a57d543640f1-6", (Object)"fab287b219b343c98318a57d543640f1-7", (Object[])new String[]{"fab287b219b343c98318a57d543640f1-8", "edde293a05924207ad88b2b9de85eea9-3", "87397ac0787448e69afc82375b553685-3", "87397ac0787448e69afc82375b553685-5", "87397ac0787448e69afc82375b553685-6", "90273d3f463849d6a3e47cafc863edd5-3", "90273d3f463849d6a3e47cafc863edd5-4", "95728cd9ce354f978c4e82bfa0e02b56-1"});
        List oldTagMsgs = this.mediaMapper.queryOldTag();
        if (CollectionUtils.isNotEmpty((Collection)oldTagMsgs)) {
            HashMap<String, List> mapTags = new HashMap<String, List>();
            for (OldTagMsg oldTagMsg : oldTagMsgs) {
                String positionId = oldTagMsg.getPositionId();
                List list = mapTags.getOrDefault(positionId, new ArrayList());
                AdMediaTag adMediaTag = new AdMediaTag();
                adMediaTag.setTag(oldTagMsg.getTag());
                adMediaTag.setRegions(oldTagMsg.getRegions());
                list.add(adMediaTag);
                if (ignore.contains(positionId)) continue;
                mapTags.put(positionId, list);
            }
            ArrayList<Rules> insertRules = new ArrayList<Rules>();
            for (Map.Entry tag : mapTags.entrySet()) {
                List value = (List)tag.getValue();
                if (!CollectionUtils.isNotEmpty((Collection)value)) continue;
                Rules rule = new Rules();
                rule.setKey((String)tag.getKey());
                rule.setValue(JSON.toJSONString(tag.getValue()));
                insertRules.add(rule);
            }
            this.adRulesMapper.batchInsertMediaTag(Integer.valueOf(RuleTargetEnum.GUANGGAO_WEI.getValue()), Integer.valueOf(RuleTypeEnum.BIAOQIANDIYU.getValue()), insertRules);
            this.pushMediaTag(insertRules);
        }
    }

    @Override
    @Deprecated
    public void pusholdByPositionId() throws Exception {
        ArrayList<Rules> insertRules = new ArrayList<Rules>();
        List adRulesList = this.adRulesMapper.findAllByTargetIdSupplement();
        ArrayList<Rules> updateRules = new ArrayList<Rules>();
        ArrayList<String> oldls = new ArrayList<String>();
        ArrayList<String> newls = new ArrayList<String>();
        for (AdRules adRule : adRulesList) {
            List adMediaTags = JSON.parseArray((String)adRule.getRuleValue(), AdMediaTag.class);
            if (!CollectionUtils.isNotEmpty((Collection)adMediaTags)) continue;
            List<Object> newAdMediaTags = new ArrayList();
            for (AdMediaTag amt : adMediaTags) {
                oldls.add(amt.getTag());
            }
            newAdMediaTags = MediaServiceImpl.getnewAdMediaTags(oldls, newls, adMediaTags);
            Rules updateRule = new Rules();
            updateRule.setKey(adRule.getTargetIdSupplement());
            updateRule.setValue(JSON.toJSONString(newAdMediaTags));
            updateRules.add(updateRule);
            oldls.clear();
            newls.clear();
            Rules rl = new Rules();
            rl.setKey(adRule.getTargetIdSupplement());
            rl.setValue(JSON.toJSONString(newAdMediaTags));
            insertRules.add(rl);
        }
        this.adRulesMapper.updateRuleBakByTargetIdSupplements(Integer.valueOf(RuleTargetEnum.GUANGGAO_WEI.getValue()), Integer.valueOf(RuleTypeEnum.BIAOQIANDIYU.getValue()), updateRules);
    }

    @Override
    public void pushTagsByTicketId() throws Exception {
        List list = this.adTicketMapper.findAllTicket();
        int count = 0;
        for (AdTicket at : list) {
            log.info("\u5df2\u7ecf\u63a8\u9001\u4e86" + ++count + "-----\u603b\u5171\u6709" + list.size() + "\u6761\u6570\u636e");
            this.prodService.pushAdTicketToProdPre(at.getId());
        }
    }

    @Override
    public void rollbackTagByPositionId() throws Exception {
        ArrayList<Rules> insertRules = new ArrayList<Rules>();
        List adRulesList = this.adRulesMapper.findAllByTargetIdSupplement();
        for (AdRules adRule : adRulesList) {
            List adMediaTags = JSON.parseArray((String)adRule.getRuleValue(), AdMediaTag.class);
            if (!CollectionUtils.isNotEmpty((Collection)adMediaTags)) continue;
            Rules rl = new Rules();
            rl.setKey(adRule.getTargetIdSupplement());
            rl.setValue(JSON.toJSONString((Object)adMediaTags));
            insertRules.add(rl);
        }
        this.pushMediaTag(insertRules);
    }

    @Deprecated
    public static List<AdMediaTag> getnewAdMediaTags(List<String> oldls, List<String> newls, List<AdMediaTag> oldTag) {
        AdMediaTag amt55;
        AdMediaTag amt44;
        AdMediaTag amt33;
        AdMediaTag amt22;
        AdMediaTag amt11;
        AdMediaTag amt5;
        AdMediaTag amt4;
        AdMediaTag amt3;
        AdMediaTag amt2;
        AdMediaTag amt1;
        ArrayList<AdMediaTag> newTag = new ArrayList<AdMediaTag>();
        HashMap<String, AdMediaTag> map = new HashMap<String, AdMediaTag>();
        for (AdMediaTag at : oldTag) {
            map.put(at.getTag(), at);
        }
        if (oldls.contains("3") || oldls.contains("4") || oldls.contains("38") || oldls.contains("19")) {
            if (oldls.contains("3")) {
                newls.add("3");
                amt1 = new AdMediaTag();
                BeanUtils.copyProperties(map.get("3"), (Object)amt1);
                newTag.add(amt1);
            }
            if (oldls.contains("4")) {
                newls.add("4");
                amt1 = new AdMediaTag();
                BeanUtils.copyProperties(map.get("4"), (Object)amt1);
                newTag.add(amt1);
            }
            if (oldls.contains("38")) {
                newls.add("38");
                amt1 = new AdMediaTag();
                BeanUtils.copyProperties(map.get("38"), (Object)amt1);
                newTag.add(amt1);
            }
            if (oldls.contains("19")) {
                newls.add("19");
                amt1 = new AdMediaTag();
                BeanUtils.copyProperties(map.get("19"), (Object)amt1);
                newTag.add(amt1);
            }
        }
        if (oldls.contains("1")) {
            newls.add("40");
            newls.add("46");
            newls.add("47");
            newls.add("48");
            newls.add("14");
            amt1 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("1"), (Object)amt1);
            amt1.setTag("40");
            newTag.add(amt1);
            amt2 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("1"), (Object)amt2);
            amt2.setTag("46");
            newTag.add(amt2);
            amt3 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("1"), (Object)amt3);
            amt3.setTag("47");
            newTag.add(amt3);
            amt4 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("1"), (Object)amt4);
            amt4.setTag("48");
            newTag.add(amt4);
            amt5 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("1"), (Object)amt5);
            amt5.setTag("14");
            newTag.add(amt5);
        }
        if (!oldls.contains("1") && oldls.contains("40")) {
            newls.add("40");
            amt1 = new AdMediaTag();
            amt1 = (AdMediaTag)map.get("40");
            newTag.add(amt1);
        }
        if (oldls.contains("29") && !oldls.contains("2")) {
            newls.add("8");
            newls.add("9");
            newls.add("10");
            newls.add("34");
            newls.add("23");
            amt1 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("29"), (Object)amt1);
            amt1.setTag("8");
            newTag.add(amt1);
            amt2 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("29"), (Object)amt2);
            amt2.setTag("9");
            newTag.add(amt2);
            amt3 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("29"), (Object)amt3);
            amt3.setTag("10");
            newTag.add(amt3);
            amt4 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("29"), (Object)amt4);
            amt4.setTag("34");
            newTag.add(amt4);
            amt5 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("29"), (Object)amt5);
            amt5.setTag("23");
            newTag.add(amt5);
            newls.add("41");
            newls.add("42");
            newls.add("43");
            newls.add("44");
            newls.add("22");
            amt11 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("29"), (Object)amt11);
            amt11.setTag("41");
            newTag.add(amt11);
            amt22 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("29"), (Object)amt22);
            amt22.setTag("42");
            newTag.add(amt22);
            amt33 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("29"), (Object)amt33);
            amt33.setTag("43");
            newTag.add(amt33);
            amt44 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("29"), (Object)amt44);
            amt44.setTag("44");
            newTag.add(amt44);
            amt55 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("29"), (Object)amt55);
            amt55.setTag("22");
            newTag.add(amt55);
        }
        if (oldls.contains("29") && oldls.contains("2")) {
            newls.add("8");
            newls.add("9");
            newls.add("10");
            newls.add("34");
            newls.add("23");
            amt1 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("2"), (Object)amt1);
            amt1.setTag("8");
            newTag.add(amt1);
            amt2 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("2"), (Object)amt2);
            amt2.setTag("9");
            newTag.add(amt2);
            amt3 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("2"), (Object)amt3);
            amt3.setTag("10");
            newTag.add(amt3);
            amt4 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("2"), (Object)amt4);
            amt4.setTag("34");
            newTag.add(amt4);
            amt5 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("2"), (Object)amt5);
            amt5.setTag("23");
            newTag.add(amt5);
            newls.add("41");
            newls.add("42");
            newls.add("43");
            newls.add("44");
            newls.add("22");
            amt11 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("2"), (Object)amt11);
            amt11.setTag("41");
            newTag.add(amt11);
            amt22 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("2"), (Object)amt22);
            amt22.setTag("42");
            newTag.add(amt22);
            amt33 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("2"), (Object)amt33);
            amt33.setTag("43");
            newTag.add(amt33);
            amt44 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("2"), (Object)amt44);
            amt44.setTag("44");
            newTag.add(amt44);
            amt55 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("2"), (Object)amt55);
            amt55.setTag("22");
            newTag.add(amt55);
        }
        if (!oldls.contains("29") && oldls.contains("2")) {
            newls.add("8");
            newls.add("9");
            newls.add("10");
            newls.add("34");
            newls.add("23");
            amt1 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("2"), (Object)amt1);
            amt1.setTag("8");
            newTag.add(amt1);
            amt2 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("2"), (Object)amt2);
            amt2.setTag("9");
            newTag.add(amt2);
            amt3 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("2"), (Object)amt3);
            amt3.setTag("10");
            newTag.add(amt3);
            amt4 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("2"), (Object)amt4);
            amt4.setTag("34");
            newTag.add(amt4);
            amt5 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("2"), (Object)amt5);
            amt5.setTag("23");
            newTag.add(amt5);
            newls.add("41");
            newls.add("42");
            newls.add("43");
            newls.add("44");
            newls.add("22");
            amt11 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("2"), (Object)amt11);
            amt11.setTag("41");
            newTag.add(amt11);
            amt22 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("2"), (Object)amt22);
            amt22.setTag("42");
            newTag.add(amt22);
            amt33 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("2"), (Object)amt33);
            amt33.setTag("43");
            newTag.add(amt33);
            amt44 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("2"), (Object)amt44);
            amt44.setTag("44");
            newTag.add(amt44);
            amt55 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("2"), (Object)amt55);
            amt55.setTag("22");
            newTag.add(amt55);
        }
        if (!oldls.contains("2") && !oldls.contains("29") && (oldls.contains("8") || oldls.contains("9") || oldls.contains("10") || oldls.contains("34"))) {
            AdMediaTag amt52;
            if (oldls.contains("8")) {
                newls.add("8");
                newls.add("41");
                amt1 = new AdMediaTag();
                BeanUtils.copyProperties(map.get("8"), (Object)amt1);
                newTag.add(amt1);
                amt52 = new AdMediaTag();
                BeanUtils.copyProperties(map.get("8"), (Object)amt52);
                amt52.setTag("41");
                newTag.add(amt52);
            }
            if (oldls.contains("9")) {
                newls.add("9");
                newls.add("42");
                amt1 = new AdMediaTag();
                BeanUtils.copyProperties(map.get("9"), (Object)amt1);
                newTag.add(amt1);
                amt52 = new AdMediaTag();
                BeanUtils.copyProperties(map.get("9"), (Object)amt52);
                amt52.setTag("42");
                newTag.add(amt52);
            }
            if (oldls.contains("10")) {
                newls.add("10");
                newls.add("43");
                amt1 = new AdMediaTag();
                BeanUtils.copyProperties(map.get("10"), (Object)amt1);
                newTag.add(amt1);
                amt52 = new AdMediaTag();
                BeanUtils.copyProperties(map.get("10"), (Object)amt52);
                amt52.setTag("43");
                newTag.add(amt52);
            }
            if (oldls.contains("34")) {
                newls.add("34");
                newls.add("44");
                amt1 = new AdMediaTag();
                BeanUtils.copyProperties(map.get("34"), (Object)amt1);
                newTag.add(amt1);
                amt52 = new AdMediaTag();
                BeanUtils.copyProperties(map.get("34"), (Object)amt52);
                amt52.setTag("44");
                newTag.add(amt52);
            }
        }
        if (oldls.contains("5")) {
            newls.add("49");
            newls.add("50");
            newls.add("51");
            newls.add("52");
            newls.add("31");
            newls.add("32");
            newls.add("59");
            newls.add("60");
            newls.add("61");
            newls.add("57");
            newls.add("58");
            newls.add("21");
            newls.add("33");
            amt1 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("5"), (Object)amt1);
            amt1.setTag("49");
            newTag.add(amt1);
            amt2 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("5"), (Object)amt2);
            amt2.setTag("50");
            newTag.add(amt2);
            amt3 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("5"), (Object)amt3);
            amt3.setTag("51");
            newTag.add(amt3);
            amt4 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("5"), (Object)amt4);
            amt4.setTag("52");
            newTag.add(amt4);
            amt5 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("5"), (Object)amt5);
            amt5.setTag("31");
            newTag.add(amt5);
            amt11 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("5"), (Object)amt11);
            amt11.setTag("32");
            newTag.add(amt11);
            amt22 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("5"), (Object)amt22);
            amt22.setTag("59");
            newTag.add(amt22);
            amt33 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("5"), (Object)amt33);
            amt33.setTag("60");
            newTag.add(amt33);
            amt44 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("5"), (Object)amt44);
            amt44.setTag("61");
            newTag.add(amt44);
            amt55 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("5"), (Object)amt55);
            amt55.setTag("57");
            newTag.add(amt55);
            AdMediaTag amt111 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("5"), (Object)amt111);
            amt111.setTag("58");
            newTag.add(amt111);
            AdMediaTag amt222 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("5"), (Object)amt222);
            amt222.setTag("21");
            newTag.add(amt222);
            AdMediaTag amt333 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("5"), (Object)amt333);
            amt333.setTag("33");
            newTag.add(amt333);
        }
        if (!oldls.contains("5") && (oldls.contains("33") || oldls.contains("45") || oldls.contains("31") || oldls.contains("32"))) {
            if (oldls.contains("33")) {
                newls.add("33");
                amt1 = new AdMediaTag();
                amt1 = (AdMediaTag)map.get("33");
                newTag.add(amt1);
            }
            if (oldls.contains("45")) {
                newls.add("45");
                amt1 = new AdMediaTag();
                amt1 = (AdMediaTag)map.get("45");
                newTag.add(amt1);
            }
            if (oldls.contains("31")) {
                newls.add("31");
                amt1 = new AdMediaTag();
                amt1 = (AdMediaTag)map.get("31");
                newTag.add(amt1);
            }
            if (oldls.contains("32")) {
                newls.add("32");
                amt1 = new AdMediaTag();
                amt1 = (AdMediaTag)map.get("32");
                newTag.add(amt1);
            }
        }
        if (oldls.contains("11")) {
            newls.add("62");
            newls.add("63");
            newls.add("64");
            newls.add("65");
            newls.add("20");
            amt1 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("11"), (Object)amt1);
            amt1.setTag("62");
            newTag.add(amt1);
            amt2 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("11"), (Object)amt2);
            amt2.setTag("63");
            newTag.add(amt2);
            amt3 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("11"), (Object)amt3);
            amt3.setTag("64");
            newTag.add(amt3);
            amt4 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("11"), (Object)amt4);
            amt4.setTag("65");
            newTag.add(amt4);
            amt5 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("11"), (Object)amt5);
            amt5.setTag("20");
            newTag.add(amt5);
        }
        if (oldls.contains("15")) {
            newls.add("18");
            newls.add("66");
            newls.add("67");
            newls.add("68");
            amt1 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("15"), (Object)amt1);
            amt1.setTag("18");
            newTag.add(amt1);
            amt2 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("15"), (Object)amt2);
            amt2.setTag("66");
            newTag.add(amt2);
            amt3 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("15"), (Object)amt3);
            amt3.setTag("67");
            newTag.add(amt3);
            amt4 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("15"), (Object)amt4);
            amt4.setTag("68");
            newTag.add(amt4);
        }
        if (oldls.contains("16")) {
            newls.add("37");
            newls.add("39");
            newls.add("17");
            amt1 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("16"), (Object)amt1);
            amt1.setTag("37");
            newTag.add(amt1);
            amt2 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("16"), (Object)amt2);
            amt2.setTag("39");
            newTag.add(amt2);
            amt3 = new AdMediaTag();
            BeanUtils.copyProperties(map.get("16"), (Object)amt3);
            amt3.setTag("17");
            newTag.add(amt3);
        }
        if (!oldls.contains("16") && (oldls.contains("37") || oldls.contains("39") || oldls.contains("17"))) {
            if (oldls.contains("37")) {
                newls.add("37");
                amt1 = new AdMediaTag();
                amt1 = (AdMediaTag)map.get("37");
                newTag.add(amt1);
            }
            if (oldls.contains("39")) {
                newls.add("39");
                amt1 = new AdMediaTag();
                amt1 = (AdMediaTag)map.get("39");
                newTag.add(amt1);
            }
            if (oldls.contains("17")) {
                newls.add("17");
                amt1 = new AdMediaTag();
                amt1 = (AdMediaTag)map.get("17");
                newTag.add(amt1);
            }
        }
        if (oldls.contains("25")) {
            newls.add("25");
            amt1 = new AdMediaTag();
            amt1 = (AdMediaTag)map.get("25");
            newTag.add(amt1);
        }
        if (oldls.contains("26")) {
            newls.add("26");
            amt1 = new AdMediaTag();
            amt1 = (AdMediaTag)map.get("26");
            newTag.add(amt1);
        }
        if (oldls.contains("27")) {
            newls.add("27");
            amt1 = new AdMediaTag();
            amt1 = (AdMediaTag)map.get("27");
            newTag.add(amt1);
        }
        if (oldls.contains("30")) {
            newls.add("30");
            amt1 = new AdMediaTag();
            amt1 = (AdMediaTag)map.get("30");
            newTag.add(amt1);
        }
        if (oldls.contains("35")) {
            newls.add("35");
            amt1 = new AdMediaTag();
            amt1 = (AdMediaTag)map.get("35");
            newTag.add(amt1);
        }
        if (oldls.contains("36")) {
            newls.add("36");
            amt1 = new AdMediaTag();
            amt1 = (AdMediaTag)map.get("36");
            newTag.add(amt1);
        }
        if (oldls.contains("13")) {
            newls.add("13");
            amt1 = new AdMediaTag();
            amt1 = (AdMediaTag)map.get("13");
            newTag.add(amt1);
        }
        if (oldls.contains("6")) {
            newls.add("6");
            amt1 = new AdMediaTag();
            amt1 = (AdMediaTag)map.get("6");
            newTag.add(amt1);
        }
        if (oldls.contains("7")) {
            newls.add("7");
            amt1 = new AdMediaTag();
            amt1 = (AdMediaTag)map.get("7");
            newTag.add(amt1);
        }
        return newTag;
    }

    @Override
    @Deprecated
    public void comparison() throws Exception {
        List oldRule = this.adRulesMapper.findAllByTargetIdSupplement();
        List oldls = new ArrayList<String>();
        HashMap<String, Object> mapold = new HashMap<String, Object>();
        int count = 0;
        for (AdRules adRule : oldRule) {
            List adMediaTags = JSON.parseArray((String)adRule.getRuleValue(), AdMediaTag.class);
            if (CollectionUtils.isNotEmpty((Collection)adMediaTags)) {
                for (AdMediaTag amt : adMediaTags) {
                    oldls.add(amt.getTag());
                }
                List list = this.adRulesMapper.findTicketIdByParams(oldls);
                if (CollectionUtils.isNotEmpty((Collection)list) && list.size() > 0) {
                    mapold.put(adRule.getTargetIdSupplement(), list);
                }
                oldls.clear();
            }
            log.info("\u603b\u6570" + oldRule.size() + "------\u5f53\u524d--" + ++count);
        }
        List newRule = this.adRulesMapper.findAllBakByTargetIdSupplement();
        List newls = new ArrayList<String>();
        HashMap<String, List> mapnew = new HashMap<String, List>();
        count = 0;
        for (AdRules adRule : newRule) {
            List adMediaTags = JSON.parseArray((String)adRule.getRuleValue(), AdMediaTag.class);
            if (CollectionUtils.isNotEmpty((Collection)adMediaTags)) {
                for (AdMediaTag amt : adMediaTags) {
                    newls.add(amt.getTag());
                }
                List list = this.adRulesMapper.findNewTicketIdByParams(newls);
                if (CollectionUtils.isNotEmpty((Collection)list) && list.size() > 0) {
                    mapnew.put(adRule.getTargetIdSupplement(), list);
                }
                newls.clear();
            }
            log.info("\u603b\u6570" + oldRule.size() + "------\u5f53\u524d--" + ++count);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashSet<String> s = new HashSet<String>();
        HashSet<String> position = new HashSet<String>();
        for (String str : mapold.keySet()) {
            StringBuffer sb = new StringBuffer();
            oldls = (List)mapold.get(str);
            newls = (List)mapnew.get(str);
            if (newls == null) {
                position.add(str);
                continue;
            }
            for (String st : oldls) {
                if (newls.contains(st)) continue;
                sb.append(st + ",");
                s.add(st);
            }
            if (StringUtil.isNotBlank((CharSequence)sb.toString())) {
                map.put(str, sb.toString());
            }
            oldls.clear();
            newls.clear();
        }
        log.info(((Object)s).toString());
        log.info("\u4e3a\u7a7a\u7684\u5e7f\u544a\u4f4d" + position);
        for (String str : map.keySet()) {
            log.info("- \u5e7f\u544a\u4f4d-" + str + "--\u6ca1\u6709\u9650\u5236\u5230\u7684\u5238--" + (String)map.get(str));
        }
    }

    @Override
    public Boolean updateProvider(PositionUpdateDto positionUpdateDto) {
        String appKey = positionUpdateDto.getAppKey();
        String wbAppId = positionUpdateDto.getWbAppId();
        Byte allowOcpr = positionUpdateDto.getAllowOcpr();
        PositionNewConfig positionNewConfig = this.positionNewConfigMapper.findByPositionId(appKey);
        if (Objects.isNull(positionNewConfig)) {
            positionNewConfig = new PositionNewConfig();
        }
        positionNewConfig.setPositionId(positionUpdateDto.getAppKey());
        positionNewConfig.setActExplain(positionUpdateDto.getActExplain());
        positionNewConfig.setIntro(positionUpdateDto.getIntro());
        positionNewConfig.setActRule(positionUpdateDto.getActRule());
        positionNewConfig.setActivityStatement(positionUpdateDto.getActivityStatement());
        if (Objects.isNull(positionNewConfig.getId())) {
            this.positionNewConfigMapper.insertSelective(positionNewConfig);
        } else {
            this.positionNewConfigMapper.updateByPrimaryKeySelective(positionNewConfig);
        }
        String json = JSON.toJSONString((Object)positionNewConfig);
        this.redisNewClient.hset("AD_POSITION_CONFIG_NEW", appKey, json, 3, null);
        this.updater.hupdate(() -> KeyBuilder.build((Object[])new Object[]{"ALLOW", "OCPR"}), appKey, (Object)allowOcpr);
        if (StringUtils.isBlank((CharSequence)wbAppId)) {
            this.updater.hremove(CommonConstant.getWeiboAppId(), new String[]{appKey});
        } else {
            this.updater.hupdate(CommonConstant.getWeiboAppId(), appKey, (Object)wbAppId);
        }
        String kuaishouAppId = positionUpdateDto.getKuaishouAppId();
        String kuaishouSecret = positionUpdateDto.getKuaishouSecret();
        if (StringUtils.isBlank((CharSequence)kuaishouAppId)) {
            this.updater.hremove(RedisKeys.hashKuaishouAppIdConfig(), new String[]{appKey});
        } else {
            String oldConfig = (String)this.fetcher.hfetch(RedisKeys.hashKuaishouAppIdConfig(), appKey, String.class);
            if (StringUtils.isNotBlank((CharSequence)oldConfig)) {
                String[] split = oldConfig.split(",");
                String appId = split[0];
                this.updater.hremove(RedisKeys.hashKuaishouToken(), new String[]{appId});
            }
            String api = "https://mgr.bianxianmao.com:18501/kuaishou/callback";
            String callbackUrl = UriComponentsBuilder.fromUriString((String)api).replaceQueryParam("appKey", new Object[]{appKey}).replaceQueryParam("appId", new Object[]{kuaishouAppId}).toUriString();
            String kuaishouConfigValue = kuaishouAppId + "," + kuaishouSecret + "," + callbackUrl;
            this.updater.hupdate(RedisKeys.hashKuaishouAppIdConfig(), appKey, (Object)kuaishouConfigValue);
        }
        return this.providerFacadeIntegration.updateProvider(positionUpdateDto);
    }

    @Override
    public List<AdMedia> queryMedia2(String keyword) throws Exception {
        ProviderAppAdDTO providerAppAdDto = new ProviderAppAdDTO();
        providerAppAdDto.setKeywords(keyword);
        List<AdMedia> adMedias = AppEntityConvertHelper.appListConvertToAdMediaList(this.providerFacadeIntegration.getProviderAppList(providerAppAdDto));
        return adMedias;
    }

    @Override
    public boolean setPositionDirectFlow(PositionDirectFlowAssignDto dto) {
        List adPositionDirectTicketList = this.mediaPositionDirectTicketMapper.selectTicketIdByList(Stream.of(dto.getPositionId()).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty((Collection)adPositionDirectTicketList)) {
            return false;
        }
        long count = adPositionDirectTicketList.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getPositionId())).filter(e -> StringUtils.isNotBlank((CharSequence)e.getTicketIds())).count();
        if (count > 0L) {
            this.pair.set(KeyBuilder.build((Object[])new Object[]{"DIRECT", dto.getPositionId()}), String.valueOf(dto.getDirectTicketRatio()));
            return true;
        }
        return false;
    }

    @Override
    public List<AdMedia> queryMediaByAppKeys(String appKeys) {
        ProviderAppAdDTO providerAppAdDto = new ProviderAppAdDTO();
        if (StringUtils.isBlank((CharSequence)appKeys)) {
            return Collections.EMPTY_LIST;
        }
        List<String> appKeysList = Arrays.asList(appKeys.split(","));
        providerAppAdDto.setAppKeys(appKeysList);
        List<AdMedia> adMedias = AppEntityConvertHelper.appListConvertToAdMediaList(this.providerFacadeIntegration.getProviderAppList(providerAppAdDto));
        return adMedias;
    }

    @Override
    public void updateHighestPositions(String positionId, Boolean highestPositionStatus) throws Exception {
        if (highestPositionStatus.booleanValue()) {
            this.updater.hupdate(TicketKeyGenerator.Media.getMediaTagHighestControllers(), positionId, (Object)"1");
        } else {
            this.updater.hremove(TicketKeyGenerator.Media.getMediaTagHighestControllers(), new String[]{positionId});
        }
        byte[] data = JsonHelper.convert2bytes((Object)this.fetcher.hfetchall(TicketKeyGenerator.Media.getMediaTagHighestControllers(), String.class));
        this.prodPusher.pushToProd(ProdServiceNameEnum.POSITION_BLACKTAG_HIGHEST_LEVEL.getServiceName(), new HashMap(), data);
    }

    @Override
    public void bathInsertByCopy(String copyFromPositionId, String positionIds) throws Exception {
        ArrayList<String> positionIdsList = new ArrayList<String>();
        String[] value = positionIds.split(",");
        for (int i = 0; i < value.length; ++i) {
            positionIdsList.add(value[i]);
        }
        ArrayList<Rules> updateRules = new ArrayList<Rules>();
        ArrayList<Rules> insertRules = new ArrayList<Rules>();
        String rules = this.adRulesMapper.findByTargetIdSupplement(Integer.valueOf(RuleTargetEnum.GUANGGAO_WEI.getValue()), Integer.valueOf(RuleTypeEnum.BIAOQIANDIYU.getValue()), copyFromPositionId);
        List updateRulesList = this.adRulesMapper.findByTargetIdSupplements(Integer.valueOf(RuleTargetEnum.GUANGGAO_WEI.getValue()), Integer.valueOf(RuleTypeEnum.BIAOQIANDIYU.getValue()), positionIdsList);
        if (CollectionUtils.isNotEmpty((Collection)updateRulesList)) {
            for (Rules rules1 : updateRulesList) {
                rules1.setValue(rules);
                updateRules.add(rules1);
                positionIdsList.remove(rules1.getKey());
            }
            this.adRulesMapper.updateByTargetIdSupplements(Integer.valueOf(RuleTargetEnum.GUANGGAO_WEI.getValue()), Integer.valueOf(RuleTypeEnum.BIAOQIANDIYU.getValue()), updateRules);
        }
        if (CollectionUtils.isNotEmpty(positionIdsList)) {
            for (String positionId : positionIdsList) {
                Rules insertRule = new Rules();
                insertRule.setKey(positionId);
                insertRule.setValue(rules);
                insertRules.add(insertRule);
            }
            this.adRulesMapper.batchInsertMediaTag(Integer.valueOf(RuleTargetEnum.GUANGGAO_WEI.getValue()), Integer.valueOf(RuleTypeEnum.BIAOQIANDIYU.getValue()), insertRules);
        }
        updateRules.addAll(insertRules);
        this.pushMediaTag(updateRules);
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        System.out.println(URLEncoder.encode("http://47.98.242.33:18501/kuaishou/callback?appKey=757e39a645e9482e965a87cc28ee3b27&appId=165900167", "UTF-8"));
    }
}

