/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.media.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bxm.adsmanager.dal.mapper.media.MediaTestMapper;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.integration.adsmedia.provider.ProviderFacadeIntegration;
import com.bxm.adsmanager.integration.adsprod.service.ProdPullerIntegration;
import com.bxm.adsmanager.integration.adsprod.service.ProdPusherIntegration;
import com.bxm.adsmanager.integration.datapark.service.DataparkMediaPositionTestPullerIntegration;
import com.bxm.adsmanager.integration.utils.DataParkUtils;
import com.bxm.adsmanager.model.dao.AdTicketPopup.ProvideAppDto;
import com.bxm.adsmanager.model.dao.media.AdMediaTest;
import com.bxm.adsmanager.model.dto.mediamanager.MediaTestDto;
import com.bxm.adsmanager.model.dto.mediamanager.PositionWeightDto;
import com.bxm.adsmanager.model.enums.ProdServiceNameEnum;
import com.bxm.adsmanager.model.vo.media.AdMediaTestVo;
import com.bxm.adsmanager.model.vo.media.MediaTicketVo;
import com.bxm.adsmanager.service.adkeeper.AdPositionService;
import com.bxm.adsmanager.service.media.MediaTestService;
import com.bxm.adsmanager.service.mediamanager.PositionTicketWeightService;
import com.bxm.adsmanager.utils.CollectionDataCopyUtil;
import com.bxm.adsmanager.utils.DoubleUtil;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import com.bxm.adsmedia.facade.model.provider.ProviderAppAdRO;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.util.DateUtil;
import com.bxm.util.StringUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MediaTestServiceImpl
implements MediaTestService {
    private static final boolean String = false;
    @Autowired
    private MediaTestMapper mediaTestMapper;
    @Autowired
    private AdPositionService adPositionServiceImpl;
    @Autowired
    private ProdPusherIntegration prodPusherIntegration;
    @Autowired
    private ProdPullerIntegration pullerIntegration;
    @Autowired
    private PositionTicketWeightService positionTicketWeightService;
    @Autowired
    private DataparkMediaPositionTestPullerIntegration dataparkMediaPositionTestPullerIntegration;
    @Autowired
    private ProdPullerIntegration prodPullerIntegration;
    @Autowired
    private ProviderFacadeIntegration providerFacadeIntegration;
    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public void add(MediaTestDto mediaTestDto, String userName) throws Exception {
        Integer count = this.mediaTestMapper.getCountByPositionId(mediaTestDto.getPositionId());
        if (count > 0) {
            throw new Exception("\u8be5\u5e7f\u544a\u4f4d\u5df2\u7ecf\u6dfb\u52a0\u5165\u53e3\uff0c");
        }
        if (mediaTestDto.getCount() <= 0) {
            throw new Exception("\u66dd\u5149\u91cf\u7ea7\u5fc5\u987b\u5927\u4e8e0");
        }
        String[] temp = mediaTestDto.getPositionId().split("-");
        String appKey = temp[0];
        ProviderAppAdRO providerAppInfo = this.providerFacadeIntegration.getProviderAppInfoByAppKey(appKey);
        AdMediaTest adMediaTest = new AdMediaTest();
        adMediaTest.setCount(Long.valueOf(mediaTestDto.getCount().longValue()));
        adMediaTest.setCreateTime(new Date());
        adMediaTest.setCreateUser(userName);
        adMediaTest.setPositionId(mediaTestDto.getPositionId());
        adMediaTest.setStartTime(DateUtil.convertStr3Date((String)mediaTestDto.getMediaStartTime()));
        adMediaTest.setTicketId(mediaTestDto.getTicketId());
        adMediaTest.setState(Short.valueOf((short)0));
        adMediaTest.setTestName(mediaTestDto.getTestName());
        adMediaTest.setIsUseByWeight(Short.valueOf((short)0));
        adMediaTest.setMjCode(providerAppInfo.getMedium());
        this.mediaTestMapper.insert(adMediaTest);
        adMediaTest = this.mediaTestMapper.findAdMediaTestByPositionId(mediaTestDto.getPositionId());
        HashMap propMap = Maps.newHashMap();
        propMap.put("positionid", mediaTestDto.getPositionId());
        adMediaTest.setDeleted(false);
        adMediaTest.setTicketIds(MediaTestServiceImpl.getTicketIdList(adMediaTest.getTicketId().split(",")));
        this.prodPusherIntegration.pushToProd(ProdServiceNameEnum.POSITION_TEST.getServiceName(), (Map)propMap, JSONArray.toJSONBytes((Object)adMediaTest, (SerializerFeature[])new SerializerFeature[0]));
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public void update(MediaTestDto mediaTestDto, String userName) throws Exception {
        Integer count = this.mediaTestMapper.getCountByPositionId(mediaTestDto.getPositionId());
        if (count < 0) {
            throw new Exception("\u6539id\u4e0d\u5b58\u5728");
        }
        if (mediaTestDto.getCount() <= 0) {
            throw new Exception("\u66dd\u5149\u91cf\u7ea7\u5fc5\u987b\u5927\u4e8e0");
        }
        AdMediaTest adMediaTestBefore = this.mediaTestMapper.findAdMediaTestById(Long.valueOf(mediaTestDto.getId().longValue()));
        this.updateWeight(mediaTestDto.getId().longValue(), mediaTestDto.getTicketId(), mediaTestDto.getPositionId());
        String[] temp = mediaTestDto.getPositionId().split("-");
        String appKey = temp[0];
        ProviderAppAdRO providerAppInfo = this.providerFacadeIntegration.getProviderAppInfoByAppKey(appKey);
        AdMediaTest adMediaTest = new AdMediaTest();
        adMediaTest.setId(Long.valueOf(mediaTestDto.getId().longValue()));
        adMediaTest.setCount(Long.valueOf(mediaTestDto.getCount().longValue()));
        adMediaTest.setCreateTime(new Date());
        adMediaTest.setPositionId(mediaTestDto.getPositionId());
        adMediaTest.setStartTime(DateUtil.convertStr3Date((String)mediaTestDto.getMediaStartTime()));
        adMediaTest.setTicketId(mediaTestDto.getTicketId());
        adMediaTest.setState(mediaTestDto.getState());
        adMediaTest.setModifyUser(userName);
        adMediaTest.setTestName(mediaTestDto.getTestName());
        adMediaTest.setModifyTime(new Date());
        adMediaTest.setMjCode(providerAppInfo.getMedium());
        this.mediaTestMapper.update(adMediaTest);
        adMediaTest = this.mediaTestMapper.findAdMediaTestById(Long.valueOf(mediaTestDto.getId().longValue()));
        HashMap propMap = Maps.newHashMap();
        propMap.put("positionid", mediaTestDto.getPositionId());
        adMediaTest.setDeleted(false);
        adMediaTest.setTicketIds(MediaTestServiceImpl.getTicketIdList(adMediaTest.getTicketId().split(",")));
        this.prodPusherIntegration.pushToProd(ProdServiceNameEnum.POSITION_TEST.getServiceName(), (Map)propMap, JSONArray.toJSONBytes((Object)adMediaTest, (SerializerFeature[])new SerializerFeature[0]));
    }

    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public void updateWeight(Long id, String newTicket, String positionId) throws IOException {
        AdMediaTest beforUpdateadMediaTest = this.mediaTestMapper.findAdMediaTestById(id);
        List<String> oldTickeId = MediaTestServiceImpl.getTicketIdListString(beforUpdateadMediaTest.getTicketId().split(","));
        List<String> newTickeId = MediaTestServiceImpl.getTicketIdListString(newTicket.split(","));
        HashMap<String, String> map = new HashMap<String, String>();
        for (String string : newTickeId) {
            map.put(string, string);
        }
        StringBuffer sb = new StringBuffer();
        for (String strOld : oldTickeId) {
            if (map.get(strOld) != null) continue;
            sb.append(strOld + ",");
            this.prodPullerIntegration.updateHashMap(positionId, strOld);
        }
        if (StringUtils.isNotBlank((String)sb.toString())) {
            PositionWeightDto positionWeightDto = new PositionWeightDto();
            positionWeightDto.setInterventionFactor(100.0);
            positionWeightDto.setPositionId(beforUpdateadMediaTest.getPositionId());
            positionWeightDto.setTicketIdChar(sb.toString().substring(0, sb.toString().length() - 1));
            this.positionTicketWeightService.updatePositionWeight(positionWeightDto);
            this.dataparkMediaPositionTestPullerIntegration.removeAll();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public void updateStatus(Long id, Integer type) throws Exception {
        PositionWeightDto record;
        AdMediaTest adMediaTest = new AdMediaTest();
        adMediaTest.setId(id);
        adMediaTest.setState(Short.valueOf((short)1));
        adMediaTest.setIsUseByWeight(Short.valueOf((short)0));
        if (type == 2) {
            adMediaTest.setStartTime(new Date());
        }
        if (type == 4) {
            adMediaTest = this.mediaTestMapper.findAdMediaTestById(id);
            adMediaTest.setState(Short.valueOf((short)3));
            record = new PositionWeightDto();
            record.setInterventionFactor(100.0);
            record.setPositionId(adMediaTest.getPositionId());
            record.setTicketIdChar(adMediaTest.getTicketId());
            this.positionTicketWeightService.updatePositionWeight(record);
        } else {
            record = new PositionWeightDto();
            record.setInterventionFactor(1000.0);
            record.setPositionId(adMediaTest.getPositionId());
            record.setTicketIdChar(adMediaTest.getTicketId());
            this.positionTicketWeightService.updatePositionWeight(record);
        }
        this.mediaTestMapper.updateStatus(adMediaTest);
        adMediaTest = this.mediaTestMapper.findAdMediaTestById(id);
        if (type == 2) {
            adMediaTest.setDeleted(true);
        } else {
            adMediaTest.setDeleted(false);
        }
        HashMap propMap = Maps.newHashMap();
        propMap.put("positionid", adMediaTest.getPositionId());
        adMediaTest.setTicketIds(MediaTestServiceImpl.getTicketIdList(adMediaTest.getTicketId().split(",")));
        this.prodPusherIntegration.pushToProd(ProdServiceNameEnum.POSITION_TEST.getServiceName(), (Map)propMap, JSONArray.toJSONBytes((Object)adMediaTest, (SerializerFeature[])new SerializerFeature[0]));
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public void delete(Long id) throws Exception {
        AdMediaTest adMediaTest = this.mediaTestMapper.findAdMediaTestById(id);
        if (adMediaTest.getState() == 1) {
            throw new Exception("\u5e7f\u544a\u4f4d\u6d4b\u8bd5\u5df2\u7ecf\u5f00\u59cb\u4e0d\u80fd\u5220\u9664");
        }
        PositionWeightDto record = new PositionWeightDto();
        record.setInterventionFactor(100.0);
        record.setPositionId(adMediaTest.getPositionId());
        record.setTicketIdChar(adMediaTest.getTicketId());
        this.positionTicketWeightService.updatePositionWeight(record);
        this.mediaTestMapper.delete(id);
        HashMap propMap = Maps.newHashMap();
        propMap.put("positionid", adMediaTest.getPositionId());
        this.prodPusherIntegration.pushToProd(ProdServiceNameEnum.POSITION_TEST.getServiceName(), (Map)propMap, null);
    }

    @Override
    public PageInfo<AdMediaTestVo> findAllByAppKyeOrKeywords(String appKey, String keywords, String mjCode, Integer pageNum, Integer pageSize) {
        HashMap map = Maps.newHashMap();
        map.put("mjCode", mjCode);
        List adMediaTestVos = this.mediaTestMapper.findAllByAppKyeOrKeywords((Map)map);
        if (CollectionUtils.isEmpty((Collection)adMediaTestVos)) {
            return new PageInfo();
        }
        List positionIds = adMediaTestVos.stream().map(AdMediaTestVo::getPositionId).collect(Collectors.toList());
        QueryAppEntranceParamDTO paramDTO = new QueryAppEntranceParamDTO();
        paramDTO.setAppKey(appKey);
        paramDTO.setKeywords(keywords);
        paramDTO.setPositionIds(positionIds);
        paramDTO.setPageNum(pageNum);
        paramDTO.setPageSize(pageSize);
        PageInfo appEntranceAdRoPageInfo = this.newAppEntranceFacadeIntegration.getPage(paramDTO);
        List appEntranceAdRos = appEntranceAdRoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)appEntranceAdRos)) {
            return new PageInfo();
        }
        Map appEntranceAdRoMap = appEntranceAdRos.stream().collect(HashMap::new, (k, v) -> k.put(v.getPositionId(), v), HashMap::putAll);
        Double rtion = 0.0;
        Map<String, Long> mapCount = Maps.newHashMap();
        ArrayList resultList = Lists.newArrayListWithCapacity((int)appEntranceAdRos.size());
        for (AdMediaTestVo adMediaTestVo : adMediaTestVos) {
            if (!appEntranceAdRoMap.containsKey(adMediaTestVo.getPositionId())) continue;
            AppEntranceAdRO appEntranceAdRo = (AppEntranceAdRO)appEntranceAdRoMap.get(adMediaTestVo.getPositionId());
            if (null != appEntranceAdRo) {
                adMediaTestVo.setMediaName(appEntranceAdRo.getProviderAlias());
                adMediaTestVo.setPositionName(appEntranceAdRo.getAppEntranceName());
            }
            if ((mapCount = this.pullerIntegration.fetchPositionTestClickPvCount(adMediaTestVo.getPositionId())) != null && !mapCount.isEmpty()) {
                for (String ticketId : mapCount.keySet()) {
                    Ticket ticket = this.pullerIntegration.fetchTicket(ticketId);
                    mapCount.putIfAbsent(ticketId, 0L);
                    Double d = DoubleUtil.formatDouble(mapCount.get(ticketId) + "", ticket.getCloseThreshold() + "");
                    rtion = rtion + (null == d ? 0.0 : d);
                }
                adMediaTestVo.setRtion(DataParkUtils.formatDouble((Double)(DoubleUtil.formatDouble(rtion + "", adMediaTestVo.getTicketId().split(",").length + "") / 100.0)) + "%");
                mapCount.clear();
            } else {
                adMediaTestVo.setRtion("0%");
            }
            rtion = 0.0;
            resultList.add(adMediaTestVo);
        }
        PageInfo adMediaTestVoPageInfo = CollectionDataCopyUtil.copyPageInfo(appEntranceAdRoPageInfo);
        adMediaTestVoPageInfo.setList((List)resultList);
        return adMediaTestVoPageInfo;
    }

    @Override
    public AdMediaTestVo findAdMediaTestVoById(Long id) throws Exception {
        AdMediaTest adMediaTest = this.mediaTestMapper.findAdMediaTestById(id);
        AdMediaTestVo adMediaTestVo = new AdMediaTestVo();
        if (adMediaTest != null) {
            BeanUtils.copyProperties((Object)adMediaTest, (Object)adMediaTestVo);
            List<ProvideAppDto> prolist = this.adPositionServiceImpl.findAllByPositionId(adMediaTest.getPositionId());
            adMediaTestVo.setMediaName(prolist.get(0).getAppName());
            adMediaTestVo.setPositionName(prolist.get(0).getBusinessName());
        }
        return adMediaTestVo;
    }

    @Override
    public PageInfo<MediaTicketVo> findTicketByParam(String keywords, Integer pageNum, Integer pageSize, String ids) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("keywords", keywords);
        map.put("pageNum", pageNum);
        map.put("pageSize", pageSize);
        if (StringUtils.isNotBlank((String)ids)) {
            ArrayList<BigInteger> list = new ArrayList<BigInteger>();
            String[] s = ids.split(",");
            for (int i = 0; i < s.length; ++i) {
                list.add(BigInteger.valueOf(Long.parseLong(s[i])));
            }
            map.put("list", list);
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List adMediaTestList = this.mediaTestMapper.findTicketByParam(map);
        PageInfo pageInfo = new PageInfo(adMediaTestList);
        return pageInfo;
    }

    @Override
    public PageInfo<MediaTicketVo> findTicketByParamAndIds(String keywords, Integer pageNum, Integer pageSize, String ids) throws Exception {
        ArrayList<BigInteger> list;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("keywords", keywords);
        map.put("pageNum", pageNum);
        map.put("pageSize", pageSize);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        if (StringUtils.isNotBlank((String)ids)) {
            list = new ArrayList<BigInteger>();
            String[] s = ids.split(",");
            for (int i = 0; i < s.length; ++i) {
                list.add(BigInteger.valueOf(Long.parseLong(s[i])));
            }
        } else {
            return new PageInfo(new ArrayList());
        }
        map.put("list", list);
        List adMediaTestList = this.mediaTestMapper.findTicketByParam(map);
        PageInfo pageInfo = new PageInfo(adMediaTestList);
        return pageInfo;
    }

    @Override
    public PageInfo<MediaTicketVo> findOcpcTicketByParam(String keywords, Integer pageNum, Integer pageSize, String ids) throws Exception {
        ArrayList<BigInteger> list;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("keywords", keywords);
        map.put("pageNum", pageNum);
        map.put("pageSize", pageSize);
        if (StringUtils.isNotBlank((String)ids)) {
            list = new ArrayList<BigInteger>();
            String[] s = ids.split(",");
            for (int i = 0; i < s.length; ++i) {
                list.add(BigInteger.valueOf(Long.parseLong(s[i])));
            }
        } else {
            return new PageInfo();
        }
        map.put("list", list);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List adMediaTestList = this.mediaTestMapper.findOcpcTicketByParam(map);
        PageInfo pageInfo = new PageInfo(adMediaTestList);
        return pageInfo;
    }

    @Override
    public List<Integer> findOcpcTicketId() {
        List list = this.mediaTestMapper.findOcpcTicketIds();
        if (list == null || list.isEmpty()) {
            return Lists.newArrayList();
        }
        return list;
    }

    public static List<BigInteger> getTicketIdList(String[] str) {
        ArrayList<BigInteger> list = new ArrayList<BigInteger>();
        for (int i = 0; i < str.length; ++i) {
            if (!StringUtil.isNotBlank((CharSequence)str[i])) continue;
            list.add(BigInteger.valueOf(Long.parseLong(str[i])));
        }
        return list;
    }

    public static List<String> getTicketIdListString(String[] str) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < str.length; ++i) {
            if (!StringUtil.isNotBlank((CharSequence)str[i])) continue;
            list.add(str[i]);
        }
        return list;
    }
}

