/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.media.impl;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.common.DictionariesMapper;
import com.bxm.adsmanager.dal.mapper.media.MediaMapper;
import com.bxm.adsmanager.dal.mapper.media.MediaPositionWhiteTicketMapper;
import com.bxm.adsmanager.dal.mapper.tbltag.ext.TblAdPostionTagMapperExt;
import com.bxm.adsmanager.integration.acl.AclUserIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.common.Dictionaries;
import com.bxm.adsmanager.model.dto.common.CommonSearchDto;
import com.bxm.adsmanager.model.vo.media.MediaTicketVo;
import com.bxm.adsmanager.model.vo.tbltag.TblAdTagVo;
import com.bxm.adsmanager.service.media.MediaTicketTagService;
import com.bxm.adsmanager.service.tbltag.TblAdTagService;
import com.bxm.util.StringUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MediaTicketTagServiceImpl
implements MediaTicketTagService {
    private static final int TWO = 2;
    private static final String S_TWO = "2";
    private static final String STR_TWO = "2-";
    @Autowired
    private MediaMapper mediaMapper;
    @Autowired
    private TblAdTagService tblAdTagService;
    @Autowired
    private DictionariesMapper dictionariesMapper;
    @Autowired
    private TblAdPostionTagMapperExt tblAdPostionTagMapperExt;
    @Autowired
    private MediaPositionWhiteTicketMapper mediaPositionWhiteTicketMapper;
    @Autowired
    private AdTicketMapper adTicketMapper;
    @Autowired
    private AclUserIntegration aclUserIntegration;

    @Override
    public PageInfo<MediaTicketVo> findTicketByParam(String keywords, Integer pageNum, Integer pageSize, String ids, String type, String parentId, String statusCode, String positionId, String childId) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtil.isNotBlank((CharSequence)statusCode)) {
            if (statusCode.contains(STR_TWO)) {
                map.put("pauseReason", Integer.parseInt(statusCode.substring(2)));
            } else {
                map.put("status", Short.valueOf(statusCode));
            }
        }
        map.put("keywords", keywords);
        map.put("pageNum", pageNum);
        map.put("pageSize", pageSize);
        if (StringUtils.isNotBlank((String)ids)) {
            ArrayList<BigInteger> list = new ArrayList<BigInteger>();
            String[] s = ids.split(",");
            try {
                for (int i = 0; i < s.length; ++i) {
                    list.add(BigInteger.valueOf(Long.parseLong(s[i])));
                }
            }
            catch (Exception e) {
                throw new Exception("\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            map.put("list", list);
        } else if (StringUtils.isNotBlank((String)positionId)) {
            CommonSearchDto dto = new CommonSearchDto();
            dto.setPositionId(positionId);
            dto.setPageNum(Integer.valueOf(1));
            dto.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
            List avalibaleTicketList = this.adTicketMapper.findAvalibaleTicketList(dto);
            if (CollectionUtils.isNotEmpty((Collection)avalibaleTicketList)) {
                List listids = avalibaleTicketList.stream().map(AdTicket::getId).collect(Collectors.toList());
                map.put("list", listids);
            }
        }
        if (StringUtils.equals((String)S_TWO, (String)type) && StringUtils.isBlank((String)ids)) {
            return new PageInfo();
        }
        ArrayList<String> codeList = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)parentId) && StringUtils.isBlank((String)childId)) {
            List<TblAdTagVo> tbl = this.tblAdTagService.findTblAdTagListByType(Integer.parseInt(parentId), 2);
            if (tbl.size() == 0) {
                TblAdTagVo byPrimaryId = this.tblAdPostionTagMapperExt.findByPrimaryId(Integer.valueOf(Integer.parseInt(parentId)));
                codeList.add(byPrimaryId.getCode() + "");
                map.put("codelist", codeList);
            } else {
                for (TblAdTagVo tt : tbl) {
                    if (tt.getChildList().size() > 0) {
                        for (TblAdTagVo child : tt.getChildList()) {
                            codeList.add(child.getCode() + "");
                        }
                        continue;
                    }
                    codeList.add(tt.getCode() + "");
                }
            }
            if (codeList.size() < 0) {
                return new PageInfo();
            }
            map.put("codelist", codeList);
        }
        if (StringUtils.isNotBlank((String)childId)) {
            codeList.add(childId);
            map.put("codelist", codeList);
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List adMediaTestList = this.mediaMapper.findTicketByParam(map);
        if (adMediaTestList != null && adMediaTestList.size() > 0) {
            List tblList = this.tblAdTagService.findAll(1, 1000, null).getList();
            HashMap<String, TblAdTagVo> mapTblAdTagVo = new HashMap<String, TblAdTagVo>();
            for (TblAdTagVo tt : tblList) {
                mapTblAdTagVo.put(tt.getCode().toString(), tt);
            }
            Map ae = this.aclUserIntegration.queryUserByRoleCode("ae", Boolean.valueOf(false));
            for (MediaTicketVo mediaTicketVo : adMediaTestList) {
                if (StringUtils.isNotBlank((String)mediaTicketVo.getAe())) {
                    mediaTicketVo.setAe((String)ae.get(mediaTicketVo.getAe()));
                }
                if (StringUtils.isNotBlank((String)mediaTicketVo.getTagCode())) {
                    mediaTicketVo.setParentFirstName(mapTblAdTagVo.getOrDefault(mediaTicketVo.getTagCode().toString(), new TblAdTagVo()).getFullNameStr());
                }
                Map<String, String> dictionariesMap = this.getDictionaries("adstatus");
                if (mediaTicketVo.getPauseReason() != null && mediaTicketVo.getStatus().equals(S_TWO)) {
                    mediaTicketVo.setPauseReasonShow(dictionariesMap.get(STR_TWO + mediaTicketVo.getPauseReason()));
                    continue;
                }
                mediaTicketVo.setPauseReasonShow(dictionariesMap.get(mediaTicketVo.getStatus()));
            }
        }
        PageInfo pageInfo = new PageInfo(adMediaTestList);
        return pageInfo;
    }

    public Map<String, String> getDictionaries(String typegroupid) {
        List list = this.dictionariesMapper.findAll(typegroupid);
        HashMap<String, String> map = new HashMap<String, String>(list.size());
        for (Dictionaries dictionaries : list) {
            map.put(dictionaries.getTypecode(), dictionaries.getTypename());
        }
        return map;
    }
}

