/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.menu.impl;

import com.bxm.adsmanager.dal.mapper.menu.ext.AdMenuMapperExt;
import com.bxm.adsmanager.dal.mapper.menu.ext.AdMenuRoleMapperExt;
import com.bxm.adsmanager.model.vo.AdMenuVo;
import com.bxm.adsmanager.service.menu.AdMenuRoleService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdMenuRoleServiceImpl
implements AdMenuRoleService {
    @Autowired
    private AdMenuRoleMapperExt adMenuRoleMapperExt;
    @Autowired
    private AdMenuMapperExt adMenuMapperExt;

    @Override
    public List<AdMenuVo> findMenuByRole(List<String> roleCodes) {
        if (CollectionUtils.isEmpty(roleCodes)) {
            return this.findAllMenu();
        }
        ArrayList<String> distinctRoleCodes = new ArrayList<String>();
        for (String role : roleCodes) {
            if (distinctRoleCodes.contains(role)) continue;
            distinctRoleCodes.add(role);
        }
        List result = this.adMenuRoleMapperExt.selectMenuByRole(distinctRoleCodes);
        if (CollectionUtils.isNotEmpty((Collection)result) && result.size() == distinctRoleCodes.size()) {
            String[] menuCodes = null;
            for (String str : result) {
                menuCodes = (String[])ArrayUtils.addAll(menuCodes, (Object[])StringUtils.splitByWholeSeparatorPreserveAllTokens((String)str, (String)","));
            }
            return this.findRoleMenu(menuCodes);
        }
        return this.findAllMenu();
    }

    private List<AdMenuVo> findRoleMenu(String[] menuCodes) {
        TreeSet<String> menuCodeSet = new TreeSet<String>(Arrays.asList(menuCodes));
        List roleMenus = this.adMenuMapperExt.selectMenuParentByMenuCodeSet(menuCodeSet);
        if (CollectionUtils.isNotEmpty((Collection)roleMenus)) {
            for (AdMenuVo menuVo : roleMenus) {
                this.findChildrenMenu(menuVo, menuCodeSet);
            }
        }
        return roleMenus;
    }

    private void findChildrenMenu(AdMenuVo menuVo, Set<String> menuCodeSet) {
        List childrenMenus = this.adMenuMapperExt.selectMenuByParentIdAndNames(menuVo.getId(), menuCodeSet);
        menuVo.setChildren(childrenMenus);
        if (CollectionUtils.isNotEmpty((Collection)childrenMenus)) {
            for (AdMenuVo adMenuVo : childrenMenus) {
                this.findChildrenMenu(adMenuVo, menuCodeSet);
            }
        }
    }

    private List<AdMenuVo> findAllMenu() {
        List allParentMenu = this.adMenuMapperExt.selectAllParentMenu();
        if (CollectionUtils.isNotEmpty((Collection)allParentMenu)) {
            for (AdMenuVo menuVo : allParentMenu) {
                this.findChildrenMenu(menuVo);
            }
        }
        return allParentMenu;
    }

    private void findChildrenMenu(AdMenuVo menuVo) {
        List childrenMenus = this.adMenuMapperExt.selectMenuByParentId(menuVo.getId());
        menuVo.setChildren(childrenMenus);
        if (CollectionUtils.isNotEmpty((Collection)childrenMenus)) {
            for (AdMenuVo adMenuVo : childrenMenus) {
                this.findChildrenMenu(adMenuVo);
            }
        }
    }
}

