/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.monitor.impl;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.monitor.AdPositionTagTodayMapper;
import com.bxm.adsmanager.dal.mapper.monitor.AdPositionTicketTagTodayMapper;
import com.bxm.adsmanager.dal.mapper.monitor.AdTicketTagTodayMapper;
import com.bxm.adsmanager.dal.mapper.monitor.PositionTicketThresholdMapper;
import com.bxm.adsmanager.dal.mapper.tbltag.ext.TblAdPostionTagMapperExt;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.monitor.AdPositionTagToday;
import com.bxm.adsmanager.model.dao.monitor.AdPositionTicketTagToday;
import com.bxm.adsmanager.model.dao.monitor.AdTicketTagToday;
import com.bxm.adsmanager.model.dao.monitor.PositionTicketThreshold;
import com.bxm.adsmanager.model.dao.tbltag.TblAdPostionTag;
import com.bxm.adsmanager.model.dto.monitor.AdPositionTicketTagTodayDto;
import com.bxm.adsmanager.model.enums.AdPositionTicketSortEnum;
import com.bxm.adsmanager.model.vo.tbltag.TblAdTagVo;
import com.bxm.adsmanager.service.monitor.AdPositionTicketService;
import com.bxm.adsmanager.utils.DoubleUtil;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.alarm.model.AdPositionTagTodayCondition;
import com.bxm.datapark.facade.alarm.model.AdTicketTagTodayCondition;
import com.bxm.datapark.facade.alarm.service.PositionTicketWarnService;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdPositionTicketServiceImpl
implements AdPositionTicketService {
    private static final Logger log = LoggerFactory.getLogger(AdPositionTicketServiceImpl.class);
    @Autowired
    private PositionTicketThresholdMapper positionTicketThresholdMapper;
    @Autowired
    private AdPositionTagTodayMapper adPositionTagTodayMapper;
    @Autowired
    private TblAdPostionTagMapperExt tblAdPostionTagMapperExt;
    @Autowired
    private AdTicketTagTodayMapper adTicketTagTodayMapper;
    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;
    @Autowired
    private AdShopIntegration adShopIntegration;
    @Autowired
    private AdTicketMapper adTicketMapper;
    @Autowired
    private AdPositionTicketTagTodayMapper adPositionTicketTagTodayMapper;
    @Autowired
    private PositionTicketWarnService positionTicketWarnService;

    @Override
    public ResultModel add(PositionTicketThreshold positionTicketThreshold) {
        ResultModel resultModel = new ResultModel();
        TblAdTagVo adTagVo = this.tblAdPostionTagMapperExt.findByFullCode(positionTicketThreshold.getTicketTag());
        if (adTagVo == null) {
            return ResultModelFactory.FAIL500("\u5e7f\u544a\u7c7b\u522b\u53c2\u6570\u5f02\u5e38");
        }
        positionTicketThreshold.setTicketTag(adTagVo.getCode() + "");
        List thresholds = this.positionTicketThresholdMapper.selectByTicketTag(adTagVo.getCode() + "");
        if (CollectionUtils.isNotEmpty((Collection)thresholds)) {
            return ResultModelFactory.FAIL500("\u5e7f\u544a\u7c7b\u522b\u4e0d\u5141\u8bb8\u91cd\u590d\u6dfb\u52a0");
        }
        positionTicketThreshold.setCreateTime(new Date());
        int result = this.positionTicketThresholdMapper.insertSelective(positionTicketThreshold);
        if (result != 1) {
            return ResultModelFactory.FAIL500("\u6570\u636e\u63d2\u5165\u5931\u8d25");
        }
        resultModel.setReturnValue((Object)true);
        return resultModel;
    }

    public ResultModel<PageInfo> findAll(PositionTicketThreshold positionTicketThreshold, Integer pageNum, Integer pageSize) {
        List tags;
        PageHelper.startPage((int)pageNum, (int)pageSize);
        ResultModel resultModel = new ResultModel();
        ArrayList tagList = Lists.newArrayList();
        if (positionTicketThreshold != null && StringUtils.isNotEmpty((CharSequence)positionTicketThreshold.getTicketTag()) && CollectionUtils.isNotEmpty((Collection)(tags = this.tblAdPostionTagMapperExt.findByFullpath(positionTicketThreshold.getTicketTag())))) {
            for (TblAdPostionTag adPositionTag : tags) {
                tagList.add(adPositionTag.getCode() + "");
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("positionTicketThreshold", positionTicketThreshold);
        map.put("tagList", tagList);
        List result = this.positionTicketThresholdMapper.selectByParam(map);
        if (CollectionUtils.isEmpty((Collection)result)) {
            return resultModel;
        }
        PageInfo pageInfo = new PageInfo(result);
        for (PositionTicketThreshold positionTicketThreshold1 : pageInfo.getList()) {
            TblAdTagVo tblAdTagVo = this.tblAdPostionTagMapperExt.findByCode(Integer.valueOf(positionTicketThreshold1.getTicketTag()));
            positionTicketThreshold1.setTagCode(tblAdTagVo.getFullCodePath());
            positionTicketThreshold1.setTicketTag(tblAdTagVo.getFullNameStr());
        }
        resultModel.setReturnValue((Object)pageInfo);
        return resultModel;
    }

    @Override
    public ResultModel update(PositionTicketThreshold positionTicketThreshold) {
        ResultModel resultModel = new ResultModel();
        positionTicketThreshold.setModifyTime(new Date());
        int result = this.positionTicketThresholdMapper.updateByPrimaryKeySelective(positionTicketThreshold);
        if (result != 1) {
            return ResultModelFactory.FAIL500("\u6570\u636e\u4fee\u6539\u5931\u8d25");
        }
        resultModel.setReturnValue((Object)true);
        return resultModel;
    }

    @Override
    public ResultModel findPositionWarnPage(String ticketTag, String keyword, String dateTime, Integer pageNum, Integer pageSize, String sortName, String sortType) {
        ResultModel resultModel = new ResultModel();
        List<Object> tagList = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)ticketTag) && CollectionUtils.isEmpty((Collection)(tagList = this.getTicketCode(ticketTag)))) {
            resultModel.setReturnValue((Object)new PageInfo());
            return resultModel;
        }
        Map<String, String> mapTag = this.getTagName();
        if (this.timeIsToday(dateTime).booleanValue()) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
            HashedMap map = new HashedMap();
            map.put("tagList", tagList);
            map.put("positionId", keyword);
            map.put("dateTime", dateTime);
            map.put("sortName", AdPositionTicketSortEnum.getName((String)sortName));
            map.put("sortType", sortType);
            List list = this.adPositionTagTodayMapper.findByParam((Map)map);
            if (CollectionUtils.isEmpty((Collection)list)) {
                resultModel.setReturnValue((Object)new PageInfo());
                return resultModel;
            }
            PageInfo pageInfo = new PageInfo(list);
            Map<String, String> resultMap = this.getPositionDtoMap(list);
            pageInfo.getList().forEach(adPositionTagToday -> {
                adPositionTagToday.setPositionId((String)resultMap.get(adPositionTagToday.getPositionId()));
                adPositionTagToday.setTicketTag((String)mapTag.get(adPositionTagToday.getTicketTag()));
                adPositionTagToday.setCvrShow(DoubleUtil.savePoint(adPositionTagToday.getCvr() * 100.0, 2) + "%");
                adPositionTagToday.setValidErrorClickPvRateShow(DoubleUtil.savePoint(adPositionTagToday.getValidErrorClickPvRate() * 100.0, 2) + "%");
                adPositionTagToday.setErrorCost(Double.valueOf(DoubleUtil.savePoint(adPositionTagToday.getErrorCost(), 2)));
            });
            resultModel.setReturnValue((Object)pageInfo);
        } else {
            ArrayList list = Lists.newArrayList();
            AdPositionTagTodayCondition adPositionTagTodayCondition = new AdPositionTagTodayCondition();
            adPositionTagTodayCondition.setDateTime(dateTime);
            adPositionTagTodayCondition.setPageNum(pageNum);
            adPositionTagTodayCondition.setPageSize(pageSize);
            adPositionTagTodayCondition.setTags((List)tagList);
            adPositionTagTodayCondition.setPositionId(keyword);
            adPositionTagTodayCondition.setSortName(AdPositionTicketSortEnum.getName((String)sortName));
            adPositionTagTodayCondition.setSortType(sortType);
            Page page = this.positionTicketWarnService.findPositionWarnByParam(adPositionTagTodayCondition);
            if (page == null || CollectionUtils.isEmpty((Collection)page.getList())) {
                resultModel.setReturnValue((Object)new PageInfo());
                return resultModel;
            }
            page.getList().forEach(adPositionTagToday -> {
                AdPositionTagToday adPositionTagToday1 = new AdPositionTagToday();
                BeanUtils.copyProperties((Object)adPositionTagToday, (Object)adPositionTagToday1);
                list.add(adPositionTagToday1);
            });
            Map<String, String> resultMap = this.getPositionDtoMap(list);
            list.forEach(adPositionTagToday -> {
                adPositionTagToday.setPositionId((String)resultMap.get(adPositionTagToday.getPositionId()));
                adPositionTagToday.setTicketTag((String)mapTag.get(adPositionTagToday.getTicketTag()));
                adPositionTagToday.setCvrShow(DoubleUtil.savePoint(adPositionTagToday.getCvr() * 100.0, 2) + "%");
                adPositionTagToday.setValidErrorClickPvRateShow(DoubleUtil.savePoint(adPositionTagToday.getValidErrorClickPvRate() * 100.0, 2) + "%");
                adPositionTagToday.setErrorCost(Double.valueOf(DoubleUtil.savePoint(adPositionTagToday.getErrorCost(), 2)));
            });
            PageInfo pageInfo = new PageInfo();
            pageInfo.setTotal(page.getTotal().longValue());
            pageInfo.setList((List)list);
            resultModel.setReturnValue((Object)pageInfo);
        }
        return resultModel;
    }

    @Override
    public List<AdPositionTagToday> excludePositionWarn(String ticketTag, String keyword, String dateTime) {
        List<Object> tagList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)ticketTag) && CollectionUtils.isEmpty((Collection)(tagList = this.getTicketCode(ticketTag)))) {
            return Lists.newArrayList();
        }
        Map<String, String> mapTag = this.getTagName();
        if (this.timeIsToday(dateTime).booleanValue()) {
            List<AdPositionTagToday> list = Lists.newArrayList();
            HashedMap map = new HashedMap();
            map.put("tagList", tagList);
            map.put("positionId", keyword);
            map.put("dateTime", dateTime);
            map.put("sortName", "click_pv");
            map.put("sortType", "desc");
            list = this.adPositionTagTodayMapper.findByParam((Map)map);
            if (CollectionUtils.isEmpty((Collection)list)) {
                return list;
            }
            Map<String, String> resultMap = this.getPositionDtoMap(list);
            list.forEach(adPositionTagToday -> {
                adPositionTagToday.setPositionId((String)resultMap.get(adPositionTagToday.getPositionId()));
                adPositionTagToday.setTicketTag((String)mapTag.get(adPositionTagToday.getTicketTag()));
                adPositionTagToday.setCvrShow(DoubleUtil.savePoint(adPositionTagToday.getCvr() * 100.0, 2) + "%");
                adPositionTagToday.setValidErrorClickPvRateShow(DoubleUtil.savePoint(adPositionTagToday.getValidErrorClickPvRate() * 100.0, 2) + "%");
                adPositionTagToday.setErrorCost(Double.valueOf(DoubleUtil.savePoint(adPositionTagToday.getErrorCost(), 2)));
            });
            return list;
        }
        ArrayList list = Lists.newArrayList();
        AdPositionTagTodayCondition adPositionTagTodayCondition = new AdPositionTagTodayCondition();
        adPositionTagTodayCondition.setDateTime(dateTime);
        adPositionTagTodayCondition.setTags((List)tagList);
        adPositionTagTodayCondition.setPositionId(keyword);
        List result = this.positionTicketWarnService.excludePositionWarn(adPositionTagTodayCondition);
        if (CollectionUtils.isEmpty((Collection)result)) {
            return list;
        }
        result.forEach(adPositionTagToday -> {
            AdPositionTagToday adPositionTagToday1 = new AdPositionTagToday();
            BeanUtils.copyProperties((Object)adPositionTagToday, (Object)adPositionTagToday1);
            list.add(adPositionTagToday1);
        });
        Map<String, String> resultMap = this.getPositionDtoMap(list);
        list.forEach(adPositionTagToday -> {
            adPositionTagToday.setPositionId((String)resultMap.get(adPositionTagToday.getPositionId()));
            adPositionTagToday.setTicketTag((String)mapTag.get(adPositionTagToday.getTicketTag()));
            adPositionTagToday.setCvrShow(DoubleUtil.savePoint(adPositionTagToday.getCvr() * 100.0, 2) + "%");
            adPositionTagToday.setValidErrorClickPvRateShow(DoubleUtil.savePoint(adPositionTagToday.getValidErrorClickPvRate() * 100.0, 2) + "%");
            adPositionTagToday.setErrorCost(Double.valueOf(DoubleUtil.savePoint(adPositionTagToday.getErrorCost(), 2)));
        });
        return list;
    }

    @Override
    public ResultModel findTicketWarnPage(String ticketTag, Long ticketId, String dateTime, String advertiser, Integer pageNum, Integer pageSize, String sortName, String sortType) throws Exception {
        Page page;
        ResultModel resultModel = new ResultModel();
        List<Object> tagList = Lists.newArrayList();
        List<Object> ticketIds = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)ticketTag) && CollectionUtils.isEmpty((Collection)(tagList = this.getTicketCode(ticketTag)))) {
            resultModel.setReturnValue((Object)new PageInfo());
            return resultModel;
        }
        if (StringUtils.isNotEmpty((CharSequence)advertiser) && CollectionUtils.isEmpty((Collection)(ticketIds = this.getTicketIds(advertiser)))) {
            resultModel.setReturnValue((Object)new PageInfo());
            return resultModel;
        }
        Map<String, String> mapTag = this.getTagName();
        if (this.timeIsToday(dateTime).booleanValue()) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
            HashedMap map = new HashedMap();
            map.put("tagList", tagList);
            map.put("ticketIds", ticketIds);
            map.put("ticketId", ticketId);
            map.put("sortName", AdPositionTicketSortEnum.getName((String)sortName));
            map.put("sortType", sortType);
            List list = this.adTicketTagTodayMapper.findByParam((Map)map);
            if (CollectionUtils.isEmpty((Collection)list)) {
                resultModel.setReturnValue((Object)new PageInfo());
                return resultModel;
            }
            for (AdTicketTagToday adTicketTagToday : list) {
                AdTicket adTicket = this.adTicketMapper.selectByPrimaryKey(adTicketTagToday.getTicketId());
                if (adTicket != null) {
                    AdvertiserDto advertiserDto = this.adShopIntegration.findAdShopMsg(adTicket.getAdvertiser().longValue());
                    adTicketTagToday.setAdvertiser(advertiserDto.getCompany());
                }
                adTicketTagToday.setTicketTag(mapTag.get(adTicketTagToday.getTicketTag()));
                adTicketTagToday.setCvrShow(DoubleUtil.savePoint(adTicketTagToday.getCvr() * 100.0, 2) + "%");
                adTicketTagToday.setValidErrorClickPvRateShow(DoubleUtil.savePoint(adTicketTagToday.getValidErrorClickPvRate() * 100.0, 2) + "%");
                adTicketTagToday.setErrorCost(Double.valueOf(DoubleUtil.savePoint(adTicketTagToday.getErrorCost(), 2)));
            }
            PageInfo pageInfo = new PageInfo(list);
            resultModel.setReturnValue((Object)pageInfo);
            return resultModel;
        }
        ArrayList list = Lists.newArrayList();
        AdTicketTagTodayCondition adPositionTicketTagTodayCondition = new AdTicketTagTodayCondition();
        adPositionTicketTagTodayCondition.setPageNum(pageNum);
        adPositionTicketTagTodayCondition.setPageSize(pageSize);
        adPositionTicketTagTodayCondition.setDateTime(dateTime);
        adPositionTicketTagTodayCondition.setTicketId(ticketId);
        adPositionTicketTagTodayCondition.setSortName(AdPositionTicketSortEnum.getName((String)sortName));
        adPositionTicketTagTodayCondition.setSortType(sortType);
        if (CollectionUtils.isNotEmpty((Collection)ticketIds)) {
            adPositionTicketTagTodayCondition.setTicketIds((List)ticketIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)tagList)) {
            adPositionTicketTagTodayCondition.setTags((List)tagList);
        }
        if ((page = this.positionTicketWarnService.findTicketWarnByParam(adPositionTicketTagTodayCondition)) == null || CollectionUtils.isEmpty((Collection)page.getList())) {
            resultModel.setReturnValue((Object)new PageInfo());
            return resultModel;
        }
        for (com.bxm.datapark.facade.alarm.model.AdTicketTagToday adPositionTicketTagToday : page.getList()) {
            AdTicket adTicket = this.adTicketMapper.selectByPrimaryKey(adPositionTicketTagToday.getTicketId());
            if (adTicket != null) {
                AdvertiserDto advertiserDto = this.adShopIntegration.findAdShopMsg(adTicket.getAdvertiser().longValue());
                adPositionTicketTagToday.setAdvertiser(advertiserDto.getCompany());
            }
            adPositionTicketTagToday.setTicketTag(mapTag.get(adPositionTicketTagToday.getTicketTag()));
            AdTicketTagToday adTicketTagToday1 = new AdTicketTagToday();
            BeanUtils.copyProperties((Object)adPositionTicketTagToday, (Object)adTicketTagToday1);
            adTicketTagToday1.setCvrShow(DoubleUtil.savePoint(adTicketTagToday1.getCvr() * 100.0, 2) + "%");
            adTicketTagToday1.setValidErrorClickPvRateShow(DoubleUtil.savePoint(adTicketTagToday1.getValidErrorClickPvRate() * 100.0, 2) + "%");
            adTicketTagToday1.setErrorCost(Double.valueOf(DoubleUtil.savePoint(adTicketTagToday1.getErrorCost(), 2)));
            list.add(adTicketTagToday1);
        }
        PageInfo pageInfo = new PageInfo((List)list);
        resultModel.setReturnValue((Object)pageInfo);
        return resultModel;
    }

    @Override
    public List<AdTicketTagToday> excludeTicketWarn(Long ticketId, String advertiser, String dateTime, String ticketTag) throws Exception {
        ArrayList list = Lists.newArrayList();
        List<Object> tagList = Lists.newArrayList();
        List<Object> ticketIds = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)ticketTag) && CollectionUtils.isEmpty((Collection)(tagList = this.getTicketCode(ticketTag)))) {
            return list;
        }
        if (StringUtils.isNotEmpty((CharSequence)advertiser) && CollectionUtils.isEmpty((Collection)(ticketIds = this.getTicketIds(advertiser)))) {
            return list;
        }
        Map<String, String> mapTag = this.getTagName();
        if (this.timeIsToday(dateTime).booleanValue()) {
            HashedMap map = new HashedMap();
            map.put("tagList", tagList);
            map.put("ticketIds", ticketIds);
            map.put("ticketId", ticketId);
            map.put("dateTime", dateTime);
            map.put("sortName", "click_pv");
            map.put("sortType", "desc");
            List result = this.adTicketTagTodayMapper.findByParam((Map)map);
            if (CollectionUtils.isEmpty((Collection)result)) {
                return list;
            }
            for (AdTicketTagToday adTicketTagToday : result) {
                AdTicket adTicket = this.adTicketMapper.selectByPrimaryKey(adTicketTagToday.getTicketId());
                if (adTicket != null) {
                    AdvertiserDto advertiserDto = this.adShopIntegration.findAdShopMsg(adTicket.getAdvertiser().longValue());
                    adTicketTagToday.setAdvertiser(advertiserDto.getCompany());
                }
                adTicketTagToday.setTicketTag(mapTag.get(adTicketTagToday.getTicketTag()));
                adTicketTagToday.setCvrShow(DoubleUtil.savePoint(adTicketTagToday.getCvr() * 100.0, 2) + "%");
                adTicketTagToday.setValidErrorClickPvRateShow(DoubleUtil.savePoint(adTicketTagToday.getValidErrorClickPvRate() * 100.0, 2) + "%");
                adTicketTagToday.setErrorCost(Double.valueOf(DoubleUtil.savePoint(adTicketTagToday.getErrorCost(), 2)));
            }
            return result;
        }
        AdTicketTagTodayCondition adPositionTicketTagTodayCondition = new AdTicketTagTodayCondition();
        adPositionTicketTagTodayCondition.setDateTime(dateTime);
        if (CollectionUtils.isNotEmpty((Collection)ticketIds)) {
            adPositionTicketTagTodayCondition.setTicketIds((List)ticketIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)tagList)) {
            adPositionTicketTagTodayCondition.setTags((List)tagList);
        }
        List result = this.positionTicketWarnService.excludeTicketWarn(adPositionTicketTagTodayCondition);
        for (com.bxm.datapark.facade.alarm.model.AdTicketTagToday adPositionTicketTagToday : result) {
            AdTicket adTicket = this.adTicketMapper.selectByPrimaryKey(adPositionTicketTagToday.getTicketId());
            if (null != adTicket) {
                AdvertiserDto advertiserDto = this.adShopIntegration.findAdShopMsg(adTicket.getAdvertiser().longValue());
                adPositionTicketTagToday.setAdvertiser(advertiserDto.getCompany());
            }
            adPositionTicketTagToday.setTicketTag(mapTag.get(adPositionTicketTagToday.getTicketTag()));
            AdTicketTagToday adTicketTagToday1 = new AdTicketTagToday();
            BeanUtils.copyProperties((Object)adPositionTicketTagToday, (Object)adTicketTagToday1);
            adTicketTagToday1.setCvrShow(DoubleUtil.savePoint(adTicketTagToday1.getCvr() * 100.0, 2) + "%");
            adTicketTagToday1.setValidErrorClickPvRateShow(DoubleUtil.savePoint(adTicketTagToday1.getValidErrorClickPvRate() * 100.0, 2) + "%");
            adTicketTagToday1.setErrorCost(Double.valueOf(DoubleUtil.savePoint(adTicketTagToday1.getErrorCost(), 2)));
            list.add(adTicketTagToday1);
        }
        return list;
    }

    @Override
    public ResultModel updatePositionWarn(AdPositionTagToday adPositionTagToday) {
        ResultModel resultModel = new ResultModel();
        int result = this.adPositionTagTodayMapper.updateByPrimaryKeySelective(adPositionTagToday);
        if (result == 1) {
            return resultModel;
        }
        resultModel.setReturnValue((Object)false);
        return resultModel;
    }

    @Override
    public List<AdPositionTagToday> findPositionDateByParam(AdPositionTagToday adPositionTagToday) {
        return this.adPositionTagTodayMapper.findPositionDateByParam(adPositionTagToday);
    }

    @Override
    public int deletePositionData() {
        return this.adPositionTagTodayMapper.deletePositionData();
    }

    @Override
    public List<AdPositionTicketTagToday> findPositionTicketDate(AdPositionTicketTagTodayDto adPositionTicketTagTodayDto) {
        return this.adPositionTicketTagTodayMapper.findByParam(adPositionTicketTagTodayDto);
    }

    @Override
    public Integer updatePositionSendStatus(List<Integer> positionWarnIds) {
        return this.adPositionTagTodayMapper.updateSendStatus(positionWarnIds);
    }

    @Override
    public Integer setResend(List<String> positionIds) {
        return this.adPositionTicketTagTodayMapper.setResend(positionIds);
    }

    private List<Long> getTicketIds(String advertiserName) throws Exception {
        ArrayList ticketIds = Lists.newArrayList();
        AdvertiserDto advertiserDto = new AdvertiserDto();
        advertiserDto.setCompany(advertiserName);
        List advertiserDtos = this.adShopIntegration.getAdShopList(advertiserDto);
        if (CollectionUtils.isEmpty((Collection)advertiserDtos)) {
            return ticketIds;
        }
        ArrayList advertiserIds = new ArrayList();
        advertiserDtos.forEach(advertiserDto1 -> advertiserIds.add(advertiserDto1.getId().longValue()));
        List tickets = this.adTicketMapper.findTicketsByAdvertisers(advertiserIds);
        if (CollectionUtils.isEmpty((Collection)tickets)) {
            return ticketIds;
        }
        tickets.forEach(adTicket -> ticketIds.add(adTicket.getId()));
        return ticketIds;
    }

    private Map<String, String> getPositionDtoMap(List<AdPositionTagToday> list) {
        ArrayList positionIdList = Lists.newArrayList();
        list.forEach(adPositionTagToday -> positionIdList.add(adPositionTagToday.getPositionId()));
        QueryAppEntranceParamDTO dto = new QueryAppEntranceParamDTO();
        dto.setPositionIds((List)positionIdList);
        List appEntranceAdROS = this.newAppEntranceFacadeIntegration.getAllList(dto);
        HashMap resultMap = Maps.newHashMap();
        for (AppEntranceAdRO appEntranceAdRO : appEntranceAdROS) {
            resultMap.put(appEntranceAdRO.getPositionId(), String.format("%06d", appEntranceAdRO.getCode()) + "-" + appEntranceAdRO.getAppEntranceId());
        }
        return resultMap;
    }

    private Map<String, String> getTagName() {
        List tablAdTag = this.tblAdPostionTagMapperExt.findAll();
        HashMap<String, String> mapTag = new HashMap<String, String>(tablAdTag == null ? 0 : tablAdTag.size());
        if (CollectionUtils.isNotEmpty((Collection)tablAdTag)) {
            tablAdTag.forEach(label -> mapTag.put(label.getCode() + "", label.getFullNameStr()));
        }
        return mapTag;
    }

    private List<String> getTicketCode(String ticketTag) {
        ArrayList tagList = Lists.newArrayList();
        List tags = this.tblAdPostionTagMapperExt.findByFullpath(ticketTag);
        if (CollectionUtils.isEmpty((Collection)tags)) {
            return tagList;
        }
        tags.forEach(tblAdPostionTag -> tagList.add(tblAdPostionTag.getCode() + ""));
        return tagList;
    }

    private Boolean timeIsToday(String dateTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date();
        String toDay = sdf.format(date);
        if (dateTime.equals(toDay)) {
            return true;
        }
        return false;
    }
}

