/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.monitor.impl;

import com.bxm.adsmanager.dal.mapper.monitor.PositionWarnConfigMapper;
import com.bxm.adsmanager.dal.mapper.monitor.WarnConfigMapper;
import com.bxm.adsmanager.integration.acl.AclUserIntegration;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.model.dao.monitor.WarnConfig;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.monitor.PositionSpareTicketDto;
import com.bxm.adsmanager.model.dto.monitor.PositionWarnConfigDto;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.model.enums.WarnConfigEnum;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.model.vo.monitor.PositionSpareTicketVo;
import com.bxm.adsmanager.model.vo.monitor.PositionWarnConfigVo;
import com.bxm.adsmanager.service.common.DictionariesService;
import com.bxm.adsmanager.service.monitor.PositionWarnConfigService;
import com.bxm.adsmanager.utils.UserRoleCodeUtil;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppAdPositionDTO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import com.bxm.util.DateUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PositionWarnConfigServiceImpl
implements PositionWarnConfigService {
    @Autowired
    private PositionWarnConfigMapper positionWarnConfigMapper;
    @Autowired
    private WarnConfigMapper warnConfigMapper;
    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;
    @Autowired
    private DictionariesService dictionariesService;
    @Resource
    private AclUserIntegration aclUserIntegration;

    @Override
    public Pagination getAllPositionConfigList(PositionWarnConfigDto param) throws Exception {
        List paramList;
        Integer pageSize = param.getPageSize();
        Integer pageNum = param.getPageNum();
        ArrayList queryList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)param.getPositionIdList()) && !CollectionUtils.isEmpty((Collection)(paramList = param.getPositionIdList()))) {
            queryList.addAll(paramList);
        }
        if (CollectionUtils.isEmpty(queryList)) {
            return new Pagination();
        }
        param.setPositionIdList(queryList);
        param.setPageNum(null);
        param.setPageSize(null);
        QueryAppEntranceParamDTO dto = new QueryAppEntranceParamDTO();
        dto.setPositionIdOrFuzzyAppEntranceNameKeywords(param.getKeywords());
        dto.setPositionIds(queryList);
        dto.setPageNum(pageNum);
        dto.setPageSize(pageSize);
        PageInfo appEntranceAdRoPageInfo = this.newAppEntranceFacadeIntegration.getPage(dto);
        List appEntranceAdRos = appEntranceAdRoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)appEntranceAdRos)) {
            return new Pagination();
        }
        ArrayList positionWarnConfigVos = Lists.newArrayListWithCapacity((int)appEntranceAdRos.size());
        for (AppEntranceAdRO ro : appEntranceAdRos) {
            PositionWarnConfigVo positionWarnConfigVo = new PositionWarnConfigVo();
            positionWarnConfigVo.setPositionId(ro.getPositionId());
            positionWarnConfigVo.setMediaName(ro.getAlias());
            positionWarnConfigVo.setPositionName(ro.getAppEntranceName());
            positionWarnConfigVos.add(positionWarnConfigVo);
        }
        Pagination pagination = new Pagination();
        pagination.setList((List)positionWarnConfigVos);
        pagination.setPageSize(pageSize);
        pagination.setPageNo(pageNum);
        pagination.setTotalCount((int)appEntranceAdRoPageInfo.getTotal());
        return pagination;
    }

    @Override
    public List<String> getAllConfigPositionId(String configKey) throws Exception {
        return this.positionWarnConfigMapper.selectAllConfigPositionId(configKey);
    }

    @Override
    public PageInfo<PositionSpareTicketVo> getPositionSpareTicketWarnPageList(PositionSpareTicketDto param) throws Exception {
        User user = param.getUser();
        if (null != user && StringUtils.isNotBlank((String)param.getMediumCode()) && StringUtils.isNotBlank((String)UserRoleCodeUtil.isMj(user)) && !param.getMediumCode().equals(user.getUsername())) {
            return new PageInfo(new ArrayList());
        }
        param = this.generateThresholdParam(param);
        param = this.generateQueryParam(param);
        PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
        List<PositionSpareTicketVo> list = this.positionWarnConfigMapper.selectPositionSpareTicketWarnList(param);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list = this.generateResultData(list, param);
        }
        PageInfo pageInfo = new PageInfo((List)list);
        return pageInfo;
    }

    @Override
    public List<PositionSpareTicketVo> getPositionSpareTicketWarnList(PositionSpareTicketDto param) throws Exception {
        User user = param.getUser();
        if (null != user && StringUtils.isNotBlank((String)param.getMediumCode()) && StringUtils.isNotBlank((String)UserRoleCodeUtil.isMj(user)) && !param.getMediumCode().equals(user.getUsername())) {
            return new ArrayList<PositionSpareTicketVo>();
        }
        param = this.generateThresholdParam(param);
        param.setPageNum(null);
        param.setPageSize(null);
        List<PositionSpareTicketVo> list = this.positionWarnConfigMapper.selectPositionSpareTicketWarnList(this.generateQueryParam(param));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list = this.generateResultData(list, param);
        }
        return list;
    }

    @Override
    public Long getPositionSpareTicketWarnCount(PositionSpareTicketDto param) throws Exception {
        param.setPageNum(null);
        param.setPageSize(null);
        return this.positionWarnConfigMapper.selectPositionSpareTicketWarnCount(this.generateThresholdParam(param));
    }

    private PositionSpareTicketDto generateThresholdParam(PositionSpareTicketDto param) throws Exception {
        List excludePositionIds;
        WarnConfig warnConfig = this.warnConfigMapper.selectByConfigKey(WarnConfigEnum.POSITION_SPARE_TICKET.getConfigKey());
        if (warnConfig != null && StringUtils.isNotBlank((String)warnConfig.getPropValue())) {
            String propValue = warnConfig.getPropValue();
            String[] param1 = propValue.split(",");
            param.setOpenPv(Double.valueOf(param1[0]));
            if (StringUtils.isNotBlank((String)param1[1])) {
                String[] param2 = param1[1].split("-");
                if (StringUtils.isNotBlank((String)param2[0])) {
                    param.setSpareOpenProportionMin(Double.valueOf(param2[0]));
                }
                if (StringUtils.isNotBlank((String)param2[1])) {
                    param.setSpareOpenProportionMax(Double.valueOf(param2[1]));
                }
            }
            if (null != warnConfig.getMonitorPeriod()) {
                Date nowDate = new Date();
                Integer monitorPeriod = warnConfig.getMonitorPeriod();
                param.setMonitorPeriod(monitorPeriod);
                param.setStartTime(DateUtil.dateTo14String((Date)DateUtil.increaseHour((Date)nowDate, (int)(-monitorPeriod.intValue()))));
                param.setEndTime(DateUtil.dateTo14String((Date)nowDate));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(excludePositionIds = this.positionWarnConfigMapper.selectAllConfigPositionId(WarnConfigEnum.POSITION_SPARE_TICKET.getConfigKey())))) {
            param.setExcludePositionIds(excludePositionIds);
        }
        return param;
    }

    private PositionSpareTicketDto generateQueryParam(PositionSpareTicketDto param) {
        User user = param.getUser();
        String codeName = UserRoleCodeUtil.getMjOrBdCode(user);
        if (StringUtils.isNotBlank((String)param.getKeywords()) || StringUtils.isNotBlank((String)param.getMediumCode()) || StringUtils.isNotBlank((String)codeName)) {
            QueryAppAdPositionDTO dto = new QueryAppAdPositionDTO();
            if (StringUtils.isNotBlank((String)param.getKeywords())) {
                dto.setKeywords(param.getKeywords().trim());
            }
            if (StringUtils.isNotBlank((String)param.getMediumCode())) {
                dto.setMedium(param.getMediumCode());
            }
            if (StringUtils.isNotBlank((String)codeName)) {
                if (user.getRoleCodes().contains(RoleEnum.BD.getCode())) {
                    dto.setBd(codeName);
                }
                if (user.getRoleCodes().contains(RoleEnum.MJ.getCode())) {
                    dto.setMedium(codeName);
                }
            }
            List positionList = this.newAppEntranceFacadeIntegration.getPositionList(dto);
            ArrayList paramPositionIds = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)positionList)) {
                positionList.forEach(appEntranceAdRo -> paramPositionIds.add(appEntranceAdRo.getPositionId()));
            }
            param.setPositionIds(paramPositionIds);
        }
        return param;
    }

    private List<PositionSpareTicketVo> generateResultData(List<PositionSpareTicketVo> result, PositionSpareTicketDto query) throws Exception {
        Map mjMap = this.aclUserIntegration.queryUserByRoleCode("mj", Boolean.valueOf(false));
        ArrayList positionIdList = new ArrayList();
        result.forEach(positionSpareTicketVo -> positionIdList.add(positionSpareTicketVo.getPositionId()));
        QueryAppAdPositionDTO queryAppAdPositionDto = new QueryAppAdPositionDTO();
        queryAppAdPositionDto.setPositionIds(positionIdList);
        List positionList = this.newAppEntranceFacadeIntegration.getPositionList(queryAppAdPositionDto);
        HashMap mediaNameMap = new HashMap();
        HashMap positionNameMap = new HashMap();
        HashMap meijieCodeMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)positionList)) {
            positionList.forEach(appEntranceAdRo -> {
                mediaNameMap.put(appEntranceAdRo.getPositionId(), appEntranceAdRo.getProviderAlias());
                positionNameMap.put(appEntranceAdRo.getPositionId(), appEntranceAdRo.getAlias());
                meijieCodeMap.put(appEntranceAdRo.getPositionId(), appEntranceAdRo.getMjCode());
            });
        }
        result.forEach(positionSpareTicketVo -> {
            positionSpareTicketVo.setAppName((String)mediaNameMap.get(positionSpareTicketVo.getPositionId()));
            positionSpareTicketVo.setAppEntranceName((String)positionNameMap.get(positionSpareTicketVo.getPositionId()));
            positionSpareTicketVo.setMediumCode((String)meijieCodeMap.get(positionSpareTicketVo.getPositionId()));
            positionSpareTicketVo.setMedium((String)mjMap.get(positionSpareTicketVo.getMediumCode()));
            positionSpareTicketVo.setThresholdSpareOpenProportionMax(query.getSpareOpenProportionMax());
            positionSpareTicketVo.setMonitorPeriod(query.getMonitorPeriod());
        });
        return result;
    }
}

