/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.monitor.impl;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.monitor.TicketWarnConfigMapper;
import com.bxm.adsmanager.dal.mapper.monitor.WarnConfigMapper;
import com.bxm.adsmanager.integration.acl.AclUserIntegration;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.monitor.WarnConfig;
import com.bxm.adsmanager.model.dto.monitor.TicketUrlDto;
import com.bxm.adsmanager.model.dto.monitor.TicketWarnConfigDto;
import com.bxm.adsmanager.model.enums.EnvironmentEnum;
import com.bxm.adsmanager.model.enums.WarnConfigEnum;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.model.vo.monitor.TicketUrlVo;
import com.bxm.adsmanager.model.vo.monitor.TicketWarnConfigVo;
import com.bxm.adsmanager.service.common.DictionariesService;
import com.bxm.adsmanager.service.monitor.TicketWarnConfigService;
import com.bxm.adsmanager.utils.ListUtil;
import com.bxm.util.DateUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TicketWarnConfigServiceImpl
implements TicketWarnConfigService {
    @Autowired
    private TicketWarnConfigMapper ticketWarnConfigMapper;
    @Autowired
    private WarnConfigMapper warnConfigMapper;
    @Autowired
    private AdShopIntegration adShopIntegration;
    @Autowired
    private DictionariesService dictionariesService;
    @Resource
    private AclUserIntegration aclUserIntegration;
    @Autowired
    private AdTicketMapper adTicketMapper;

    @Override
    public Pagination getAllTicketConfigList(TicketWarnConfigDto param) throws Exception {
        List paramList;
        Pagination pagination = new Pagination();
        Integer pageSize = param.getPageSize();
        Integer pageNum = param.getPageNum();
        ArrayList<Long> queryList = new ArrayList<Long>();
        if (null != param && !CollectionUtils.isEmpty((Collection)param.getTicketIds()) && !CollectionUtils.isEmpty((Collection)(paramList = param.getTicketIds()))) {
            for (Long positionId : paramList) {
                queryList.add(positionId);
            }
        }
        param.setTicketIds(queryList);
        param.setPageNum(null);
        param.setPageSize(null);
        List list = this.ticketWarnConfigMapper.selectAllTicketConfigList(param);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            pagination.setTotalCount(list.size());
            list = ListUtil.getTotalPage(list, list.size(), pageNum, pageSize);
        }
        pagination.setList(list);
        pagination.setPageSize(pageSize);
        pagination.setPageNo(pageNum);
        return pagination;
    }

    @Override
    public List<Long> getAllConfigTicketId(String configKey) throws Exception {
        return this.ticketWarnConfigMapper.selectAllConfigTicketId(configKey);
    }

    @Override
    public PageInfo<TicketWarnConfigVo> getAllTicketList(TicketWarnConfigDto param) throws Exception {
        PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
        List list = this.ticketWarnConfigMapper.selectAllTicketList(param);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    @Override
    public PageInfo<TicketUrlVo> getTicketUrlWarnPageList(TicketUrlDto param) throws Exception {
        if (StringUtils.isNotBlank((String)(param = this.generateThresholdParam(param)).getSale()) && CollectionUtils.isEmpty((Collection)param.getCertificateIds())) {
            return new PageInfo(new ArrayList());
        }
        param = this.generateQueryParam(param);
        PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
        List<TicketUrlVo> list = this.ticketWarnConfigMapper.selectTicketUrlWarnList(param);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list = this.generateResultData(list, param);
        }
        PageInfo pageInfo = new PageInfo((List)list);
        return pageInfo;
    }

    @Override
    public List<TicketUrlVo> getTicketUrlWarnList(TicketUrlDto param) throws Exception {
        if (StringUtils.isNotBlank((String)(param = this.generateThresholdParam(param)).getSale()) && CollectionUtils.isEmpty((Collection)param.getCertificateIds())) {
            return new ArrayList<TicketUrlVo>();
        }
        param.setPageNum(null);
        param.setPageSize(null);
        List<TicketUrlVo> list = this.ticketWarnConfigMapper.selectTicketUrlWarnList(this.generateQueryParam(param));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list = this.generateResultData(list, param);
        }
        return list;
    }

    @Override
    public Long getTicketUrlWarnCount(TicketUrlDto param) throws Exception {
        param.setPageNum(null);
        param.setPageSize(null);
        return this.ticketWarnConfigMapper.selectTicketUrlWarnCount(this.generateThresholdParam(param));
    }

    private TicketUrlDto generateThresholdParam(TicketUrlDto param) throws Exception {
        List ticketIds;
        WarnConfig warnConfig = this.warnConfigMapper.selectByConfigKey(WarnConfigEnum.TICKET_URL.getConfigKey());
        if (warnConfig != null && StringUtils.isNotBlank((String)warnConfig.getPropValue())) {
            String propValue = warnConfig.getPropValue();
            String[] param1 = propValue.split(",");
            param.setClickPv(Double.valueOf(param1[0]));
            if (StringUtils.isNotBlank((String)param1[1])) {
                String[] param2 = param1[1].split("-");
                if (StringUtils.isNotBlank((String)param2[0])) {
                    param.setExposureRateMin(Double.valueOf(param2[0]));
                }
                if (StringUtils.isNotBlank((String)param2[1])) {
                    param.setExposureRateMax(Double.valueOf(param2[1]));
                }
            }
            if (null != warnConfig.getMonitorPeriod()) {
                Date nowDate = new Date();
                Integer monitorPeriod = warnConfig.getMonitorPeriod();
                param.setMonitorPeriod(monitorPeriod);
                param.setStartTime(DateUtil.dateTo14String((Date)DateUtil.increaseHour((Date)nowDate, (int)(-monitorPeriod.intValue()))));
                param.setEndTime(DateUtil.dateTo14String((Date)nowDate));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(ticketIds = this.ticketWarnConfigMapper.selectAllConfigTicketId(WarnConfigEnum.TICKET_URL.getConfigKey())))) {
            param.setExcludeCertificateIds(ticketIds);
        }
        if (StringUtils.isNotBlank((String)param.getSale())) {
            AdvertiserDto advertiserDto = new AdvertiserDto();
            advertiserDto.setSale(param.getSale());
            List advertiserDtos = this.adShopIntegration.getAdShopList(advertiserDto);
            ArrayList<Long> advtiserIds = new ArrayList<Long>();
            List adTickets = Lists.newArrayList();
            ArrayList ids = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)advertiserDtos)) {
                for (AdvertiserDto advertiser : advertiserDtos) {
                    advtiserIds.add(advertiser.getId().longValue());
                }
                if (CollectionUtils.isNotEmpty(advtiserIds) && CollectionUtils.isNotEmpty((Collection)(adTickets = this.adTicketMapper.findTicketsByAdvertisers(advtiserIds)))) {
                    for (AdTicket adTicket : adTickets) {
                        ids.add(adTicket.getId());
                    }
                    param.setCertificateIds((List)ids);
                }
            }
        }
        return param;
    }

    private TicketUrlDto generateQueryParam(TicketUrlDto ticketUrlDto) {
        if (StringUtils.isNotBlank((String)ticketUrlDto.getKeywords()) && StringUtils.isNumeric((String)ticketUrlDto.getKeywords().trim())) {
            ticketUrlDto.setCertificateId(Long.valueOf(ticketUrlDto.getKeywords().trim()));
        }
        if (StringUtils.isNotBlank((String)ticketUrlDto.getKeywords()) && !StringUtils.isNumeric((String)ticketUrlDto.getKeywords().trim())) {
            ticketUrlDto.setCertificateName(ticketUrlDto.getKeywords().trim());
        }
        return ticketUrlDto;
    }

    private List<TicketUrlVo> generateResultData(List<TicketUrlVo> result, TicketUrlDto query) throws Exception {
        Map allAdvertiserMap = this.adShopIntegration.getAllAdvertiserMap();
        Map aeMap = this.aclUserIntegration.queryUserByRoleCode("ae", Boolean.valueOf(false));
        result.forEach(ticketUrlVo -> {
            ticketUrlVo.setCompany((String)allAdvertiserMap.get(ticketUrlVo.getAdvertiserId().intValue()));
            ticketUrlVo.setAe((String)aeMap.get(ticketUrlVo.getAeCode()));
            ticketUrlVo.setThresholdExposureRateMax(query.getExposureRateMax());
            ticketUrlVo.setMonitorPeriod(query.getMonitorPeriod());
            if (StringUtils.isNotBlank((String)ticketUrlVo.getEnvironment())) {
                ticketUrlVo.setEnvironment(EnvironmentEnum.getEnvironmentEnumByValue((String)ticketUrlVo.getEnvironment()));
            }
        });
        return result;
    }
}

