/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.overseas.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.dal.mapper.overseas.OverseasOfflineAdvertMapper;
import com.bxm.adsmanager.model.dao.overseas.OverseasOfflineAdvert;
import com.bxm.adsmanager.model.dto.overseas.OverseasOfflineAdvertDto;
import com.bxm.adsmanager.model.enums.OverseasOfflineAdSourceEnum;
import com.bxm.adsmanager.model.enums.OverseasOfflineAdStatusEnum;
import com.bxm.adsmanager.model.enums.OverseasOfflinePayTypeEnum;
import com.bxm.adsmanager.model.enums.OverseasOfflinePlatformEnum;
import com.bxm.adsmanager.model.vo.overseas.OverseasGeneralMaterialVo;
import com.bxm.adsmanager.model.vo.overseas.OverseasOfflineAdvertConditionVo;
import com.bxm.adsmanager.model.vo.overseas.OverseasOfflineAdvertVo;
import com.bxm.adsmanager.service.overseas.OverseasOfflineAdvertService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OverseasOfflineAdvertServiceImpl
implements OverseasOfflineAdvertService {
    @Autowired
    private OverseasOfflineAdvertMapper advertMapper;
    private final Map<String, String> countryMap = new HashMap<String, String>(300);
    private final Map<Integer, String> sourceMap = new HashMap<Integer, String>(4);
    private final Map<Integer, String> statusMap = new HashMap<Integer, String>(4);
    private final Map<Integer, String> payTypeMap = new HashMap<Integer, String>(16);
    private final Map<String, String> platformMap = new HashMap<String, String>(16);

    /*
     * WARNING - void declaration
     */
    @PostConstruct
    public void init() {
        void var4_13;
        String[] isoCountries;
        this.countryMap.put("ALL", "\u5168\u7403");
        this.platformMap.put("ALL", "\u6240\u6709\u5e73\u53f0");
        for (OverseasOfflineAdSourceEnum overseasOfflineAdSourceEnum : OverseasOfflineAdSourceEnum.values()) {
            this.sourceMap.put(overseasOfflineAdSourceEnum.getCode(), overseasOfflineAdSourceEnum.getDesc());
        }
        for (OverseasOfflineAdSourceEnum overseasOfflineAdSourceEnum : OverseasOfflineAdStatusEnum.values()) {
            this.statusMap.put(overseasOfflineAdSourceEnum.getCode(), overseasOfflineAdSourceEnum.getDesc());
        }
        for (OverseasOfflineAdSourceEnum overseasOfflineAdSourceEnum : OverseasOfflinePayTypeEnum.values()) {
            this.payTypeMap.put(overseasOfflineAdSourceEnum.getCode(), overseasOfflineAdSourceEnum.getDesc());
        }
        for (OverseasOfflineAdSourceEnum overseasOfflineAdSourceEnum : OverseasOfflinePlatformEnum.values()) {
            this.platformMap.put(overseasOfflineAdSourceEnum.getCode(), overseasOfflineAdSourceEnum.getDesc());
        }
        String[] stringArray = isoCountries = Locale.getISOCountries();
        int n = stringArray.length;
        boolean bl = false;
        while (var4_13 < n) {
            String data = stringArray[var4_13];
            Locale locale = new Locale("zh", data);
            this.countryMap.put(locale.getCountry(), locale.getDisplayCountry(locale));
            ++var4_13;
        }
    }

    @Override
    public OverseasOfflineAdvertConditionVo getCondition() {
        return OverseasOfflineAdvertConditionVo.builder().offerSourceMap(this.sourceMap).offerStatusMap(this.statusMap).payTypeMap(this.payTypeMap).offerCountryMap(this.countryMap).targetPlatFormMap(this.platformMap).build();
    }

    @Override
    public OverseasOfflineAdvertVo getAdvertById(Long id) {
        return this.mappingDoToVo(this.advertMapper.selectByPrimaryKey(id));
    }

    @Override
    public PageInfo<OverseasOfflineAdvertVo> getAdvertList(OverseasOfflineAdvertDto dto) {
        OverseasOfflineAdvert advert = new OverseasOfflineAdvert();
        BeanUtils.copyProperties((Object)dto, (Object)advert);
        PageInfo pageInfo = PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize()).doSelectPageInfo(() -> this.advertMapper.selectByCondition(dto.getOfferSource(), advert));
        PageInfo pageInfoVo = new PageInfo();
        BeanUtils.copyProperties((Object)pageInfo, (Object)pageInfoVo);
        pageInfoVo.setList(this.mappingDoToVo(pageInfo.getList()));
        return pageInfoVo;
    }

    private List<OverseasOfflineAdvertVo> mappingDoToVo(List<OverseasOfflineAdvert> advert) {
        if (CollectionUtils.isEmpty(advert)) {
            return Lists.newArrayList();
        }
        ArrayList vos = Lists.newArrayList();
        for (OverseasOfflineAdvert tmp : advert) {
            vos.add(this.mappingDoToVo(tmp));
        }
        return vos;
    }

    private OverseasOfflineAdvertVo mappingDoToVo(OverseasOfflineAdvert advert) {
        if (advert == null) {
            return null;
        }
        OverseasOfflineAdvertVo vo = new OverseasOfflineAdvertVo();
        BeanUtils.copyProperties((Object)advert, (Object)vo);
        if (StringUtils.isNotEmpty((CharSequence)advert.getIconMaterial())) {
            vo.setIconMaterial(JSON.parseArray((String)advert.getIconMaterial(), OverseasGeneralMaterialVo.class));
        }
        if (StringUtils.isNotEmpty((CharSequence)advert.getImageMaterial())) {
            vo.setImageMaterial(JSON.parseArray((String)advert.getImageMaterial(), OverseasGeneralMaterialVo.class));
        }
        if (StringUtils.isNotEmpty((CharSequence)advert.getVideoMaterial())) {
            vo.setVideoMaterial(JSON.parseArray((String)advert.getVideoMaterial(), OverseasGeneralMaterialVo.class));
        }
        vo.setDailyCap(advert.getDailyCap() == null ? null : advert.getDailyCap().toString());
        vo.setPayPrice(advert.getPayPrice() == null ? null : advert.getPayPrice().toString());
        vo.setOfferCountry(this.toUpperCase(this.replaceListLogo(vo.getOfferCountry())));
        vo.setTargetPlatform(this.toUpperCase(this.replaceListLogo(vo.getTargetPlatform())));
        vo.setTrafficSource(this.replaceListLogo(vo.getTrafficSource()));
        vo.setAppLabel(this.replaceListLogo(vo.getAppLabel()));
        vo.setTrackingLinkParameter(this.replaceListLogo(vo.getTrackingLinkParameter()));
        vo.setOfferCategory(this.replaceListLogo(vo.getOfferCategory()));
        vo.setAppCategory(this.replaceListLogo(vo.getAppCategory()));
        vo.setTrafficNetwork(this.replaceListLogo(vo.getTrafficNetwork()));
        vo.setTrafficExclude(this.replaceListLogo(vo.getTrafficExclude()));
        vo.setTargetDevice(this.replaceListLogo(vo.getTargetDevice()));
        vo.setTargetCarries(this.replaceListLogo(vo.getTargetCarries()));
        vo.setBlacklist(this.replaceListLogo(vo.getBlacklist()));
        vo.setWhitelist(this.replaceListLogo(vo.getWhitelist()));
        this.youMiSpecialDeal(vo);
        return vo;
    }

    private void youMiSpecialDeal(OverseasOfflineAdvertVo vo) {
        if (!OverseasOfflineAdSourceEnum.YOU_MI.getCode().equals(vo.getOfferSource())) {
            return;
        }
        if ("0".equals(vo.getDailyCap())) {
            vo.setDailyCap("open kpi");
        }
        if (vo.getPayPrice() != null && new BigDecimal(vo.getPayPrice()).doubleValue() == 0.0) {
            vo.setPayPrice("dynamic payout");
        }
        if (StringUtils.isEmpty((CharSequence)vo.getOfferCountry())) {
            vo.setOfferCountry("ALL");
        }
    }

    private String replaceListLogo(String data) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return data;
        }
        if ("[]".equals(data)) {
            return null;
        }
        if (data.charAt(0) == '[' && data.charAt(data.length() - 1) == ']' && data.length() > 2) {
            List list = JSON.parseArray((String)data, String.class);
            data = list.toString();
            return data.substring(1, data.length() - 1).replaceAll(" ", "");
        }
        return data;
    }

    private String toUpperCase(String data) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return data;
        }
        return data.toUpperCase();
    }
}

