/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.precharge.impl;

import com.bxm.adsmanager.dal.mapper.precharge.PrechargeNewConfigMapper;
import com.bxm.adsmanager.dal.mapper.precharge.PrechargeNewCorrectRecordMapper;
import com.bxm.adsmanager.dal.mapper.precharge.PrechargeNewRecordMapper;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.facade.model.precharge.PrechargeCorrectSearchDTO;
import com.bxm.adsmanager.model.dao.precharge.PrechargeCorrectRecord;
import com.bxm.adsmanager.model.dao.precharge.PrechargeNewConfig;
import com.bxm.adsmanager.model.dao.precharge.PrechargeNewCorrectRecord;
import com.bxm.adsmanager.model.dao.precharge.PrechargeNewRecord;
import com.bxm.adsmanager.model.dto.PrechargeCorrectDTO;
import com.bxm.adsmanager.model.vo.PrechargeCorrectVo;
import com.bxm.adsmanager.service.precharge.PrechargeCorrectService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrechargeNewCorrectServiceImpl
implements PrechargeCorrectService {
    private static final Logger log = LoggerFactory.getLogger(PrechargeNewCorrectServiceImpl.class);
    @Autowired
    private PrechargeNewRecordMapper prechargeNewRecordMapper;
    @Autowired
    private PrechargeNewCorrectRecordMapper prechargeNewCorrectRecordMapper;
    @Autowired
    private PrechargeNewConfigMapper prechargeNewConfigMapper;

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public void add(PrechargeCorrectDTO dto) {
        PrechargeCorrectVo prechargeCorrectVo;
        PrechargeNewConfig prechargeNewConfig = this.prechargeNewConfigMapper.selectByPrimaryKey(dto.getAccountId());
        if (null == prechargeNewConfig) {
            throw new BusinessException("\u8d26\u53f7id\u4e0d\u5b58\u5728");
        }
        PrechargeCorrectSearchDTO searchDTO = new PrechargeCorrectSearchDTO();
        searchDTO.setAccountId(dto.getAccountId());
        List recordList = this.prechargeNewCorrectRecordMapper.getRecordList(searchDTO);
        if (CollectionUtils.isNotEmpty((Collection)recordList) && PrechargeCorrectRecord.STATUS_AUDIT_WAIT.equals((prechargeCorrectVo = (PrechargeCorrectVo)recordList.get(0)).getAuditStatus())) {
            throw new BusinessException("\u5f85\u5ba1\u6838\u72b6\u6001\u4fee\u6b63\u6570\u636e\u4e0d\u53ef\u64cd\u4f5c");
        }
        PrechargeNewCorrectRecord prechargeCorrectRecord = new PrechargeNewCorrectRecord();
        BeanUtils.copyProperties((Object)dto, (Object)prechargeCorrectRecord);
        prechargeCorrectRecord.setAccountName(prechargeNewConfig.getAccountName());
        this.prechargeNewCorrectRecordMapper.insertSelective(prechargeCorrectRecord);
    }

    @Override
    public PageInfo<PrechargeCorrectVo> getRecordList(PrechargeCorrectSearchDTO searchDTO) {
        Page page = PageHelper.startPage((int)searchDTO.getPageNum(), (int)searchDTO.getPageSize());
        this.prechargeNewCorrectRecordMapper.getRecordList(searchDTO);
        return page.toPageInfo();
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public synchronized Boolean correctAudit(Long correctId, Byte auditStatus, String refuseReason, String auditUser) {
        PrechargeNewCorrectRecord prechargeNewCorrectRecord = this.prechargeNewCorrectRecordMapper.selectByPrimaryKey(correctId);
        if (null == prechargeNewCorrectRecord) {
            return false;
        }
        if (!PrechargeNewCorrectRecord.STATUS_AUDIT_WAIT.equals(prechargeNewCorrectRecord.getAuditStatus())) {
            return false;
        }
        HashMap map = Maps.newHashMap();
        map.put("correctId", correctId);
        map.put("auditStatus", auditStatus);
        map.put("refuseReason", refuseReason);
        map.put("modifyUser", auditUser);
        int auditResult = this.prechargeNewCorrectRecordMapper.correctAudit((Map)map);
        if (auditResult == 0) {
            log.warn("\u9884\u4ed8\u4fee\u6b63\u5ba1\u6838\u672a\u66f4\u65b0\u6210\u529f, \u4fee\u6b63\u8bb0\u5f55Id:{}", (Object)correctId);
            return false;
        }
        if (PrechargeCorrectRecord.STATUS_AUDIT_PASS.equals(auditStatus)) {
            PrechargeNewRecord prechargeNewRecord = new PrechargeNewRecord();
            if (PrechargeNewCorrectRecord.CORRECT_TYPE_PLUS.equals(prechargeNewCorrectRecord.getCorrectType())) {
                prechargeNewRecord.setAmount(prechargeNewCorrectRecord.getCorrectAmount().negate());
            } else {
                prechargeNewRecord.setAmount(prechargeNewCorrectRecord.getCorrectAmount());
            }
            prechargeNewRecord.setAccountId(prechargeNewCorrectRecord.getAccountId());
            prechargeNewRecord.setAccountName(prechargeNewCorrectRecord.getAccountName());
            prechargeNewRecord.setCreateUser(auditUser);
            prechargeNewRecord.setType(PrechargeNewRecord.TYPE_CORRECT);
            prechargeNewRecord.setDatetime(prechargeNewCorrectRecord.getDatetime());
            this.prechargeNewRecordMapper.insertSelective(prechargeNewRecord);
        }
        return true;
    }
}

