/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.precharge.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.dal.mapper.adprofit.ext.AdProfitPositionMapperExt;
import com.bxm.adsmanager.dal.mapper.precharge.PrechargeDeveloperRelationMapper;
import com.bxm.adsmanager.dal.mapper.precharge.PrechargeNewConfigMapper;
import com.bxm.adsmanager.dal.mapper.precharge.PrechargeNewCorrectRecordMapper;
import com.bxm.adsmanager.dal.mapper.precharge.PrechargeNewRecordMapper;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.ecxeption.SearchResultEmptyException;
import com.bxm.adsmanager.facade.model.precharge.PrechargeDTO;
import com.bxm.adsmanager.integration.acl.AclUserIntegration;
import com.bxm.adsmanager.integration.adsmedia.provider.ProviderFacadeIntegration;
import com.bxm.adsmanager.integration.utils.DateUtil;
import com.bxm.adsmanager.model.dao.adprofit.AdProfitPosition;
import com.bxm.adsmanager.model.dao.media.AdMedia;
import com.bxm.adsmanager.model.dao.precharge.PrechargeDeveloperRelation;
import com.bxm.adsmanager.model.dao.precharge.PrechargeNewConfig;
import com.bxm.adsmanager.model.dao.precharge.PrechargeNewCorrectRecord;
import com.bxm.adsmanager.model.dao.precharge.PrechargeNewRecord;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.model.vo.PrechargeConfigVo;
import com.bxm.adsmanager.service.media.MediaService;
import com.bxm.adsmanager.service.precharge.PrechargeService;
import com.bxm.adsmanager.utils.DateUtils;
import com.bxm.adsmanager.utils.MoneyUtils;
import com.bxm.adsmanager.utils.RequestUtils;
import com.bxm.adsmedia.facade.model.provider.ProviderAppAdDTO;
import com.bxm.warcar.utils.DateHelper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrechargeNewServiceImpl
implements PrechargeService {
    private static final Logger log = LoggerFactory.getLogger(PrechargeNewServiceImpl.class);
    @Resource
    private AclUserIntegration aclUserIntegration;
    @Autowired
    private PrechargeNewConfigMapper prechargeNewConfigMapper;
    @Autowired
    private PrechargeDeveloperRelationMapper prechargeDeveloperRelationMapper;
    @Autowired
    private AdProfitPositionMapperExt adProfitPositionMapper;
    @Autowired
    private PrechargeNewRecordMapper prechargeNewRecordMapper;
    @Autowired
    private PrechargeNewCorrectRecordMapper prechargeNewCorrectRecordMapper;
    @Autowired
    private ProviderFacadeIntegration providerFacadeIntegration;
    @Autowired
    private MediaService mediaService;

    @Override
    public PageInfo<PrechargeConfigVo> listPrechargeConfig(Integer pageNum, Integer pageSize, String account, String providerKeyword, Byte correctStatus, String dateTime, String mjs, String bds) {
        ArrayList searchIds = Lists.newArrayList();
        HashMap<Long, PrechargeNewCorrectRecord> correctStatusMap = new HashMap<Long, PrechargeNewCorrectRecord>();
        try {
            this.fillSearch(searchIds, correctStatusMap, providerKeyword, correctStatus, mjs, bds);
        }
        catch (SearchResultEmptyException e) {
            return new PageInfo();
        }
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        List prechargeNewConfigs = this.prechargeNewConfigMapper.listPrechargeConfig(account, (List)searchIds);
        List allPrechargeDeveloperRelations = this.prechargeDeveloperRelationMapper.selectByParams(Collections.EMPTY_MAP);
        Map<Long, List<PrechargeDeveloperRelation>> developerGroupMap = allPrechargeDeveloperRelations.stream().collect(Collectors.groupingBy(PrechargeDeveloperRelation::getAccountId));
        List<String> appKeys = allPrechargeDeveloperRelations.stream().map(p -> p.getProviderAppKey()).collect(Collectors.toList());
        Map<Long, BigDecimal> yesterdayAccountConsumeMap = this.getYesterdayConsumeMap(appKeys, developerGroupMap, dateTime);
        Map<Long, BigDecimal> monthConsumeMap = this.getMonthConsumeMapByDatetime(appKeys, developerGroupMap, dateTime);
        Map<Long, BigDecimal> lastMonthConsumeMap = this.getMonthConsumeMapByDatetime(appKeys, developerGroupMap, DateUtils.getLastMonthStartDay(dateTime));
        HashMap mjMap = Maps.newHashMap();
        HashMap bdMap = Maps.newHashMap();
        HashMap mediaCodeMap = Maps.newHashMap();
        this.setProviderMap(mjMap, mediaCodeMap, appKeys, bdMap);
        List<PrechargeConfigVo> vos = prechargeNewConfigs.stream().map(p -> this.toVo((PrechargeNewConfig)p, yesterdayAccountConsumeMap, (Map<Long, PrechargeNewCorrectRecord>)correctStatusMap, mjMap, mediaCodeMap, developerGroupMap, monthConsumeMap, lastMonthConsumeMap, bdMap)).collect(Collectors.toList());
        this.fillAccountBalance(vos, dateTime);
        PageInfo pageInfo = page.toPageInfo();
        pageInfo.setList(vos);
        return pageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=60)
    public synchronized void addPrechargeConfig(PrechargeDTO dto) {
        this.checkParam(dto);
        PrechargeNewConfig prechargeNewConfig = new PrechargeNewConfig();
        BeanUtils.copyProperties((Object)dto, (Object)prechargeNewConfig);
        prechargeNewConfig.setCreateUser(RequestUtils.getCurrentUserName());
        prechargeNewConfig.setId(null);
        this.prechargeNewConfigMapper.insertSelective(prechargeNewConfig);
        if (prechargeNewConfig.getId() == null) {
            throw new BusinessException("\u65b0\u589e\u51fa\u73b0\u5f02\u5e38: prechargeNewConfig id is null!");
        }
        this.saveProvider(dto, prechargeNewConfig);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=60)
    public synchronized void updatePrechargeConfig(PrechargeDTO dto) {
        this.checkParam(dto);
        PrechargeNewConfig prechargeNewConfig = new PrechargeNewConfig();
        BeanUtils.copyProperties((Object)dto, (Object)prechargeNewConfig);
        prechargeNewConfig.setModifyUser(RequestUtils.getCurrentUserName());
        this.prechargeNewConfigMapper.updateByPrimaryKeySelective(prechargeNewConfig);
        this.prechargeDeveloperRelationMapper.deleteByAccountId(dto.getId());
        this.saveProvider(dto, prechargeNewConfig);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=60)
    public synchronized Boolean rechargeBalance(Long accountId, BigDecimal amount, String datetime, String currentUser) {
        if (amount.equals(BigDecimal.ZERO)) {
            return true;
        }
        PrechargeNewConfig prechargeNewConfig = this.prechargeNewConfigMapper.selectByPrimaryKey(accountId);
        if (null == prechargeNewConfig) {
            throw new BusinessException("\u4e0d\u5b58\u5728\u7684\u8d26\u6237");
        }
        PrechargeNewRecord prechargeRecord = new PrechargeNewRecord();
        prechargeRecord.setDatetime(datetime);
        prechargeRecord.setAmount(amount);
        prechargeRecord.setType(PrechargeNewRecord.TYPE_RECHARGE);
        prechargeRecord.setAccountName(prechargeNewConfig.getAccountName());
        prechargeRecord.setAccountId(accountId);
        prechargeRecord.setCreateUser(currentUser);
        this.prechargeNewRecordMapper.insertSelective(prechargeRecord);
        return true;
    }

    @Override
    public BigDecimal getBalanceByDate(Long accountId, String date) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("accountId", accountId);
        List prechargeDeveloperRelations = this.prechargeDeveloperRelationMapper.selectByParams(map);
        Long totalActualProfit = 0L;
        for (PrechargeDeveloperRelation p : prechargeDeveloperRelations) {
            String providerAppKey = p.getProviderAppKey();
            String startDate = p.getStartDate();
            String endDate = p.getEndDate();
            if (DateUtil.compareDateStr((String)date, (String)p.getStartDate()) < 0) continue;
            if (p.containDate(date).booleanValue()) {
                endDate = date;
            }
            Long developerTotalActualProfit = this.adProfitPositionMapper.getTotalActualProfitByAppKeyDatetime(providerAppKey, startDate, endDate);
            totalActualProfit = totalActualProfit + developerTotalActualProfit;
        }
        BigDecimal totalRechargeCorrectAmount = this.prechargeNewRecordMapper.getTotalRechargeCorrectAmount(accountId, date);
        return totalRechargeCorrectAmount.subtract(MoneyUtils.parseAmountOfYuan(totalActualProfit));
    }

    @Override
    public synchronized void updateProviderEndDate(Long accountId, String providers) {
        List providerDtos = JSONObject.parseArray((String)providers, PrechargeDTO.ProviderDTO.class);
        providerDtos.forEach(this::checkProviderDate);
        for (PrechargeDTO.ProviderDTO providerDto : providerDtos) {
            if (providerDto.getId() == null) continue;
            PrechargeDeveloperRelation prechargeDeveloperRelation = new PrechargeDeveloperRelation();
            prechargeDeveloperRelation.setId(providerDto.getId());
            prechargeDeveloperRelation.setEndDate(providerDto.getEndDate() == null ? "" : providerDto.getEndDate());
            this.prechargeDeveloperRelationMapper.updateByPrimaryKeySelective(prechargeDeveloperRelation);
        }
    }

    private Map<Long, BigDecimal> getYesterdayConsumeMap(List<String> appKeys, Map<Long, List<PrechargeDeveloperRelation>> developerGroupMap, String dateTime) {
        String yesterDayDate = null;
        yesterDayDate = StringUtils.isNotBlank((CharSequence)dateTime) ? dateTime : DateUtils.getPreDate(DateUtil.dateTo8String((Date)new Date()));
        List listByParams = this.adProfitPositionMapper.getListByParams(appKeys, yesterDayDate, yesterDayDate, null);
        Map<String, Integer> consumeMap = listByParams.stream().collect(Collectors.groupingBy(AdProfitPosition::getAppId, Collectors.reducing(0, AdProfitPosition::getProfitActual, Integer::sum)));
        HashMap<Long, BigDecimal> yesterdayConsumeMap = new HashMap<Long, BigDecimal>();
        String finalYesterDayDate = yesterDayDate;
        developerGroupMap.forEach((accountId, developers) -> {
            BigDecimal accountYesterdayConsume = BigDecimal.ZERO;
            for (PrechargeDeveloperRelation developer : developers) {
                if (!developer.containDate(finalYesterDayDate).booleanValue()) continue;
                Integer profitActual = consumeMap.getOrDefault(developer.getProviderAppKey(), 0);
                accountYesterdayConsume = accountYesterdayConsume.add(new BigDecimal(profitActual));
            }
            yesterdayConsumeMap.put((Long)accountId, MoneyUtils.parseAmountOfYuan(accountYesterdayConsume));
        });
        return yesterdayConsumeMap;
    }

    private Map<Long, BigDecimal> getMonthConsumeMapByDatetime(List<String> appKeys, Map<Long, List<PrechargeDeveloperRelation>> developerGroupMap, String dateTime) {
        if (StringUtils.isBlank((CharSequence)dateTime)) {
            dateTime = DateHelper.format((String)"yyyy-MM-dd");
        }
        String monthStartDay = DateUtils.getStartDayOfMonthByDate(dateTime);
        String monthEndDay = DateUtils.getEndDayOfMonthByDate(dateTime);
        Set<String> dailyOfMonth = DateUtils.getDailyBetweenDate2(DateUtil.StringToDate((String)monthStartDay), DateUtil.StringToDate((String)monthEndDay));
        List listByParams = this.adProfitPositionMapper.getListByParams(appKeys, monthStartDay, monthEndDay, null);
        Map<String, Integer> consumeMap = listByParams.stream().collect(Collectors.groupingBy(p -> p.getAppId() + ":" + p.getDatetime(), Collectors.reducing(0, AdProfitPosition::getProfitActual, Integer::sum)));
        HashMap<Long, BigDecimal> currentMonthConsumeMap = new HashMap<Long, BigDecimal>();
        developerGroupMap.forEach((accountId, developers) -> {
            BigDecimal accountMonthConsume = BigDecimal.ZERO;
            for (String day : dailyOfMonth) {
                for (PrechargeDeveloperRelation developer : developers) {
                    if (!developer.containDate(day).booleanValue()) continue;
                    Integer profitActual = consumeMap.getOrDefault(developer.getProviderAppKey() + ":" + day, 0);
                    accountMonthConsume = accountMonthConsume.add(new BigDecimal(profitActual));
                }
            }
            currentMonthConsumeMap.put((Long)accountId, MoneyUtils.parseAmountOfYuan(accountMonthConsume));
        });
        return currentMonthConsumeMap;
    }

    private void fillAccountBalance(List<PrechargeConfigVo> vos, String dateTime) {
        String today = DateUtil.dateTo8String((Date)new Date());
        if (StringUtils.isNotBlank((CharSequence)dateTime)) {
            today = dateTime;
        }
        String finalToday = today;
        vos.forEach(vo -> {
            Long accountId = vo.getId();
            BigDecimal balance = this.getBalanceByDate(accountId, finalToday);
            vo.setBalance(balance);
        });
    }

    private PrechargeConfigVo toVo(PrechargeNewConfig prechargeNewConfig, Map<Long, BigDecimal> consumeMap, Map<Long, PrechargeNewCorrectRecord> correctStatusMap, Map<String, String> mjMap, Map<String, String> mediaCodeMap, Map<Long, List<PrechargeDeveloperRelation>> developerGroupMap, Map<Long, BigDecimal> monthConsumeMap, Map<Long, BigDecimal> lastMonthConsumeMap, Map<String, String> bdMap) {
        PrechargeConfigVo prechargeConfigVo = new PrechargeConfigVo();
        BeanUtils.copyProperties((Object)prechargeNewConfig, (Object)prechargeConfigVo);
        prechargeConfigVo.setYesterdayConsume(consumeMap.getOrDefault(prechargeNewConfig.getId(), BigDecimal.ZERO));
        prechargeConfigVo.setCurrentMonthConsume(monthConsumeMap.getOrDefault(prechargeNewConfig.getId(), BigDecimal.ZERO));
        prechargeConfigVo.setLastMonthConsume(lastMonthConsumeMap.getOrDefault(prechargeNewConfig.getId(), BigDecimal.ZERO));
        PrechargeNewCorrectRecord prechargeNewCorrectRecord = correctStatusMap.get(prechargeNewConfig.getId());
        if (null != prechargeNewCorrectRecord) {
            prechargeConfigVo.setCorrectStatus(prechargeNewCorrectRecord.getAuditStatus());
            prechargeConfigVo.setRefuseReason(prechargeNewCorrectRecord.getRefuseReason());
        }
        List<PrechargeDeveloperRelation> prechargeDeveloperRelations = developerGroupMap.get(prechargeNewConfig.getId());
        prechargeConfigVo.setProviderList(prechargeDeveloperRelations);
        HashSet mjSet = Sets.newHashSet();
        HashSet bdSet = Sets.newHashSet();
        HashSet mediaCodeSet = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(prechargeDeveloperRelations)) {
            for (PrechargeDeveloperRelation prechargeDeveloperRelation : prechargeDeveloperRelations) {
                String providerAppKey = prechargeDeveloperRelation.getProviderAppKey();
                if (mjMap.containsKey(providerAppKey)) {
                    mjSet.add(mjMap.get(providerAppKey));
                }
                if (mediaCodeMap.containsKey(providerAppKey)) {
                    mediaCodeSet.add(mediaCodeMap.get(providerAppKey));
                }
                if (!bdMap.containsKey(providerAppKey)) continue;
                bdSet.add(bdMap.get(providerAppKey));
            }
        }
        String mjs = StringUtils.join((Iterable)mjSet, (String)",");
        String bds = StringUtils.join((Iterable)bdSet, (String)",");
        String mediaCode = StringUtils.join((Iterable)mediaCodeSet, (String)",");
        prechargeConfigVo.setMjs(mjs);
        prechargeConfigVo.setBds(bds);
        prechargeConfigVo.setMediaCode(mediaCode);
        return prechargeConfigVo;
    }

    private void checkParam(PrechargeDTO dto) {
        boolean checkRepeatProvider;
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("accountName", dto.getAccountName());
        map.put("accountId", dto.getId());
        int count = this.prechargeNewConfigMapper.countByParam(map);
        if (count > 0) {
            throw new BusinessException("\u8d26\u6237\u540d\u79f0\u5df2\u5b58\u5728");
        }
        String providers = dto.getProviders();
        List providerDTOS = JSONObject.parseArray((String)providers, PrechargeDTO.ProviderDTO.class);
        if (CollectionUtils.isEmpty((Collection)providerDTOS)) {
            return;
        }
        ArrayList providerAppKeys = Lists.newArrayList();
        providerDTOS.forEach(p -> {
            this.checkProviderDate((PrechargeDTO.ProviderDTO)p);
            providerAppKeys.add(p.getAppKey());
        });
        List<AdMedia> adMedias = this.mediaService.queryMediaByAppKeys(StringUtils.join((Iterable)providerAppKeys, (String)","));
        adMedias.forEach(m -> {
            if (!m.getPrepay().booleanValue()) {
                throw new BusinessException("\u53ea\u80fd\u7ed1\u5b9a\u9884\u4ed8\u5f00\u53d1\u8005\uff0c\u8bf7\u68c0\u67e5");
            }
        });
        boolean bl = checkRepeatProvider = providerAppKeys.size() != providerDTOS.size();
        if (checkRepeatProvider) {
            throw new BusinessException("\u540c\u4e00\u8d26\u6237\u4e0b\u4e0d\u80fd\u6709\u76f8\u540c\u7684\u5f00\u53d1\u8005");
        }
        if (null != dto.getId()) {
            HashMap<String, Long> paramMap = new HashMap<String, Long>(1);
            paramMap.put("accountId", dto.getId());
            List prechargeDeveloperRelations = this.prechargeDeveloperRelationMapper.selectByParams(paramMap);
            if (CollectionUtils.isNotEmpty((Collection)prechargeDeveloperRelations)) {
                for (PrechargeDeveloperRelation prechargeDeveloperRelation : prechargeDeveloperRelations) {
                    if (providerAppKeys.contains(prechargeDeveloperRelation.getProviderAppKey())) continue;
                    throw new BusinessException("\u4e0d\u80fd\u5220\u9664\u5df2\u6709\u5f00\u53d1\u8005");
                }
            }
        }
    }

    private void checkProviderDate(PrechargeDTO.ProviderDTO p) {
        String repeatAccountId;
        if (StringUtils.isBlank((CharSequence)p.getAppKey())) {
            throw new BusinessException("appKey\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)p.getStartDate())) {
            throw new BusinessException("\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((CharSequence)p.getEndDate())) {
            boolean startDateLateThanEndDate;
            boolean bl = startDateLateThanEndDate = DateUtil.compareDateStr((String)p.getStartDate(), (String)p.getEndDate()) > 0;
            if (startDateLateThanEndDate) {
                throw new BusinessException("\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5f00\u59cb\u65e5\u671f");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(repeatAccountId = this.checkRepeatDeveloperDate(p.getId(), p.getAppKey(), p.getStartDate(), p.getEndDate())))) {
            throw new BusinessException(String.format("\u4f60\u9009\u62e9\u7684\u7edf\u8ba1\u65f6\u95f4\u6bb5\u5df2\u5728\u5176\u4ed6\u4e3b\u4f53(\u8d26\u6237id:%s)\u4e0b\u88ab\u7edf\u8ba1\u8fc7\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u65f6\u95f4\u6bb5", repeatAccountId));
        }
    }

    private void saveProvider(PrechargeDTO dto, PrechargeNewConfig prechargeNewConfig) {
        String providers = dto.getProviders();
        List providerDtos = JSONObject.parseArray((String)providers, PrechargeDTO.ProviderDTO.class);
        providerDtos.forEach(p -> {
            PrechargeDeveloperRelation prechargeDeveloperRelation = new PrechargeDeveloperRelation();
            BeanUtils.copyProperties((Object)p, (Object)prechargeDeveloperRelation);
            prechargeDeveloperRelation.setAccountId(prechargeNewConfig.getId());
            prechargeDeveloperRelation.setProviderAppKey(p.getAppKey());
            this.prechargeDeveloperRelationMapper.insert(prechargeDeveloperRelation);
        });
    }

    private void setProviderMap(Map<String, String> mjMap, Map<String, String> mediaCodeMap, List<String> appKeys, Map<String, String> bdMap) {
        ProviderAppAdDTO dto = new ProviderAppAdDTO();
        dto.setAppKeys(appKeys);
        List providerAppList = this.providerFacadeIntegration.getProviderAppList(dto);
        if (CollectionUtils.isNotEmpty((Collection)providerAppList)) {
            Map mjNameMap = this.aclUserIntegration.queryUserByRoleCode(RoleEnum.MJ.getCode(), Boolean.valueOf(false));
            Map bdNameMap = this.aclUserIntegration.queryUserByRoleCode(RoleEnum.BD.getCode(), Boolean.valueOf(false));
            Map<String, String> providerMjCodeMap = providerAppList.stream().collect(Collectors.toMap(p -> p.getAppKey(), p -> mjNameMap.getOrDefault(p.getMedium(), "-")));
            Map<String, String> providerBdCodeMap = providerAppList.stream().collect(Collectors.toMap(p -> p.getAppKey(), p -> bdNameMap.getOrDefault(p.getBd(), "-")));
            Map<String, String> allPositionCodeMap = providerAppList.stream().collect(Collectors.toMap(p -> p.getAppKey(), p -> this.dealPositionCode(p.getCode())));
            mjMap.putAll(providerMjCodeMap);
            bdMap.putAll(providerBdCodeMap);
            mediaCodeMap.putAll(allPositionCodeMap);
        }
    }

    private String dealPositionCode(Long code) {
        if (null != code) {
            return StringUtils.leftPad((String)code.toString(), (int)6, (String)"0");
        }
        return "";
    }

    private String checkRepeatDeveloperDate(Integer id, String appKey, String startDate, String endDate) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("providerKeyword", appKey);
        map.put("excludeId", id);
        List developers = this.prechargeDeveloperRelationMapper.selectByParams(map);
        for (PrechargeDeveloperRelation developer : developers) {
            boolean crossDate;
            if (StringUtils.isBlank((CharSequence)endDate)) {
                endDate = "2099-01-01";
            }
            if (StringUtils.isBlank((CharSequence)developer.getEndDate())) {
                developer.setEndDate("2099-01-01");
            }
            if (!(crossDate = DateUtil.compareDateStr((String)endDate, (String)developer.getStartDate()) >= 0 && DateUtil.compareDateStr((String)startDate, (String)developer.getEndDate()) <= 0)) continue;
            return developer.getAccountId().toString();
        }
        return null;
    }

    private void fillSearch(List<Long> searchIds, Map<Long, PrechargeNewCorrectRecord> correctStatusMap, String providerKeyword, Byte correctStatus, String mjs, String bds) {
        if (StringUtils.isNotBlank((CharSequence)mjs) || StringUtils.isNotBlank((CharSequence)bds)) {
            List providerAppList;
            List searchMjAppKeys;
            ProviderAppAdDTO dto = new ProviderAppAdDTO();
            if (StringUtils.isNotBlank((CharSequence)mjs)) {
                dto.setMedium(mjs);
            }
            if (StringUtils.isNotBlank((CharSequence)bds)) {
                dto.setBd(bds);
            }
            if (CollectionUtils.isEmpty(searchMjAppKeys = (providerAppList = this.providerFacadeIntegration.getProviderAppList(dto)).stream().map(p -> p.getAppKey()).collect(Collectors.toList()))) {
                throw new SearchResultEmptyException();
            }
            HashMap map = new HashMap();
            map.put("providerAppKeys", searchMjAppKeys);
            List prechargeDeveloperRelations1 = this.prechargeDeveloperRelationMapper.selectByParams(map);
            if (CollectionUtils.isEmpty((Collection)prechargeDeveloperRelations1)) {
                throw new SearchResultEmptyException();
            }
            List searchIdByMj = prechargeDeveloperRelations1.stream().map(PrechargeDeveloperRelation::getAccountId).collect(Collectors.toList());
            searchIds.addAll(searchIdByMj);
        }
        if (StringUtils.isNotBlank((CharSequence)providerKeyword)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("providerKeyword", providerKeyword);
            List prechargeDeveloperRelations = this.prechargeDeveloperRelationMapper.selectByParams(map);
            if (CollectionUtils.isEmpty((Collection)prechargeDeveloperRelations)) {
                throw new SearchResultEmptyException();
            }
            List searchIdByDeveloper = prechargeDeveloperRelations.stream().map(PrechargeDeveloperRelation::getAccountId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(searchIds)) {
                searchIds.addAll(searchIdByDeveloper);
            } else {
                searchIds.retainAll(searchIdByDeveloper);
            }
        }
        List allLatestCorrectRecord = this.prechargeNewCorrectRecordMapper.getAllLatestCorrectRecord();
        correctStatusMap.putAll(allLatestCorrectRecord.stream().collect(Collectors.toMap(r -> r.getAccountId(), r -> r)));
        if (null != correctStatus) {
            List correctStatusAccountId = allLatestCorrectRecord.stream().filter(r -> correctStatus.equals(r.getAuditStatus())).map(r -> r.getAccountId()).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(correctStatusAccountId)) {
                throw new SearchResultEmptyException();
            }
            if (CollectionUtils.isNotEmpty(searchIds)) {
                searchIds.retainAll(correctStatusAccountId);
            } else {
                searchIds.addAll(correctStatusAccountId);
            }
        }
    }
}

