/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.review.oppo.impl;

import com.bxm.adsmanager.dal.mapper.adkeeper.DownloadLandingPageMapper;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplate;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplateAssets;
import com.bxm.adsmanager.model.dao.adkeeper.DownloadLandingPage;
import com.bxm.adsmanager.model.dto.AdAssetsTemplateAssetsJsonConfig;
import com.bxm.adsmanager.model.enums.PageTypeEnum;
import com.bxm.adsmanager.model.vo.AdTicketVo;
import com.bxm.adsmanager.service.review.QueryRequest;
import com.bxm.adsmanager.service.review.QueryResult;
import com.bxm.adsmanager.service.review.ReviewRequest;
import com.bxm.adsmanager.service.review.ReviewResult;
import com.bxm.adsmanager.service.review.oppo.OppoCreativeService;
import com.bxm.adsmanager.service.review.oppo.conf.OppoProperties;
import com.bxm.adsmanager.service.review.oppo.entity.OppoData;
import com.bxm.adsmanager.service.review.oppo.entity.OppoResponse;
import com.bxm.adsmanager.service.review.oppo.entity.OppoReviewRequest;
import com.bxm.warcar.utils.JsonHelper;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class OppoCreativeServiceImpl
implements OppoCreativeService {
    private static final Logger log = LoggerFactory.getLogger(OppoCreativeServiceImpl.class);
    private final OppoProperties oppoProperties;
    private final RestTemplate restTemplate;
    private final ObjectMapper objectMapper;
    private final DownloadLandingPageMapper downloadLandingPageMapper;

    public OppoCreativeServiceImpl(OppoProperties oppoProperties, RestTemplate restTemplate, ObjectMapper objectMapper, DownloadLandingPageMapper downloadLandingPageMapper) {
        this.oppoProperties = oppoProperties;
        this.restTemplate = restTemplate;
        this.objectMapper = objectMapper;
        this.downloadLandingPageMapper = downloadLandingPageMapper;
    }

    @Override
    public ReviewResult submitCreative(ReviewRequest reviewRequest) {
        List<OppoReviewRequest> request = this.buildOppoRequestBody(reviewRequest);
        if (log.isDebugEnabled()) {
            log.debug("review request = {}", (Object)JsonHelper.convert(request));
        }
        HttpEntity httpEntity = new HttpEntity((Object)JsonHelper.convert(request), this.headers());
        ResponseEntity responseEntityStr = this.restTemplate.postForEntity(this.oppoProperties.getReviewUrl(), (Object)httpEntity, String.class, new Object[0]);
        OppoResponse response = null;
        try {
            response = (OppoResponse)this.objectMapper.readValue((String)responseEntityStr.getBody(), OppoResponse.class);
        }
        catch (IOException e) {
            throw new BusinessException("oppo\u63d0\u5ba1\u5f02\u5e38");
        }
        if (log.isDebugEnabled()) {
            log.debug("review resp = {}", (Object)JsonHelper.convert((Object)response));
        }
        HashMap result = Maps.newHashMap();
        if (Objects.nonNull(response.getRet()) && response.getRet() == 1) {
            throw new BusinessException(response.getMsg());
        }
        List<OppoData> data = response.getData();
        StringBuilder errMsg = new StringBuilder();
        for (OppoData d : data) {
            if (Objects.nonNull(d.getCrId())) {
                result.put(d.getExternalId(), d.getCrId());
                continue;
            }
            errMsg.append("(id = " + d.getExternalId() + ", reason = " + d.getMsg() + ")\n");
        }
        return ReviewResult.builder().result(result).errMsg(errMsg.toString()).build();
    }

    @Override
    public QueryResult queryCreative(QueryRequest request) {
        if (log.isDebugEnabled()) {
            log.debug("query request = {}", (Object)JsonHelper.convert((Object)request));
        }
        HttpEntity httpEntity = new HttpEntity((Object)JsonHelper.convert(request.getList()), this.headers());
        ResponseEntity responseEntityStr = this.restTemplate.postForEntity(this.oppoProperties.getQueryUrl(), (Object)httpEntity, String.class, new Object[0]);
        OppoResponse response = null;
        try {
            response = (OppoResponse)this.objectMapper.readValue((String)responseEntityStr.getBody(), OppoResponse.class);
        }
        catch (IOException e) {
            throw new BusinessException("oppo\u67e5\u8be2\u5f02\u5e38");
        }
        if (log.isDebugEnabled()) {
            log.debug("query resp = {}", (Object)JsonHelper.convert((Object)response));
        }
        if (Objects.nonNull(response.getRet()) && response.getRet() == 1) {
            throw new BusinessException(response.getMsg());
        }
        List<OppoData> data = response.getData();
        HashSet success = Sets.newHashSet();
        HashMap fail = Maps.newHashMap();
        for (OppoData d : data) {
            Integer status = d.getStatus();
            if (!Objects.nonNull(status)) continue;
            if (OppoData.SUCCESS_STATUS == status) {
                success.add(d.getCrId());
                continue;
            }
            if (OppoData.FAIL_STATUS != status) continue;
            fail.put(d.getCrId(), d.getRemark());
        }
        return QueryResult.builder().success(success).fail(fail).build();
    }

    private MultiValueMap<String, String> headers() {
        LinkedMultiValueMap header = new LinkedMultiValueMap();
        header.add((Object)"Content-Type", (Object)"application/json");
        header.add((Object)"Authorization", (Object)("Bearer " + this.token(this.oppoProperties)));
        return header;
    }

    private String sign(String dspId, String key, String timestamp) {
        MessageDigest messageDigest;
        String text;
        block2: {
            text = dspId + key + timestamp;
            messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                if (!log.isErrorEnabled()) break block2;
                log.error("oppo sign err", (Throwable)e);
            }
        }
        byte[] bytes = messageDigest.digest(text.getBytes());
        return Hex.encodeHexString((byte[])bytes);
    }

    private String token(OppoProperties oppoProperties) {
        String dspId = oppoProperties.getDspId();
        String key = oppoProperties.getKey();
        String timestamp = System.currentTimeMillis() / 1000L + "";
        String sign = this.sign(dspId, key, timestamp);
        String text = dspId + "," + timestamp + "," + sign;
        String token = Base64.encodeBase64String((byte[])text.getBytes(StandardCharsets.UTF_8));
        return token;
    }

    private List<OppoReviewRequest> buildOppoRequestBody(ReviewRequest reviewRequest) {
        ArrayList<OppoReviewRequest> oppoReviewRequests = new ArrayList<OppoReviewRequest>();
        Map<Long, String> adAssetsTemplateExtMap = reviewRequest.getAdAssetsTemplates().stream().filter(t -> t.getExt() != null).collect(Collectors.toMap(AdAssetsTemplate::getId, AdAssetsTemplate::getExt));
        for (AdAssetsTemplateAssets adAssetsTemplateAssets : reviewRequest.getAdAssetsTemplateAssetsList()) {
            OppoReviewRequest oppoReviewRequest = new OppoReviewRequest();
            this.fillInfo(oppoReviewRequest, reviewRequest.getAdTicketVo(), adAssetsTemplateAssets, adAssetsTemplateExtMap);
            oppoReviewRequests.add(oppoReviewRequest);
        }
        return oppoReviewRequests;
    }

    private void fillInfo(OppoReviewRequest reviewRequest, AdTicketVo adTicketVo, AdAssetsTemplateAssets adAssetsTemplateAssets, Map<Long, String> adAssetsTemplateExtMap) {
        String config = adAssetsTemplateAssets.getConfig();
        AdAssetsTemplateAssetsJsonConfig adAssetsTemplateAssetsJsonConfig = (AdAssetsTemplateAssetsJsonConfig)JsonHelper.convert((String)config, AdAssetsTemplateAssetsJsonConfig.class);
        String templateId = adAssetsTemplateAssetsJsonConfig.getTemplateId();
        if (Objects.nonNull(templateId)) {
            String ext = adAssetsTemplateExtMap.get(Long.valueOf(templateId.toString()));
            if (StringUtils.isBlank((CharSequence)ext)) {
                throw new BusinessException("\u7d20\u6750\u6a21\u677f\u4e0a\u7684\u6269\u5c55\u4fe1\u606f\u914d\u7f6e\u4e3a\u7a7a");
            }
            try {
                reviewRequest.setFmtSpec(Integer.valueOf(ext));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new BusinessException("\u7d20\u6750\u6a21\u677f\u4e0a\u7684\u6269\u5c55\u4fe1\u606f\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u6570\u5b57");
            }
        }
        Integer contentType = 1;
        AdTicketVo.TicketAppExtendVo ticketAppExtendVo = adTicketVo.getTicketAppExtendVo();
        PageTypeEnum pageTypeEnum = PageTypeEnum.getByType((short)ticketAppExtendVo.getPageType());
        switch (pageTypeEnum) {
            case DOWNLOAD: {
                contentType = 2;
                break;
            }
            case FORM: {
                contentType = 1;
                break;
            }
            case DEEPLINK: {
                contentType = 4;
                break;
            }
            case INSPIRE_BROWSE: {
                contentType = 2;
                break;
            }
            default: {
                contentType = 1;
            }
        }
        String banners = adTicketVo.getControlVo().getBanners();
        if (StringUtils.isNotEmpty((CharSequence)banners) && banners.startsWith("1-")) {
            String str = banners.split(",")[0];
            String posId = banners.substring(2, str.length());
            String[] posInfos = posId.split("-");
            String key = posInfos[0];
            String enter = posInfos[1];
            reviewRequest.setLandingPage(adTicketVo.getUrl().replace("__APPKEY__", key).replace("__APPENTRANCE__", enter));
        }
        if (StringUtils.isEmpty((CharSequence)reviewRequest.getLandingPage())) {
            reviewRequest.setLandingPage(adTicketVo.getUrl());
        }
        reviewRequest.setContentType(contentType);
        reviewRequest.setDeepLink(ticketAppExtendVo.getJumpUrl());
        if (StringUtils.isNotEmpty((CharSequence)ticketAppExtendVo.getPackageName())) {
            reviewRequest.setAppPkg(ticketAppExtendVo.getPackageName());
        } else {
            DownloadLandingPage downloadLandingPage;
            Long id = ticketAppExtendVo.getDownloadLandingPageId();
            if (Objects.nonNull(id) && Objects.nonNull(downloadLandingPage = this.downloadLandingPageMapper.selectByPrimaryKey(id))) {
                reviewRequest.setAppPkg(downloadLandingPage.getAppPackageName());
            }
        }
        reviewRequest.setTitle(adAssetsTemplateAssetsJsonConfig.getTitle());
        reviewRequest.setBdName(adAssetsTemplateAssetsJsonConfig.getOriginName());
        reviewRequest.setDesc(adAssetsTemplateAssetsJsonConfig.getContent());
        long currentTimeMillis = System.currentTimeMillis() / 1000L;
        reviewRequest.setBeginTime(String.valueOf(currentTimeMillis));
        reviewRequest.setEndTime(String.valueOf(currentTimeMillis + 7776000L));
        reviewRequest.setExternalId(String.valueOf(adAssetsTemplateAssets.getId()));
        ArrayList<String> fileUrls = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)adAssetsTemplateAssetsJsonConfig.getVideo())) {
            fileUrls.add(adAssetsTemplateAssetsJsonConfig.getVideo());
        }
        if (StringUtils.isNotBlank((CharSequence)adAssetsTemplateAssetsJsonConfig.getImage())) {
            fileUrls.add(adAssetsTemplateAssetsJsonConfig.getImage());
        }
        if (CollectionUtils.isNotEmpty(fileUrls)) {
            reviewRequest.setFileUrls(fileUrls);
        }
        reviewRequest.setBtnText(adAssetsTemplateAssetsJsonConfig.getButtonText());
        reviewRequest.setBdLogo(adAssetsTemplateAssetsJsonConfig.getIcon());
        reviewRequest.setVideoCoverImg(adAssetsTemplateAssetsJsonConfig.getCoverOrEndImage());
    }
}

