/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.rtb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.adticketgroup.AppkeyGroupConfigMapper;
import com.bxm.adsmanager.dal.mapper.adticketgroup.TicketGroupWhiteMapper;
import com.bxm.adsmanager.dal.mapper.media.MediaMapper;
import com.bxm.adsmanager.dal.mapper.rtb.PositionRtbHeadTicketGroupMapper;
import com.bxm.adsmanager.dal.mapper.rtb.PositionRtbMapper;
import com.bxm.adsmanager.dal.mapper.rtb.RtbCvrControlMapper;
import com.bxm.adsmanager.dal.mapper.rtb.RtbRatioControlMapper;
import com.bxm.adsmanager.dal.mapper.rtb.RtbSpeedControlMapper;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.integration.datapark.service.DataparkPositionRtbIntegration;
import com.bxm.adsmanager.integration.utils.DateUtil;
import com.bxm.adsmanager.model.constant.CommonConstant;
import com.bxm.adsmanager.model.constant.RedisKeys;
import com.bxm.adsmanager.model.dao.adticketgroup.AppkeyGroupConfig;
import com.bxm.adsmanager.model.dao.rtb.HeadTicket;
import com.bxm.adsmanager.model.dao.rtb.PositionRtb;
import com.bxm.adsmanager.model.dao.rtb.PositionRtbHeadTicketGroup;
import com.bxm.adsmanager.model.dao.rtb.RtbCvrControl;
import com.bxm.adsmanager.model.dao.rtb.RtbRatioControl;
import com.bxm.adsmanager.model.dao.rtb.RtbSpeedControl;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.CvrStatisticDto;
import com.bxm.adsmanager.model.dto.rtb.PositionRtbDto;
import com.bxm.adsmanager.model.vo.AdTicketValueVo;
import com.bxm.adsmanager.model.vo.CvrStatisticVo;
import com.bxm.adsmanager.model.vo.RtbCvrControlVo;
import com.bxm.adsmanager.model.vo.RtbRatioControlVo;
import com.bxm.adsmanager.model.vo.RtbSpeedControlVo;
import com.bxm.adsmanager.model.vo.kuaishou.KuaishouTokenVo;
import com.bxm.adsmanager.model.vo.rtb.PositionRtbVo;
import com.bxm.adsmanager.model.vo.weibo.WBToken;
import com.bxm.adsmanager.service.media.MediaTicketTagService;
import com.bxm.adsmanager.service.rtb.PositionRTBService;
import com.bxm.adsmanager.utils.DoubleUtil;
import com.bxm.adsmanager.utils.ListOrderUtils;
import com.bxm.datapark.web.model.RtbPositionGroupHourly;
import com.bxm.util.StringUtil;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.TypeHelper;
import com.bxm.warcar.utils.UrlHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.util.UriComponentsBuilder;
import redis.clients.jedis.JedisPool;

@Service
public class PositionRTBServiceImpl
implements PositionRTBService {
    private static final Logger log = LoggerFactory.getLogger(PositionRTBServiceImpl.class);
    @Resource
    PositionRtbMapper positionRtbMapper;
    @Resource
    RtbCvrControlMapper rtbCvrControlMapper;
    @Resource
    RtbSpeedControlMapper rtbSpeedControlMapper;
    @Resource
    RtbRatioControlMapper rtbRatioControlMapper;
    @Resource
    PositionRtbHeadTicketGroupMapper positionRtbHeadTicketGroupMapper;
    @Resource
    AdTicketMapper adTicketMapper;
    @Resource
    AppkeyGroupConfigMapper appkeyGroupConfigMapper;
    @Resource
    TicketGroupWhiteMapper ticketGroupWhiteMapper;
    @Resource
    MediaTicketTagService mediaTicketTagService;
    @Autowired
    private MediaMapper mediaMapper;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired
    private JedisFetcher fetcher;
    @Autowired
    @Qualifier(value="rtbJedisFetcher")
    private JedisFetcher rtbJedisFetcher;
    @Autowired
    private DataparkPositionRtbIntegration dataparkPositionRtbIntegration;
    @Autowired
    @Qualifier(value="rtbJedisPool")
    private JedisPool rtbJedisPool;
    public static final String KEY_SPLIT_CHAR = "_";
    private static final String SHALLOW = "SHALLOW";
    private static final String DEEP = "DEEP";

    @Override
    public PositionRtbVo getPositionRtbByPositionId(String positionId) {
        List newHeadlist;
        PositionRtbVo positionRtbVo = new PositionRtbVo();
        PositionRtb positionRtb = this.positionRtbMapper.selectByPositionId(positionId);
        if (positionRtb == null) {
            return positionRtbVo;
        }
        String appKey = positionId.split("-")[0];
        String appId = (String)this.fetcher.hfetch(CommonConstant.getWeiboAppId(), appKey, String.class);
        if (!org.springframework.util.StringUtils.isEmpty((Object)appId)) {
            WBToken wbToken = (WBToken)this.fetcher.hfetch(CommonConstant.wbToken(), appId, WBToken.class);
            positionRtbVo.setExDate(Objects.nonNull(wbToken) ? wbToken.getExDate() : null);
            positionRtbVo.setRefreshTokenExDate(Objects.nonNull(wbToken) ? wbToken.getRefreshExDate() : null);
        }
        BeanUtils.copyProperties((Object)positionRtb, (Object)positionRtbVo);
        List rtbRatioControls = this.rtbRatioControlMapper.selectByPositionId(positionId);
        positionRtbVo.setRatioControlJson(JSONObject.toJSONString(this.getRtbRatioControlVo(rtbRatioControls)));
        List rtbSpeedControls = this.rtbSpeedControlMapper.selectByPositionId(positionId);
        if (!CollectionUtils.isEmpty((Collection)rtbSpeedControls)) {
            List<RtbSpeedControl> rtbTicketControls = rtbSpeedControls.stream().filter(rtbSpeedControl -> StringUtil.isNotBlank((CharSequence)rtbSpeedControl.getAdTicketId())).collect(Collectors.toList());
            List<RtbSpeedControl> rtbActivityControls = rtbSpeedControls.stream().filter(rtbSpeedControl -> StringUtil.isBlank((CharSequence)rtbSpeedControl.getAdTicketId())).collect(Collectors.toList());
            positionRtbVo.setTicketControlJson(JSONObject.toJSONString(this.getRtbSpeedControlVo(rtbTicketControls)));
            positionRtbVo.setActivityControlJson(JSONObject.toJSONString(this.getRtbSpeedControlVo(rtbActivityControls)));
        }
        if (!CollectionUtils.isEmpty((Collection)(newHeadlist = this.positionRtbHeadTicketGroupMapper.selectByPrimaryParams(positionId)))) {
            for (PositionRtbHeadTicketGroup positionRtbHeadTicketGroup : newHeadlist) {
                positionRtbHeadTicketGroup.setHeadTicketList(JSONObject.parseArray((String)positionRtbHeadTicketGroup.getHeadTicketJson(), HeadTicket.class));
                positionRtbHeadTicketGroup.setHeadTicketJson(null);
            }
            positionRtbVo.setNewHeadTicketJson(JSONObject.toJSONString((Object)newHeadlist));
        }
        this.fillKuaishouToken(positionRtbVo);
        return positionRtbVo;
    }

    @Override
    public void saveOrUpdate(PositionRtbDto positionRtbDto, User user) {
        List<String> positionIdList;
        List updatePositionRtbList;
        List<Object> updateIdsList = new ArrayList();
        if (!org.springframework.util.StringUtils.isEmpty((Object)positionRtbDto.getUpdateIds())) {
            updateIdsList = Arrays.asList(positionRtbDto.getUpdateIds().split(","));
        }
        boolean isPositionBatch = (updatePositionRtbList = this.positionRtbMapper.selectListByPositionIds(positionIdList = Arrays.asList(positionRtbDto.getPositionIds().split(",")))).size() > 1 || positionRtbDto.getIsCopy() == 1;
        ArrayList<String> updateList = new ArrayList<String>();
        ArrayList<PositionRtb> insertPositionRtbList = new ArrayList<PositionRtb>();
        ArrayList<RtbRatioControl> insertRtbRatioControlList = new ArrayList<RtbRatioControl>();
        ArrayList<RtbRatioControl> updateRtbRatioControlList = new ArrayList<RtbRatioControl>();
        ArrayList<Long> deleteRtbRatioControlIdList = new ArrayList<Long>();
        ArrayList<RtbSpeedControl> insertRtbSpeedControlList = new ArrayList<RtbSpeedControl>();
        ArrayList<RtbSpeedControl> updateRtbSpeedControlList = new ArrayList<RtbSpeedControl>();
        ArrayList<Long> deleteRtbSpeedControlIdList = new ArrayList<Long>();
        ArrayList<PositionRtbHeadTicketGroup> updateNewHead = new ArrayList<PositionRtbHeadTicketGroup>();
        ArrayList<PositionRtbHeadTicketGroup> addNewHead = new ArrayList<PositionRtbHeadTicketGroup>();
        ArrayList<String> ids = new ArrayList<String>();
        Boolean isTouFang = CollectionUtils.isEmpty(updateIdsList) || updateIdsList.contains("1");
        Boolean isHead = CollectionUtils.isEmpty(updateIdsList) || updateIdsList.contains("2");
        Boolean isHelp = CollectionUtils.isEmpty(updateIdsList) || updateIdsList.contains("3");
        Boolean isCover = CollectionUtils.isEmpty(updateIdsList) || updateIdsList.contains("4");
        Boolean isSpeed = CollectionUtils.isEmpty(updateIdsList) || updateIdsList.contains("5");
        for (PositionRtb positionRtb : updatePositionRtbList) {
            positionRtb.setModifyUser(user.getUsername());
            positionRtb.setModifyTime(new Date());
            if (isTouFang.booleanValue()) {
                positionRtb.setTargetOneRtb(positionRtbDto.getTargetOneRtb());
                positionRtb.setTargetTwoRtb(positionRtbDto.getTargetTwoRtb());
                positionRtb.setActivityOne(positionRtbDto.getActivityOne());
                positionRtb.setActivityTwo(positionRtbDto.getActivityTwo());
            }
            if (isHead.booleanValue()) {
                positionRtb.setHeadTicketJson(positionRtbDto.getHeadTicketJson());
                this.fillNewHeadTicket(positionRtbDto, updateNewHead, addNewHead, positionRtb, ids, isPositionBatch);
            }
            if (isHelp.booleanValue()) {
                positionRtb.setHelpTicketJson(positionRtbDto.getHelpTicketJson());
            }
            positionRtb.setTargetType(positionRtbDto.getTargetType());
            positionRtb.setIsUse(positionRtbDto.getIsUse());
            if (positionIdList.size() == 1) {
                positionRtb.setCustomerId(positionRtbDto.getCustomerId());
                positionRtb.setToken(positionRtbDto.getToken());
                positionRtb.setSourceId(positionRtbDto.getSourceId());
            }
            if (isCover.booleanValue()) {
                this.fillRtbRatioControlList(positionRtbDto, positionRtb.getPositionId(), insertRtbRatioControlList, updateRtbRatioControlList, deleteRtbRatioControlIdList, isPositionBatch);
            }
            if (isSpeed.booleanValue()) {
                this.fillRtbSpeedControlList(positionRtbDto, positionRtb.getPositionId(), insertRtbSpeedControlList, updateRtbSpeedControlList, deleteRtbSpeedControlIdList, isPositionBatch);
            }
            updateList.add(positionRtb.getPositionId());
        }
        for (String positionId : positionIdList) {
            if (updateList.contains(positionId)) continue;
            PositionRtb positionRtb = new PositionRtb();
            positionRtb.setCreateTime(new Date());
            positionRtb.setCreateUser(user.getUsername());
            positionRtb.setTargetType(positionRtbDto.getTargetType());
            positionRtb.setPositionId(positionId);
            positionRtb.setIsUse(positionRtbDto.getIsUse());
            positionRtb.setSourceType(positionRtbDto.getSourceType());
            if (isTouFang.booleanValue()) {
                positionRtb.setTargetOneRtb(positionRtbDto.getTargetOneRtb());
                positionRtb.setTargetTwoRtb(positionRtbDto.getTargetTwoRtb());
                positionRtb.setActivityOne(positionRtbDto.getActivityOne());
                positionRtb.setActivityTwo(positionRtbDto.getActivityTwo());
            }
            if (isHead.booleanValue()) {
                positionRtb.setHeadTicketJson(positionRtbDto.getHeadTicketJson());
                this.fillNewHeadTicket(positionRtbDto, updateNewHead, addNewHead, positionRtb, ids, isPositionBatch);
            }
            if (isHelp.booleanValue()) {
                positionRtb.setHelpTicketJson(positionRtbDto.getHelpTicketJson());
            }
            if (positionIdList.size() == 1) {
                positionRtb.setToken(positionRtbDto.getToken());
                positionRtb.setCustomerId(positionRtbDto.getCustomerId());
                positionRtb.setSourceId(positionRtbDto.getSourceId());
            }
            if (isCover.booleanValue()) {
                positionRtb.setConversionControlType(Optional.ofNullable(positionRtbDto.getConversionControlType()).orElse((byte)1));
                this.fillRtbRatioControlList(positionRtbDto, positionId, insertRtbRatioControlList, updateRtbRatioControlList, deleteRtbRatioControlIdList, isPositionBatch);
            }
            if (isSpeed.booleanValue()) {
                this.fillRtbSpeedControlList(positionRtbDto, positionRtb.getPositionId(), insertRtbSpeedControlList, updateRtbSpeedControlList, deleteRtbSpeedControlIdList, isPositionBatch);
            }
            insertPositionRtbList.add(positionRtb);
        }
        if (!CollectionUtils.isEmpty((Collection)updatePositionRtbList)) {
            this.positionRtbMapper.batchUpdate(updatePositionRtbList);
        }
        if (!CollectionUtils.isEmpty(insertPositionRtbList)) {
            this.positionRtbMapper.batchInsert(insertPositionRtbList);
        }
        if (!CollectionUtils.isEmpty(insertRtbRatioControlList)) {
            this.rtbRatioControlMapper.batchInsert(insertRtbRatioControlList);
        }
        if (!CollectionUtils.isEmpty(updateRtbRatioControlList)) {
            this.rtbRatioControlMapper.batchUpdate(updateRtbRatioControlList);
        }
        if (!CollectionUtils.isEmpty(deleteRtbRatioControlIdList)) {
            this.rtbRatioControlMapper.batchDelete(deleteRtbRatioControlIdList);
        }
        if (!CollectionUtils.isEmpty(insertRtbSpeedControlList)) {
            this.rtbSpeedControlMapper.batchInsert(insertRtbSpeedControlList);
        }
        if (!CollectionUtils.isEmpty(updateRtbSpeedControlList)) {
            this.rtbSpeedControlMapper.batchUpdate(updateRtbSpeedControlList);
        }
        if (!CollectionUtils.isEmpty(deleteRtbSpeedControlIdList)) {
            this.rtbSpeedControlMapper.batchDelete(deleteRtbSpeedControlIdList);
        }
        if (!CollectionUtils.isEmpty(updateNewHead)) {
            this.positionRtbHeadTicketGroupMapper.batchDelete(updateNewHead, ids);
            this.positionRtbHeadTicketGroupMapper.batchUpdate(updateNewHead);
        }
        if (isPositionBatch && !CollectionUtils.isEmpty(addNewHead)) {
            this.positionRtbHeadTicketGroupMapper.batchDelete(addNewHead, null);
        }
        if (!CollectionUtils.isEmpty(addNewHead)) {
            this.positionRtbHeadTicketGroupMapper.batchInsert(addNewHead);
        }
        this.refreshCache(positionIdList);
    }

    private void fillNewHeadTicket(PositionRtbDto positionRtbDto, List<PositionRtbHeadTicketGroup> updateNewHead, List<PositionRtbHeadTicketGroup> addNewHead, PositionRtb positionRtb, List<String> ids, Boolean isPositionBatch) {
        if (!org.springframework.util.StringUtils.isEmpty((Object)positionRtbDto.getNewHeadTicketJson())) {
            List list = JSONObject.parseArray((String)positionRtbDto.getNewHeadTicketJson(), PositionRtbHeadTicketGroup.class);
            for (PositionRtbHeadTicketGroup positionRtbHeadTicketGroup : list) {
                positionRtbHeadTicketGroup.setPositionId(positionRtb.getPositionId());
                positionRtbHeadTicketGroup.setHeadTicketJson(JSON.toJSONString((Object)positionRtbHeadTicketGroup.getHeadTicketList()));
                if (!isPositionBatch.booleanValue() && positionRtbHeadTicketGroup.getId() != null) {
                    ids.add(positionRtbHeadTicketGroup.getId().toString());
                    updateNewHead.add(positionRtbHeadTicketGroup);
                    continue;
                }
                addNewHead.add(positionRtbHeadTicketGroup);
            }
        }
    }

    @Override
    public List<AdTicketValueVo> getTicketByIds(String ticketIds) {
        return this.adTicketMapper.findValusByIds(Arrays.asList(ticketIds.split(",")));
    }

    @Override
    public List<String> getNewPositionIds(String positionIds) {
        ArrayList<String> positionIdList = new ArrayList<String>();
        String[] value = positionIds.split(",");
        for (int i = 0; i < value.length; ++i) {
            positionIdList.add(value[i]);
        }
        List positionRtbList = this.positionRtbMapper.selectListByPositionIds(positionIdList);
        for (PositionRtb positionRtb : positionRtbList) {
            positionIdList.remove(positionRtb.getPositionId());
        }
        return positionIdList;
    }

    @Override
    public List<CvrStatisticVo> getCvrStatistic(CvrStatisticDto cvrStatisticDto) {
        Integer dataType = cvrStatisticDto.getDataType();
        switch (dataType) {
            case 1: {
                return this.getAdGroupMediaStatistic(cvrStatisticDto);
            }
            case 2: {
                return this.getAdGroupHourStatistic(cvrStatisticDto);
            }
        }
        return this.getAdGroupMediaStatistic(cvrStatisticDto);
    }

    private List<CvrStatisticVo> getAdGroupMediaStatistic(CvrStatisticDto cvrStatisticDto) {
        RtbRatioControl rtbRatioControl = this.rtbRatioControlMapper.selectByPrimaryKey(cvrStatisticDto.getControlId());
        Set mediaSet = this.rtbJedisFetcher.sfetchAll(PositionRTBServiceImpl.setsAdGroupMedias(cvrStatisticDto.getPositionId(), cvrStatisticDto.getAdGroupId()), String.class);
        if (CollectionUtils.isEmpty((Collection)mediaSet) || Objects.isNull(rtbRatioControl)) {
            return Collections.EMPTY_LIST;
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)cvrStatisticDto.getMediaName())) {
            if (!mediaSet.contains(cvrStatisticDto.getMediaName())) {
                return Collections.EMPTY_LIST;
            }
            mediaSet = Sets.newHashSet((Object[])new String[]{cvrStatisticDto.getMediaName()});
        }
        String dimensionKey = PositionRTBServiceImpl.createKey(cvrStatisticDto.getPositionId(), cvrStatisticDto.getAdGroupId(), TypeHelper.castToString((Object)cvrStatisticDto.getControlId()), rtbRatioControl.getStartTime(), rtbRatioControl.getEndTime());
        log.info("debug cvr data | mediaSet: {}, dimensionKey: {}", (Object)mediaSet, (Object)dimensionKey);
        ArrayList<CvrStatisticVo> cvrStatisticVos = new ArrayList<CvrStatisticVo>();
        for (String media : mediaSet) {
            CvrStatisticVo cvrStatisticVo = new CvrStatisticVo();
            Map hfetchall = this.rtbJedisFetcher.hfetchall(PositionRTBServiceImpl.hashAdGroupMediaData(dimensionKey, media), Integer.class);
            cvrStatisticVo.setMediaName(media);
            hfetchall = Optional.ofNullable(hfetchall).orElse(Maps.newHashMap());
            cvrStatisticVo.setClick(hfetchall.getOrDefault("click", 0));
            cvrStatisticVo.setFeedback_success(hfetchall.getOrDefault("feedback_success", 0));
            cvrStatisticVo.setPlus(hfetchall.getOrDefault("plus", 0));
            cvrStatisticVo.setMinus(hfetchall.getOrDefault("minus", 0));
            cvrStatisticVo.setMinusTotal(hfetchall.getOrDefault("minus_total", 0));
            cvrStatisticVo.setReceivers(hfetchall.getOrDefault("receivers", 0));
            cvrStatisticVo.setCvr(DoubleUtil.doubleToPercent(cvrStatisticVo.computeCvr()));
            cvrStatisticVos.add(cvrStatisticVo);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)cvrStatisticDto.getSortParam())) {
            ListOrderUtils.sortList(cvrStatisticVos, cvrStatisticDto.getSortParam(), cvrStatisticDto.getSortParam());
        }
        CvrStatisticVo sumCvrStatisticVo = new CvrStatisticVo();
        sumCvrStatisticVo.setMediaName("\u6c47\u603b");
        for (CvrStatisticVo cvrStatisticVo : cvrStatisticVos) {
            sumCvrStatisticVo.setClick(Integer.valueOf(Optional.ofNullable(sumCvrStatisticVo.getClick()).orElse(0) + cvrStatisticVo.getClick()));
            sumCvrStatisticVo.setFeedback_success(Integer.valueOf(Optional.ofNullable(sumCvrStatisticVo.getFeedback_success()).orElse(0) + cvrStatisticVo.getFeedback_success()));
            sumCvrStatisticVo.setMinus(Integer.valueOf(Optional.ofNullable(sumCvrStatisticVo.getMinus()).orElse(0) + cvrStatisticVo.getMinus()));
            sumCvrStatisticVo.setMinusTotal(Integer.valueOf(Optional.ofNullable(sumCvrStatisticVo.getMinusTotal()).orElse(0) + cvrStatisticVo.getMinusTotal()));
            sumCvrStatisticVo.setPlus(Integer.valueOf(Optional.ofNullable(sumCvrStatisticVo.getPlus()).orElse(0) + cvrStatisticVo.getPlus()));
            sumCvrStatisticVo.setReceivers(Integer.valueOf(Optional.ofNullable(sumCvrStatisticVo.getReceivers()).orElse(0) + cvrStatisticVo.getReceivers()));
        }
        sumCvrStatisticVo.setCvr(DoubleUtil.doubleToPercent(sumCvrStatisticVo.computeCvr()));
        cvrStatisticVos.add(0, sumCvrStatisticVo);
        return cvrStatisticVos;
    }

    private List<CvrStatisticVo> getAdGroupHourStatistic(CvrStatisticDto cvrStatisticDto) {
        ArrayList<CvrStatisticVo> cvrStatisticVos = new ArrayList<CvrStatisticVo>();
        List rtbAdGroupDatas = this.dataparkPositionRtbIntegration.getRtbAdGroupData(cvrStatisticDto.getPositionId(), cvrStatisticDto.getAdGroupId(), cvrStatisticDto.getStartTime(), cvrStatisticDto.getEndTime());
        if (rtbAdGroupDatas == null) {
            return Collections.EMPTY_LIST;
        }
        for (RtbPositionGroupHourly rtbAdGroupData : rtbAdGroupDatas) {
            CvrStatisticVo cvrStatisticVo = new CvrStatisticVo();
            cvrStatisticVo.setDateTime(rtbAdGroupData.getThehour());
            cvrStatisticVo.setClick(rtbAdGroupData.getClickPv());
            cvrStatisticVo.setPlus(rtbAdGroupData.getSupplyValidPv());
            cvrStatisticVo.setMinus(rtbAdGroupData.getDetainValidPv());
            cvrStatisticVo.setFeedback_success(rtbAdGroupData.getSuccessValidPv());
            cvrStatisticVo.setReceivers(rtbAdGroupData.getActualValidPv());
            cvrStatisticVo.setActualCost(rtbAdGroupData.getShallowConvCost());
            cvrStatisticVo.setCvr(DoubleUtil.doubleToPercent(cvrStatisticVo.computeCvr()));
            cvrStatisticVos.add(cvrStatisticVo);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)cvrStatisticDto.getSortParam())) {
            ListOrderUtils.sortList(cvrStatisticVos, cvrStatisticDto.getSortParam(), cvrStatisticDto.getSortParam());
        }
        return cvrStatisticVos;
    }

    @Override
    public void refreshCache(List<String> positionIds) {
        BigDecimal cvrBigDecimal;
        List positionRtbs = this.positionRtbMapper.selectListByPositionIds(positionIds);
        List rtbSpeedControls = this.rtbSpeedControlMapper.selectListByPositionIds(positionIds);
        List rtbRatioControls = this.rtbRatioControlMapper.selectListByPositionIds(positionIds);
        List newHeadList = this.positionRtbHeadTicketGroupMapper.selectListByPositionIds(positionIds);
        List rtbCvrControls = this.rtbCvrControlMapper.selectListByPositionIds(positionIds);
        for (RtbRatioControl ratioControl : rtbRatioControls) {
            if (Objects.nonNull(ratioControl.getCvr())) {
                cvrBigDecimal = new BigDecimal(Objects.toString(ratioControl.getCvr())).divide(new BigDecimal(100), 4, RoundingMode.DOWN);
                ratioControl.setCvr(Double.valueOf(cvrBigDecimal.doubleValue()));
            }
            if (Objects.nonNull(ratioControl.getShallowRatio())) {
                BigDecimal shallowRatio = new BigDecimal(Objects.toString(ratioControl.getShallowRatio())).divide(new BigDecimal(100), 4, RoundingMode.DOWN);
                ratioControl.setShallowRatio(Double.valueOf(shallowRatio.doubleValue()));
            }
            if (!Objects.nonNull(ratioControl.getDeepRatio())) continue;
            BigDecimal deepRatio = new BigDecimal(Objects.toString(ratioControl.getDeepRatio())).divide(new BigDecimal(100), 4, RoundingMode.DOWN);
            ratioControl.setDeepRatio(Double.valueOf(deepRatio.doubleValue()));
        }
        for (RtbCvrControl cvrControl : rtbCvrControls) {
            cvrBigDecimal = new BigDecimal(Objects.toString(cvrControl.getCvr())).divide(new BigDecimal(100), 4, RoundingMode.DOWN);
            cvrControl.setCvr(Double.valueOf(cvrBigDecimal.doubleValue()));
            if (!Objects.nonNull(cvrControl.getDeepCvr())) continue;
            BigDecimal deepCvrBigDecimal = new BigDecimal(Objects.toString(cvrControl.getDeepCvr())).divide(new BigDecimal(100), 4, RoundingMode.DOWN);
            cvrControl.setDeepCvr(Double.valueOf(deepCvrBigDecimal.doubleValue()));
        }
        Map<String, List<RtbRatioControl>> rtbRatioControlMap = rtbRatioControls.stream().collect(Collectors.groupingBy(rtbRatioControl -> rtbRatioControl.getPositionId()));
        Map<String, List<RtbCvrControl>> rtbCvrControlMap = rtbCvrControls.stream().filter(RtbCvrControl::enableCvrControl).collect(Collectors.groupingBy(rtbCvrControl -> rtbCvrControl.getPositionId()));
        Map<String, List<RtbCvrControl>> rtbRateControlMap = rtbCvrControls.stream().filter(RtbCvrControl::enableRateControl).collect(Collectors.groupingBy(rtbCvrControl -> rtbCvrControl.getPositionId()));
        Map<String, List<RtbSpeedControl>> rtbTicketControlMap = rtbSpeedControls.stream().filter(rtbSpeedControl -> StringUtil.isNotBlank((CharSequence)rtbSpeedControl.getAdTicketId())).collect(Collectors.groupingBy(rtbSpeedControl -> rtbSpeedControl.getPositionId()));
        Map<String, List<RtbSpeedControl>> rtbActivityControlMap = rtbSpeedControls.stream().filter(rtbSpeedControl -> StringUtil.isBlank((CharSequence)rtbSpeedControl.getAdTicketId())).collect(Collectors.groupingBy(rtbSpeedControl -> rtbSpeedControl.getPositionId()));
        Map<String, List<PositionRtbHeadTicketGroup>> newHeadMap = newHeadList.stream().collect(Collectors.groupingBy(positionRtbHeadTicketGroup -> positionRtbHeadTicketGroup.getPositionId()));
        for (PositionRtb positionRtb : positionRtbs) {
            String positionId = positionRtb.getPositionId();
            List<RtbCvrControl> cvrControls = rtbCvrControlMap.getOrDefault(positionId, Lists.newArrayList());
            List<RtbCvrControl> rateControls = rtbRateControlMap.getOrDefault(positionId, Lists.newArrayList());
            List<RtbRatioControl> ratioControls = rtbRatioControlMap.getOrDefault(positionId, Lists.newArrayList());
            List<RtbSpeedControl> ticketControls = rtbTicketControlMap.getOrDefault(positionId, Lists.newArrayList());
            List<RtbSpeedControl> activityControls = rtbActivityControlMap.getOrDefault(positionId, Lists.newArrayList());
            positionRtb.setCvrControls(cvrControls);
            positionRtb.setRateControls(rateControls);
            positionRtb.setRatioControls(ratioControls);
            positionRtb.setTicketControls(ticketControls);
            positionRtb.setActivityControls(activityControls);
            List<PositionRtbHeadTicketGroup> list = newHeadMap.getOrDefault(positionId, Lists.newArrayList());
            positionRtb.setNewHeadList(list);
            for (PositionRtbHeadTicketGroup positionRtbHeadTicketGroup2 : list) {
                positionRtbHeadTicketGroup2.setHeadTicketList(JSONObject.parseArray((String)positionRtbHeadTicketGroup2.getHeadTicketJson(), HeadTicket.class));
                positionRtbHeadTicketGroup2.setHeadTicketJson(null);
            }
            this.updater.hupdate(PositionRTBServiceImpl.rtbKeyGenerator(), positionId, (Object)positionRtb);
        }
    }

    @Override
    public String getWhiteIds(String appKey, String id) {
        List adMediaTestList;
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)appKey) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)id)) {
            throw new BusinessException("appKdy \u548c id \u4e0d\u80fd\u4e3a\u7a7a");
        }
        String returnIds = null;
        StringBuilder ids = new StringBuilder();
        AppkeyGroupConfig byAppKey = this.appkeyGroupConfigMapper.findByAppKey(appKey);
        if (!Objects.isNull(byAppKey)) {
            String groupIds = byAppKey.getGroupIds();
            List<String> groupIdsList = Arrays.asList(groupIds.split(","));
            HashMap<String, List<String>> map = new HashMap<String, List<String>>(1);
            map.put("groupIdsList", groupIdsList);
            List list = this.ticketGroupWhiteMapper.findTicketGroup(map);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                list.forEach(t -> {
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)t.getTicketIds())) {
                        ids.append(t.getTicketIds());
                        ids.append(",");
                    }
                });
            }
        }
        HashMap map = new HashMap();
        if (StringUtils.isNotBlank((String)id)) {
            ArrayList<BigInteger> list = new ArrayList<BigInteger>();
            String[] s = id.split(",");
            for (int i = 0; i < s.length; ++i) {
                list.add(BigInteger.valueOf(Long.parseLong(s[i])));
            }
            map.put("list", list);
        }
        if (!CollectionUtils.isEmpty((Collection)(adMediaTestList = this.mediaMapper.findTicketByParam(map)))) {
            adMediaTestList.forEach(t -> {
                ids.append(t.getId());
                ids.append(",");
            });
        }
        if (ids.length() > 0) {
            ids.deleteCharAt(ids.length() - 1);
            List collect = Arrays.stream(ids.toString().split(",")).distinct().collect(Collectors.toList());
            returnIds = collect.toString();
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(returnIds)) {
            returnIds = returnIds.substring(1, returnIds.length() - 1);
            returnIds = returnIds.replaceAll(" ", "");
        }
        return returnIds;
    }

    private void fillRtbRatioControlList(PositionRtbDto positionRtbDto, String positionId, List<RtbRatioControl> insertRtbRatioControlList, List<RtbRatioControl> updateRtbRatioControlList, List<Long> deleteRtbRatioControlIdList, boolean isPositionBatch) {
        String ratioControlJson = positionRtbDto.getRatioControlJson();
        ArrayList<Long> remainRtbRatioControlIds = new ArrayList<Long>();
        List rtbRatioControls = new ArrayList();
        if (StringUtil.isNotBlank((CharSequence)ratioControlJson)) {
            rtbRatioControls = JSONObject.parseArray((String)ratioControlJson, RtbRatioControl.class);
        }
        if (isPositionBatch) {
            for (RtbRatioControl rtbRatioControl : rtbRatioControls) {
                rtbRatioControl.setId(null);
            }
        }
        for (RtbRatioControl rtbRatioControl : rtbRatioControls) {
            rtbRatioControl.setPositionId(positionId);
            if (Objects.isNull(rtbRatioControl.getId())) {
                insertRtbRatioControlList.add(rtbRatioControl);
                continue;
            }
            remainRtbRatioControlIds.add(rtbRatioControl.getId());
            updateRtbRatioControlList.add(rtbRatioControl);
        }
        List oldRtbRatioControls = this.rtbRatioControlMapper.selectByPositionId(positionId);
        for (RtbRatioControl oldRtbRatioControl : oldRtbRatioControls) {
            Long id = oldRtbRatioControl.getId();
            if (remainRtbRatioControlIds.contains(id)) continue;
            deleteRtbRatioControlIdList.add(id);
        }
    }

    private void fillRtbSpeedControlList(PositionRtbDto positionRtbDto, String positionId, List<RtbSpeedControl> insertRtbSpeedControlList, List<RtbSpeedControl> updateRtbSpeedControlList, List<Long> deleteRtbSpeedControlIdList, boolean isPositionBatch) {
        String ticketControlJson = positionRtbDto.getTicketControlJson();
        ArrayList<Long> remainRtbSpeedControlIds = new ArrayList<Long>();
        List ticketControls = new ArrayList();
        if (StringUtil.isNotBlank((CharSequence)ticketControlJson)) {
            ticketControls = JSONObject.parseArray((String)ticketControlJson, RtbSpeedControl.class);
        }
        List activityControls = new ArrayList();
        String activityControlJson = positionRtbDto.getActivityControlJson();
        if (StringUtil.isNotBlank((CharSequence)activityControlJson)) {
            activityControls = JSONObject.parseArray((String)activityControlJson, RtbSpeedControl.class);
        }
        if (isPositionBatch) {
            for (RtbSpeedControl ticketControl : ticketControls) {
                ticketControl.setId(null);
            }
            for (RtbSpeedControl activityControl : activityControls) {
                activityControl.setId(null);
            }
        }
        for (RtbSpeedControl ticketControl : ticketControls) {
            ticketControl.setPositionId(positionId);
            if (Objects.isNull(ticketControl.getId())) {
                insertRtbSpeedControlList.add(ticketControl);
                continue;
            }
            remainRtbSpeedControlIds.add(ticketControl.getId());
            updateRtbSpeedControlList.add(ticketControl);
        }
        for (RtbSpeedControl activityControl : activityControls) {
            activityControl.setPositionId(positionId);
            if (Objects.isNull(activityControl.getId())) {
                insertRtbSpeedControlList.add(activityControl);
                continue;
            }
            remainRtbSpeedControlIds.add(activityControl.getId());
            updateRtbSpeedControlList.add(activityControl);
        }
        List oldRtbSpeedControls = this.rtbSpeedControlMapper.selectByPositionId(positionId);
        for (RtbSpeedControl oldRtbSpeedControl : oldRtbSpeedControls) {
            Long id = oldRtbSpeedControl.getId();
            if (remainRtbSpeedControlIds.contains(id)) continue;
            deleteRtbSpeedControlIdList.add(id);
        }
    }

    private List<RtbSpeedControlVo> getRtbSpeedControlVo(List<RtbSpeedControl> rtbTicketControls) {
        ArrayList<RtbSpeedControlVo> rtbSpeedControlVos = new ArrayList<RtbSpeedControlVo>();
        for (RtbSpeedControl rtbTicketControl : rtbTicketControls) {
            RtbSpeedControlVo rtbSpeedControlVo = new RtbSpeedControlVo();
            BeanUtils.copyProperties((Object)rtbTicketControl, (Object)rtbSpeedControlVo);
            rtbSpeedControlVo.setEnable(Integer.valueOf(rtbTicketControl.getEnable() != false ? 1 : 0));
            rtbSpeedControlVos.add(rtbSpeedControlVo);
        }
        return rtbSpeedControlVos;
    }

    private List<RtbCvrControlVo> getRtbCvrControlVo(List<RtbCvrControl> rtbCvrControls) {
        ArrayList<RtbCvrControlVo> rtbCvrControlVos = new ArrayList<RtbCvrControlVo>();
        for (RtbCvrControl rtbCvrControl : rtbCvrControls) {
            RtbCvrControlVo rtbCvrControlVo = new RtbCvrControlVo();
            BeanUtils.copyProperties((Object)rtbCvrControl, (Object)rtbCvrControlVo);
            if (rtbCvrControl.enableCvrControl()) {
                String dimensionKey = PositionRTBServiceImpl.createKey(rtbCvrControl.getPositionId(), rtbCvrControl.getAdGroupId(), TypeHelper.castToString((Object)rtbCvrControl.getId()), rtbCvrControl.getStartTime(), rtbCvrControl.getEndTime());
                Map data = Optional.ofNullable(this.rtbJedisFetcher.hfetchall(PositionRTBServiceImpl.hashAdGroupData(dimensionKey), Integer.class)).orElse(new HashMap());
                Long filterCounter = data.getOrDefault("minus", 0).longValue();
                Long plusCount = data.getOrDefault("plus", 0).longValue();
                rtbCvrControlVo.setFilterCount(filterCounter);
                rtbCvrControlVo.setPlusCount(plusCount);
            }
            if (rtbCvrControl.enableRateControl()) {
                Long totalSuccessCount;
                Long totalFilterCount;
                if (org.springframework.util.StringUtils.isEmpty((Object)rtbCvrControl.getAdGroupId())) {
                    totalFilterCount = (Long)this.rtbJedisFetcher.fetch(PositionRTBServiceImpl.stringRejectForGlobal(Objects.toString(rtbCvrControl.getId())), Long.class);
                    totalSuccessCount = (Long)this.rtbJedisFetcher.fetch(PositionRTBServiceImpl.stringAcceptForGlobal(Objects.toString(rtbCvrControl.getId())), Long.class);
                } else {
                    String shallowKey = PositionRTBServiceImpl.createKey(rtbCvrControl.getPositionId(), rtbCvrControl.getAdGroupId(), TypeHelper.castToString((Object)rtbCvrControl.getId()), rtbCvrControl.getStartTime(), rtbCvrControl.getEndTime(), SHALLOW);
                    String deepKey = PositionRTBServiceImpl.createKey(rtbCvrControl.getPositionId(), rtbCvrControl.getAdGroupId(), TypeHelper.castToString((Object)rtbCvrControl.getId()), rtbCvrControl.getStartTime(), rtbCvrControl.getEndTime(), DEEP);
                    Long shallowFilterCount = (Long)this.rtbJedisFetcher.fetch(PositionRTBServiceImpl.stringReject(shallowKey), Long.class);
                    Long shallowSuccessCount = (Long)this.rtbJedisFetcher.fetch(PositionRTBServiceImpl.stringAccept(shallowKey), Long.class);
                    Long deepFilterCount = (Long)this.rtbJedisFetcher.fetch(PositionRTBServiceImpl.stringReject(deepKey), Long.class);
                    Long deepSuccessCount = (Long)this.rtbJedisFetcher.fetch(PositionRTBServiceImpl.stringAccept(deepKey), Long.class);
                    totalFilterCount = Optional.ofNullable(shallowFilterCount).orElse(0L) + Optional.ofNullable(deepFilterCount).orElse(0L);
                    totalSuccessCount = Optional.ofNullable(shallowSuccessCount).orElse(0L) + Optional.ofNullable(deepSuccessCount).orElse(0L);
                }
                rtbCvrControlVo.setSuccessCount(Optional.ofNullable(totalSuccessCount).orElse(0L));
                rtbCvrControlVo.setFilterCount(Optional.ofNullable(totalFilterCount).orElse(0L));
            }
            rtbCvrControlVo.setEnable(Integer.valueOf(rtbCvrControl.getEnable() != false ? 1 : 0));
            rtbCvrControlVos.add(rtbCvrControlVo);
        }
        return rtbCvrControlVos;
    }

    private List<RtbRatioControlVo> getRtbRatioControlVo(List<RtbRatioControl> rtbRatioControls) {
        ArrayList<RtbRatioControlVo> rtbRatioControlVos = new ArrayList<RtbRatioControlVo>();
        for (RtbRatioControl rtbRatioControl : rtbRatioControls) {
            List adGroupDataList;
            RtbRatioControlVo rtbRatioControlVo = new RtbRatioControlVo();
            BeanUtils.copyProperties((Object)rtbRatioControl, (Object)rtbRatioControlVo);
            String dimensionKey = PositionRTBServiceImpl.createKey(rtbRatioControl.getPositionId(), rtbRatioControl.getAdGroupId(), TypeHelper.castToString((Object)rtbRatioControl.getId()), rtbRatioControl.getStartTime(), rtbRatioControl.getEndTime());
            String hashKey = StringUtil.isBlank((CharSequence)rtbRatioControl.getAdGroupId()) ? Objects.toString(rtbRatioControl.getId()) : dimensionKey;
            Map data = Optional.ofNullable(this.rtbJedisFetcher.hfetchall(PositionRTBServiceImpl.hashAdGroupData(hashKey), Integer.class)).orElse(new HashMap());
            Integer minus = data.getOrDefault("minus", 0);
            Integer plus = data.getOrDefault("plus", 0);
            Integer feedbackSuccess = data.getOrDefault("feedback_success", 0);
            Integer miunsTotal = data.getOrDefault("minus_total", 0);
            rtbRatioControlVo.setFeedbackSuccess(feedbackSuccess);
            rtbRatioControlVo.setMinus(minus);
            rtbRatioControlVo.setMinusTotal(miunsTotal);
            rtbRatioControlVo.setPlus(plus);
            rtbRatioControlVo.setEnable(Integer.valueOf(rtbRatioControl.getEnable() != false ? 1 : 0));
            String adGroupDataStr = (String)this.rtbJedisFetcher.fetch(RedisKeys.strRtbAdGroupData((Integer)1, (String)rtbRatioControl.getAdGroupId()), String.class);
            if (StringUtil.isNotBlank((CharSequence)adGroupDataStr) && !CollectionUtils.isEmpty((Collection)(adGroupDataList = JSONObject.parseArray((String)adGroupDataStr, AdGroupData.class)))) {
                AdGroupData firstAdGroupData = (AdGroupData)adGroupDataList.iterator().next();
                Long time = firstAdGroupData.getTime();
                String timeStr = DateUtil.dateTo14String((Date)new Date(time));
                rtbRatioControlVo.setKuaishouDataLastUpdateTime(timeStr);
            }
            rtbRatioControlVos.add(rtbRatioControlVo);
        }
        return rtbRatioControlVos;
    }

    private void fillKuaishouToken(PositionRtbVo positionRtbVo) {
        String positionId = positionRtbVo.getPositionId();
        String appKey = positionId.split("-")[0];
        String appIdAndSecret = (String)this.fetcher.hfetch(RedisKeys.hashKuaishouAppIdConfig(), appKey, String.class);
        if (StringUtil.isBlank((CharSequence)appIdAndSecret)) {
            return;
        }
        String appId = null;
        String callback = null;
        String[] split = appIdAndSecret.split(",");
        appId = split[0];
        callback = split[2];
        if (StringUtil.isBlank((CharSequence)appId)) {
            return;
        }
        if (StringUtil.isNotBlank((CharSequence)callback)) {
            String[] callbackSplit = org.springframework.util.StringUtils.split((String)callback, (String)"?");
            String finalCallback = "";
            if (callbackSplit != null && callbackSplit.length == 2) {
                finalCallback = callbackSplit[0] + "?" + UrlHelper.urlEncode((String)callbackSplit[1]);
            }
            String kuaishouAuthUrl = UriComponentsBuilder.fromUriString((String)"https://developers.e.kuaishou.com/tools/authorize?app_id=165899974&scope=%5B%22ad_query%22%2C%22ad_manage%22%2C%22report_service%22%2C%22account_service%22%2C%22public_dmp_service%22%2C%22public_agent_service%22%2C%22public_account_service%22%5D&oauth_type=advertiser").replaceQueryParam("app_id", new Object[]{appId}).replaceQueryParam("redirect_uri", new Object[]{finalCallback}).build().toString();
            positionRtbVo.setKuaishouReauthUrl(kuaishouAuthUrl);
        }
        String customerId = positionRtbVo.getCustomerId();
        try {
            KuaishouTokenVo kuaishouTokenVo = (KuaishouTokenVo)this.fetcher.hfetch(RedisKeys.hashKuaishouToken(), appId, KuaishouTokenVo.class);
            if (Objects.nonNull(kuaishouTokenVo)) {
                List advertiserIds = kuaishouTokenVo.getAdvertiserIds();
                if (StringUtil.isBlank((CharSequence)customerId) || CollectionUtils.isEmpty((Collection)advertiserIds) || !advertiserIds.contains(Long.valueOf(customerId))) {
                    return;
                }
                positionRtbVo.setKuaishouAccessToken(kuaishouTokenVo.getToken());
                positionRtbVo.setKuaishouTokenExpireTime(kuaishouTokenVo.getTokenExpireTime());
                positionRtbVo.setKuaishouRefreshToken(kuaishouTokenVo.getRefreshToken());
                positionRtbVo.setKuaishouRefreshTokenExpireTime(kuaishouTokenVo.getRefreshExpireTime());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static KeyGenerator rtbKeyGenerator() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "RTB", "ACTIVITY", "TICKET"});
    }

    private static KeyGenerator stringAccept(String dimension) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb_control", "deduction", "accept", PositionRTBServiceImpl.getDate(), dimension});
    }

    private static KeyGenerator stringReject(String dimension) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb_control", "deduction", "reject", PositionRTBServiceImpl.getDate(), dimension});
    }

    private static KeyGenerator stringAcceptForGlobal(String dimension) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb_control", "deduction", "accept_global", PositionRTBServiceImpl.getDate(), dimension});
    }

    private static KeyGenerator stringRejectForGlobal(String dimension) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb_control", "deduction", "reject_global", PositionRTBServiceImpl.getDate(), dimension});
    }

    private static KeyGenerator setsAdGroupMedias(String positionId, String adGroupId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "conv", "MAP", PositionRTBServiceImpl.getDate(), positionId, adGroupId});
    }

    private static KeyGenerator hashAdGroupData(String dimension) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "conv", "DATA", PositionRTBServiceImpl.getDate(), dimension});
    }

    private static KeyGenerator hashAdGroupMediaData(String dimension, String media) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "conv", "APP_DATA", PositionRTBServiceImpl.getDate(), dimension, media});
    }

    public static String createKey(String ... strings) {
        StringBuilder s = new StringBuilder();
        for (String string : strings) {
            s.append(string.replaceAll(":", "")).append(KEY_SPLIT_CHAR);
        }
        return StringUtils.removeEnd((String)s.toString(), (String)KEY_SPLIT_CHAR);
    }

    private static String getDate() {
        return LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
    }

    private static class AdGroupData {
        private Long time;

        public Long getTime() {
            return this.time;
        }

        public void setTime(Long time) {
            this.time = time;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AdGroupData)) {
                return false;
            }
            AdGroupData other = (AdGroupData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$time = this.getTime();
            Long other$time = other.getTime();
            return !(this$time == null ? other$time != null : !((Object)this$time).equals(other$time));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AdGroupData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $time = this.getTime();
            result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
            return result;
        }

        public String toString() {
            return "PositionRTBServiceImpl.AdGroupData(time=" + this.getTime() + ")";
        }
    }
}

