/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.service.tbltag.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdRulesMapper;
import com.bxm.adsmanager.dal.mapper.tbltag.ext.TblAdPostionTagMapperExt;
import com.bxm.adsmanager.model.constant.CommonConstant;
import com.bxm.adsmanager.model.dao.adkeeper.AdRules;
import com.bxm.adsmanager.model.dao.media.AdMediaTag;
import com.bxm.adsmanager.model.dao.tbltag.TblAdPostionTag;
import com.bxm.adsmanager.model.dto.tbltag.TblAdTagDto;
import com.bxm.adsmanager.model.vo.tbltag.TblAdTagVo;
import com.bxm.adsmanager.service.media.MediaService;
import com.bxm.adsmanager.service.tbltag.TblAdTagService;
import com.bxm.util.dto.ValidateException;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.utils.KeyBuilder;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TblAdTagServiceImpl
implements TblAdTagService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TblAdTagService.class);
    @Autowired
    private TblAdPostionTagMapperExt tblAdTagMapperExt;
    List<TblAdTagVo> parentList = null;
    @Autowired
    private MediaService mediaService;
    @Autowired
    private AdRulesMapper adRulesMapper;
    @Autowired
    private JedisUpdater jedisUpdater;
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;

    @Override
    public List<TblAdTagVo> findTblAdTagListByType(Integer parentId, Integer type) {
        List<TblAdTagVo> list = this.recursiveFindTblAdTag(parentId, type);
        return list;
    }

    @Override
    public List<TblAdTagVo> findTblAdTagById(Integer parentId) {
        List list = this.tblAdTagMapperExt.findTblAdTagList(parentId, Integer.valueOf(2), null);
        return list;
    }

    @Override
    public TblAdTagVo updateFindTblAdTag(Integer id, Integer type) {
        this.parentList = new ArrayList<TblAdTagVo>();
        TblAdTagVo tblAdTag = this.tblAdTagMapperExt.selectByPrimaryKey(id);
        if (tblAdTag.getParentId() == 0) {
            return tblAdTag;
        }
        List<TblAdTagVo> parentList = this.findParentList(tblAdTag.getId(), "1");
        parentList.stream().forEach(vo -> vo.setBrotherList(this.tblAdTagMapperExt.findTblAdTagList(vo.getParentId(), type, null)));
        tblAdTag.setParentList(parentList);
        tblAdTag.setBrotherList(this.tblAdTagMapperExt.findTblAdTagList(tblAdTag.getParentId(), type, null));
        return tblAdTag;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.DEFAULT, timeout=36000, rollbackFor={Exception.class})
    public TblAdPostionTag addTag(TblAdPostionTag tblAdTag) throws ValidateException {
        TblAdTagVo tblAdTagVo = this.findParentTag(tblAdTag.getParentId());
        Integer code = this.tblAdTagMapperExt.findMaxCode();
        tblAdTag.setCode(Integer.valueOf(code + 1));
        tblAdTag.setCreateTime(new Date());
        this.buildTagFullInfo(tblAdTag, (TblAdPostionTag)tblAdTagVo);
        if (this.tblAdTagMapperExt.insert(tblAdTag) > 0) {
            if (tblAdTag.getTypeTag() == 1) {
                List list = this.tblAdTagMapperExt.findTblAdTagList(Integer.valueOf(0), Integer.valueOf(1), null);
                HashSet<String> set = new HashSet<String>();
                for (TblAdTagVo tv : list) {
                    set.add(tv.getCode().toString());
                }
                this.jedisUpdater.update(TblAdTagServiceImpl.getAttributeTag(), set);
            }
            return tblAdTag;
        }
        return null;
    }

    public static KeyGenerator getAttributeTag() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "ATTRIBUTE", "TAG"});
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, isolation=Isolation.DEFAULT, timeout=36000, rollbackFor={Exception.class})
    public Boolean updateTag(TblAdTagDto tblAdTagDto, String user) throws ValidateException {
        TblAdTagVo entity = this.tblAdTagMapperExt.selectByPrimaryKey(tblAdTagDto.getId());
        if (null == entity) {
            throw new NullPointerException("\u672a\u67e5\u8be2\u5230\u6807\u7b7e\uff01");
        }
        Date modifyTime = new Date();
        TblAdTagVo tblAdTagVo = this.findParentTag(tblAdTagDto.getParentId());
        TblAdPostionTag tblAdTag = new TblAdPostionTag();
        BeanUtils.copyProperties((Object)tblAdTagDto, (Object)tblAdTag);
        tblAdTag.setModifyUser(user);
        tblAdTag.setModifyTime(modifyTime);
        tblAdTag.setCode(entity.getCode());
        this.buildTagFullInfo(tblAdTag, (TblAdPostionTag)tblAdTagVo);
        if (this.tblAdTagMapperExt.updateByPrimaryKeySelective(tblAdTag) < 1) {
            throw new RuntimeException("\u4fee\u6539\u6807\u7b7e\uff0c\u6267\u884cSQL\u5931\u8d25\uff01");
        }
        List tblAdPostionTags = this.tblAdTagMapperExt.findByFullpath(entity.getFullCodePath());
        if (CollectionUtils.isNotEmpty((Collection)tblAdPostionTags)) {
            String newFullNameStr = tblAdTag.getFullNameStr();
            String oldFullNameStr = entity.getFullNameStr();
            ArrayList updateEntities = Lists.newArrayListWithCapacity((int)tblAdPostionTags.size());
            for (TblAdPostionTag tblAdPostionTag : tblAdPostionTags) {
                String fullNameStr = tblAdPostionTag.getFullNameStr();
                int index = fullNameStr.indexOf(oldFullNameStr);
                if (index < 0) continue;
                int lastIndex = fullNameStr.lastIndexOf(oldFullNameStr);
                fullNameStr = index != lastIndex ? fullNameStr.substring(0, lastIndex) + newFullNameStr + fullNameStr.substring(lastIndex + oldFullNameStr.length(), fullNameStr.length()) : fullNameStr.replace(oldFullNameStr, newFullNameStr);
                TblAdPostionTag updateEntity = new TblAdPostionTag();
                updateEntity.setId(tblAdPostionTag.getId());
                updateEntity.setFullNameStr(fullNameStr);
                updateEntity.setModifyTime(modifyTime);
                updateEntity.setModifyUser(user);
                updateEntities.add(updateEntity);
            }
            if (updateEntities.size() > 0 && this.tblAdTagMapperExt.batchUpdateTag((List)updateEntities, user) < 1) {
                throw new RuntimeException("\u4fee\u6539\u5f53\u524d\u6807\u7b7e\u6210\u529f\uff0c\u4f46\u6279\u91cf\u4fee\u6539\u5b50\u6807\u7b7e\u5931\u8d25\uff01");
            }
        }
        return true;
    }

    private TblAdTagVo findParentTag(Integer parentId) {
        TblAdTagVo tblAdTagVo = null;
        if (!parentId.equals(CommonConstant.TicketTag.BASIC_PARENT_ID) && null == (tblAdTagVo = this.tblAdTagMapperExt.selectByPrimaryKey(parentId))) {
            throw new NullPointerException("\u672a\u67e5\u8be2\u5230\u7236\u6807\u7b7e\uff01");
        }
        return tblAdTagVo;
    }

    private void buildTagFullInfo(TblAdPostionTag entity, TblAdPostionTag parent) {
        String fullNameStrSuffix = ".";
        if (null != parent) {
            entity.setFullCodePath(StringUtils.join((Object[])new Serializable[]{parent.getFullCodePath(), entity.getCode(), fullNameStrSuffix}));
            if (parent.getFullNameStr().endsWith(fullNameStrSuffix)) {
                entity.setFullNameStr(StringUtils.join((Object[])new String[]{parent.getFullNameStr(), entity.getName(), fullNameStrSuffix}));
            } else {
                entity.setFullNameStr(StringUtils.join((Object[])new String[]{parent.getFullNameStr(), fullNameStrSuffix, entity.getName(), fullNameStrSuffix}));
            }
        } else {
            entity.setFullCodePath(entity.getCode().toString() + fullNameStrSuffix);
            entity.setFullNameStr(entity.getName() + fullNameStrSuffix);
        }
    }

    private List<TblAdTagVo> recursiveFindTblAdTag(Integer parentId, Integer type) {
        List list = null;
        if (type == 1) {
            return this.tblAdTagMapperExt.findTblAdTagList(Integer.valueOf(0), Integer.valueOf(1), null);
        }
        list = this.tblAdTagMapperExt.findTblAdTagList(parentId, type, null);
        if (list == null) {
            return null;
        }
        list.stream().forEach(vo -> {
            List<TblAdTagVo> childList = this.recursiveFindTblAdTag(vo.getId(), type);
            vo.setChildList(childList);
        });
        return list;
    }

    private List<TblAdTagVo> findParentList(Integer id, String type) {
        TblAdTagVo tblAdTagVo = this.tblAdTagMapperExt.selectByPrimaryKey(id);
        if (!type.equals("1")) {
            this.parentList.add(tblAdTagVo);
        }
        if (tblAdTagVo == null) {
            LOGGER.info("findParentList is null , id is {} ,type is {}", (Object)id, (Object)type);
            return this.parentList;
        }
        if (tblAdTagVo.getParentId() == 0) {
            return this.parentList;
        }
        this.findParentList(tblAdTagVo.getParentId(), type);
        return this.parentList;
    }

    @Override
    public PageInfo<TblAdTagVo> findfindTblAdTagByNameAndID(String param, String type) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)param)) {
            paramMap.put("param", param);
        } else {
            paramMap.put("param", "");
        }
        List<TblAdTagVo> list = this.tblAdTagMapperExt.findTblAdTagChildByName(paramMap);
        TblAdTagVo tblAdTagVo = this.tblAdTagMapperExt.findTblAdTagByName(paramMap);
        if (tblAdTagVo == null) {
            return null;
        }
        list = this.getLabelList(type, list, tblAdTagVo);
        return new PageInfo(list);
    }

    @Override
    public PageInfo<TblAdTagVo> findAll(Integer pageNum, Integer pageSize, String name) {
        if (StringUtils.isNotEmpty((CharSequence)(pageNum + "")) && StringUtils.isNotEmpty((CharSequence)(pageSize + ""))) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
        }
        List list = this.tblAdTagMapperExt.findTblAdTagList(Integer.valueOf(-1), Integer.valueOf(2), name);
        PageInfo page = new PageInfo(list);
        page.setList(this.getLabelList("1", list, null));
        return page;
    }

    @Override
    public JSONObject findTblAdTagByCodeStr(String str) {
        ArrayList categoryLableList = new ArrayList();
        ArrayList attrlableList = new ArrayList();
        JSONObject entity = new JSONObject();
        String[] codes = str.split(",");
        Arrays.stream(codes).forEach(code -> {
            this.parentList = new ArrayList<TblAdTagVo>();
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("codestr", (String)code);
            TblAdTagVo tblAdTagVo = this.tblAdTagMapperExt.findTblAdTagByName(paramMap);
            if (tblAdTagVo != null) {
                if (tblAdTagVo.getTypeTag() == 1) {
                    attrlableList.add(tblAdTagVo);
                } else if (tblAdTagVo.getParentId() == 0) {
                    categoryLableList.add(tblAdTagVo);
                } else {
                    List<TblAdTagVo> parentList = this.findParentList(tblAdTagVo.getParentId(), "2");
                    tblAdTagVo.setParentList(parentList);
                    categoryLableList.add(tblAdTagVo);
                }
            }
        });
        entity.put("attributeLable", attrlableList);
        entity.put("categoryLagle", categoryLableList);
        return entity;
    }

    private List<TblAdTagVo> getLabelList(String type, List<TblAdTagVo> list, TblAdTagVo tblAdTagVo) {
        if (type.equals("1")) {
            if (tblAdTagVo != null) {
                list.add(tblAdTagVo);
            }
        } else {
            list.stream().sorted(Comparator.comparing(TblAdPostionTag::getCode)).forEach(vo -> {
                vo.setBrotherList(null);
                vo.setParentList(null);
                vo.setChildList(null);
            });
        }
        list.stream().forEach(vo -> {
            this.parentList = new ArrayList<TblAdTagVo>();
            vo.setBrotherList(null);
            vo.setParentList(null);
            vo.setChildList(null);
            if (vo.getParentId() == 0) {
                vo.setParentFirstName("--");
                vo.setParentScendName("--");
            } else {
                List<Object> listchile = this.findParentList(vo.getId(), "2");
                listchile = listchile.stream().filter(childvo -> !Objects.equals(childvo.getName(), vo.getName())).collect(Collectors.toList());
                if ((listchile = listchile.stream().sorted(Comparator.comparing(TblAdPostionTag::getCode)).collect(Collectors.toList())).size() > 1) {
                    vo.setParentFirstName(((TblAdTagVo)listchile.get(0)).getName());
                    vo.setParentScendName(((TblAdTagVo)listchile.get(1)).getName());
                } else {
                    vo.setParentFirstName(((TblAdTagVo)listchile.get(0)).getName());
                    vo.setParentScendName("--");
                }
            }
        });
        list = list.stream().sorted(Comparator.comparing(TblAdPostionTag::getId)).collect(Collectors.toList());
        return list;
    }

    @Override
    public List<TblAdTagVo> tblTagByFirstCode() {
        return this.tblAdTagMapperExt.tblTagByFirstCode();
    }

    @Override
    public PageInfo<TblAdTagVo> findNewTreeAll(Integer pageNum, Integer pageSize, Integer type, String name, Integer parentId) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List<Object> list = new ArrayList();
        list = this.findNewTreeAllTblAdTag(parentId, type, name);
        PageInfo page = new PageInfo(list);
        return page;
    }

    private List<TblAdTagVo> findNewTreeAllTblAdTag(Integer parentId, Integer type, String name) {
        List list = null;
        if (type == 1) {
            return this.tblAdTagMapperExt.findTblAdTagList(Integer.valueOf(0), type, name);
        }
        list = this.tblAdTagMapperExt.findTblAdTagList(parentId, type, name);
        if (list == null) {
            return null;
        }
        list.stream().forEach(vo -> {
            List<TblAdTagVo> childList = this.findNewTreeAllTblAdTag(vo.getId(), type, null);
            vo.setChildList(childList);
        });
        return list;
    }

    @Override
    public PageInfo<TblAdTagVo> findNewAll(Integer pageNum, Integer pageSize, String name, Integer type) {
        if (StringUtils.isNotEmpty((CharSequence)(pageNum + "")) && StringUtils.isNotEmpty((CharSequence)(pageSize + ""))) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
        }
        List list = this.tblAdTagMapperExt.findTblAdTagList(Integer.valueOf(-1), type, name);
        PageInfo page = new PageInfo(list);
        page.setList(this.getNewLabelList("1", list, null, type));
        return page;
    }

    @Override
    public List<TblAdPostionTag> findOneLevelTag(Integer tagType) {
        return this.tblAdTagMapperExt.findOneLevelTag(tagType);
    }

    private List<TblAdTagVo> getNewLabelList(String bs, List<TblAdTagVo> list, TblAdTagVo tblAdTagVo, Integer type) {
        if (bs.equals("1")) {
            if (tblAdTagVo != null) {
                list.add(tblAdTagVo);
            }
        } else {
            list.stream().sorted(Comparator.comparing(TblAdPostionTag::getCode)).forEach(vo -> {
                vo.setBrotherList(null);
                vo.setParentList(null);
                vo.setChildList(null);
            });
        }
        list.stream().forEach(vo -> {
            this.parentList = new ArrayList<TblAdTagVo>();
            vo.setBrotherList(null);
            vo.setParentList(null);
            vo.setChildList(null);
            if (vo.getParentId() == 0) {
                vo.setParentFirstName("--");
                vo.setParentScendName("--");
            } else {
                List<Object> listchile = this.findParentList(vo.getId(), type + "");
                listchile = listchile.stream().filter(childvo -> !childvo.getName().equals(vo.getName())).collect(Collectors.toList());
                if ((listchile = listchile.stream().sorted(Comparator.comparing(TblAdPostionTag::getCode)).collect(Collectors.toList())).size() > 1) {
                    vo.setParentFirstName(((TblAdTagVo)listchile.get(0)).getName());
                    vo.setParentScendName(((TblAdTagVo)listchile.get(1)).getName());
                } else {
                    vo.setParentFirstName(((TblAdTagVo)listchile.get(0)).getName());
                    vo.setParentScendName("--");
                }
            }
        });
        list = list.stream().sorted(Comparator.comparing(TblAdPostionTag::getId)).collect(Collectors.toList());
        return list;
    }

    @Override
    public List<TblAdPostionTag> getTagCode(String tagCode) {
        return this.tblAdTagMapperExt.getTagCode(tagCode);
    }

    @Override
    public List<TblAdPostionTag> getLevel3TagCode(String tagCode) {
        return this.tblAdTagMapperExt.getLevel3TagCode(tagCode);
    }

    @Override
    public List<TblAdPostionTag> findByFullpath(String tagCodes) {
        return this.tblAdTagMapperExt.findByFullpath(tagCodes);
    }

    @Override
    public List<String> findCodeByTime() {
        List strings = this.tblAdTagMapperExt.findCodeByTime();
        if (null == strings) {
            return Lists.newArrayList();
        }
        return strings;
    }

    @Override
    public List<String> findCodeOtherByTime() {
        List strings = this.tblAdTagMapperExt.findCodeOtherByTime();
        if (null == strings) {
            return Lists.newArrayList();
        }
        return strings;
    }

    @Override
    public void insertMediaTag(Integer parentId, String code) throws Exception {
        TblAdTagVo tav = this.findParentTag(parentId);
        List<Object> listTblAdTagVo = new ArrayList();
        listTblAdTagVo = tav.getParentId() != 0 ? this.findTblAdTagListByType(tav.getParentId(), 2) : this.findTblAdTagListByType(parentId, 2);
        List adRulesList = this.adRulesMapper.findAllByTargetIdSupplement();
        HashSet<String> mediaTagsSet = new HashSet<String>();
        ArrayList<String> listPositionId = new ArrayList<String>();
        ArrayList<String> tag = new ArrayList<String>();
        tag.add(code);
        for (AdRules rule : adRulesList) {
            List adMediaTags = JSON.parseArray((String)rule.getRuleValue(), AdMediaTag.class);
            if (CollectionUtils.isNotEmpty((Collection)adMediaTags)) {
                listPositionId.add(rule.getTargetIdSupplement().split("-")[1]);
                if (this.isContainMediaTag(adMediaTags, listTblAdTagVo, mediaTagsSet, code, parentId, tav.getCode())) {
                    this.mediaService.bathInsertTag(rule.getTargetIdSupplement().split("-")[0], JSON.toJSONString(listPositionId), JSON.toJSONString(tag), null, null);
                }
            }
            mediaTagsSet.clear();
            listPositionId.clear();
        }
    }

    public boolean isContainMediaTag(List<AdMediaTag> mediaTags, List<TblAdTagVo> listTblAdTagVo, Set<String> mediaTagsSet, String code, Integer parentId, Integer firstCode) {
        for (AdMediaTag adTag : mediaTags) {
            mediaTagsSet.add(adTag.getTag());
        }
        mediaTagsSet.add(code);
        if (listTblAdTagVo.size() == 1 && !mediaTagsSet.contains(firstCode.toString())) {
            return false;
        }
        for (TblAdTagVo tbladTag : listTblAdTagVo) {
            if (tbladTag.getParentId().intValue() == parentId.intValue()) {
                if (tbladTag.getChildList().size() > 0) {
                    for (TblAdTagVo tbladTagThree : tbladTag.getChildList()) {
                        if (mediaTagsSet.contains(tbladTagThree.getCode().toString())) continue;
                        return false;
                    }
                    continue;
                }
                if (mediaTagsSet.contains(tbladTag.getCode().toString())) continue;
                return false;
            }
            if (tbladTag.getId().intValue() != parentId.intValue() || tbladTag.getChildList().size() <= 0) continue;
            if (tbladTag.getChildList().size() == 1 && !mediaTagsSet.contains(tbladTag.getCode().toString())) {
                return false;
            }
            for (TblAdTagVo tbladTagThree : tbladTag.getChildList()) {
                if (mediaTagsSet.contains(tbladTagThree.getCode().toString())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public List<TblAdTagVo> findAllClassTag() {
        List tblAdTagVos = this.tblAdTagMapperExt.findAllClassTag();
        return tblAdTagVos;
    }
}

