/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.utils;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.cdn.model.v20180510.AddCdnDomainRequest;
import com.aliyuncs.cdn.model.v20180510.AddCdnDomainResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.bxm.adsmanager.configures.DIYSiteConfiguration;
import com.bxm.adsmanager.utils.DingtalkMsgUtil;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddCdnDomainUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddCdnDomainUtils.class);
    private static final String DING_TALK_URL = "https://oapi.dingtalk.com/robot/send?access_token=75624edea098dd6abe970b50cf4a37f02caecb83cfcc13fd878b7f654b52b2ea";

    public static boolean addDomain(String domain, DIYSiteConfiguration diySiteConfiguration) {
        DefaultProfile profile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)diySiteConfiguration.getCdnAccessKeyID(), (String)diySiteConfiguration.getCdnAccessKeySecret());
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        AddCdnDomainRequest request = new AddCdnDomainRequest();
        request.setDomainName(domain);
        request.setCdnType("web");
        request.setSources("[{\"content\":\"" + diySiteConfiguration.getSourcesContent() + "\",\"type\":\"" + diySiteConfiguration.getSourcesType() + "\",\"priority\":\"20\",\"port\":" + diySiteConfiguration.getSourcesPort() + ",\"weight\":\"100\"}]");
        try {
            AddCdnDomainResponse response = (AddCdnDomainResponse)client.getAcsResponse((AcsRequest)request);
            LOGGER.info("aliyun cdn add domain:" + domain);
        }
        catch (ServerException e) {
            DingtalkMsgUtil.sendMsg(DING_TALK_URL, "\u589e\u52a0\u963f\u91cccdn\u57df\u540d\u62a5\u9519\uff1a\u52a0\u901f\u57df\u540d\uff1a" + domain, false, Collections.emptyList());
            LOGGER.error("addDomain  ServerException ", (Throwable)e);
            return false;
        }
        catch (ClientException e) {
            if (null != e.getMessage() && e.getMessage().contains("DomainAlreadyExist")) {
                return true;
            }
            DingtalkMsgUtil.sendMsg(DING_TALK_URL, "\u589e\u52a0\u963f\u91cccdn\u57df\u540d\u62a5\u9519\uff1a\u52a0\u901f\u57df\u540d\uff1a" + domain, false, Collections.emptyList());
            LOGGER.error("addDomain  ClientException ", (Throwable)e);
            return false;
        }
        return true;
    }
}

