/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.utils;

import com.bxm.adsmanager.ecxeption.BusinessException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import jxl.Sheet;
import jxl.Workbook;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class CouponCodeFileUploadUtil {
    public static Set<String> upload(HttpServletRequest request) throws Exception {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Iterator iterator = multipartRequest.getFileNames();
        if (!iterator.hasNext()) {
            throw new BusinessException("\u6ca1\u6709\u6587\u4ef6");
        }
        Set<String> map = CouponCodeFileUploadUtil.handerFile(multipartRequest, iterator);
        return map;
    }

    public static List<Set<String>> batchUpload(HttpServletRequest request) throws Exception {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Iterator iterator = multipartRequest.getFileNames();
        if (!iterator.hasNext()) {
            throw new BusinessException("\u6ca1\u6709\u6587\u4ef6");
        }
        ArrayList<Set<String>> rtList = new ArrayList<Set<String>>();
        while (iterator.hasNext()) {
            Set<String> map = CouponCodeFileUploadUtil.handerFile(multipartRequest, iterator);
            rtList.add(map);
        }
        return rtList;
    }

    private static Set<String> handerFile(MultipartHttpServletRequest multipartRequest, Iterator<String> iterator) throws Exception {
        MultipartFile file = multipartRequest.getFile(iterator.next());
        String fileName = file.getOriginalFilename();
        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
        if (("txt".equalsIgnoreCase(suffix) || "xls".equalsIgnoreCase(suffix)) == Boolean.FALSE) {
            throw new BusinessException("\u53ea\u80fd\u4e0a\u4f20txt\u6216xls\u683c\u5f0f\u7684\u6587\u4ef6\u3002");
        }
        Set<String> codeSet = null;
        codeSet = "txt".equalsIgnoreCase(suffix) ? CouponCodeFileUploadUtil.readCopuonCodeByTxt(file.getInputStream(), "UTF-8") : CouponCodeFileUploadUtil.readCouponCodeByExcel(file.getInputStream());
        return codeSet;
    }

    public static void main(String[] args) throws Exception {
        CouponCodeFileUploadUtil.readCouponCodeByExcel(new FileInputStream("/Users/zhengwangeng/Downloads/123.xls"));
    }

    public static Set<String> readCouponCodeByExcel(InputStream inputStream) throws Exception {
        HashSet<String> codeSet = new HashSet<String>();
        try {
            Workbook workbook = Workbook.getWorkbook((InputStream)inputStream);
            Sheet sheet = workbook.getSheet(0);
            int sheetRows = sheet.getRows();
            int sheetColumns = sheet.getColumns();
            sheetColumns = 1;
            for (int i = 1; i < sheetRows; ++i) {
                for (int j = 0; j < sheetColumns; ++j) {
                    codeSet.add(sheet.getCell(j, i).getContents());
                }
            }
            workbook.close();
            inputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\u8bfb\u53d6\u7968\u5238\u7801Excel\u6587\u4ef6\u5931\u8d25\u3002");
        }
        return codeSet;
    }

    public static Set<String> readCopuonCodeByTxt(InputStream in, String charset) throws Exception {
        if (charset == null) {
            charset = "UTF-8";
        }
        HashSet<String> codeSet = new HashSet<String>();
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            inputStreamReader = new InputStreamReader(in, charset);
            bufferedReader = new BufferedReader(inputStreamReader);
            StringBuffer sb = new StringBuffer();
            String code = null;
            while ((code = bufferedReader.readLine()) != null) {
                sb.append(code);
                codeSet.add(code);
            }
        }
        catch (Exception e) {
            throw new Exception("\u8bfb\u53d6\u7968\u5238\u7801Txt\u6587\u4ef6\u5931\u8d25\u3002", e);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (Exception exception) {}
        }
        return codeSet;
    }
}

