/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.utils;

import com.bxm.util.StringUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class DateParkUtil {
    public static Double getArpuOrEcpm(Double income, Integer number) {
        if (number == null || number == 0 || income == null) {
            return 0.0;
        }
        DecimalFormat df = new DecimalFormat("#.0000");
        String sArpu = df.format(income / (double)number.intValue());
        return Double.parseDouble(sArpu);
    }

    public static Double getArpuOrEcpm(String income, Integer number) {
        if (number == null || number == 0 || income == null) {
            return 0.0;
        }
        DecimalFormat df = new DecimalFormat("#.0000");
        Integer aIncome = Integer.parseInt(income);
        String sarpu = df.format((double)aIncome.intValue() / (double)number.intValue());
        return Double.parseDouble(sarpu);
    }

    public static String getNextDate(String dateTime) {
        return DateParkUtil.getDate(dateTime, 1);
    }

    public static String getPreDate(String dateTime) {
        return DateParkUtil.getDate(dateTime, -1);
    }

    public static String getDate(String dateTime, Integer amount) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        GregorianCalendar calendar = new GregorianCalendar();
        try {
            calendar.setTime(sdf.parse(dateTime));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        ((Calendar)calendar).add(5, amount);
        return sdf.format(calendar.getTime());
    }

    public static String dealChange(BigDecimal pre, BigDecimal now) {
        if (now == null || pre == null || StringUtil.isEmpty((CharSequence)now.toString()) || StringUtil.isEmpty((CharSequence)pre.toString()) || Integer.valueOf(0).doubleValue() == pre.doubleValue()) {
            return "-";
        }
        return DateParkUtil.formatDouble((now.doubleValue() - pre.doubleValue()) * (double)Integer.valueOf(100).intValue() / pre.doubleValue()) + "%";
    }

    public static Double dealChangeDouble(BigDecimal pre, BigDecimal now) {
        if (now == null || pre == null || StringUtil.isEmpty((CharSequence)now.toString()) || StringUtil.isEmpty((CharSequence)pre.toString()) || Integer.valueOf(0).doubleValue() == pre.doubleValue()) {
            return null;
        }
        return Double.valueOf(DateParkUtil.formatDouble((now.doubleValue() - pre.doubleValue()) * (double)Integer.valueOf(100).intValue() / pre.doubleValue()));
    }

    public static Double dealChangeDouble(Double pre, BigDecimal now) {
        if (now == null || pre == null || StringUtil.isEmpty((CharSequence)now.toString()) || StringUtil.isEmpty((CharSequence)pre.toString()) || Integer.valueOf(0).doubleValue() == pre.doubleValue()) {
            return null;
        }
        return Double.valueOf(DateParkUtil.formatDouble((now.doubleValue() - pre) * (double)Integer.valueOf(100).intValue() / pre));
    }

    public static String dealChange(Double pre, Double now) {
        if (now == null || pre == null || StringUtil.isEmpty((CharSequence)now.toString()) || StringUtil.isEmpty((CharSequence)pre.toString()) || Integer.valueOf(0).doubleValue() == pre.doubleValue()) {
            return "-";
        }
        return DateParkUtil.formatDouble((now - pre) * 100.0 / pre);
    }

    public static String dealChange(Integer pre, Integer now) {
        if (now == null || pre == null || StringUtil.isEmpty((CharSequence)now.toString()) || StringUtil.isEmpty((CharSequence)pre.toString()) || "0".equals(pre)) {
            return "-";
        }
        return DateParkUtil.formatDouble((double)((now - pre) * 100) / (double)pre.intValue()) + "%";
    }

    public static String formatDouble(Double d) {
        return DateParkUtil.formatDouble(d, "#.00");
    }

    public static String formatDouble(Double d, String fomat) {
        DecimalFormat df = new DecimalFormat(fomat);
        String rs = df.format(d);
        if (rs.indexOf("-") != Integer.valueOf(-1).intValue()) {
            return rs.indexOf(".") == Integer.valueOf(1).intValue() ? rs.replaceFirst("-", "-0") : rs;
        }
        return rs.indexOf(".") == Integer.valueOf(0).intValue() ? "-0" + rs : rs;
    }
}

