/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.utils;

import com.bxm.datapark.facade.positiontest.MongoConstant;
import com.bxm.util.DateUtil;
import com.bxm.warcar.utils.DateHelper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DateUtils {
    public static Set<String> getDailyBetweenDate(Date beginDate, Date endDate) {
        HashSet<String> lDate = new HashSet<String>();
        lDate.add(DateUtil.dateTo8String1((Date)beginDate));
        Calendar cal = Calendar.getInstance();
        cal.setTime(beginDate);
        boolean bContinue = true;
        while (bContinue) {
            cal.add(5, 1);
            if (!endDate.after(cal.getTime())) break;
            lDate.add(DateUtil.dateTo8String1((Date)cal.getTime()));
        }
        lDate.add(DateUtil.dateTo8String1((Date)endDate));
        return lDate;
    }

    public static List<String> validatedDateOverlap(List<String> list, final String split, String dateFormat) {
        if ("HH".equals(dateFormat) || "SSS".equals(dateFormat)) {
            Collections.sort(list, new Comparator<String>(){

                @Override
                public int compare(String v1, String v2) {
                    String[] split1 = v1.split(split);
                    String[] split2 = v2.split(split);
                    return Integer.valueOf(split1[0]).compareTo(Integer.valueOf(split2[0]));
                }
            });
        }
        ArrayList<String> errorList = new ArrayList<String>();
        SimpleDateFormat formater = new SimpleDateFormat(dateFormat);
        try {
            for (int i = 0; i < list.size(); ++i) {
                String[] d1 = list.get(i).split(split);
                Date startdate1 = formater.parse(d1[0]);
                Date enddate1 = formater.parse(d1[1]);
                for (int j = i + 1; j < list.size(); ++j) {
                    String[] d2 = list.get(j).split(split);
                    Date startdate2 = formater.parse(d2[0]);
                    Date enddate2 = formater.parse(d2[1]);
                    if (!startdate2.before(startdate1)) {
                        if (startdate2.equals(enddate1) || startdate2.after(enddate1)) continue;
                        errorList.add(list.get(i) + " \u4e0e " + list.get(j) + " \u91cd\u5408\n");
                        continue;
                    }
                    if (enddate2.before(startdate1)) continue;
                    errorList.add(list.get(i) + " \u4e0e " + list.get(j) + " \u91cd\u5408\n");
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return errorList;
    }

    private static void testHs() {
        ArrayList<String> listYmd = new ArrayList<String>();
        listYmd.add("1#2");
        listYmd.add("0#1");
        listYmd.add("8#9");
        listYmd.add("20#24");
        listYmd.add("19#20");
        List<String> errorList = DateUtils.validatedDateOverlap(listYmd, "#", "HH");
        if (CollectionUtils.isNotEmpty(errorList)) {
            System.out.println(errorList);
        }
    }

    public static String getNextDate(String dateTime) {
        return DateUtils.getDate(dateTime, MongoConstant.ONE);
    }

    public static String getPreDate(String dateTime) {
        return DateUtils.getDate(dateTime, MongoConstant.BAR_ONE);
    }

    public static String getDate(String dateTime, Integer amount) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        GregorianCalendar calendar = new GregorianCalendar();
        try {
            calendar.setTime(sdf.parse(dateTime));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        ((Calendar)calendar).add(5, amount);
        return sdf.format(calendar.getTime());
    }

    public static Set<String> getDailyBetweenDate2(Date beginDate, Date endDate) {
        TreeSet<String> lDate = new TreeSet<String>();
        lDate.add(DateUtil.dateTo8String((Date)beginDate));
        Calendar cal = Calendar.getInstance();
        cal.setTime(beginDate);
        boolean bContinue = true;
        while (bContinue) {
            cal.add(5, 1);
            if (!endDate.after(cal.getTime())) break;
            lDate.add(DateUtil.dateTo8String((Date)cal.getTime()));
        }
        lDate.add(DateUtil.dateTo8String((Date)endDate));
        return lDate;
    }

    public static String getStartDayOfMonthByDate(String date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.StringToDate((String)date));
        calendar.set(5, calendar.getActualMinimum(5));
        return DateUtil.dateTo8String((Date)calendar.getTime());
    }

    public static String getEndDayOfMonthByDate(String date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.StringToDate((String)date));
        int day = calendar.getActualMaximum(5);
        calendar.set(5, day);
        return DateUtil.dateTo8String((Date)calendar.getTime());
    }

    public static String getLastMonthStartDay(String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            date = DateHelper.format((String)"yyyy-MM-dd");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.StringToDate((String)date));
        calendar.add(2, -1);
        calendar.set(5, calendar.getActualMinimum(5));
        return DateUtil.dateTo8String((Date)calendar.getTime());
    }
}

