/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.utils;

import com.bxm.util.StringUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class DoubleUtil {
    public static Double formatDouble(String num1, String num2) {
        if (StringUtils.isBlank((String)num1) || StringUtils.isBlank((String)num2)) {
            return null;
        }
        if (!StringUtil.isPositiveNumber((String)num1) || !StringUtil.isPositiveNumber((String)num2)) {
            return null;
        }
        BigDecimal b1 = new BigDecimal(Double.valueOf(num1));
        BigDecimal b2 = new BigDecimal(Double.valueOf(num2));
        double num = 0.0;
        if (b2.compareTo(new BigDecimal(BigInteger.ZERO)) != 0) {
            num = b1.divide(b2, 4, 1).multiply(new BigDecimal(100)).doubleValue();
        }
        return num;
    }

    public static Double doubleSum(Double num1, Double num2) {
        BigDecimal b1 = new BigDecimal(num1.toString());
        BigDecimal b2 = new BigDecimal(num2.toString());
        return new Double(b1.add(b2).doubleValue());
    }

    public static Double div(Double v1, Double v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(v1.toString());
        BigDecimal b2 = new BigDecimal(v2.toString());
        return b1.divide(b2, scale, 4).doubleValue();
    }

    public static int divide1000(Integer v1) {
        if (null == v1) {
            return 0;
        }
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal("1000");
        return b1.divide(b2, 4, 4).intValue();
    }

    public static double savePoint(double data, int digit) {
        BigDecimal bg = new BigDecimal(data).setScale(digit, RoundingMode.HALF_UP);
        return bg.doubleValue();
    }

    public static String doubleToPercent(Double num) {
        if (Objects.isNull(num)) {
            return "0.00%";
        }
        DecimalFormat df = new DecimalFormat("0.00%");
        return df.format(num);
    }
}

