/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class ListOrderUtils {
    public static <T> void sortList(List<T> list, final String sortField, final String sortMode) {
        if (list == null || list.size() < 2) {
            return;
        }
        Collections.sort(list, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                try {
                    boolean ASC_order;
                    Class<?> clazz = o1.getClass();
                    Field field = clazz.getDeclaredField(sortField);
                    field.setAccessible(true);
                    String typeName = field.getType().getName().toLowerCase();
                    Object v1 = field.get(o1);
                    Object v2 = field.get(o2);
                    boolean bl = ASC_order = sortMode == null || "ASC".equalsIgnoreCase(sortMode);
                    if (typeName.endsWith("string")) {
                        String value1 = v1.toString();
                        String value2 = v2.toString();
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);
                    }
                    if (typeName.endsWith("short")) {
                        Short value1 = Short.parseShort(v1.toString());
                        Short value2 = Short.parseShort(v2.toString());
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);
                    }
                    if (typeName.endsWith("byte")) {
                        Byte value1 = Byte.parseByte(v1.toString());
                        Byte value2 = Byte.parseByte(v2.toString());
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);
                    }
                    if (typeName.endsWith("char")) {
                        Integer value1 = v1.toString().charAt(0);
                        Integer value2 = v2.toString().charAt(0);
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);
                    }
                    if (typeName.endsWith("int") || typeName.endsWith("integer")) {
                        Integer value1 = Integer.parseInt(v1.toString());
                        Integer value2 = Integer.parseInt(v2.toString());
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);
                    }
                    if (typeName.endsWith("long")) {
                        Long value1 = Long.parseLong(v1.toString());
                        Long value2 = Long.parseLong(v2.toString());
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);
                    }
                    if (typeName.endsWith("float")) {
                        Float value1 = Float.valueOf(Float.parseFloat(v1.toString()));
                        Float value2 = Float.valueOf(Float.parseFloat(v2.toString()));
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);
                    }
                    if (typeName.endsWith("double")) {
                        Double value1 = Double.parseDouble(v1.toString());
                        Double value2 = Double.parseDouble(v2.toString());
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);
                    }
                    if (typeName.endsWith("boolean")) {
                        Boolean value1 = Boolean.parseBoolean(v1.toString());
                        Boolean value2 = Boolean.parseBoolean(v2.toString());
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);
                    }
                    if (typeName.endsWith("date")) {
                        Date value1 = (Date)v1;
                        Date value2 = (Date)v2;
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);
                    }
                    if (typeName.endsWith("timestamp")) {
                        Timestamp value1 = (Timestamp)v1;
                        Timestamp value2 = (Timestamp)v2;
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);
                    }
                    Method method = field.getType().getDeclaredMethod("compareTo", field.getType());
                    method.setAccessible(true);
                    int result = (Integer)method.invoke(v1, v2);
                    return ASC_order ? result : result * -1;
                }
                catch (Exception e) {
                    String err = e.getLocalizedMessage();
                    System.out.println(err);
                    e.printStackTrace();
                    return 0;
                }
            }
        });
    }
}

