/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Objects;

public class LocalDateUtils {
    public static LocalDate coverByString6Date(String dateTime) {
        return LocalDate.parse(dateTime, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    public static String coverDateByString6(LocalDate dateTime) {
        return dateTime.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
    }

    public static String coverDateByLocalTime6(LocalTime dateTime) {
        return dateTime.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
    }

    public static LocalTime coverTimeByString6Date(String dateTime) {
        return LocalTime.parse(dateTime, DateTimeFormatter.ofPattern("HH:mm:ss"));
    }

    public static LocalDateTime toTime(long millis) {
        return LocalDateUtils.toTime(new Date(millis));
    }

    public static LocalDateTime toTime(Date date) {
        if (Objects.isNull(date)) {
            return null;
        }
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        return instant.atZone(zoneId).toLocalDateTime();
    }

    public static LocalDate to(Date date) {
        if (Objects.isNull(date)) {
            return null;
        }
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        return instant.atZone(zoneId).toLocalDate();
    }

    public static Date to(LocalDate localDate) {
        if (Objects.isNull(localDate)) {
            return null;
        }
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = localDate.atStartOfDay(zoneId);
        return Date.from(zdt.toInstant());
    }

    public static String format(LocalDateTime time, String pattern) {
        return time.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String format(String pattern) {
        return LocalDateUtils.format(LocalDateTime.now(), pattern);
    }

    public static long difference(LocalDateTime first, LocalDateTime second) {
        if (first == null || second == null) {
            return -1L;
        }
        return first.toEpochSecond(ZoneOffset.of("+8")) - second.toEpochSecond(ZoneOffset.of("+8"));
    }

    public static void main(String[] args) {
        LocalDateTime time = LocalDateTime.now();
        String date = LocalDateUtils.format(time, "yyyy-MM-dd");
        String hms = LocalDateUtils.format(time, "HH:mm:ss");
        System.out.println(LocalDateUtils.coverDateByLocalTime6(LocalTime.now()));
    }
}

