/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.utils;

import java.io.Serializable;

public class Page<T>
implements Serializable {
    public static final int DEFAULT_PAGE_INDEX = 1;
    public static final int DEFAULT_PAGE_SIZE = 10;
    private static final long serialVersionUID = 1L;
    private Integer pageSize;
    private T data;
    private int totalPage;
    private Integer pageIndex;
    private Integer totalNum;
    private boolean hasNextPage = false;
    private boolean hasPreviousPage = false;

    public Page(Integer pageSize, Integer pageIndex, Integer totalNum, T data) {
        if (pageSize == null || pageSize == 0) {
            pageSize = 10;
        }
        if (pageIndex == null || pageIndex == 0) {
            pageIndex = 1;
        }
        if (totalNum == null || totalNum == 0) {
            totalNum = 0;
        }
        this.pageSize = pageSize;
        this.data = data;
        this.totalPage = totalNum % pageSize == 0 ? totalNum / pageSize : totalNum / pageSize + 1;
        this.pageIndex = pageIndex == 0 ? 1 : pageIndex;
        this.totalNum = totalNum;
        this.hasNextPage = this.totalPage > 1 && this.totalPage > this.pageIndex;
        this.hasPreviousPage = this.pageIndex > 1;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public Integer getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public Integer getTotalNum() {
        return this.totalNum;
    }

    public void setTotalNum(Integer totalNum) {
        this.totalNum = totalNum;
    }

    public boolean isHasNextPage() {
        return this.hasNextPage;
    }

    public void setHasNextPage(boolean hasNextPage) {
        this.hasNextPage = hasNextPage;
    }

    public boolean isHasPreviousPage() {
        return this.hasPreviousPage;
    }

    public void setHasPreviousPage(boolean hasPreviousPage) {
        this.hasPreviousPage = hasPreviousPage;
    }

    public static long getSerialversionuid() {
        return 1L;
    }
}

