/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.utils;

import com.bxm.util.dto.ErrorCode;
import com.bxm.util.dto.ResultModel;
import java.io.Serializable;

public final class ResultModelFactory {
    private ResultModelFactory() {
    }

    public static <T extends Serializable> ResultModel<T> FAIL() {
        return ResultModelFactory.FAIL(ErrorCode.SERVER_ERROR.getErrorCode(), ErrorCode.SERVER_ERROR.getErrorMessage());
    }

    public static <T extends Serializable> ResultModel<T> FAIL500(String message) {
        return ResultModelFactory.FAIL(ErrorCode.SERVER_ERROR.getErrorCode(), message);
    }

    public static <T extends Serializable> ResultModel<T> FAIL400(String message) {
        return ResultModelFactory.FAIL(ErrorCode.ILLEGAL_PARAMS.getErrorCode(), message);
    }

    public static <T extends Serializable> ResultModel<T> FAIL(String errCode, String message) {
        ResultModel rs = ResultModel.newInstance();
        rs.setSuccessed(false);
        rs.setErrorCode(errCode);
        rs.setErrorDesc(message);
        return rs;
    }

    public static <T extends Serializable> ResultModel<T> SUCCESS() {
        return ResultModelFactory.SUCCESS(null);
    }

    public static <T extends Serializable> ResultModel<T> SUCCESS(T returning) {
        ResultModel rs = ResultModel.newInstance();
        rs.setSuccessed(true);
        if (null != returning) {
            rs.setReturnValue(returning);
        }
        return rs;
    }
}

