/*
 * Decompiled with CFR 0.152.
 */
package com.tinify;

import com.tinify.AccountException;
import com.tinify.ClientException;
import com.tinify.ServerException;

public class Exception
extends RuntimeException {
    int status = 0;

    public static Exception create(String message, String type, int status) {
        if (status == 401 || status == 429) {
            return new AccountException(message, type, status);
        }
        if (status >= 400 && status <= 499) {
            return new ClientException(message, type, status);
        }
        if (status >= 500 && status <= 599) {
            return new ServerException(message, type, status);
        }
        return new Exception(message, type, status);
    }

    public Exception() {
    }

    public Exception(Throwable t) {
        super(t);
    }

    public Exception(String message) {
        super(message);
    }

    public Exception(String message, Throwable t) {
        super(message, t);
    }

    public Exception(String message, String type, int status) {
        super(message + " (HTTP " + status + "/" + type + ")");
        this.status = status;
    }

    public static class Data {
        private String message;
        private String error;

        public void setMessage(String message) {
            this.message = message;
        }

        public final String getMessage() {
            return this.message;
        }

        public void setError(String error) {
            this.error = error;
        }

        public final String getError() {
            return this.error;
        }
    }
}

