/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.integration.adsmedia.appentrance;

import com.bxm.acl.facade.model.UserRo;
import com.bxm.adsmanager.integration.acl.AclUserIntegration;
import com.bxm.adsmanager.integration.adsmedia.appentrance.service.AppEntranceFacadeService;
import com.bxm.adsmanager.integration.utils.FacadePageInfoUtil;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAssetsTemplateIdAndNumVo;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAuditVO;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceCountByAppKeyVO;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceMinOnlineTimeByAppKeyVO;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceUrlVO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppAdPositionDTO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceByMinOnlineTimeParamDTO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import com.bxm.adsmedia.facade.model.appentrance.UpdateAppEntranceDTO;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NewAppEntranceFacadeIntegration {
    private static final Logger log = LoggerFactory.getLogger(NewAppEntranceFacadeIntegration.class);
    @Autowired
    private AppEntranceFacadeService appEntranceFacadeService;
    @Autowired
    private AclUserIntegration aclUserIntegration;
    public static final String COMMA = ",";

    public AppEntranceAdRO findByPositionId(String positionId) {
        try {
            ResultModel<AppEntranceAdRO> resultModel = this.appEntranceFacadeService.findByPositionId(positionId);
            if (resultModel.isSuccessed()) {
                return (AppEntranceAdRO)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u6839\u636epositionId\u67e5\u8be2\u5e7f\u544a\u4f4d\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u6839\u636epositionId\u67e5\u8be2\u5e7f\u544a\u4f4d\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }

    public List<AppEntranceAdRO> findListByPositionIds(List<String> positionIds) {
        if (CollectionUtils.isEmpty(positionIds)) {
            return Collections.emptyList();
        }
        try {
            String positionIdsStr = Joiner.on((String)COMMA).skipNulls().join(positionIds);
            ResultModel<List<AppEntranceAdRO>> resultModel = this.appEntranceFacadeService.findListByPositionIds(positionIdsStr);
            if (resultModel.isSuccessed()) {
                return (List)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u6839\u636epositionIds\u96c6\u5408\u6279\u91cf\u67e5\u8be2\u5e7f\u544a\u4f4d\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u6839\u636epositionIds\u96c6\u5408\u6279\u91cf\u67e5\u8be2\u5e7f\u544a\u4f4d\u5f02\u5e38", (Throwable)e);
        }
        return Collections.emptyList();
    }

    public List<AppEntranceAdRO> findByFuzzyProviderAlias(String providerAlias) {
        if (StringUtils.isBlank((CharSequence)providerAlias)) {
            return Collections.emptyList();
        }
        try {
            ResultModel<List<AppEntranceAdRO>> resultModel = this.appEntranceFacadeService.findByFuzzyProviderAlias(providerAlias);
            if (resultModel.isSuccessed()) {
                return (List)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u6839\u636eproviderName\u67e5\u8be2\u5e7f\u544a\u4f4d\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u6839\u636eproviderName\u67e5\u8be2\u5e7f\u544a\u4f4d\u5f02\u5e38", (Throwable)e);
        }
        return Collections.emptyList();
    }

    public List<AppEntranceAdRO> findByIds(List<Long> appEntranceIds) {
        if (CollectionUtils.isEmpty(appEntranceIds)) {
            return Collections.emptyList();
        }
        try {
            String idsStr = Joiner.on((String)COMMA).skipNulls().join(appEntranceIds);
            ResultModel<List<AppEntranceAdRO>> resultModel = this.appEntranceFacadeService.findByIds(idsStr);
            if (resultModel.isSuccessed()) {
                return (List)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u6839\u636e\u4e3b\u952e\u96c6\u5408\u67e5\u8be2\u5e7f\u544a\u4f4d\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u4e3b\u952e\u96c6\u5408\u67e5\u8be2\u5e7f\u544a\u4f4d\u5f02\u5e38", (Throwable)e);
        }
        return Collections.emptyList();
    }

    public PageInfo<AppEntranceAdRO> getPage(QueryAppEntranceParamDTO dto) {
        try {
            ResultModel<PageInfo<AppEntranceAdRO>> resultModel = this.appEntranceFacadeService.getPage(dto);
            if (resultModel.isSuccessed()) {
                return (PageInfo)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u67e5\u8be2\u5e7f\u544a\u4f4d\u5217\u8868\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5f00\u53d1\u8005\u540e\u53f0\u7684\u5e7f\u544a\u4f4d\u5217\u8868\u5f02\u5e38", (Throwable)e);
        }
        return FacadePageInfoUtil.noneDataPage();
    }

    public List<AppEntranceAdRO> getAllList(QueryAppEntranceParamDTO dto) {
        dto.setPageNum(dto.getPageNum());
        dto.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        return this.getPage(dto).getList();
    }

    public Map<String, String> getAppEntranceCodeName() {
        List<AppEntranceAdRO> appEntranceAdROS = this.getAllList(new QueryAppEntranceParamDTO());
        if (CollectionUtils.isEmpty(appEntranceAdROS)) {
            return Collections.emptyMap();
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)appEntranceAdROS.size());
        for (AppEntranceAdRO appEntranceAdRO : appEntranceAdROS) {
            map.put(String.format("%06d", appEntranceAdRO.getCode()) + "-" + appEntranceAdRO.getAppEntranceId(), appEntranceAdRO.getPositionId());
        }
        return map;
    }

    public Map<String, String> getAppEntranceCodeMap(QueryAppEntranceParamDTO paramDTO) {
        List<AppEntranceAdRO> appEntranceAdROS = this.getAllList(paramDTO);
        if (CollectionUtils.isEmpty(appEntranceAdROS)) {
            return Collections.emptyMap();
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)appEntranceAdROS.size());
        for (AppEntranceAdRO appEntranceAdRO : appEntranceAdROS) {
            map.put(appEntranceAdRO.getPositionId(), String.format("%06d", appEntranceAdRO.getCode()) + "-" + appEntranceAdRO.getAppEntranceId());
        }
        return map;
    }

    public List<String> getAllPositionIds(QueryAppEntranceParamDTO dto) {
        try {
            ResultModel<List<String>> resultModel = this.appEntranceFacadeService.getAllPositionIds(dto);
            if (resultModel.isSuccessed()) {
                return (List)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u6761\u4ef6\u83b7\u53d6\u6240\u6709\u7684\u5e7f\u544a\u4f4dID\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u6761\u4ef6\u83b7\u53d6\u6240\u6709\u7684\u5e7f\u544a\u4f4dID\u5f02\u5e38", (Throwable)e);
        }
        return Collections.emptyList();
    }

    public PageInfo<AppEntranceAuditVO> getAuditPage(String keywords, Byte status, Long providerId, String mjCode, Integer areaType, Integer pageNum, Integer pageSize) {
        try {
            ResultModel<PageInfo<AppEntranceAuditVO>> resultModel = this.appEntranceFacadeService.getAuditPage(keywords, status, providerId, mjCode, areaType, pageNum, pageSize);
            if (resultModel.isSuccessed()) {
                PageInfo pageInfo = (PageInfo)resultModel.getReturnValue();
                for (AppEntranceAuditVO mauditVO : pageInfo.getList()) {
                    if (!StringUtils.isNotBlank((CharSequence)mauditVO.getMjCode())) continue;
                    UserRo userRo = this.aclUserIntegration.queryUserByUsername(mauditVO.getMjCode());
                    mauditVO.setMjName(userRo.getName());
                }
                return pageInfo;
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u67e5\u8be2\u5ba1\u6838\u9875\u9762\u5e7f\u544a\u4f4d\u5217\u8868\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5ba1\u6838\u9875\u9762\u5e7f\u544a\u4f4d\u5217\u8868\u5f02\u5e38", (Throwable)e);
        }
        return FacadePageInfoUtil.noneDataPage();
    }

    public List<Long> batchAudit(String idsStr, Boolean auditPass, Boolean isMJ, String refuseReason, String reviewRefuseIds, String modifier) {
        try {
            ResultModel<List<Long>> resultModel = this.appEntranceFacadeService.batchAudit(idsStr, auditPass, isMJ, refuseReason, reviewRefuseIds, modifier);
            if (resultModel.isSuccessed()) {
                return (List)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u6279\u91cf\u5ba1\u6838\u5e7f\u544a\u4f4d\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u5ba1\u6838\u5e7f\u544a\u4f4d\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }

    public Boolean positionSwitch(String positionId, Boolean closeFlag, String modifier) {
        try {
            ResultModel<Boolean> resultModel = this.appEntranceFacadeService.positionSwitch(positionId, closeFlag, modifier);
            if (resultModel.isSuccessed()) {
                return (Boolean)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u5f00\u542f/\u5173\u95ed\u5e7f\u544a\u4f4d\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u5f00\u542f/\u5173\u95ed\u5e7f\u544a\u4f4d\u5f02\u5e38", (Throwable)e);
        }
        return false;
    }

    public Boolean updateByPositionId(UpdateAppEntranceDTO dto) {
        try {
            ResultModel<Boolean> resultModel = this.appEntranceFacadeService.updateByPositionId(dto);
            if (resultModel.isSuccessed()) {
                return (Boolean)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u4fee\u6539\u5e7f\u544a\u4f4d\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5e7f\u544a\u4f4d\u5f02\u5e38", (Throwable)e);
        }
        return false;
    }

    public Integer queryDockMethod(String appKey, String appEntranceId) {
        try {
            ResultModel<Integer> result = this.appEntranceFacadeService.queryDockMethod(appKey, appEntranceId);
            return result == null ? null : (Integer)result.getReturnValue();
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42app\u7cfb\u7edf\u67e5\u8be2dockMethod\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            return null;
        }
    }

    public List<AppEntranceAdRO> getPositionList(QueryAppAdPositionDTO dto) {
        try {
            ResultModel<List<AppEntranceAdRO>> resultModel = this.appEntranceFacadeService.getPositionList(dto);
            if (resultModel.isSuccessed()) {
                return (List)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u67e5\u8be2\u5e7f\u544a\u4f4d\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5e7f\u544a\u4f4d\u5f02\u5e38", (Throwable)e);
        }
        return Collections.emptyList();
    }

    public List<AppEntranceCountByAppKeyVO> getAppEntranceCountGroupByAppKeys(List<String> appKeys) {
        if (CollectionUtils.isEmpty(appKeys)) {
            return Collections.emptyList();
        }
        try {
            ResultModel<List<AppEntranceCountByAppKeyVO>> resultModel = this.appEntranceFacadeService.getAppEntranceCountGroupByAppKeys(Joiner.on((String)COMMA).skipNulls().join(appKeys));
            if (resultModel.isSuccessed()) {
                return (List)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u6839\u636eAPP KEY\u96c6\u5408\u6279\u91cf\u67e5\u8be2\u5404\u4e2aappkey\u4e0b\u7684\u6240\u62e5\u6709\u7684\u5e7f\u544a\u4f4d\u4e2a\u6570 \u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u6839\u636eAPP KEY\u96c6\u5408\u6279\u91cf\u67e5\u8be2\u5404\u4e2aappkey\u4e0b\u7684\u6240\u62e5\u6709\u7684\u5e7f\u544a\u4f4d\u4e2a\u6570 \u5f02\u5e38", (Throwable)e);
        }
        return Collections.emptyList();
    }

    public List<AppEntranceMinOnlineTimeByAppKeyVO> getAppEntranceMinOnlineTimeGroupByAppKey(List<String> appKeys, String onlineBegin, String onlineEnd) {
        QueryAppEntranceByMinOnlineTimeParamDTO dto = new QueryAppEntranceByMinOnlineTimeParamDTO();
        dto.setAppKeys(appKeys);
        dto.setOnlineTimeStart(onlineBegin);
        dto.setOnlineTimeEnd(onlineEnd);
        try {
            ResultModel<List<AppEntranceMinOnlineTimeByAppKeyVO>> resultModel = this.appEntranceFacadeService.getAppEntranceMinOnlineTimeGroupByAppKey(dto);
            if (resultModel.isSuccessed()) {
                return (List)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u6839\u636eAPP KEY\u96c6\u5408\u6279\u91cf\u5206\u7ec4\u67e5\u8be2\u5404\u4e2aappkey\u4e0b\u7684\u5e7f\u544a\u4f4d\u7684\u6700\u65e9\u7684\u4e0a\u7ebf\u65f6\u95f4\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u6839\u636eAPP KEY\u96c6\u5408\u6279\u91cf\u5206\u7ec4\u67e5\u8be2\u5404\u4e2aappkey\u4e0b\u7684\u5e7f\u544a\u4f4d\u7684\u6700\u65e9\u7684\u4e0a\u7ebf\u65f6\u95f4\u5f02\u5e38", (Throwable)e);
        }
        return Collections.emptyList();
    }

    public Boolean updateMaterialType(String positionId, String materialType) {
        try {
            ResultModel<Boolean> resultModel = this.appEntranceFacadeService.updateMaterialType(positionId, materialType);
            if (resultModel.isSuccessed()) {
                return (Boolean)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u4fee\u6539\u5e7f\u544a\u4f4d\u5165\u53e3\u573a\u666f\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5e7f\u544a\u4f4d\u5165\u53e3\u573a\u666f\u5f02\u5e38", (Throwable)e);
        }
        return false;
    }

    public Boolean updateCouponsInfo(UpdateAppEntranceDTO dto) {
        try {
            ResultModel<Boolean> resultModel = this.appEntranceFacadeService.updateCouponsInfo(dto);
            if (resultModel.isSuccessed()) {
                return (Boolean)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u4fee\u6539\u5e7f\u544a\u4f4d\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5e7f\u544a\u4f4d\u5f02\u5e38", (Throwable)e);
        }
        return false;
    }

    public Boolean updatePutinTypeInfo(UpdateAppEntranceDTO dto) {
        try {
            ResultModel<Boolean> resultModel = this.appEntranceFacadeService.updatePutinTypeInfo(dto);
            if (resultModel.isSuccessed()) {
                return (Boolean)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u4fee\u6539\u5e7f\u544a\u4f4d\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5e7f\u544a\u4f4d\u5f02\u5e38", (Throwable)e);
        }
        return false;
    }

    public Boolean updateWechatMiniAppPutInfo(UpdateAppEntranceDTO dto) {
        try {
            ResultModel<Boolean> resultModel = this.appEntranceFacadeService.updateWechatMiniAppPutInfo(dto);
            if (resultModel.isSuccessed()) {
                return (Boolean)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u4fee\u6539\u5e7f\u544a\u4f4d\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5e7f\u544a\u4f4d\u5f02\u5e38", (Throwable)e);
        }
        return false;
    }

    public AppEntranceUrlVO getUrl(String positionId) {
        try {
            ResultModel<AppEntranceUrlVO> resultModel = this.appEntranceFacadeService.getUrl(positionId);
            if (resultModel.isSuccessed()) {
                return (AppEntranceUrlVO)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u83b7\u53d6\u5e7f\u544a\u4f4d\u94fe\u63a5\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5e7f\u544a\u4f4d\u94fe\u63a5\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }

    public Boolean updateCooperationTypeByAppKey(String appKey) {
        try {
            ResultModel<Boolean> resultModel = this.appEntranceFacadeService.updateCooperationTypeByAppKey(appKey);
            if (resultModel.isSuccessed()) {
                return (Boolean)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff01\u66f4\u65b0\u5408\u4f5c\u7c7b\u578b\u5931\u8d25-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u5408\u4f5c\u7c7b\u578b\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    public List<AppEntranceAssetsTemplateIdAndNumVo> getPositionNumByTemplateId(String assetsTemplateIds) {
        try {
            ResultModel<List<AppEntranceAssetsTemplateIdAndNumVo>> resultModel = this.appEntranceFacadeService.getPositionNumByTemplateId(assetsTemplateIds);
            if (resultModel.isSuccessed()) {
                return (List)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff01\u66f4\u65b0\u5408\u4f5c\u7c7b\u578b\u5931\u8d25-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u5408\u4f5c\u7c7b\u578b\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    public List<AppEntranceAdRO> getPageByPostioinIdOrName(String positionIdOrName) {
        QueryAppEntranceParamDTO paramDTO = new QueryAppEntranceParamDTO();
        paramDTO.setEntranceNameOrCode(positionIdOrName);
        paramDTO.setPageNum(Integer.valueOf(1));
        paramDTO.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        PageInfo<AppEntranceAdRO> page = this.getPage(paramDTO);
        List list = page.getList();
        return list;
    }
}

