/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.integration.adsmedia.cashapply;

import com.bxm.adsmanager.integration.acl.AclUserIntegration;
import com.bxm.adsmanager.integration.utils.FacadePageInfoUtil;
import com.bxm.adsmedia.facade.model.cashapplylog.CashApplyLogPageDto;
import com.bxm.adsmedia.facade.model.cashapplylog.CashApplyLogPageSearchDto;
import com.bxm.adsmedia.facade.service.CashApplyLogFacadeService;
import com.bxm.warcar.utils.response.ResultModel;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CashApplyLogFacadeIntegration {
    @Autowired
    private CashApplyLogFacadeService cashApplyLogFacadeService;
    @Autowired
    private AclUserIntegration aclUserIntegration;
    private static final Logger LOGGER = LoggerFactory.getLogger(CashApplyLogFacadeIntegration.class);

    public PageInfo<CashApplyLogPageDto> getCashApplyLogList(CashApplyLogPageSearchDto searchDto) {
        try {
            ResultModel resultModel = this.cashApplyLogFacadeService.getPageCashApplyLog(searchDto);
            if (resultModel.isSuccessed()) {
                this.changeMjAndBd((ResultModel<PageInfo<CashApplyLogPageDto>>)resultModel);
                return (PageInfo)resultModel.getReturnValue();
            }
            LOGGER.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u83b7\u53d6\u5f00\u53d1\u8005\u63d0\u73b0\u8bb0\u5f55\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5f00\u53d1\u8005\u63d0\u73b0\u8bb0\u5f55\u5f02\u5e38", (Throwable)e);
        }
        return FacadePageInfoUtil.noneDataPage();
    }

    private void changeMjAndBd(ResultModel<PageInfo<CashApplyLogPageDto>> resultModel) {
        List list;
        if (resultModel != null && resultModel.isSuccessed() && resultModel.getReturnValue() != null && CollectionUtils.isNotEmpty((Collection)(list = ((PageInfo)resultModel.getReturnValue()).getList()))) {
            Map<String, String> bdMaps = this.aclUserIntegration.queryUserByRoleCode("BD", false);
            Map<String, String> mjMaps = this.aclUserIntegration.queryUserByRoleCode("mj", false);
            for (CashApplyLogPageDto applyLog : list) {
                if (bdMaps != null) {
                    applyLog.setBdName(bdMaps.getOrDefault(applyLog.getBdCode(), ""));
                }
                if (mjMaps == null) continue;
                applyLog.setMjName(mjMaps.getOrDefault(applyLog.getMjCode(), ""));
            }
        }
    }
}

