/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.integration.adsmedia.media;

import com.bxm.acl.facade.model.UserRo;
import com.bxm.adsmanager.integration.acl.AclUserIntegration;
import com.bxm.adsmanager.integration.adsmedia.media.service.MediaFacadeService;
import com.bxm.adsmanager.integration.utils.FacadePageInfoUtil;
import com.bxm.adsmedia.facade.model.media.MediaAuditVO;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NewMediaFacadeIntegration {
    private static final Logger log = LoggerFactory.getLogger(NewMediaFacadeIntegration.class);
    @Autowired
    private MediaFacadeService mediaFacadeService;
    @Autowired
    private AclUserIntegration aclUserIntegration;

    public PageInfo<MediaAuditVO> getAuditPage(String companyName, String mediaName, String mjCode, Byte status, Long providerId, Integer areaType, Integer pageNum, Integer pageSize) {
        try {
            ResultModel<PageInfo<MediaAuditVO>> resultModel = this.mediaFacadeService.getAuditPage(companyName, mediaName, status, providerId, mjCode, areaType, pageNum, pageSize);
            if (resultModel.isSuccessed()) {
                PageInfo pageInfo = (PageInfo)resultModel.getReturnValue();
                for (MediaAuditVO auditVO : pageInfo.getList()) {
                    if (!StringUtils.isNotBlank((String)auditVO.getMjCode())) continue;
                    UserRo userRo = this.aclUserIntegration.queryUserByUsername(auditVO.getMjCode());
                    auditVO.setMjName(userRo.getName());
                }
                return pageInfo;
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u83b7\u53d6\u5a92\u4f53\u5ba1\u6838\u5217\u8868\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5a92\u4f53\u5ba1\u6838\u5217\u8868\u5f02\u5e38", (Throwable)e);
        }
        return FacadePageInfoUtil.noneDataPage();
    }

    public Boolean audit(Long id, Boolean auditPass, Boolean isMJ, String refuseReason, String reviewRefuseIds, String modifier) {
        try {
            ResultModel<Boolean> resultModel = this.mediaFacadeService.audit(id, auditPass, isMJ, refuseReason, reviewRefuseIds, modifier);
            if (resultModel.isSuccessed()) {
                return (Boolean)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u5ba1\u6838\u5a92\u4f53\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u5ba1\u6838\u5a92\u4f53\u5f02\u5e38", (Throwable)e);
        }
        return false;
    }

    public Boolean updateTags(Long id, String tags, String modifier) {
        try {
            ResultModel<Boolean> resultModel = this.mediaFacadeService.updateTags(id, tags, modifier);
            if (resultModel.isSuccessed()) {
                return (Boolean)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u4fee\u6539\u5a92\u4f53\u6807\u7b7e\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5a92\u4f53\u6807\u7b7e\u5f02\u5e38", (Throwable)e);
        }
        return false;
    }
}

