/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.integration.adsprod.service;

import com.bxm.adsprod.facade.advertiser.AdvertiserService;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketStatisticsService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.stereotype.Component;

@EnableFeignClients(value={"com.bxm.adsprod.facade"})
@Component
public class ProdPullerIntegration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProdPullerIntegration.class);
    private static final int DEFULT = 0;
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Resource
    private AdvertiserService advertiserService;
    @Resource
    private TicketStatisticsService ticketStatisticsService;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;

    public Long getBudgetOfToday(Long ticketId) {
        return this.ticketStatisticsService.getBudgetOfToday(BigInteger.valueOf(ticketId));
    }

    public Long getAdxBudgetOfToday(Long ticketId) {
        Integer adxBudgetOfDailyCount = this.fetchAdxBudgetOfDailyCount(String.valueOf(ticketId), DateHelper.format((String)"yyyyMMdd"));
        return (long)adxBudgetOfDailyCount;
    }

    public long getBudgetOfTimeline(BigInteger ticketId, int startHour, int endHour) throws IllegalArgumentException {
        return this.ticketStatisticsService.getBudgetOfTimeline(ticketId, startHour, endHour);
    }

    public Long getAdvertiserBalance(Long advertiserId) {
        return this.advertiserService.getAdvertiserBalance(BigInteger.valueOf(advertiserId));
    }

    public Long fetchBudgetOfDailyCount(String ticketId, String dateStr) {
        try {
            Long budgetOfDaily = (Long)this.fetcher.hfetch(TicketKeyGenerator.Statistics.getBudgetOfDaily((String)dateStr), ticketId, null, Long.class);
            return budgetOfDaily == null ? 0L : budgetOfDaily;
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u5f53\u5929\u7684\u65e5\u9884\u7b97\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public Integer fetchActivityCostOfDailyCount(String ticketId, String dateStr) {
        try {
            Integer budgetOfDaily = (Integer)this.fetcher.hfetch(TicketKeyGenerator.Statistics.getPanGuCostOfDaily((String)dateStr), ticketId, null, Integer.class);
            return budgetOfDaily == null ? 0 : budgetOfDaily;
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u5f53\u5929\u7684\u65e5\u9884\u7b97\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public Integer fetchAdxBudgetOfDailyCount(String ticketId, String dateStr) {
        try {
            Integer budgetOfDaily = (Integer)this.fetcher.hfetch(TicketKeyGenerator.Statistics.getAdxBudgetOfDaily((String)dateStr), ticketId, null, Integer.class);
            return budgetOfDaily == null ? 0 : budgetOfDaily;
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u5f53\u5929\u7684ADX\u65e5\u9884\u7b97\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public Integer fetchAdxBudgetOfDailyCountByPangu(String ticketId, String dateStr) {
        try {
            Integer budgetOfDaily = (Integer)this.fetcher.hfetch(TicketKeyGenerator.Statistics.getPanGuBudgetOfDaily((String)dateStr), ticketId, null, Integer.class);
            return budgetOfDaily == null ? 0 : budgetOfDaily;
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u5f53\u5929\u7684ADX\u65e5\u9884\u7b97\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public Integer fetchAssetsBudgetOfDailyCount(String assetsId, String dateStr) {
        try {
            Integer budgetOfDaily = (Integer)this.fetcher.hfetch(TicketKeyGenerator.Statistics.getAssetsBudgetOfDaily((String)dateStr), assetsId, null, Integer.class);
            return budgetOfDaily == null ? 0 : budgetOfDaily;
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u5f53\u5929\u7d20\u6750\u7684\u65e5\u9884\u7b97\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public Integer fetchOpenPvCount(String ticketId, String dateStr) {
        try {
            Integer budgetOfDaily = (Integer)this.fetcher.hfetch(TicketKeyGenerator.Statistics.getViewOfDaily((String)dateStr), ticketId, null, Integer.class);
            return budgetOfDaily == null ? 0 : budgetOfDaily;
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u5f53\u5929\u7684\u66dd\u5149\u91cf\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public Integer fetchClikePvCount(String ticketId, String dateStr) {
        try {
            Integer budgetOfDaily = (Integer)this.fetcher.hfetch(TicketKeyGenerator.Statistics.getClickOfDaily((String)dateStr), ticketId, null, Integer.class);
            return budgetOfDaily == null ? 0 : budgetOfDaily;
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u5f53\u5929\u7684\u70b9\u51fb\u91cf\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public Integer fetchAssetAllClikePvCount(String assetsId, String daily) {
        try {
            Integer allClickCount = (Integer)this.fetcher.hfetch(TicketKeyGenerator.Statistics.getTicketDailyAssetsClick((String)daily), assetsId, null, Integer.class);
            return allClickCount == null ? 0 : allClickCount;
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u83b7\u53d6\u70b9\u51fb\u91cf\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public Integer fetchAssetAllViewPvCount(String assetsId, String daily) {
        try {
            Integer allViewCount = (Integer)this.fetcher.hfetch(TicketKeyGenerator.Statistics.getTicketDailyAssetsView((String)daily), assetsId, null, Integer.class);
            return allViewCount == null ? 0 : allViewCount;
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u83b7\u53d6\u70b9\u51fb\u91cf\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public Integer fetchAssetValiedClikePvCount(String assetsId, String daily) {
        try {
            Long allValiedClickCount = this.fetcher.pfCount(TicketKeyGenerator.Statistics.getTicketDailyAssetsValidClick((String)assetsId, (String)daily));
            return allValiedClickCount == null ? 0 : allValiedClickCount.intValue();
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u83b7\u53d6\u70b9\u51fb\u91cf\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public Map<String, Long> fetchPositionTestViewPvCount(String positionId) {
        try {
            Map map = this.fetcher.hfetchall(TicketKeyGenerator.Statistics.getPositionIdTestViews((String)positionId), null, Long.class);
            return map;
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u83b7\u53d6\u70b9\u51fb\u91cf\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return new HashMap<String, Long>();
        }
    }

    public void updateHashMap(String positionId, String field) {
        try {
            this.updater.hremove(TicketKeyGenerator.Statistics.getPositionIdTestClick((String)positionId), new String[]{field});
        }
        catch (Exception e) {
            LOGGER.error("\u79fb\u9664\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
    }

    public Map<String, Long> fetchPositionTestClickPvCount(String positionId) {
        try {
            Map map = this.fetcher.hfetchall(TicketKeyGenerator.Statistics.getPositionIdTestClick((String)positionId), null, Long.class);
            return map;
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u83b7\u53d6\u70b9\u51fb\u91cf\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return new HashMap<String, Long>();
        }
    }

    public Map<String, Ticket> fetchTicketAll() {
        try {
            Map map = this.fetcher.hfetchall(TicketKeyGenerator.getAllTickets(), null, Ticket.class);
            return map;
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u83b7\u53d6\u70b9\u51fb\u91cf\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return new HashMap<String, Ticket>();
        }
    }

    public Ticket fetchTicket(String ticketId) {
        try {
            Ticket ticket = (Ticket)this.fetcher.hfetch(TicketKeyGenerator.getAllTickets(), ticketId, null, Ticket.class);
            return ticket;
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u83b7\u53d6\u5238\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return new Ticket();
        }
    }

    public Integer fetchTicketDailyCreativeClick(String ticketId, String assetsId, String daily) {
        try {
            Integer allClickCount = (Integer)this.fetcher.hfetch(TicketKeyGenerator.Statistics.getTicketDailyCreativeClick((String)ticketId, (String)daily), assetsId, null, Integer.class);
            return allClickCount == null ? 0 : allClickCount;
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u83b7\u53d6\u70b9\u51fb\u91cf\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public Integer fetchTicketDailyCreativeView(String ticketId, String assetsId, String daily) {
        try {
            Integer allClickCount = (Integer)this.fetcher.hfetch(TicketKeyGenerator.Statistics.getTicketDailyCreativeView((String)ticketId, (String)daily), assetsId, null, Integer.class);
            return allClickCount == null ? 0 : allClickCount;
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u83b7\u53d6\u70b9\u51fb\u91cf\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public Integer fetchTicketDailyCreativeValidClick(String ticketId, String assetsId, String daily) {
        try {
            Long allClickCount = this.fetcher.pfCount(TicketKeyGenerator.Statistics.getTicketDailyCreativeValidClick((String)ticketId, (String)assetsId, (String)daily));
            return allClickCount == null ? 0 : allClickCount.intValue();
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u83b7\u53d6\u70b9\u51fb\u91cf\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public Integer fetchTicketActivityDailyCreativeValidClick(String ticketId, String assetsId, String daily) {
        try {
            Long allClickCount = this.fetcher.pfCount(TicketKeyGenerator.Statistics.getPanGuTicketDailyCreativeValidClick((String)ticketId, (String)assetsId, (String)daily));
            return allClickCount == null ? 0 : allClickCount.intValue();
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u83b7\u53d6\u70b9\u51fb\u91cf\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public void deleteTicketClick(String positionId, String ticketId) {
        try {
            this.updater.hremove(TicketKeyGenerator.Statistics.getPositionIdTestClick((String)positionId), new String[]{ticketId});
            LOGGER.info(ticketId + "\u5220\u9664\u70b9\u51fb\u91cf");
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u83b7\u53d6\u5238\u51fa\u9519" + e.getMessage(), (Throwable)e);
        }
    }

    public Map<Integer, Long> findBalanceByIds(List<Integer> advertiserIds) {
        HashMap map = Maps.newHashMap();
        for (Integer advertiserId : advertiserIds) {
            Long moneyTemp = this.advertiserService.getAdvertiserBalance(BigInteger.valueOf(advertiserId.intValue()));
            map.put(advertiserId, moneyTemp);
        }
        return map;
    }

    public Integer fetchAdxRequestCount(String ticketId, String dateStr) {
        try {
            Integer requestCount = (Integer)this.fetcher.hfetch(() -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "ADX", "REQUEST", dateStr}), ticketId, null, Integer.class);
            return requestCount == null ? 0 : requestCount;
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u5f53\u5929\u7684ADX\u8bf7\u6c42\u6570\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public Integer fetchAdxOfferPriceCount(String ticketId, String dateStr) {
        try {
            Integer offerPriceCount = (Integer)this.fetcher.hfetch(() -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "ADX", "OFFER_PRICE", dateStr}), ticketId, null, Integer.class);
            return offerPriceCount == null ? 0 : offerPriceCount;
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u5f53\u5929\u7684ADX\u51fa\u4ef7\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return 0;
        }
    }
}

