/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.integration.advertiser.service;

import com.bxm.adsmanager.integration.advertiser.model.AdvertiserFinance;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserFinanceNewDto;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserFinanceVo;
import com.bxm.adsmanager.integration.advertiser.model.Pagination;
import com.bxm.adsmanager.integration.advertiser.service.AdFinanceFinanceService;
import com.bxm.commons.export.ExportDataRow;
import com.bxm.commons.export.ExportExcel;
import com.bxm.commons.export.ExportModel;
import com.bxm.util.DateUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
@Component
public class AdFinanceIntegration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdFinanceIntegration.class);
    @Autowired
    private AdFinanceFinanceService adFinanceFinanceService;

    public Pagination getAdShopFinanceOnlyList(AdvertiserFinanceNewDto search) throws Exception {
        Pagination pageBean = new Pagination();
        try {
            PageInfo result = (PageInfo)this.adFinanceFinanceService.getAdFinanceList(search.getPageNum(), search.getPageSize(), search.getOrderParam(), search.getOrderType(), search.getStartTime(), search.getEndTime(), search.getAdvertiserId()).getReturnValue();
            if (null == result) {
                return pageBean;
            }
            pageBean.setTotalCount((int)result.getTotal());
            pageBean.setPageNo(result.getPageNum());
            pageBean.setPageSize(result.getPageSize());
            pageBean.setList(result.getList());
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5e7f\u544a\u4e3b\u8d44\u91d1\u6d41\u6c34\u67e5\u8be2\u5931\u8d25" + e.getMessage());
        }
        return pageBean;
    }

    public List<AdvertiserFinanceVo> exportAdvertiserFinanceOnly(AdvertiserFinanceNewDto search) throws Exception {
        ArrayList lists = Lists.newArrayList();
        try {
            List<AdvertiserFinance> list = this.adFinanceFinanceService.exportAdvertiserFinanceOnly(search.getPageNum(), search.getPageSize(), search.getOrderParam(), search.getOrderType(), search.getStartTime(), search.getEndTime(), search.getAdvertiserId());
            if (CollectionUtils.isNotEmpty(list)) {
                for (AdvertiserFinance advertiserFinance : list) {
                    AdvertiserFinanceVo advertiserFinanceVo = new AdvertiserFinanceVo();
                    BeanUtils.copyProperties((Object)advertiserFinance, (Object)advertiserFinanceVo);
                    lists.add(advertiserFinanceVo);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u51fa\u5e7f\u544a\u4e3b\u8d44\u91d1\u6d41\u6c34\u51fa\u9519" + e.getMessage(), (Throwable)e);
            throw new Exception("\u5bfc\u51fa\u5e7f\u544a\u4e3b\u8d44\u91d1\u6d41\u6c34\u51fa\u9519");
        }
        return lists;
    }

    public void generateAdFinanceExcel(List<AdvertiserFinanceVo> advertiserFinanceList, HttpServletResponse response) {
        String fileName = "\u8d22\u52a1\u6d41\u6c34\u6570\u636e";
        ExportModel exportModel = new ExportModel();
        ArrayList<ExportDataRow> dataRowList = new ArrayList<ExportDataRow>();
        String headNames = "\u521b\u5efa\u65f6\u95f4,\u73b0\u91d1\u5b58\u5165,\u8fd4\u70b9\u5b58\u5165,\u6388\u4fe1\u5b58\u5165,\u73b0\u91d1\u652f\u51fa,\u8fd4\u70b9\u652f\u51fa,\u6388\u4fe1\u652f\u51fa,\u5907\u6ce8";
        int headNamesLength = headNames.split(",").length;
        exportModel.setHeadNames(headNames);
        for (AdvertiserFinanceVo data : advertiserFinanceList) {
            ExportDataRow exportDataRow = new ExportDataRow();
            exportDataRow.setDataColumnList(this.getAdFinanceColumnList(data, headNamesLength));
            dataRowList.add(exportDataRow);
        }
        exportModel.setDataRowList(dataRowList);
        try {
            ExportExcel.exportExcel((HttpServletResponse)response, (ExportModel)exportModel, (String)fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<String> getAdFinanceColumnList(AdvertiserFinanceVo data, int headNamesLength) {
        List<Field> list = Arrays.asList(data.getClass().getDeclaredFields());
        ArrayList<String> dataColumnList = new ArrayList<String>();
        for (int i = 0; i < headNamesLength; ++i) {
            dataColumnList.add(new String());
        }
        block21: for (Field field : list) {
            switch (field.getName()) {
                case "dateTime": {
                    dataColumnList.set(0, DateUtil.dateTo14String((Date)data.getCreated()));
                    continue block21;
                }
                case "balanceIncome": {
                    dataColumnList.set(1, data.getBalanceIncome() + "");
                    continue block21;
                }
                case "rebateIncome": {
                    dataColumnList.set(2, data.getRebateIncome() + "");
                    continue block21;
                }
                case "creditIncome": {
                    dataColumnList.set(3, data.getCreditIncome() + "");
                    continue block21;
                }
                case "balanceExpenditure": {
                    dataColumnList.set(4, data.getBalanceExpenditure() + "");
                    continue block21;
                }
                case "rebateExpenditure": {
                    dataColumnList.set(5, data.getRebateExpenditure() + "");
                    continue block21;
                }
                case "creditExpenditure": {
                    dataColumnList.set(6, data.getCreditExpenditure() + "");
                    continue block21;
                }
                case "remark": {
                    dataColumnList.set(7, data.getRemark() + "");
                    continue block21;
                }
            }
        }
        return dataColumnList;
    }
}

