/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.integration.advertiser.service;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.integration.advertiser.model.Advertiser;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserAuditVo;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserFinanceDto;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserMainInfoVo;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserNewDto;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserVo;
import com.bxm.adsmanager.integration.advertiser.model.Pagination;
import com.bxm.adsmanager.integration.advertiser.service.AdFinanceFinanceService;
import com.bxm.adsmanager.integration.advertiser.service.AdvertiserFeignService;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.utils.KeyBuilder;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
@Component
public class AdShopIntegration {
    private static final Logger log = LoggerFactory.getLogger(AdShopIntegration.class);
    @Autowired
    private AdvertiserFeignService advertiserFeignService;
    @Autowired
    private AdFinanceFinanceService adFinaceFeignService;
    @Autowired
    private JedisFetcher jedisFetcher;

    public List<AdvertiserDto> getAdShopList(AdvertiserDto search) throws Exception {
        if (null == search) {
            search = new AdvertiserDto();
        }
        List listAdvertiser = (List)this.advertiserFeignService.getList(search.getCompany(), null, search.getAccountType(), search.getAe(), search.getSale(), search.getId(), search.getStatus(), null, search.getAssetAuditWhiteStatus(), search.getAreaType()).getReturnValue();
        ArrayList<AdvertiserDto> lists = new ArrayList<AdvertiserDto>();
        if (CollectionUtils.isNotEmpty((Collection)listAdvertiser)) {
            for (Advertiser advertiser : listAdvertiser) {
                AdvertiserDto advertiserDto = new AdvertiserDto();
                BeanUtils.copyProperties((Object)advertiser, (Object)advertiserDto);
                lists.add(advertiserDto);
            }
        }
        return lists;
    }

    public Pagination getAdvertiserList(AdvertiserNewDto search) throws Exception {
        if (null == search) {
            search = new AdvertiserNewDto();
        }
        if (StringUtil.isNotEmpty((CharSequence)search.getKeywords()) && StringUtil.isNumeric((CharSequence)search.getKeywords())) {
            search.setId(Integer.valueOf(search.getKeywords()));
        }
        log.info("-------------------------status:{}", (Object)search.getStatus());
        PageInfo page = (PageInfo)this.advertiserFeignService.getList(search.getPageNum(), search.getPageSize(), search.getOrderParam(), search.getOrderType(), search.getKeywords(), null, null, search.getAgentId(), search.getAccountType(), search.getAe(), search.getSale(), search.getId(), (byte)1, search.getAuditStatus(), search.getAreaType(), null).getReturnValue();
        Pagination pageBean = new Pagination();
        pageBean.setTotalCount(Integer.parseInt(page.getTotal() + ""));
        pageBean.setPageNo(Integer.parseInt(page.getPageNum() + ""));
        pageBean.setPageSize(Integer.parseInt(page.getPageSize() + ""));
        List listAdvertiser = page.getList();
        ArrayList<AdvertiserVo> lists = new ArrayList<AdvertiserVo>();
        if (CollectionUtils.isNotEmpty((Collection)listAdvertiser)) {
            for (Advertiser advertiser : listAdvertiser) {
                AdvertiserVo advertiserVo = new AdvertiserVo();
                BeanUtils.copyProperties((Object)advertiser, (Object)advertiserVo);
                String ownSites = (String)this.jedisFetcher.hfetchWithSelector(() -> KeyBuilder.build((Object[])new Object[]{"ADVERTISER", "OWN_SITE_TEMPLATE"}), advertiser.getId() + "", String.class, 4);
                List<String> list = new ArrayList<String>();
                if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{ownSites}) && !"[]".equals(ownSites)) {
                    list = JSON.parseArray((String)ownSites, String.class);
                }
                advertiserVo.setOwnSite(list);
                lists.add(advertiserVo);
            }
        }
        pageBean.setList(lists);
        return pageBean;
    }

    public Map<Integer, String> getAllAdvertiserMap() throws Exception {
        List<AdvertiserDto> adShopList = this.getAdShopList(new AdvertiserDto());
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        if (CollectionUtils.isNotEmpty(adShopList)) {
            adShopList.forEach(e -> map.put(e.getId(), e.getCompany()));
        }
        return map;
    }

    public Pagination getAdvertiserPage(Map<String, Object> param) throws Exception {
        Integer id = null;
        String keywords = null;
        String updated = Objects.toString(param.get("updated"), null);
        if (null != param.get("id") && StringUtil.isNotBlank((CharSequence)(param.get("id") + ""))) {
            id = Integer.parseInt(param.get("id") + "");
        }
        if (null != param.get("keywords") && StringUtil.isNotBlank((CharSequence)(param.get("keywords") + ""))) {
            keywords = param.get("keywords") + "";
        }
        PageInfo page = (PageInfo)this.advertiserFeignService.getList(Integer.parseInt(param.get("pageNum") + ""), Integer.parseInt(param.get("pageSize") + ""), null, null, keywords, null, null, null, null, null, null, id, (byte)1, null, null, updated).getReturnValue();
        ArrayList<AdvertiserVo> lists = new ArrayList<AdvertiserVo>();
        Pagination pageBean = new Pagination();
        pageBean.setTotalCount(Integer.parseInt(page.getTotal() + ""));
        pageBean.setPageNo(Integer.parseInt(page.getPageNum() + ""));
        pageBean.setPageSize(Integer.parseInt(page.getPageSize() + ""));
        List listAdvertiser = page.getList();
        if (CollectionUtils.isNotEmpty((Collection)listAdvertiser)) {
            for (Advertiser advertiser : listAdvertiser) {
                AdvertiserVo advertiserVo = new AdvertiserVo();
                BeanUtils.copyProperties((Object)advertiser, (Object)advertiserVo);
                lists.add(advertiserVo);
            }
        }
        pageBean.setList(lists);
        return pageBean;
    }

    public List<AdvertiserDto> findAdShopMsgs(String ids) throws IOException {
        List advList = (List)this.advertiserFeignService.getListByIds(ids).getReturnValue();
        ArrayList<AdvertiserDto> lists = new ArrayList<AdvertiserDto>();
        if (CollectionUtils.isNotEmpty((Collection)advList)) {
            for (Advertiser advertiser : advList) {
                AdvertiserDto advertiserDto = new AdvertiserDto();
                BeanUtils.copyProperties((Object)advertiser, (Object)advertiserDto);
                lists.add(advertiserDto);
            }
        }
        return lists;
    }

    public List<AdvertiserDto> findAdShopMsgsByKeywords(String keywords, String ae) throws IOException {
        List advList = (List)this.advertiserFeignService.getListByKeywords(keywords, ae).getReturnValue();
        ArrayList<AdvertiserDto> lists = new ArrayList<AdvertiserDto>();
        if (CollectionUtils.isNotEmpty((Collection)advList)) {
            for (Advertiser advertiser : advList) {
                AdvertiserDto advertiserDto = new AdvertiserDto();
                BeanUtils.copyProperties((Object)advertiser, (Object)advertiserDto);
                lists.add(advertiserDto);
            }
        }
        return lists;
    }

    public String addAdShopCashNew(AdvertiserFinanceDto record) throws IOException {
        Boolean result = (Boolean)this.adFinaceFeignService.add(record).getReturnValue();
        if (result.booleanValue() || !result.booleanValue()) {
            return result + "";
        }
        return null;
    }

    public AdvertiserDto findAdShopMsg(long id) {
        Advertiser advertiser = (Advertiser)this.advertiserFeignService.getById((int)id).getReturnValue();
        AdvertiserDto advertiserDto = new AdvertiserDto();
        BeanUtils.copyProperties((Object)advertiser, (Object)advertiserDto);
        return advertiserDto;
    }

    public boolean updateAdShopMsg(AdvertiserNewDto update) throws Exception {
        Advertiser advertiser = new Advertiser();
        BeanUtils.copyProperties((Object)update, (Object)advertiser);
        boolean result = (Boolean)this.advertiserFeignService.updateByJson(advertiser).getReturnValue();
        return result;
    }

    public boolean addAdShopCash(AdvertiserFinanceDto record) throws IOException {
        boolean result = (Boolean)this.adFinaceFeignService.add(record).getReturnValue();
        return result;
    }

    public List<AdvertiserDto> getAdvertiserListById(Integer id) throws IOException {
        List list = (List)this.advertiserFeignService.getAdvertiserListById(id).getReturnValue();
        ArrayList lists = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (Advertiser advertiser : list) {
                AdvertiserDto advertiserDto = new AdvertiserDto();
                BeanUtils.copyProperties((Object)advertiser, (Object)advertiserDto);
                lists.add(advertiserDto);
            }
        }
        return lists;
    }

    public List<AdvertiserDto> findAdShopMsgsByKeywordsAndAe(String keywords, String ae) throws IOException {
        List advList = (List)this.advertiserFeignService.getListByKeywordsAndAe(keywords, ae).getReturnValue();
        ArrayList<AdvertiserDto> lists = new ArrayList<AdvertiserDto>();
        if (CollectionUtils.isNotEmpty((Collection)advList)) {
            for (Advertiser advertiser : advList) {
                AdvertiserDto advertiserDto = new AdvertiserDto();
                BeanUtils.copyProperties((Object)advertiser, (Object)advertiserDto);
                lists.add(advertiserDto);
            }
        }
        return lists;
    }

    public PageInfo<AdvertiserAuditVo> getAdvertiserAuditList(Integer pageNum, Integer pageSize, Byte accountType, String advertiserIdOrName, Byte advertiserStatus, List<Integer> ids, Integer areaType) {
        if (Objects.isNull(ids)) {
            ids = new ArrayList<Integer>();
        }
        ResultModel<PageInfo<AdvertiserAuditVo>> advertiserAuditList = this.advertiserFeignService.getAdvertiserAuditList(pageNum, pageSize, accountType, advertiserIdOrName, advertiserStatus, ids, areaType);
        PageInfo returnValue = (PageInfo)advertiserAuditList.getReturnValue();
        return returnValue;
    }

    public AdvertiserAuditVo getAdvertiserAuditInfoById(Integer advertiserId) {
        ResultModel<PageInfo<AdvertiserAuditVo>> advertiserAuditList = this.advertiserFeignService.getAdvertiserAuditList(0, 10, null, null, null, Collections.singletonList(advertiserId), 0);
        PageInfo returnValue = (PageInfo)advertiserAuditList.getReturnValue();
        if (Objects.nonNull(returnValue) && CollectionUtils.isNotEmpty((Collection)returnValue.getList())) {
            return (AdvertiserAuditVo)returnValue.getList().get(0);
        }
        return null;
    }

    public ResultModel<Boolean> advertiserAudit(Integer id, Integer isPass, String refuseReason, String refuseRemark) {
        ResultModel<Boolean> resultModel = new ResultModel<Boolean>();
        try {
            resultModel = this.advertiserFeignService.advertiserAudit(id, isPass, refuseReason, refuseRemark);
        }
        catch (Exception e) {
            resultModel.setErrorCode("500");
            resultModel.setErrorDesc("\u8c03\u7528\u670d\u52a1\u9519\u8bef");
        }
        return resultModel;
    }

    public AdvertiserMainInfoVo getAdvertiserMainInfo(Integer id) {
        AdvertiserMainInfoVo advertiserMainInfoVo = new AdvertiserMainInfoVo();
        Advertiser advertiser = (Advertiser)this.advertiserFeignService.getById(id).getReturnValue();
        BeanUtils.copyProperties((Object)advertiser, (Object)advertiserMainInfoVo);
        String businessLicenseImg = advertiser.getBusinessLicenseImg();
        if (StringUtils.isNotBlank((CharSequence)businessLicenseImg)) {
            List<String> imgList = Arrays.asList(businessLicenseImg.split(","));
            advertiserMainInfoVo.setImgList(imgList);
        }
        return advertiserMainInfoVo;
    }

    public ResultModel<Boolean> updateSpecialApproval(Integer advertiserId, Byte specialApproval) {
        ResultModel<Boolean> resultModel = new ResultModel<Boolean>();
        try {
            resultModel = this.advertiserFeignService.updateSpecialApproval(advertiserId, specialApproval);
        }
        catch (Exception e) {
            resultModel.setErrorCode("500");
            resultModel.setErrorDesc("\u8c03\u7528\u670d\u52a1\u9519\u8bef");
        }
        return resultModel;
    }
}

