/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.integration.adx;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.facade.model.adx.AdxMeituanReviewDto;
import com.bxm.adsmanager.integration.config.MeituanReviewConfig;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class MeituanReviewIntegration {
    private static final Logger log = LoggerFactory.getLogger(MeituanReviewIntegration.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private MeituanReviewConfig meituanReviewConfig;
    private String path = "/review/creatives/meituan";

    public static void main(String[] args) throws IllegalAccessException {
        MeituanReviewIntegration integration = new MeituanReviewIntegration();
        integration.sendReviewData(null);
    }

    public Boolean sendReviewData(AdxMeituanReviewDto adxMeituanReviewDto) throws IllegalAccessException {
        ArrayList<AdxMeituanReviewDto> list = new ArrayList<AdxMeituanReviewDto>();
        list.add(adxMeituanReviewDto);
        Object json = JSONObject.toJSON(list);
        System.out.println(json);
        log.info("meituan post json:{}", json);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)json.toString(), (MultiValueMap)headers);
        String url = this.meituanReviewConfig.getUrl();
        log.info("meituanReviewConfig.url = {}", (Object)url);
        if (StringUtils.isBlank((CharSequence)url)) {
            return false;
        }
        String reqUrl = url + this.path;
        ResponseEntity responseEntity = this.restTemplate.postForEntity(reqUrl, (Object)httpEntity, String.class, new Object[0]);
        return responseEntity.getStatusCodeValue() == 200;
    }
}

