/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.integration.datapark.model;

import java.io.Serializable;
import java.util.List;

public class Page<T>
implements Serializable {
    private Integer pageSize;
    private Integer pageNum;
    private Long total;
    private Integer pages;
    private Boolean hasNexPage;
    private Boolean hasPrePage;
    private Boolean isFirstPage;
    private Boolean isLastPage;
    private Integer size;
    private List<T> list;

    public Page() {
    }

    public Page(List<T> list, Integer pageNum, Integer pageSize, Long total) {
        this(list, pageNum, pageSize, total, false);
    }

    public Page(List<T> list, Integer pageNum, Integer pageSize, Long total, Boolean hasCount) {
        if (list == null && total == null) {
            this.list = null;
            this.pageNum = pageNum;
            this.pageSize = pageSize;
            this.total = 0L;
            this.size = 0;
            this.pages = 0;
        } else {
            this.list = list;
            this.pageNum = pageNum;
            this.pageSize = pageSize;
            this.total = total;
            this.size = hasCount != false ? Integer.valueOf(list.size() != 0 ? list.size() - 1 : 0) : Integer.valueOf(list.size());
            this.pages = Integer.valueOf(String.valueOf(Math.ceil((double)total.longValue() / (double)pageSize.intValue())).split("\\.")[0]);
        }
        this.isFirstPage = pageNum == 1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        this.isLastPage = pageNum == this.pages ? Boolean.valueOf(true) : Boolean.valueOf(false);
        this.hasNexPage = this.pages > pageNum ? Boolean.valueOf(true) : Boolean.valueOf(false);
        this.hasPrePage = pageNum > 1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Long getTotal() {
        return this.total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public Integer getPages() {
        return this.pages;
    }

    public void setPages(Integer pages) {
        this.pages = pages;
    }

    public Boolean getHasNexPage() {
        return this.hasNexPage;
    }

    public void setHasNexPage(Boolean hasNexPage) {
        this.hasNexPage = hasNexPage;
    }

    public Boolean getHasPrePage() {
        return this.hasPrePage;
    }

    public void setHasPrePage(Boolean hasPrePage) {
        this.hasPrePage = hasPrePage;
    }

    public Boolean getFirstPage() {
        return this.isFirstPage;
    }

    public void setFirstPage(Boolean firstPage) {
        this.isFirstPage = firstPage;
    }

    public Boolean getLastPage() {
        return this.isLastPage;
    }

    public void setLastPage(Boolean lastPage) {
        this.isLastPage = lastPage;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public List<T> getList() {
        return this.list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }
}

