/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.integration.datapark.service;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.integration.advertiser.model.Pagination;
import com.bxm.adsmanager.integration.datapark.model.ActivityCount;
import com.bxm.adsmanager.integration.datapark.model.AppCount;
import com.bxm.adsmanager.integration.datapark.model.Page;
import com.bxm.adsmanager.integration.datapark.model.TicketCountCommon;
import com.bxm.adsmanager.integration.resttemplate.RestTemplateClient;
import com.bxm.datapark.facade.app.service.AppDataReportService;
import com.bxm.datapark.facade.ticket.model.dto.AppBusinessTicketDto;
import com.bxm.util.dto.ResultModel;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

@Configuration
@Component
public class DataparkAppPullerIntegration {
    @Autowired
    private RestTemplateClient restTemplateClient;
    @Value(value="${datapark.url}")
    private String DATAPARKURL;
    @Autowired
    private AppDataReportService appDataReportService;

    public Page<AppCount> getAppCountPage(String datetime, Integer pageSize, Integer pageNum, String sortName, String sortType, String appKeysJson) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).pageSize(pageSize).pageNum(pageNum).sortName(sortName).sortType(sortType).json(appKeysJson).build();
        ResultModel rs = this.appDataReportService.appReport(dto);
        String result = JSON.toJSONString((Object)rs);
        if (JSON.parseObject((String)result).get((Object)"returnValue") == null) {
            return new Page<AppCount>();
        }
        Page page = (Page)JSON.parseObject((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), Page.class);
        if (CollectionUtils.isNotEmpty(page.getList())) {
            List list = JSON.parseArray((String)page.getList().toString(), AppCount.class);
            page.setList(list);
        }
        return page;
    }

    public List<AppCount> getAppCountVos(String datetime, String sortName, String sortType, String appKeysJson) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).sortName(sortName).sortType(sortType).json(appKeysJson).build();
        ResultModel rs = this.appDataReportService.appReportExport(dto);
        String result = JSON.toJSONString((Object)rs);
        if (JSON.parseObject((String)result).get((Object)"returnValue") == null) {
            return new ArrayList<AppCount>();
        }
        List list = JSON.parseArray((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), AppCount.class);
        if (CollectionUtils.isEmpty((Collection)list)) {
            new ArrayList();
        }
        return list;
    }

    public Page<AppCount> getAppBusinessCountVoPage(String datetime, String appKey, Integer pageSize, Integer pageNum, String sortName, String sortType, String appBusinessesJson) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).appKey(appKey).pageSize(pageSize).pageNum(pageNum).sortName(sortName).sortType(sortType).json(appBusinessesJson).build();
        ResultModel rs = this.appDataReportService.appBusinessReport(dto);
        String result = JSON.toJSONString((Object)rs);
        if (JSON.parseObject((String)result).get((Object)"returnValue") == null) {
            return new Page<AppCount>();
        }
        Page page = (Page)JSON.parseObject((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), Page.class);
        if (CollectionUtils.isNotEmpty(page.getList())) {
            List list = JSON.parseArray((String)page.getList().toString(), AppCount.class);
            page.setList(list);
        }
        return page;
    }

    public Page<AppCount> getAppBusinessCountPage(String datetime, Integer pageSize, Integer pageNum, String sortName, String sortType, String appBusinessesJson) {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).pageSize(pageSize).pageNum(pageNum).sortName(sortName).sortType(sortType).json(appBusinessesJson).build();
        ResultModel rs = this.appDataReportService.findAppBusinessCountNew(dto);
        String result = JSON.toJSONString((Object)rs);
        if (JSON.parseObject((String)result).get((Object)"returnValue") == null) {
            return new Page<AppCount>();
        }
        Page page = (Page)JSON.parseObject((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), Page.class);
        if (CollectionUtils.isNotEmpty(page.getList())) {
            List list = JSON.parseArray((String)page.getList().toString(), AppCount.class);
            page.setList(list);
        }
        return page;
    }

    public List<AppCount> getAppBusinessCountVos(String datetime, String appKey, String sortName, String sortType, String appBusinessesJson) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).appKey(appKey).sortName(sortName).sortType(sortType).json(appBusinessesJson).build();
        ResultModel rs = this.appDataReportService.appBusinessReportExport(dto);
        String result = JSON.toJSONString((Object)rs);
        if (JSON.parseObject((String)result).get((Object)"returnValue") == null) {
            return new ArrayList<AppCount>();
        }
        return JSON.parseArray((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), AppCount.class);
    }

    public List<AppCount> getAppBusinessCountVosBydatime(String datetime) throws IOException {
        String result;
        HashMap maps = Maps.newHashMap();
        if (StringUtils.isNotEmpty((CharSequence)datetime)) {
            maps.put("datetime", datetime);
        }
        if (JSON.parseObject((String)(result = this.restTemplateClient.getByParams(this.DATAPARKURL + "/app/business/profit", maps, HttpMethod.POST, null))).get((Object)"returnValue") == null) {
            return new ArrayList<AppCount>();
        }
        return JSON.parseArray((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), AppCount.class);
    }

    public List<AppCount> getAppDateVos(String appKey, String startTime, String endTime, String sortName, String sortType) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().startTime(startTime).endTime(endTime).appKey(appKey).sortName(sortName).sortType(sortType).build();
        ResultModel rs = this.appDataReportService.appDateReport(dto);
        String result = JSON.toJSONString((Object)rs);
        if (JSON.parseObject((String)result).get((Object)"returnValue") == null) {
            return new ArrayList<AppCount>();
        }
        return JSON.parseArray((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), AppCount.class);
    }

    public List<AppCount> getAppAppBusinessDateVos(String appKey, String business, String startTime, String endTime, String sortName, String sortType) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().startTime(startTime).endTime(endTime).appKey(appKey).business(business).sortName(sortName).sortType(sortType).build();
        ResultModel rs = this.appDataReportService.appBusinessDateReport(dto);
        String result = JSON.toJSONString((Object)rs);
        if (JSON.parseObject((String)result).get((Object)"returnValue") == null) {
            return new ArrayList<AppCount>();
        }
        return JSON.parseArray((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), AppCount.class);
    }

    public Page<TicketCountCommon> getAppTicketCount(String datetime, String appKey, Integer scene, String json, Integer pageSize, Integer pageNum, String sortName, String sortType) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).scene(scene).appKey(appKey).pageNum(pageNum).pageSize(pageSize).json(json).sortName(sortName).sortType(sortType).build();
        String result = JSON.toJSONString((Object)this.appDataReportService.appTicketReport(dto));
        if (JSON.parseObject((String)result).get((Object)"returnValue") == null) {
            return new Page<TicketCountCommon>();
        }
        Page page = (Page)JSON.parseObject((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), Page.class);
        if (CollectionUtils.isNotEmpty(page.getList())) {
            List list = JSON.parseArray((String)page.getList().toString(), TicketCountCommon.class);
            page.setList(list);
        }
        return page;
    }

    public List<TicketCountCommon> getAppTicketCount(String datetime, String appKey, Integer scene, String json) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).appKey(appKey).scene(scene).json(json).build();
        String result = JSON.toJSONString((Object)this.appDataReportService.appTicketReportExport(dto));
        if (JSON.parseObject((String)result).get((Object)"returnValue") == null) {
            return new ArrayList<TicketCountCommon>();
        }
        return JSON.parseArray((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), TicketCountCommon.class);
    }

    public List<TicketCountCommon> getAppTicketCountDate(String startTime, String endTime, String appKey, Long certificateid, String sortName, String sortType) throws IOException {
        return this.getAppBusinessTicketDateReport(startTime, endTime, appKey, certificateid, sortName, sortType, null);
    }

    public Page<TicketCountCommon> getAppBusinessTicketCount(String datetime, String appKey, String business, Integer scene, String json, Integer pageSize, Integer pageNum, String sortName, String sortType) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).scene(scene).business(business).pageSize(pageSize).pageNum(pageNum).sortName(sortName).sortType(sortType).appKey(appKey).json(json).build();
        String result = JSON.toJSONString((Object)this.appDataReportService.appTicketReport(dto));
        if (JSON.parseObject((String)result).get((Object)"returnValue") == null) {
            return new Page<TicketCountCommon>();
        }
        Page page = (Page)JSON.parseObject((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), Page.class);
        if (CollectionUtils.isNotEmpty(page.getList())) {
            List list = JSON.parseArray((String)page.getList().toString(), TicketCountCommon.class);
            page.setList(list);
        }
        return page;
    }

    public List<TicketCountCommon> getAppBusinessTicketExport(String datetime, String appKey, String business, Integer scene, String json) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).scene(scene).business(business).appKey(appKey).json(json).build();
        String result = JSON.toJSONString((Object)this.appDataReportService.appTicketReportExport(dto));
        if (JSON.parseObject((String)result).get((Object)"returnValue") == null) {
            return new ArrayList<TicketCountCommon>();
        }
        return JSON.parseArray((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), TicketCountCommon.class);
    }

    public ResultModel appBusinessActivity(String json, String datetime, String appKey, String business, String activityType, String activityPlanner, Integer pageSize, Integer pageNum, String sortName, String sortType) throws IOException {
        ResultModel resultModel = new ResultModel();
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).json(json).appKey(appKey).business(business).activityType(activityType).activityPlanner(activityPlanner).pageNum(pageNum).pageSize(pageSize).sortName(sortName).sortType(sortType).build();
        String result = JSON.toJSONString((Object)this.appDataReportService.appBusinessActivity(dto));
        if (JSON.parseObject((String)result).get((Object)"returnValue") == null) {
            resultModel.setReturnValue(null);
            return resultModel;
        }
        Page page = (Page)JSON.parseObject((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), Page.class);
        if (page.getList() == null) {
            resultModel.setReturnValue(null);
            return resultModel;
        }
        if (page.getSize() > 0) {
            List list = JSON.parseArray((String)page.getList().toString(), ActivityCount.class);
            page.setList(list);
        }
        Pagination pagination = new Pagination(page.getPageNum(), page.getSize(), page.getTotal().intValue(), page.getList());
        resultModel.setReturnValue((Object)pagination);
        return resultModel;
    }

    public List<ActivityCount> appBusinessActivityExport(String json, String datetime, String appKey, String business) throws IOException {
        ResultModel resultModel = new ResultModel();
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).json(json).appKey(appKey).business(business).build();
        String result = JSON.toJSONString((Object)this.appDataReportService.appBusinessActivityExport(dto));
        if (JSON.parseObject((String)result).get((Object)"returnValue") == null) {
            return new ArrayList<ActivityCount>();
        }
        return JSON.parseArray((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), ActivityCount.class);
    }

    public List<TicketCountCommon> getAppTicketCountWeight(String datetime, String json) throws IOException {
        String result;
        HashMap maps = Maps.newHashMap();
        if (StringUtils.isNotEmpty((CharSequence)datetime)) {
            maps.put("datetime", datetime);
        }
        if (StringUtils.isNotEmpty((CharSequence)json)) {
            maps.put("json", json);
        }
        if (JSON.parseObject((String)(result = this.restTemplateClient.getByParams(this.DATAPARKURL + "/ticket/weight", maps, HttpMethod.POST, null))).get((Object)"returnValue") == null) {
            return new ArrayList<TicketCountCommon>();
        }
        return JSON.parseArray((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), TicketCountCommon.class);
    }

    public List<AppCount> getAppCountVosSum(String startTime, String endTime, String sortName, String sortType, String appKeysJson) throws Exception {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().startTime(startTime).endTime(endTime).sortName(sortName).sortType(sortType).json(appKeysJson).build();
        ResultModel rs = this.appDataReportService.appSumReport(dto);
        String result = JSON.toJSONString((Object)rs);
        if (JSON.parseObject((String)result).get((Object)"returnValue") == null) {
            return new ArrayList<AppCount>();
        }
        return JSON.parseArray((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), AppCount.class);
    }

    public List<AppCount> appCountVosSumExport(String startTime, String endTime, String appKeysJson) throws Exception {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().startTime(startTime).endTime(endTime).json(appKeysJson).build();
        ResultModel rs = this.appDataReportService.appSumReport(dto);
        String result = JSON.toJSONString((Object)rs);
        if (JSON.parseObject((String)result).get((Object)"returnValue") == null) {
            return new ArrayList<AppCount>();
        }
        return JSON.parseArray((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), AppCount.class);
    }

    public List<TicketCountCommon> getAppBusinessTicketDateReport(String startTime, String endTime, String appKey, Long certificateid, String sortName, String sortType, String business) {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().startTime(startTime).endTime(endTime).business(business).appKey(appKey).certificateid(certificateid).sortName(sortName).sortType(sortType).build();
        String result = JSON.toJSONString((Object)this.appDataReportService.appTicketDateReport(dto));
        if (JSON.parseObject((String)result).get((Object)"returnValue") == null) {
            return new ArrayList<TicketCountCommon>();
        }
        return JSON.parseArray((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), TicketCountCommon.class);
    }

    public Map<String, Integer> findAppBusinessProfitRangeTime(String beginTime, String endTime, List<String> appKey) {
        ResultModel resultModel;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        Map<String, Integer> resultMap = new HashMap<String, Integer>();
        if (StringUtils.isNotBlank((CharSequence)beginTime) && StringUtils.isNotBlank((CharSequence)endTime)) {
            paramMap.put("beginTime", beginTime);
            paramMap.put("endTime", endTime);
        }
        if (!CollectionUtils.isEmpty(appKey)) {
            paramMap.put("appKeys", appKey);
        }
        if ((resultModel = this.appDataReportService.findAppBusinessProfitRangeTime(JSON.toJSONString(paramMap))) != null && resultModel.isSuccessed()) {
            resultMap = (Map)resultModel.getReturnValue();
        }
        return resultMap;
    }

    public Map<String, String> findTicketByRangeTime(String datetime, List<String> appKey) {
        ResultModel resultModel;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        Map<String, String> resultMap = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)datetime)) {
            paramMap.put("datetime", datetime);
        }
        if (!CollectionUtils.isEmpty(appKey)) {
            paramMap.put("appKeys", appKey);
        }
        if ((resultModel = this.appDataReportService.findTicketByRangeTime(JSON.toJSONString(paramMap))) != null && resultModel.isSuccessed()) {
            resultMap = (Map)resultModel.getReturnValue();
        }
        return resultMap;
    }
}

