/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.integration.datapark.service;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.integration.resttemplate.RestTemplateClient;
import com.bxm.datapark.web.FacadeAdAssetsDataService;
import com.bxm.datapark.web.model.AdAssetsData;
import com.bxm.datapark.web.model.AdAssetsDataDTO;
import com.bxm.datapark.web.model.AssetsAnalysisData;
import com.bxm.datapark.web.model.AssetsAnalysisDataDTO;
import com.bxm.util.dto.ResultModel;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
@Component
public class DataparkAssetsPullerIntegration {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataparkAssetsPullerIntegration.class);
    @Value(value="${datapark.url}")
    private String DATAPARKURL;
    @Autowired
    private RestTemplateClient restTemplateClient;
    @Autowired
    private FacadeAdAssetsDataService facadeAdAssetsDataService;

    public List<AssetsAnalysisData> getAssetsAnalysis(String startTime, String endTime, List<Long> assetIds) {
        AssetsAnalysisDataDTO dto = new AssetsAnalysisDataDTO();
        dto.setStartTime(startTime);
        dto.setEndTime(endTime);
        dto.setAssetIds(assetIds);
        ResultModel resultModel = this.facadeAdAssetsDataService.getAssetsAnalysisList(dto);
        String result = JSON.toJSONString((Object)resultModel);
        if (JSON.parseObject((String)result).get((Object)"returnValue").toString() == null) {
            return new ArrayList<AssetsAnalysisData>();
        }
        return JSON.parseArray((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), AssetsAnalysisData.class);
    }

    public List<AdAssetsData> getDataByTicket(String startTime, String endTime, Long ticketId) {
        AdAssetsDataDTO dto = new AdAssetsDataDTO();
        dto.setStartTime(startTime);
        dto.setEndTime(endTime);
        dto.setTicketId(ticketId);
        ResultModel resultModel = this.facadeAdAssetsDataService.getDataByTicket(dto);
        String result = JSON.toJSONString((Object)resultModel);
        if (JSON.parseObject((String)result).get((Object)"returnValue").toString() == null) {
            return new ArrayList<AdAssetsData>();
        }
        return JSON.parseArray((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), AdAssetsData.class);
    }
}

