/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.integration.datapark.service;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.integration.datapark.model.AppCount;
import com.bxm.adsmanager.integration.datapark.model.TicketCountCommon;
import com.bxm.adsmanager.integration.datapark.service.DataparkAppPullerIntegration;
import com.bxm.adsmanager.integration.datapark.service.DataparkTicketPullerIntegration;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
@Component
public class DataparkListToMapService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataparkListToMapService.class);
    @Autowired
    private DataparkTicketPullerIntegration dataParkTicketPullIntegration;
    @Autowired
    private DataparkAppPullerIntegration dataparkAppPullerIntegration;

    public Map<Long, Integer> getTicketCountMap(String datetime) {
        HashMap<Long, Integer> results = new HashMap<Long, Integer>();
        try {
            List<TicketCountCommon> counts = this.dataParkTicketPullIntegration.getTicketCount(datetime, null, null);
            for (TicketCountCommon count : counts) {
                results.put(count.getCertificateid(), count.getClickPv());
            }
        }
        catch (IOException e) {
            LOGGER.error("getTicketCountMap ERROR", (Throwable)e);
        }
        return results;
    }

    public Map<Long, TicketCountCommon> getTicketCountEntityMap(String datetime) {
        HashMap<Long, TicketCountCommon> results = new HashMap<Long, TicketCountCommon>();
        try {
            List<TicketCountCommon> counts = this.dataParkTicketPullIntegration.getTicketCount(datetime, null, null);
            for (TicketCountCommon count : counts) {
                results.put(count.getCertificateid(), count);
            }
        }
        catch (IOException e) {
            LOGGER.error("getTicketCountMap ERROR", (Throwable)e);
        }
        return results;
    }

    public Map<String, AppCount> getAppCountMap(String datetime) {
        HashMap<String, AppCount> results = new HashMap<String, AppCount>();
        try {
            List<AppCount> counts = this.dataparkAppPullerIntegration.getAppCountVos(datetime, null, null, null);
            for (AppCount count : counts) {
                results.put(count.getAppKey(), count);
            }
        }
        catch (IOException e) {
            LOGGER.error("getAppCountMap ERROR", (Throwable)e);
        }
        return results;
    }

    public Map<String, AppCount> getPositionCountMap(String datetime) {
        HashMap<String, AppCount> results = new HashMap<String, AppCount>();
        try {
            List<AppCount> counts = this.dataparkAppPullerIntegration.getAppBusinessCountVosBydatime(datetime);
            for (AppCount count : counts) {
                String positionId = count.getBusiness();
                if (StringUtils.isNotBlank((String)positionId)) {
                    positionId = positionId.replace("ad-", "");
                }
                results.put(count.getAppKey() + "-" + positionId, count);
            }
        }
        catch (IOException e) {
            LOGGER.error("getPositionCountMap ERROR", (Throwable)e);
        }
        return results;
    }

    public TicketCountCommon getTicketCountByTicket(String datetime, Long ticketId) throws IOException {
        ArrayList<Long> search = new ArrayList<Long>();
        search.add(ticketId);
        List<TicketCountCommon> results = this.dataParkTicketPullIntegration.getTicketCount(datetime, null, JSONObject.toJSONString(search));
        if (results != null && results.size() > 0) {
            return results.get(0);
        }
        return new TicketCountCommon();
    }

    public Map<String, TicketCountCommon> getPositionCountMapByTicket(String datetime, Long ticketId) throws IOException {
        HashMap<String, TicketCountCommon> maps = new HashMap<String, TicketCountCommon>();
        ArrayList<Long> search = new ArrayList<Long>();
        search.add(ticketId);
        List<TicketCountCommon> results = this.dataparkAppPullerIntegration.getAppTicketCount(datetime, null, null, JSONObject.toJSONString(search));
        for (TicketCountCommon e : results) {
            maps.put(e.getAppkey() + "-" + e.getBusiness().replace("ad-", ""), e);
        }
        return maps;
    }

    public Map<String, TicketCountCommon> getPositionCountMapByTicketWeight(String datetime, Long ticketId) throws IOException {
        HashMap<String, TicketCountCommon> maps = new HashMap<String, TicketCountCommon>();
        ArrayList<Long> search = new ArrayList<Long>();
        search.add(ticketId);
        List<TicketCountCommon> results = this.dataparkAppPullerIntegration.getAppTicketCountWeight(datetime, JSONObject.toJSONString(search));
        for (TicketCountCommon e : results) {
            maps.put(e.getAppkey() + "-" + e.getBusiness().replace("ad-", ""), e);
        }
        return maps;
    }

    public Map<String, Integer> analysisAppBusinessProfitRangeTime(String beginTime, String endTime, List<String> appKey) {
        HashMap<String, Integer> results = new HashMap();
        try {
            results = this.dataparkAppPullerIntegration.findAppBusinessProfitRangeTime(beginTime, endTime, appKey);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u65f6\u95f4\u8303\u56f4\u5185\u5e7f\u544a\u4f4d\u4e0a\u7684\u7edf\u8ba1\u6570\u636e\u51fa\u9519" + e.getMessage(), (Throwable)e);
        }
        return results;
    }

    public Map<String, String> analysisTicketByRangeTime(String datetime, List<String> appKey) {
        HashMap<String, String> results = new HashMap();
        try {
            results = this.dataparkAppPullerIntegration.findTicketByRangeTime(datetime, appKey);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u5177\u4f53\u67d0\u4e00\u5929\u5e7f\u544a\u4f4d\u4e0b\u6240\u6709\u5238\u7684\u7edf\u8ba1\u6570\u636e\u51fa\u9519" + e.getMessage(), (Throwable)e);
        }
        return results;
    }

    private static Double div(Double v1, Double v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(v1.toString());
        BigDecimal b2 = new BigDecimal(v2.toString());
        return new Double(b1.divide(b2, scale, 4).doubleValue());
    }
}

