/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.integration.datapark.service;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.integration.advertiser.model.Pagination;
import com.bxm.adsmanager.integration.datapark.model.Page;
import com.bxm.adsmanager.integration.datapark.model.TicketCountCommon;
import com.bxm.adsmanager.integration.resttemplate.RestTemplateClient;
import com.bxm.datapark.facade.ticket.model.dto.AppBusinessTicketDto;
import com.bxm.datapark.facade.ticket.model.dto.SendTicketDetailDto;
import com.bxm.datapark.facade.ticket.model.dto.SendTicketDto;
import com.bxm.datapark.facade.ticket.service.TicketDataReportSevice;
import com.bxm.datapark.web.FacadeAdTicketDataService;
import com.bxm.util.dto.ResultModel;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

@Configuration
@Component
public class DataparkTicketPullerIntegration {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataparkTicketPullerIntegration.class);
    @Value(value="${datapark.url}")
    private String DATAPARKURL;
    @Autowired
    private RestTemplateClient restTemplateClient;
    @Autowired
    private TicketDataReportSevice ticketDataReportSevice;
    @Autowired
    private FacadeAdTicketDataService facadeAdTicketDataService;

    public ResultModel getTicketCompare(SendTicketDto sendTicketDto) {
        return this.ticketDataReportSevice.getTicketCompare(sendTicketDto);
    }

    public ResultModel getTicketCompareDetail(SendTicketDetailDto sendTicketDetailDto) {
        return this.ticketDataReportSevice.getTicketCompareDetail(sendTicketDetailDto);
    }

    public ResultModel ticketData(Long certificateid, String appkey, String business, String datetime, Integer sHour, Integer eHour, Integer pageSize, Integer pageNum, String sortName, String sortType) {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).sHour(sHour).eHour(eHour).appKey(appkey).business(business).certificateid(certificateid).pageNum(pageNum).pageSize(pageSize).sortName(sortName).sortType(sortType).build();
        return this.pullTicketData(dto);
    }

    private void calOpenPvRate(List<TicketCountCommon> ticketCountCommonList) {
        if (CollectionUtils.isNotEmpty(ticketCountCommonList)) {
            int countOpenPv = 1;
            for (int i = 0; i < ticketCountCommonList.size(); ++i) {
                if (i == 0) {
                    TicketCountCommon count = ticketCountCommonList.get(i);
                    countOpenPv = count.getOpenPv();
                    continue;
                }
                TicketCountCommon ticketCountCommon = ticketCountCommonList.get(i);
                int openPv = ticketCountCommon.getOpenPv();
                BigDecimal pvRate = new BigDecimal(openPv).multiply(new BigDecimal(100)).divide(new BigDecimal(countOpenPv), 2, 5);
                ticketCountCommon.setOpenPvRate(pvRate.doubleValue());
            }
        }
    }

    public List<TicketCountCommon> ticketHoursExport(String datetime, Long certificateid, String appkey, String business, Integer sHour, Integer eHour) {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).sHour(sHour).eHour(eHour).appKey(appkey).business(business).certificateid(certificateid).build();
        List<TicketCountCommon> ticketCountCommonList = this.ticketDateExport(dto);
        return ticketCountCommonList;
    }

    public ResultModel pullTicketData(AppBusinessTicketDto dto) {
        ResultModel resultModel = new ResultModel();
        try {
            ResultModel rs = this.ticketDataReportSevice.ticketHourReport(dto);
            String result = JSON.toJSONString((Object)rs);
            if (JSON.parseObject((String)result).get((Object)"returnValue") == null) {
                resultModel.setReturnValue(null);
                return resultModel;
            }
            Page page = (Page)JSON.parseObject((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), Page.class);
            if (page.getList() == null) {
                resultModel.setReturnValue(null);
                return resultModel;
            }
            if (page.getSize() > 0) {
                List list = JSON.parseArray((String)page.getList().toString(), TicketCountCommon.class);
                this.calOpenPvRate(list);
                page.setList(list);
            }
            Pagination pagination = new Pagination(page.getPageNum(), page.getSize(), page.getTotal().intValue(), page.getList());
            resultModel.setReturnValue((Object)pagination);
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528datapark\u6d3b\u52a8\u62a5\u8868\u63a5\u53e3\u5931\u8d25pullTicketData:+" + e.getMessage(), (Throwable)e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u8c03\u7528datapark\u6d3b\u52a8\u62a5\u8868\u63a5\u53e3\u5931\u8d25");
        }
        return resultModel;
    }

    public List<TicketCountCommon> ticketDateExport(AppBusinessTicketDto dto) {
        try {
            ResultModel rs = this.ticketDataReportSevice.ticketHourReportExport(dto);
            String result = JSON.toJSONString((Object)rs);
            if (JSON.parseObject((String)result).get((Object)"returnValue") == null) {
                return new ArrayList<TicketCountCommon>();
            }
            List list = JSON.parseArray((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), TicketCountCommon.class);
            if (list.size() > 0) {
                return list;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528datapark\u6d3b\u52a8\u62a5\u8868\u63a5\u53e3\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return new ArrayList<TicketCountCommon>();
    }

    public Page<TicketCountCommon> getTicketCount(String datetime, Integer scene, String json, Integer pageNum, Integer pageSize, String sortName, String sortType) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().scene(scene).datetime(datetime).json(json).pageNum(pageNum).pageSize(pageSize).sortName(sortName).sortType(sortType).build();
        ResultModel resultModel = this.ticketDataReportSevice.ticketReport(dto);
        String result = JSON.toJSONString((Object)resultModel);
        if (JSON.parseObject((String)result).get((Object)"returnValue") == null) {
            return new Page<TicketCountCommon>();
        }
        Page page = (Page)JSON.parseObject((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), Page.class);
        if (CollectionUtils.isNotEmpty(page.getList())) {
            List list = JSON.parseArray((String)page.getList().toString(), TicketCountCommon.class);
            page.setList(list);
        }
        return page;
    }

    public List<TicketCountCommon> getTicketCount(String datetime, Integer scene, String json) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().scene(scene).datetime(datetime).json(json).build();
        ResultModel resultModel = this.facadeAdTicketDataService.ticketReportExport(dto);
        String result = JSON.toJSONString((Object)resultModel);
        if (JSON.parseObject((String)result).get((Object)"returnValue").toString() == null) {
            return new ArrayList<TicketCountCommon>();
        }
        return JSON.parseArray((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), TicketCountCommon.class);
    }

    public List<TicketCountCommon> getTicketAdxCount(String datetime, Integer scene, String json) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().scene(scene).datetime(datetime).json(json).build();
        ResultModel resultModel = this.facadeAdTicketDataService.ticketAdxReportExport(dto);
        String result = JSON.toJSONString((Object)resultModel);
        if (JSON.parseObject((String)result).get((Object)"returnValue").toString() == null) {
            return new ArrayList<TicketCountCommon>();
        }
        return JSON.parseArray((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), TicketCountCommon.class);
    }

    public Page<TicketCountCommon> getTicketAppCount(String datetime, Long certificateid, String json, Integer pageNum, Integer pageSize, String sortName, String sortType) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).json(json).certificateid(certificateid).pageNum(pageNum).pageSize(pageSize).sortName(sortName).sortType(sortType).build();
        ResultModel resultModel = this.ticketDataReportSevice.ticketReport(dto);
        String result = JSON.toJSONString((Object)resultModel);
        if (JSON.parseObject((String)result).get((Object)"returnValue") == null) {
            return new Page<TicketCountCommon>();
        }
        Page page = (Page)JSON.parseObject((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), Page.class);
        if (CollectionUtils.isNotEmpty(page.getList())) {
            List list = JSON.parseArray((String)page.getList().toString(), TicketCountCommon.class);
            page.setList(list);
        }
        return page;
    }

    public List<TicketCountCommon> getTicketAppCount(String datetime, Long certificateid, String json) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().certificateid(certificateid).datetime(datetime).json(json).build();
        ResultModel resultModel = this.ticketDataReportSevice.ticketReportExport(dto);
        String result = JSON.toJSONString((Object)resultModel);
        if (JSON.parseObject((String)result).get((Object)"returnValue") == null) {
            return new ArrayList<TicketCountCommon>();
        }
        return JSON.parseArray((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), TicketCountCommon.class);
    }

    public Page<TicketCountCommon> getTicketAppBusinessCount(String datetime, Long certificateid, String appKey, String json, Integer pageNum, Integer pageSize, String sortName, String sortType) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).appKey(appKey).json(json).certificateid(certificateid).pageSize(pageSize).pageNum(pageNum).sortName(sortName).sortType(sortType).build();
        ResultModel resultModel = this.ticketDataReportSevice.ticketReport(dto);
        String result = JSON.toJSONString((Object)resultModel);
        if (JSON.parseObject((String)result).get((Object)"returnValue") == null) {
            return new Page<TicketCountCommon>();
        }
        Page page = (Page)JSON.parseObject((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), Page.class);
        if (CollectionUtils.isNotEmpty(page.getList())) {
            List list = JSON.parseArray((String)page.getList().toString(), TicketCountCommon.class);
            page.setList(list);
        }
        return page;
    }

    public List<TicketCountCommon> getTicketAppBusinessCount(String datetime, Long certificateid, String appKey, String json) throws IOException {
        String result;
        HashMap maps = Maps.newHashMap();
        if (StringUtils.isNotEmpty((String)datetime)) {
            maps.put("datetime", datetime);
        }
        if (certificateid != null) {
            maps.put("certificateid", certificateid);
        }
        if (StringUtils.isNotEmpty((String)appKey)) {
            maps.put("appkey", appKey);
        }
        if (StringUtils.isNotEmpty((String)json)) {
            maps.put("json", json);
        }
        if (JSON.parseObject((String)(result = this.restTemplateClient.getByParams(this.DATAPARKURL + "/ticket/profit", maps, HttpMethod.POST, null))).get((Object)"returnValue") == null) {
            return new ArrayList<TicketCountCommon>();
        }
        return JSON.parseArray((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), TicketCountCommon.class);
    }

    public List<TicketCountCommon> getTicketCountDate(String startTime, String endTime, Long certificateid, String sortName, String sortType) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().startTime(startTime).endTime(endTime).certificateid(certificateid).sortName(sortName).sortType(sortType).build();
        ResultModel resultModel = this.ticketDataReportSevice.ticketDateReport(dto);
        String result = JSON.toJSONString((Object)resultModel);
        if (JSON.parseObject((String)result).get((Object)"returnValue") == null) {
            return new ArrayList<TicketCountCommon>();
        }
        return JSON.parseArray((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), TicketCountCommon.class);
    }

    public List<TicketCountCommon> getTicketAppBusinessCountNew(String datetime, Long certificateid, String appKey, String json) throws IOException {
        AppBusinessTicketDto dto = new AppBusinessTicketDto.Builder().datetime(datetime).appKey(appKey).json(json).certificateid(certificateid).build();
        ResultModel resultModel = this.ticketDataReportSevice.ticketReportExport(dto);
        String result = JSON.toJSONString((Object)resultModel);
        if (JSON.parseObject((String)result).get((Object)"returnValue") == null) {
            return new ArrayList<TicketCountCommon>();
        }
        return JSON.parseArray((String)JSON.parseObject((String)result).get((Object)"returnValue").toString(), TicketCountCommon.class);
    }
}

