/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.integration.getui.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.integration.getui.model.RuleForm;
import com.bxm.adsmanager.integration.getui.utils.HttpUtils;
import com.bxm.util.MD5Util;
import com.bxm.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
@Component
public class GeTuiIntegration {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeTuiIntegration.class);
    @Value(value="${geTui.url}")
    private String GETUIURL;
    @Value(value="${geTui.userCode}")
    private String USER_CODE;
    @Value(value="${geTui.authCode}")
    private String AUTH_CODE;
    private static final String ACCESSERURL = "/accesser/auth";
    private static final String UPLOADRULEURL = "/rules/uploadRule";
    private static final String DELETERULEURL = "/rules/delRule";
    private static final String GETRULEURL = "/rules/getRuleList";

    public void uploadRule(List<RuleForm> list, Long ticketId) {
        try {
            long start = System.currentTimeMillis();
            String accessToken = this.getAccessToken();
            String parameter = this.packageParameter(list, ticketId);
            LOGGER.info("\u4e2a\u63a8\u89c4\u5219\u4e0a\u4f20:parameter=" + parameter);
            String result = this.sendPost("http://" + this.GETUIURL + UPLOADRULEURL, parameter, accessToken);
            if (StringUtils.isBlank((CharSequence)result)) {
                return;
            }
            JSONObject js = JSONObject.parseObject((String)result);
            String code = js.getString("code");
            long end = System.currentTimeMillis();
            LOGGER.info("\u4e2a\u63a8\u89c4\u5219\u4e0a\u4f20\u5b8c\u6210\uff0c\u7528\u65f6\uff1a" + (end - start) + "\u6beb\u79d2");
            if (code.equals("0")) {
                return;
            }
            LOGGER.error("\u53d1\u9001\u4e2a\u63a8\u753b\u50cf\u6210\u529f\uff0c\u4f46\u662f\u8fd4\u56de\u503c\u662f\u5931\u8d25\u7684");
        }
        catch (Exception e) {
            LOGGER.error("\u4e2a\u63a8\u89c4\u5219\u4e0a\u4f20\u63a5\u53e3\u5931\u8d25", (Throwable)e);
        }
    }

    public void deleteRule(Long ruleId) {
        try {
            LOGGER.info("\u5220\u9664\u4e2a\u63a8\u89c4\u5219:ticketId=" + ruleId);
            String accessToken = this.getAccessToken();
            String result = this.sendGet("http://" + this.GETUIURL + DELETERULEURL, "ruleId=" + ruleId, accessToken);
            if (StringUtil.isBlank((CharSequence)result)) {
                return;
            }
            JSONObject json = JSONObject.parseObject((String)result);
            String code = json.getString("code");
            if ("0".equals(code)) {
                return;
            }
            LOGGER.error("\u53d1\u9001\u4e2a\u63a8\u753b\u50cf\u6210\u529f\uff0c\u4f46\u662f\u8fd4\u56de\u503c\u662f\u5931\u8d25\u7684");
        }
        catch (Exception e) {
            LOGGER.error("\u4e2a\u63a8\u5220\u9664\u89c4\u5219\u63a5\u53e3\u5931\u8d25", (Throwable)e);
        }
    }

    public String packageParameter(List<RuleForm> list, Long ticketId) {
        JSONArray ja = new JSONArray(list.size());
        for (RuleForm ruleForm : list) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tagExpress", ruleForm.getLabelid());
            if (1 == ruleForm.getIsveto()) {
                map.put("score", 0);
            } else {
                map.put("score", null == ruleForm.getFraction() ? 0 : ruleForm.getFraction());
            }
            map.put("isVeto", ruleForm.getIsveto());
            ja.add(map);
        }
        JSONObject jo2 = new JSONObject();
        jo2.put("ruleId", (Object)ticketId);
        jo2.put("ruleScoreObjList", (Object)ja);
        JSONArray ss = new JSONArray();
        ss.add((Object)jo2);
        JSONObject jo3 = new JSONObject();
        jo3.put("rules", (Object)ss);
        return jo3.toJSONString();
    }

    public String getAccessToken() {
        String access_token = "";
        try {
            String timestamp = String.valueOf(System.currentTimeMillis());
            String sign1 = MD5Util.md5((String)(this.USER_CODE + MD5Util.md5((String)timestamp)));
            String sign2 = MD5Util.md5((String)(this.USER_CODE + this.AUTH_CODE + MD5Util.md5((String)timestamp)));
            String url = "http://" + this.GETUIURL + ACCESSERURL + "?user_code=" + this.USER_CODE + "&sign1=" + sign1 + "&sign2=" + sign2 + "&timestamp=" + timestamp;
            CloseableHttpClient httpClient = HttpUtils.CreatHttpClient();
            HttpGet httpGet = HttpUtils.getHttpGet(url);
            httpGet.setHeader("Accept", "application/vnd.dmp.v1+json");
            CloseableHttpResponse httpResp = httpClient.execute((HttpUriRequest)httpGet);
            String result = EntityUtils.toString((HttpEntity)httpResp.getEntity());
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            access_token = jsonObject.getString("access_token");
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6AccessToken\u51fa\u9519" + e.getMessage(), (Throwable)e);
        }
        return access_token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendPost(String url, String param, String access_token) {
        PrintWriter out = null;
        BufferedReader in = null;
        String result = "";
        try {
            String line;
            URL realUrl = new URL(url);
            URLConnection conn = realUrl.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Authorization", "Bearer " + access_token);
            conn.setRequestProperty("Accept", "application/vnd.dmp.v1+json");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            out = new PrintWriter(conn.getOutputStream());
            out.print(param);
            out.flush();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u53d1\u9001POST\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38" + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendGet(String url, String param, String access_token) {
        String result = "";
        BufferedReader in = null;
        try {
            String line;
            String urlNameString = url + "?" + param;
            URL realUrl = new URL(urlNameString);
            URLConnection connection = realUrl.openConnection();
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Authorization", "Bearer " + access_token);
            connection.setRequestProperty("Accept", "application/vnd.dmp.v1+json");
            connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            connection.connect();
            Map<String, List<String>> map = connection.getHeaderFields();
            for (String key : map.keySet()) {
                LOGGER.info(key + "--->" + map.get(key));
            }
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u53d1\u9001GET\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38" + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return result;
    }
}

