/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.integration.getui.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpUtils {
    public static void close(CloseableHttpClient httpclient) {
        if (httpclient != null) {
            try {
                httpclient.close();
                httpclient = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void close(CloseableHttpResponse httpResp) {
        if (httpResp != null) {
            try {
                httpResp.close();
                httpResp = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static CloseableHttpClient CreatHttpClient() {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        return httpclient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseableHttpClient CreatHttpClientSSL() {
        CloseableHttpClient httpclient = null;
        BasicCookieStore cookieStore = new BasicCookieStore();
        try {
            SSLContext sslcontext = SSLContext.getInstance("SSL");
            sslcontext.init(null, new TrustManager[]{new MyX509TrustManager()}, null);
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslcontext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            HttpClientBuilder httpClientBuilder = HttpClients.custom();
            httpClientBuilder = httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory);
            httpClientBuilder = httpClientBuilder.setDefaultCookieStore((CookieStore)cookieStore);
            httpclient = httpClientBuilder.build();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return httpclient;
    }

    public static HttpPost getHttpPost(String url) {
        HttpPost httpPost = new HttpPost(url);
        httpPost = HttpUtils.addHeader(httpPost);
        return httpPost;
    }

    public static HttpPost addHeader(HttpPost httpPost) {
        httpPost.setHeader((Header)new BasicHeader("UserAgent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.101 Safari/537.36"));
        httpPost.setHeader((Header)new BasicHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.101 Safari/537.36"));
        httpPost.setHeader((Header)new BasicHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8"));
        httpPost.setHeader((Header)new BasicHeader("Accept-Language", "zh-CN,zh;q=0.8"));
        httpPost.setHeader((Header)new BasicHeader("Connection", "keep-alive"));
        return httpPost;
    }

    public static HttpGet getHttpGet(String url) {
        HttpGet httpGet = new HttpGet(url);
        httpGet = HttpUtils.addHeader(httpGet);
        return httpGet;
    }

    public static HttpGet addHeader(HttpGet httpGet) {
        httpGet.setHeader((Header)new BasicHeader("Content-Type", "application/x-www-form-urlencoded;CharSet=gbk"));
        httpGet.setHeader((Header)new BasicHeader("UserAgent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.101 Safari/537.36"));
        httpGet.setHeader((Header)new BasicHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.101 Safari/537.36"));
        httpGet.setHeader((Header)new BasicHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8"));
        httpGet.setHeader((Header)new BasicHeader("Accept-Encoding", "gzip, deflate"));
        httpGet.setHeader((Header)new BasicHeader("Accept-Language", "zh-CN,zh;q=0.8"));
        httpGet.setHeader((Header)new BasicHeader("Connection", "keep-alive"));
        return httpGet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean savePic(InputStream inputStream, String filePath) {
        ByteArrayOutputStream outStream = null;
        FileOutputStream fileOutStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = inputStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            byte[] imgByte = outStream.toByteArray();
            String fileDir = filePath.substring(0, filePath.lastIndexOf("/"));
            File imageFilePath = new File(fileDir);
            if (!imageFilePath.exists()) {
                imageFilePath.mkdirs();
            }
            File imageFile = new File(filePath);
            fileOutStream = new FileOutputStream(imageFile);
            fileOutStream.write(imgByte);
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fileOutStream != null) {
                try {
                    fileOutStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    public static String savePic(byte[] imgByte, String pahtFile) {
        String session_token = UUID.randomUUID().toString();
        Path pathFile = Paths.get("" + pahtFile, new String[0]);
        try {
            Files.write(pathFile, imgByte, StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return session_token;
    }

    public static HashMap<String, String> findUrlParameters(String inUrl) {
        HashMap<String, String> parametersMap = new HashMap<String, String>();
        if (inUrl == null || inUrl.length() == 0 || !inUrl.contains("?")) {
            return parametersMap;
        }
        String inUrlQuerry = inUrl.substring(inUrl.indexOf("?") + 1, inUrl.length());
        if (inUrlQuerry.contains("&")) {
            String[] kvs;
            for (String kv : kvs = inUrlQuerry.split("&")) {
                if (!kv.contains("=")) continue;
                String[] kvArray = kv.split("=");
                if (kvArray.length != 2) {
                    parametersMap.put(kvArray[0], "");
                    continue;
                }
                parametersMap.put(kvArray[0], kvArray[1]);
            }
        } else if (inUrlQuerry.contains("=")) {
            String[] kvArray = inUrlQuerry.split("=");
            if (kvArray.length != 2) {
                parametersMap.put(kvArray[0], "");
            } else {
                parametersMap.put(kvArray[0], kvArray[1]);
            }
        }
        return parametersMap;
    }

    public static String urlEncode(String inStr) {
        if (inStr == null || inStr.trim().equalsIgnoreCase("")) {
            return "";
        }
        try {
            inStr = URLEncoder.encode(inStr, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return inStr;
    }

    public static String urlDecode(String inStr) {
        if (inStr == null || inStr.trim().equalsIgnoreCase("")) {
            return "";
        }
        try {
            inStr = URLDecoder.decode(inStr, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return inStr;
    }

    public static String getHost(String url) {
        String ret = "";
        if (url == null || url.length() == 0 || !url.startsWith("http://") && !url.startsWith("https://")) {
            return "";
        }
        if ((url = url.substring(url.indexOf("://") + 3, url.length())).contains("/")) {
            url = url.substring(0, url.indexOf("/"));
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUrl(String url) {
        String responseStr;
        block7: {
            int maxRunNum = 3;
            int runNum = 0;
            responseStr = null;
            CloseableHttpClient httpClient = null;
            CloseableHttpResponse httpResp = null;
            try {
                httpClient = HttpUtils.CreatHttpClient();
                HttpGet httpGet = new HttpGet(url);
                httpResp = httpClient.execute((HttpUriRequest)httpGet);
                if (httpResp.getStatusLine().getStatusCode() != 200) {
                    ++runNum;
                } else {
                    responseStr = EntityUtils.toString((HttpEntity)httpResp.getEntity());
                }
                HttpUtils.close(httpResp);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block7;
            }
            finally {
                HttpUtils.close(httpResp);
                HttpUtils.close(httpClient);
            }
            HttpUtils.close(httpClient);
        }
        return responseStr;
    }

    public static String LocationValue(CloseableHttpResponse httpResp) {
        if (httpResp.getFirstHeader("Location") != null) {
            return httpResp.getFirstHeader("Location").getValue();
        }
        return "";
    }

    public static String requestUrlWithPost(String postUrl, List<BasicNameValuePair> list) {
        String result = null;
        try {
            CloseableHttpClient httpClient = HttpUtils.CreatHttpClient();
            HttpPost httpPost = HttpUtils.getHttpPost(HttpUtils.encode(postUrl));
            httpPost.setHeader((Header)new BasicHeader("Upgrade-Insecure-Requests", "1"));
            httpPost.setHeader((Header)new BasicHeader("Connection", "keep-alive"));
            httpPost.setHeader((Header)new BasicHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko"));
            UrlEncodedFormEntity requestEntity = new UrlEncodedFormEntity(list, "UTF-8");
            httpPost.setEntity((HttpEntity)requestEntity);
            CloseableHttpResponse httpResp = httpClient.execute((HttpUriRequest)httpPost);
            result = EntityUtils.toString((HttpEntity)httpResp.getEntity());
        }
        catch (ClientProtocolException e) {
            return "ClientProtocolException failed";
        }
        catch (IOException e) {
            return "IOException failed";
        }
        return result;
    }

    public static String requestUrlWithGet(String getUrl) {
        String result = null;
        try {
            CloseableHttpClient httpClient = HttpUtils.CreatHttpClient();
            HttpGet httpGet = HttpUtils.getHttpGet(HttpUtils.encode(getUrl));
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(30000).setSocketTimeout(5000).setRedirectsEnabled(true).build();
            httpGet.setConfig(requestConfig);
            httpGet.setHeader((Header)new BasicHeader("Upgrade-Insecure-Requests", "1"));
            httpGet.setHeader((Header)new BasicHeader("Connection", "keep-alive"));
            httpGet.setHeader((Header)new BasicHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko"));
            CloseableHttpResponse httpResp = httpClient.execute((HttpUriRequest)httpGet);
            result = EntityUtils.toString((HttpEntity)httpResp.getEntity());
            result = httpResp.getLastHeader("Location").getValue();
        }
        catch (ClientProtocolException e) {
            return "ClientProtocolException failed";
        }
        catch (IOException e) {
            return "IOException failed";
        }
        return result;
    }

    public static String encode(String url) {
        try {
            Matcher matcher = Pattern.compile("[\\u4e00-\\u9fa5]").matcher(url);
            while (matcher.find()) {
                System.out.println(matcher.group());
                String tmp = matcher.group();
                url = url.replaceAll(tmp, URLEncoder.encode(tmp, "utf-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        System.out.println(url);
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String http(String url, Map<String, String> params) {
        URL u = null;
        HttpURLConnection con = null;
        StringBuffer sb = new StringBuffer();
        if (params != null) {
            for (Map.Entry<String, String> e : params.entrySet()) {
                sb.append(e.getKey());
                sb.append("=");
                sb.append(e.getValue());
                sb.append("&");
            }
            sb.substring(0, sb.length() - 1);
        }
        try {
            u = new URL(url);
            con = (HttpURLConnection)u.openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setUseCaches(false);
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            OutputStreamWriter osw = new OutputStreamWriter(con.getOutputStream(), "UTF-8");
            osw.write(sb.toString());
            osw.flush();
            osw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        StringBuffer buffer = new StringBuffer();
        try {
            String temp;
            BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), "UTF-8"));
            while ((temp = br.readLine()) != null) {
                buffer.append(temp);
                buffer.append("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }

    public static class MyX509TrustManager
    implements X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

