/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.integration.message;

import com.bxm.messager.facade.bo.PageBO;
import com.bxm.messager.facade.dto.MessageInfoDTO;
import com.bxm.messager.facade.service.MessageInfoServiceFacade;
import com.bxm.messager.facade.vo.MessageInfoListVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.stereotype.Component;

@Component
@EnableFeignClients(value={"com.bxm.messager.facade"})
public class MessagerServiceIntegration {
    private static final Logger log = LoggerFactory.getLogger(MessagerServiceIntegration.class);
    @Autowired
    private MessageInfoServiceFacade messageInfoServiceFacade;

    public PageBO<MessageInfoListVO> messageList(Long channelId, Integer channel, Integer readFlag, Integer sender, String channelName, Integer pageNum, Integer pageSize) {
        try {
            return this.messageInfoServiceFacade.messageList(channelId, channel, readFlag, sender, channelName, pageNum, pageSize);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3\u83b7\u53d6\u6d88\u606f\u5217\u8868\u5f02\u5e38\uff01\uff01", (Throwable)e);
            return new PageBO();
        }
    }

    public Boolean messageOperate(Long messageId, Integer operateType, Integer channel, Long subjectId) {
        if (log.isDebugEnabled()) {
            log.debug("messageId : {},operateType : {},channel : {},subjectId : {}", new Object[]{messageId, operateType, channel, subjectId});
        }
        try {
            return this.messageInfoServiceFacade.messageOperate(messageId, operateType, channel, subjectId);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3\u83b7\u53d6\u6d88\u606f\u5217\u8868\u5f02\u5e38\uff01\uff01");
            return Boolean.FALSE;
        }
    }

    public Integer getUnreadNum(Long channelId, Integer channel) {
        if (log.isDebugEnabled()) {
            log.debug("channelId : {},channel : {}", (Object)channelId, (Object)channel);
        }
        try {
            return this.messageInfoServiceFacade.getUnReadNum(channelId, channel);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3\u83b7\u53d6\u6d88\u606f\u5217\u8868\u5f02\u5e38\uff01\uff01");
            return 0;
        }
    }

    public boolean pushMessage(MessageInfoDTO param) {
        if (log.isDebugEnabled()) {
            log.debug("param : {}", (Object)param);
        }
        try {
            return this.messageInfoServiceFacade.pushMessage(param);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3\u63a8\u9001\u6d88\u606f\u5931\u8d25\uff01\uff01");
            return Boolean.FALSE;
        }
    }
}

