/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.integration.screenshot;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.integration.config.ScreenShotConfig;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class ScreenShotIntegration {
    private static final Logger log = LoggerFactory.getLogger(ScreenShotIntegration.class);
    private RestTemplate restTemplate;
    @Autowired
    private ScreenShotConfig screenShotConfig;

    @PostConstruct
    public void setTimeOut() {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(50000);
        requestFactory.setReadTimeout(50000);
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
    }

    public String screenshot(Long ticketId, String url) {
        String requestUrl = this.screenShotConfig.getUrl();
        if (null == ticketId || null == url || null == requestUrl) {
            log.error("\u843d\u5730\u9875\u622a\u56fe\u65f6\u6709\u4e3a\u7a7a\u53c2\u6570\uff0cticketId:{}, url:{}, requestUrl:{}", new Object[]{ticketId, url, requestUrl});
            return null;
        }
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        data.add((Object)"id", (Object)ticketId.toString());
        data.add((Object)"url", (Object)url);
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.APPLICATION_FORM_URLENCODED;
        headers.setContentType(type);
        HttpEntity httpEntity = new HttpEntity((Object)data, (MultiValueMap)headers);
        JSONObject result = (JSONObject)this.restTemplate.postForEntity(requestUrl, (Object)httpEntity, JSONObject.class, new Object[0]).getBody();
        if (null != result) {
            System.out.println(result.toString());
            System.out.println(result.toString());
            Object imgUrl = result.get((Object)"data");
            if (null != imgUrl) {
                System.out.println(imgUrl);
                return imgUrl.toString();
            }
        }
        return null;
    }
}

