/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.commons.export;

import com.bxm.commons.export.ExportDataRow;
import com.bxm.commons.export.ExportModel;
import com.bxm.util.dto.ExcelHeadModel;
import com.bxm.util.dto.ValidateException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jodd.util.StringUtil;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.Region;

public class ExportExcel {
    private static HSSFWorkbook workbook = null;
    private static HSSFCellStyle titleDefaultStyle = null;
    private static HSSFCellStyle titleRedStyle = null;
    private static HSSFCellStyle dataStyle = null;
    private static final short EXCEL_TITLE_ROW_HEIGHT = 500;
    private static final short EXCEL_ROW_HEIGHT = 400;
    private static final short EXCEL_COLUMN_WIDTH_OF_CHAR = 300;
    private static final short EXCEL_COLUMN_MIN_WIDTH = 4500;
    private static final short FONT_SIZE = 8;
    private static final String FONT_NAME = "\u6977\u4f53";

    public static void exportExcel(HttpServletResponse response, ExportModel exportModel, String fileName) throws ValidateException, Exception {
        workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(fileName);
        ExportExcel.setTitleCellStyles(workbook, sheet);
        sheet.autoSizeColumn(1);
        sheet.autoSizeColumn(1, true);
        ExportExcel.setDataCellStyles(workbook, sheet);
        List<ExcelHeadModel> excelHeadModels = ExportExcel.makeExcelTmp(exportModel);
        HashMap<String, String> mapHeads = new HashMap<String, String>();
        String[] stringArray = exportModel.getHeadNames().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String headName = stringArray[n2];
            mapHeads.put(headName, headName);
            ++n2;
        }
        ExportExcel.creatAppRowHead(sheet, 2, fileName, excelHeadModels);
        int i = 3;
        for (ExportDataRow exportDataRow : exportModel.getDataRowList()) {
            ExportExcel.creatAppRow(sheet, excelHeadModels, i, exportDataRow, mapHeads, i);
            ++i;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        workbook.write((OutputStream)os);
        byte[] content = os.toByteArray();
        ByteArrayInputStream is = new ByteArrayInputStream(content);
        response.reset();
        response.setContentType("application/vnd.ms-excel;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + new String((String.valueOf(fileName) + ".xls").getBytes(), "iso-8859-1"));
        ServletOutputStream out = response.getOutputStream();
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int bytesRead;
            bis = new BufferedInputStream(is);
            bos = new BufferedOutputStream((OutputStream)out);
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                ((BufferedOutputStream)bos).write(buff, 0, bytesRead);
            }
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
    }

    private static void setTitleCellStyles(HSSFWorkbook workbook, HSSFSheet sheet) {
        titleDefaultStyle = workbook.createCellStyle();
        titleDefaultStyle.setBorderBottom((short)1);
        titleDefaultStyle.setBorderLeft((short)1);
        titleDefaultStyle.setBorderRight((short)1);
        titleDefaultStyle.setBorderTop((short)1);
        titleDefaultStyle.setFillForegroundColor((short)42);
        titleDefaultStyle.setFillPattern((short)1);
        titleDefaultStyle.setAlignment((short)2);
        titleDefaultStyle.setVerticalAlignment((short)1);
        HSSFFont font = workbook.createFont();
        font.setFontName(FONT_NAME);
        font.setFontHeightInPoints((short)8);
        font.setBoldweight((short)700);
        font.setColor((short)8);
        titleDefaultStyle.setFont(font);
        titleDefaultStyle.setWrapText(false);
    }

    private static void setDataCellStyles(HSSFWorkbook workbook, HSSFSheet sheet) {
        dataStyle = workbook.createCellStyle();
        dataStyle.setBorderBottom((short)1);
        dataStyle.setBorderLeft((short)1);
        dataStyle.setBorderRight((short)1);
        dataStyle.setBorderTop((short)1);
        dataStyle.setAlignment((short)2);
        dataStyle.setVerticalAlignment((short)1);
        HSSFFont font = workbook.createFont();
        font.setFontName(FONT_NAME);
        font.setBoldweight((short)700);
        font.setFontHeightInPoints((short)8);
        dataStyle.setFont(font);
        dataStyle.setWrapText(false);
    }

    private static void creatAppRowHead(HSSFSheet sheet, int rowIndex, String fileName, List<ExcelHeadModel> excelHeadModels) {
        HSSFRow rowTitle = sheet.createRow(rowIndex - 2);
        HSSFCell serialNumberCellTitle = rowTitle.createCell(0);
        serialNumberCellTitle.setCellValue(fileName);
        serialNumberCellTitle.setCellStyle(titleDefaultStyle);
        rowTitle.setHeight((short)500);
        sheet.addMergedRegion((Region)new org.apache.poi.hssf.util.Region(0, 0, 0, (short)excelHeadModels.size()));
        HSSFRow row = sheet.createRow(rowIndex - 1);
        HSSFCell serialNumberCell = row.createCell(0);
        serialNumberCell.setCellValue("\u5e8f\u53f7");
        serialNumberCell.setCellStyle(titleDefaultStyle);
        int index = 1;
        for (ExcelHeadModel excelHeadModel : excelHeadModels) {
            row.setHeight((short)500);
            HSSFCell cell = row.createCell(index);
            cell.setCellValue(excelHeadModel.getHeadName().trim());
            if (excelHeadModel.getHeadName().trim().indexOf("*") != -1) {
                cell.setCellStyle(titleRedStyle);
            } else {
                cell.setCellStyle(titleDefaultStyle);
            }
            ++index;
        }
    }

    private static void creatAppRow(HSSFSheet sheet, List<ExcelHeadModel> excelHeadModels, int num, ExportDataRow exportDataRow, Map<String, String> mapHeads, int rowIndex) throws Exception {
        HSSFRow row = sheet.createRow(rowIndex - 1);
        HSSFCell serialNumberCell = row.createCell(0);
        serialNumberCell.setCellValue((double)(num - 2));
        serialNumberCell.setCellStyle(titleDefaultStyle);
        int index = 1;
        for (String exportDataColumn : exportDataRow.getDataColumnList()) {
            HSSFCell cell = row.createCell(index);
            if (StringUtil.isNotBlank((String)exportDataColumn) && !StringUtil.equals((String)exportDataColumn, (String)"null")) {
                cell.setCellValue(exportDataColumn);
                row.setHeight((short)400);
                cell.setCellStyle(dataStyle);
                int width = exportDataColumn.getBytes().length * 300;
                if (width < 4500) {
                    sheet.setColumnWidth(index, 4500);
                } else if (width > 65280) {
                    sheet.setColumnWidth(index, 6000);
                } else {
                    sheet.setColumnWidth(index, width);
                }
            } else {
                cell.setCellValue("");
                row.setHeight((short)400);
                cell.setCellStyle(dataStyle);
                sheet.setColumnWidth(index, 4500);
            }
            ++index;
        }
        row.setHeight((short)500);
    }

    private static List<ExcelHeadModel> makeExcelTmp(ExportModel exportModelVo) {
        String[] heads;
        ArrayList<ExcelHeadModel> excelHeadModels = new ArrayList<ExcelHeadModel>();
        String[] stringArray = heads = exportModelVo.getHeadNames().split(",");
        int n = heads.length;
        int n2 = 0;
        while (n2 < n) {
            String head = stringArray[n2];
            ExcelHeadModel excelHeadModel = new ExcelHeadModel();
            excelHeadModel.setHeadName(head);
            excelHeadModels.add(excelHeadModel);
            ++n2;
        }
        return excelHeadModels;
    }
}

