/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.util;

import com.aliyun.oss.ClientException;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.cdn.model.v20141111.RefreshObjectCachesRequest;
import com.aliyuncs.cdn.model.v20141111.RefreshObjectCachesResponse;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.bxm.util.CommonValidate;

public class AliCdnRefresh {
    private static final String OBJECT_TYPE_FILE = "File";
    private static final String OBJECT_TYPE_DIRECTORY = "Directory";
    private static final String REGION_ID = "cn-hangzhou";

    public static RefreshObjectCachesResponse reflushFileCDN(String accessKeyId, String secret, String url) {
        CommonValidate.me.checkParam(accessKeyId);
        CommonValidate.me.checkParam(secret);
        CommonValidate.me.checkParam(url);
        RefreshObjectCachesRequest describe = new RefreshObjectCachesRequest();
        describe.setObjectPath(url);
        describe.setObjectType(OBJECT_TYPE_FILE);
        return AliCdnRefresh.reflush(accessKeyId, secret, describe);
    }

    public static RefreshObjectCachesResponse reflushPackageCDN(String accessKeyId, String secret, String packageUrl) {
        CommonValidate.me.checkParam(accessKeyId);
        CommonValidate.me.checkParam(secret);
        CommonValidate.me.checkParam(packageUrl);
        RefreshObjectCachesRequest describe = new RefreshObjectCachesRequest();
        describe.setObjectPath(packageUrl);
        describe.setObjectType(OBJECT_TYPE_DIRECTORY);
        return AliCdnRefresh.reflush(accessKeyId, secret, describe);
    }

    private static RefreshObjectCachesResponse reflush(String accessKeyId, String secret, RefreshObjectCachesRequest describe) {
        DefaultProfile profile = DefaultProfile.getProfile((String)REGION_ID, (String)accessKeyId, (String)secret);
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        try {
            RefreshObjectCachesResponse response = (RefreshObjectCachesResponse)client.getAcsResponse((AcsRequest)describe);
            return response;
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

