/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.util;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.bxm.util.CommonValidate;
import com.bxm.util.DateUtil;
import com.bxm.util.FileType;
import com.bxm.util.FileTypeJudge;
import com.bxm.util.ImageUtil;
import com.bxm.util.RandomUtil;
import com.bxm.util.StringUtil;
import com.bxm.util.UuidUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliOSSUtil {
    private static final Logger log = LoggerFactory.getLogger(AliOSSUtil.class);
    private static String END_POINT = "oss-cn-shanghai.aliyuncs.com";
    private static String BUCKET_NAME = "bxm-image";
    private static String FILE_HOST = "https://image.bianxianmao.com/";
    private static String[] tinifyApiKeys = new String[]{"H3e0yJpIBkHrLrFVsPGmVDuuLq8WSFaf", "2lku16Gahn1ASIUr02kPEYb0GJJC_lng", "2fKMylTj9-EWJbytvskmZjRptTaelqXl", "QoWNCAkiMTel_u4i3r0Tw89ehJ5EDdhV"};

    public static String upload(final String accessKeyId, final String secret, File file) {
        if (file == null) {
            return null;
        }
        OSSClient ossClient = new OSSClient(END_POINT, accessKeyId, secret);
        try {
            String filePath;
            PutObjectResult result;
            if (!ossClient.doesBucketExist(BUCKET_NAME)) {
                ossClient.createBucket(BUCKET_NAME);
                CreateBucketRequest createBucketRequest = new CreateBucketRequest(BUCKET_NAME);
                createBucketRequest.setCannedACL(CannedAccessControlList.PublicRead);
                ossClient.createBucket(createBucketRequest);
            }
            String fileName = file.getName();
            String suffix = "";
            if (StringUtil.isNotBlank((CharSequence)fileName) && fileName.indexOf(".") != -1) {
                suffix = fileName.substring(fileName.lastIndexOf("."));
            }
            if ((result = ossClient.putObject(new PutObjectRequest(BUCKET_NAME, filePath = String.valueOf(DateUtil.dateTo8String2(new Date())) + "/" + UuidUtil.getUuidByJdk(true) + suffix, file))) != null) {
                final String fileUrl = String.valueOf(FILE_HOST) + filePath;
                if (StringUtil.equals((CharSequence)suffix, (CharSequence)".jpg") || StringUtil.equals((CharSequence)suffix, (CharSequence)".png")) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                byte[] bytes = ImageUtil.compressionFromUrl(tinifyApiKeys[RandomUtil.getRandomNum(tinifyApiKeys.length)], fileUrl);
                                AliOSSUtil.replaceUpload(accessKeyId, BUCKET_NAME, secret, bytes, filePath);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }).start();
                }
                String string = fileUrl;
                return string;
            }
        }
        catch (OSSException oe) {
            log.error(oe.getMessage());
        }
        catch (ClientException ce) {
            log.error(ce.getMessage());
        }
        catch (Exception ce) {
            log.error(ce.getMessage());
        }
        finally {
            ossClient.shutdown();
        }
        return null;
    }

    public static String upload(final String accessKeyId, final String secret, InputStream inputStream) throws Exception {
        if (inputStream == null) {
            return null;
        }
        OSSClient ossClient = new OSSClient(END_POINT, accessKeyId, secret);
        try {
            String filePath;
            PutObjectResult result;
            if (!ossClient.doesBucketExist(BUCKET_NAME)) {
                ossClient.createBucket(BUCKET_NAME);
                CreateBucketRequest createBucketRequest = new CreateBucketRequest(BUCKET_NAME);
                createBucketRequest.setCannedACL(CannedAccessControlList.PublicRead);
                ossClient.createBucket(createBucketRequest);
            }
            String fileTypeCode = "";
            FileType fileType = FileTypeJudge.getTypeByInputStream(inputStream);
            if (fileTypeCode != null) {
                fileTypeCode = fileType.getCode();
            }
            String suffix = "";
            if (StringUtil.isNotBlank((CharSequence)fileTypeCode)) {
                suffix = "." + fileTypeCode;
            }
            if ((result = ossClient.putObject(new PutObjectRequest(BUCKET_NAME, filePath = String.valueOf(DateUtil.dateTo8String2(new Date())) + "/" + UuidUtil.getUuidByJdk(true) + suffix, inputStream))) != null) {
                final String fileUrl = String.valueOf(FILE_HOST) + filePath;
                if (StringUtil.equals((CharSequence)fileTypeCode, (CharSequence)FileType.JPG.getCode()) || StringUtil.equals((CharSequence)fileTypeCode, (CharSequence)FileType.PNG.getCode())) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                byte[] bytes = ImageUtil.compressionFromUrl(tinifyApiKeys[RandomUtil.getRandomNum(tinifyApiKeys.length)], fileUrl);
                                AliOSSUtil.replaceUpload(accessKeyId, BUCKET_NAME, secret, bytes, filePath);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }).start();
                }
                String string = fileUrl;
                return string;
            }
        }
        catch (OSSException oe) {
            log.error(oe.getMessage());
        }
        catch (ClientException ce) {
            log.error(ce.getMessage());
        }
        finally {
            ossClient.shutdown();
        }
        return null;
    }

    public static String upload(final String accessKeyId, final String secret, File file, final String bucketName, String fileHost, String filePath) {
        CommonValidate.me.checkParam(file);
        CommonValidate.me.checkParam(bucketName);
        CommonValidate.me.checkParam(fileHost);
        OSSClient ossClient = new OSSClient(END_POINT, accessKeyId, secret);
        try {
            String uploadfilePath;
            PutObjectResult result;
            if (!ossClient.doesBucketExist(bucketName)) {
                ossClient.createBucket(bucketName);
                CreateBucketRequest createBucketRequest = new CreateBucketRequest(bucketName);
                createBucketRequest.setCannedACL(CannedAccessControlList.PublicRead);
                ossClient.createBucket(createBucketRequest);
            }
            String fileName = file.getName();
            String suffix = "";
            if (StringUtil.isNotBlank((CharSequence)fileName) && fileName.indexOf(".") != -1) {
                suffix = fileName.substring(fileName.lastIndexOf("."));
            }
            if (StringUtil.isBlank((CharSequence)filePath)) {
                filePath = String.valueOf(DateUtil.dateTo8String2(new Date())) + "/" + UuidUtil.getUuidByJdk(true) + suffix;
            }
            if ((result = ossClient.putObject(new PutObjectRequest(bucketName, uploadfilePath = filePath, file))) != null) {
                final String fileUrl = String.valueOf(fileHost) + uploadfilePath;
                if (StringUtil.equals((CharSequence)suffix, (CharSequence)".jpg") || StringUtil.equals((CharSequence)suffix, (CharSequence)".png")) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                byte[] bytes = ImageUtil.compressionFromUrl(tinifyApiKeys[RandomUtil.getRandomNum(tinifyApiKeys.length)], fileUrl);
                                AliOSSUtil.replaceUpload(accessKeyId, bucketName, secret, bytes, uploadfilePath);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }).start();
                }
                String string = fileUrl;
                return string;
            }
        }
        catch (OSSException oe) {
            log.error(oe.getMessage());
        }
        catch (ClientException ce) {
            log.error(ce.getMessage());
        }
        catch (Exception ce) {
            log.error(ce.getMessage());
        }
        finally {
            ossClient.shutdown();
        }
        return null;
    }

    public static String upload(final String accessKeyId, final String secret, InputStream inputStream, final String bucketName, String fileHost, String filePath) throws Exception {
        CommonValidate.me.checkParam(inputStream);
        CommonValidate.me.checkParam(bucketName);
        CommonValidate.me.checkParam(fileHost);
        OSSClient ossClient = new OSSClient(END_POINT, accessKeyId, secret);
        try {
            String uploadfilePath;
            PutObjectResult result;
            if (!ossClient.doesBucketExist(bucketName)) {
                ossClient.createBucket(bucketName);
                CreateBucketRequest createBucketRequest = new CreateBucketRequest(bucketName);
                createBucketRequest.setCannedACL(CannedAccessControlList.PublicRead);
                ossClient.createBucket(createBucketRequest);
            }
            String fileTypeCode = "";
            FileType fileType = FileTypeJudge.getTypeByInputStream(inputStream);
            if (fileTypeCode != null) {
                fileTypeCode = fileType.getCode();
            }
            String suffix = "";
            if (StringUtil.isNotBlank((CharSequence)fileTypeCode)) {
                suffix = "." + fileTypeCode;
            }
            if (StringUtil.isBlank((CharSequence)filePath)) {
                filePath = String.valueOf(DateUtil.dateTo8String2(new Date())) + "/" + UuidUtil.getUuidByJdk(true) + suffix;
            }
            if ((result = ossClient.putObject(new PutObjectRequest(bucketName, uploadfilePath = filePath, inputStream))) != null) {
                final String fileUrl = String.valueOf(fileHost) + uploadfilePath;
                if (StringUtil.equals((CharSequence)fileTypeCode, (CharSequence)FileType.JPG.getCode()) || StringUtil.equals((CharSequence)fileTypeCode, (CharSequence)FileType.PNG.getCode())) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                byte[] bytes = ImageUtil.compressionFromUrl(tinifyApiKeys[RandomUtil.getRandomNum(tinifyApiKeys.length)], fileUrl);
                                AliOSSUtil.replaceUpload(accessKeyId, bucketName, secret, bytes, uploadfilePath);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }).start();
                }
                String string = fileUrl;
                return string;
            }
        }
        catch (OSSException oe) {
            log.error(oe.getMessage());
        }
        catch (ClientException ce) {
            log.error(ce.getMessage());
        }
        finally {
            ossClient.shutdown();
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private static void replaceUpload(String accessKeyId, String bucketName, String secret, byte[] bytes, String filePath) throws FileNotFoundException {
        String[] filePaths = filePath.split("/");
        String fileName = filePaths[filePaths.length - 1];
        OSSClient ossClient = new OSSClient(END_POINT, accessKeyId, secret);
        try {
            try {
                File newFile = new File(fileName);
                FileOutputStream outStream = new FileOutputStream(newFile);
                outStream.write(bytes);
                outStream.close();
                if (!ossClient.doesBucketExist(bucketName)) {
                    ossClient.createBucket(bucketName);
                    CreateBucketRequest createBucketRequest = new CreateBucketRequest(bucketName);
                    createBucketRequest.setCannedACL(CannedAccessControlList.PublicRead);
                    ossClient.createBucket(createBucketRequest);
                }
                ossClient.putObject(new PutObjectRequest(bucketName, filePath, newFile));
                newFile.delete();
            }
            catch (OSSException oe) {
                log.error(oe.getMessage());
                ossClient.shutdown();
            }
            catch (ClientException ce) {
                log.error(ce.getMessage());
                ossClient.shutdown();
            }
            catch (Exception ce) {
                log.error(ce.getMessage());
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                ossClient.shutdown();
            }
        }
        finally {
            ossClient.shutdown();
        }
    }
}

