/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.util;

import com.bxm.util.FileType;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class FileTypeJudge {
    private FileTypeJudge() {
    }

    private static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        int i = 0;
        while (i < src.length) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
            ++i;
        }
        return stringBuilder.toString();
    }

    private static String getFileContent(String filePath) throws IOException {
        byte[] b = new byte[28];
        FileInputStream inputStream = null;
        try {
            try {
                inputStream = new FileInputStream(filePath);
                ((InputStream)inputStream).read(b, 0, 28);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        }
        return FileTypeJudge.bytesToHexString(b);
    }

    private static String getFileContentByInputStream(InputStream inputStream) throws IOException {
        byte[] b = new byte[28];
        try {
            try {
                inputStream.read(b, 0, 28);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        }
        return FileTypeJudge.bytesToHexString(b);
    }

    public static FileType getType(String filePath) throws IOException {
        FileType[] fileTypes;
        String fileHead = FileTypeJudge.getFileContent(filePath);
        if (fileHead == null || fileHead.length() == 0) {
            return null;
        }
        fileHead = fileHead.toUpperCase();
        FileType[] fileTypeArray = fileTypes = FileType.values();
        int n = fileTypes.length;
        int n2 = 0;
        while (n2 < n) {
            FileType type = fileTypeArray[n2];
            if (fileHead.startsWith(type.getValue())) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    public static FileType getTypeByInputStream(InputStream inputStream) throws IOException {
        FileType[] fileTypes;
        String fileHead = FileTypeJudge.getFileContentByInputStream(inputStream);
        if (fileHead == null || fileHead.length() == 0) {
            return null;
        }
        fileHead = fileHead.toUpperCase();
        FileType[] fileTypeArray = fileTypes = FileType.values();
        int n = fileTypes.length;
        int n2 = 0;
        while (n2 < n) {
            FileType type = fileTypeArray[n2];
            if (fileHead.startsWith(type.getValue())) {
                return type;
            }
            ++n2;
        }
        return null;
    }
}

