/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.util;

import com.bxm.util.StringUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;

public class FileUtil {
    public static String toUtf8String(String s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c >= '\u0000' && c <= '\u00ff') {
                sb.append(c);
            } else {
                byte[] b;
                try {
                    b = Character.toString(c).getBytes("utf-8");
                }
                catch (Exception ex) {
                    b = new byte[]{};
                }
                int j = 0;
                while (j < b.length) {
                    int k = b[j];
                    if (k < 0) {
                        k += 256;
                    }
                    sb.append("%" + Integer.toHexString(k).toUpperCase());
                    ++j;
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String toUtf8String(HttpServletRequest request, String s) throws Exception {
        boolean isFireFox;
        String agent = request.getHeader("User-Agent");
        boolean bl = isFireFox = agent != null && agent.toLowerCase().indexOf("firefox") != -1;
        if (isFireFox) {
            s = new String(s.getBytes("UTF-8"), "ISO8859-1");
        } else {
            s = FileUtil.toUtf8String(s);
            if (agent != null && agent.indexOf("MSIE") != -1 && s.length() > 150) {
                s = new String(s.getBytes("UTF-8"), "ISO8859-1");
            }
        }
        return s;
    }

    public static String convertTextToFile(String text, String savePath) throws IOException {
        OutputStream outputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            try {
                char[] chars;
                File file = new File(savePath);
                if (file.exists()) {
                    file.delete();
                }
                outputStream = new FileOutputStream(file);
                outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
                bufferedWriter = new BufferedWriter(outputStreamWriter);
                char[] cArray = chars = text.toCharArray();
                int n = chars.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    bufferedWriter.write(c);
                    ++n2;
                }
                bufferedWriter.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    outputStream.close();
                    outputStreamWriter.close();
                    bufferedWriter.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    outputStream.close();
                    outputStreamWriter.close();
                    bufferedWriter.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                outputStream.close();
                outputStreamWriter.close();
                bufferedWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String convertFileToText(String filePath) {
        File file = new File(filePath);
        String fileContent = "";
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                if (file.isFile() && file.exists()) {
                    String line;
                    inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                    bufferedReader = new BufferedReader(inputStreamReader);
                    while ((line = bufferedReader.readLine()) != null) {
                        fileContent = String.valueOf(fileContent) + line;
                    }
                    bufferedReader.close();
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    inputStreamReader.close();
                    bufferedReader.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    inputStreamReader.close();
                    bufferedReader.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                inputStreamReader.close();
                bufferedReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return fileContent;
    }

    public static InputStream getStringStream(String inputString) {
        if (StringUtil.isNotBlank((CharSequence)inputString)) {
            try {
                ByteArrayInputStream tInputStringStream = new ByteArrayInputStream(inputString.getBytes());
                return tInputStringStream;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static long getFileSize(String fileUrl) {
        if (StringUtil.isNotBlank((CharSequence)fileUrl)) {
            try {
                URL url = new URL(fileUrl);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setConnectTimeout(10000);
                String fileLength = conn.getHeaderField("Content-Length");
                if (StringUtil.isNotBlank((CharSequence)fileLength)) {
                    return Long.valueOf(fileLength);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return 0L;
    }
}

